/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.CollectionInfo;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ConvScopeFixer {
    protected static final Logger log = Logger.getLogger(ConvScopeFixer.class);
    protected static final int NONE = 0;
    protected static final int BORROWS = 1;
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected String oldDBName;
    protected TableWriter tblWriter;
    protected HashMap<Integer, Integer> taxonTypesInUse = new HashMap();
    protected HashMap<Integer, TaxonTreeDef> taxonTreeDefHash = new HashMap();
    protected HashMap<Integer, Integer> colObjTypeToCollMemId = new HashMap();
    protected HashMap<Integer, Integer> catSerTypeToCollMemId = new HashMap();
    protected HashMap<Integer, Integer> colObjTypeCount = new HashMap();
    String[] collectionMembers = new String[]{"BorrowAgent", "Borrow", "BorrowMaterial", "BorrowReturnMaterial", "CollectingEventAttribute", "CollectionObjectAttribute", "CollectionObjectCitation", "CollectionObject", "Collector", "DeterminationCitation", "Determination", "OtherIdentifier", "PaleoContext", "PreparationAttribute", "Preparation", "Project"};
    String[] disciplineMembers = new String[]{"CollectingEvent", "CollectingTrip", "Gift", "GiftAgent", "GiftPreparation", "Loan", "LoanAgent", "LoanPreparation", "LoanReturnPreparation", "Locality", "LocalityCitation", "Shipment"};

    public ConvScopeFixer(Connection oldDBConn, Connection newDBConn, String oldDBName, TableWriter tblWriter) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.oldDBName = oldDBName;
        this.tblWriter = tblWriter;
        for (CollectionInfo ci : CollectionInfo.getFilteredCollectionInfoList()) {
            this.colObjTypeToCollMemId.put(ci.getColObjTypeId(), ci.getCollectionId());
            Integer cnt = this.colObjTypeCount.get(ci.getColObjTypeId());
            if (cnt == null) {
                this.colObjTypeCount.put(ci.getColObjTypeId(), 1);
                continue;
            }
            cnt = cnt + 1;
            this.colObjTypeCount.put(ci.getColObjTypeId(), cnt);
        }
        tblWriter.log("Collection Object Type Counts");
        for (Integer key : this.colObjTypeCount.keySet()) {
            tblWriter.log(key + " -> " + this.colObjTypeCount.get(key));
        }
        tblWriter.log("");
        tblWriter.log("CatSeries to Collection Id");
        for (CollectionInfo ci : CollectionInfo.getFilteredCollectionInfoList()) {
            if (ci.getCatSeriesId() == null) continue;
            this.catSerTypeToCollMemId.put(ci.getCatSeriesId(), ci.getCollectionId());
            tblWriter.log(String.format("Cat Series: %d  -> CollectionId %d", ci.getCatSeriesId(), ci.getCollectionId()));
        }
    }

    public boolean checkForScopingConverters() {
        boolean isError = false;
        int cnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM borrow");
        if (cnt > 0) {
            UIRegistry.showError("There are %d Borrows and we don't have a converter for them.");
            isError = true;
        }
        return isError;
    }

    protected boolean fixCollectingEventAttributes() {
        String sql = "SELECT ce.DisciplineID, cea.CollectingEventAttributeID FROM collectingevent AS ce Inner Join collectingeventattribute AS cea ON ce.CollectingEventAttributeID = cea.CollectingEventAttributeID WHERE ce.DisciplineID <> cea.DisciplineID";
        Statement stmt = null;
        Statement pStmt = null;
        try {
            stmt = this.newDBConn.createStatement(1004, 1007);
            pStmt = this.newDBConn.prepareStatement("UPDATE collectingeventattribute SET DisciplineID=? WHERE CollectingEventAttributeID=?");
            log.debug((Object)sql);
            ResultSet rs = stmt.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                String msg = null;
                pStmt.setInt(1, rs.getInt(1));
                pStmt.setInt(2, rs.getInt(2));
                if (pStmt.executeUpdate() != 1) {
                    msg = String.format("Error updating CollectingEventAttributeID %d for Discipline %d", rs.getInt(2), rs.getInt(1));
                }
                if (msg != null) {
                    log.error(msg);
                    this.tblWriter.logError(msg);
                }
                ++count;
            }
            rs.close();
            log.debug((Object)("fixCollectingEventAttributes - Fixed: " + count));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    protected boolean fixCollectingObjectAttributesAfterConv() {
        String sql = "SELECT co.CollectionMemberID, coa.CollectionObjectAttributeID FROM collectionobject AS co Inner Join collectionobjectattribute AS coa ON co.CollectionObjectAttributeID = coa.CollectionObjectAttributeID WHERE co.CollectionMemberID <> coa.CollectionMemberID";
        Statement stmt = null;
        Statement pStmt = null;
        try {
            stmt = this.newDBConn.createStatement(1004, 1007);
            pStmt = this.newDBConn.prepareStatement("UPDATE collectionobjectattribute SET CollectionMemberID=? WHERE CollectionObjectAttributeID=?");
            log.debug((Object)sql);
            ResultSet rs = stmt.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                String msg = null;
                pStmt.setInt(1, rs.getInt(1));
                pStmt.setInt(2, rs.getInt(2));
                if (pStmt.executeUpdate() != 1) {
                    msg = String.format("Error updating CollectionObjectAttributeID %d for CollectionMemberID %d", rs.getInt(2), rs.getInt(1));
                }
                if (msg != null) {
                    log.error(msg);
                    this.tblWriter.logError(msg);
                }
                ++count;
            }
            rs.close();
            log.debug((Object)("fixCollectingObjectAttributesAfterConv - Fixed: " + count));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    protected boolean fixCollectingEventAttributesHabitat() {
        int cnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM habitat");
        if (cnt == 0) {
            return true;
        }
        IdMapperIFace habitatMapper = IdMapperMgr.getInstance().get("Habitat", "HabitatID");
        if (habitatMapper == null && ((habitatMapper = IdMapperMgr.getInstance().addTableMapper("Habitat", "HabitatID", false)) == null || habitatMapper.size() == 0)) {
            log.error((Object)"habitatMapper is null");
            return false;
        }
        Statement stmt = null;
        Statement pStmt = null;
        try {
            Integer colMemId;
            String msg;
            stmt = this.oldDBConn.createStatement(1004, 1007);
            pStmt = this.newDBConn.prepareStatement("UPDATE collectingeventattribute SET CollectionMemberID=? WHERE CollectingEventAttributeID=?");
            String sql = "SELECT h.HabitatID,cco.CatalogSeriesID FROM habitat AS h Inner Join collectionobject AS co ON h.HabitatID = co.CollectingEventID Inner Join collectionobjectcatalog AS cco ON co.CollectionObjectID = cco.CollectionObjectCatalogID ORDER BY h.HabitatID ASC";
            log.debug((Object)sql);
            ResultSet rs = stmt.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                msg = null;
                Integer oldId = rs.getInt(1);
                if (rs.wasNull()) continue;
                Integer newId = habitatMapper.get(oldId);
                if (newId != null) {
                    colMemId = this.catSerTypeToCollMemId.get(rs.getInt(2));
                    if (colMemId != null) {
                        try {
                            pStmt.setInt(1, colMemId);
                            pStmt.setInt(2, newId);
                            if (pStmt.executeUpdate() != 1) {
                                msg = String.format("Error updating CollectingEventAttributeID %d for HabitatID %d", newId, rs.getInt(1));
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        msg = String.format("The BiologicalObjectTypeCollectedID %d wasn't mapped to CollectionMemberID for HabitatID %d", rs.getInt(2), rs.getInt(1));
                    }
                } else {
                    msg = String.format("The old HabitatID %d wasn't mapped.", rs.getInt(1));
                }
                if (msg != null) {
                    log.error((Object)msg);
                    this.tblWriter.logError(msg);
                }
                ++count;
            }
            rs.close();
            sql = "SELECT T1.CollectingEventID, T1.BiologicalObjectTypeCollectedID FROM (select * from collectingevent WHERE CollectingEventID in (select HabitatID from habitat)) T1 Left Join collectionobject ON T1.CollectingEventID = collectionobject.CollectingEventID WHERE collectionobject.CollectionObjectID IS NULL";
            rs = stmt.executeQuery(sql);
            count = 0;
            while (rs.next()) {
                msg = null;
                Integer newId = habitatMapper.get(rs.getInt(1));
                if (newId != null) {
                    Integer colObjTypeCnt = this.colObjTypeCount.get(rs.getInt(2));
                    if (colObjTypeCnt != null && colObjTypeCnt == 1) {
                        colMemId = this.colObjTypeToCollMemId.get(rs.getInt(2));
                        if (colMemId != null) {
                            pStmt.setInt(1, colMemId);
                            pStmt.setInt(2, newId);
                            if (pStmt.executeUpdate() != 1) {
                                msg = String.format("Error updating CollectingEventAttributeID %d for HabitatID %d", newId, rs.getInt(1));
                            }
                        } else {
                            msg = String.format("The BiologicalObjectTypeCollectedID %d wasn't mapped to CollectionMemberID for HabitatID %d", rs.getInt(2), rs.getInt(1));
                        }
                    } else {
                        msg = String.format("The BiologicalObjectTypeCollectedID %d has more than one collection and wasn't mapped to CollectionMemberID for HabitatID %d", rs.getInt(2), rs.getInt(1));
                    }
                } else {
                    msg = String.format("The old HabitatID %d wasn't mapped.", rs.getInt(1));
                }
                if (msg != null) {
                    log.error((Object)msg);
                    this.tblWriter.logError(msg);
                }
                ++count;
            }
            rs.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    protected boolean fixDeterminations() {
        String cntSQL = "SELECT COUNT(*) FROM determination";
        String qrySQL = "SELECT d.DeterminationID, cc.CatalogSeriesID FROM determination AS d Inner Join collectionobjectcatalog AS cc ON d.BiologicalObjectID = cc.CollectionObjectCatalogID";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "Determination", "DeterminationID", "Determination", "DeterminationID");
    }

    protected boolean fixDeterminationCitations() {
        String cntSQL = "SELECT COUNT(*) FROM determinationcitation";
        String qrySQL = "SELECT dc.DeterminationCitationID, cc.CatalogSeriesID FROM determination AS d Inner Join collectionobjectcatalog AS cc ON d.BiologicalObjectID = cc.CollectionObjectCatalogID Inner Join determinationcitation AS dc ON d.DeterminationID = dc.DeterminationID";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "DeterminationCitation", "DeterminationCitationID", "DeterminationCitation", "DeterminationCitationID");
    }

    protected boolean fixCollectionObjects() {
        String cntSQL = "SELECT COUNT(*) FROM collectionobjectcatalog WHERE CollectionObjectTypeID > 8 AND CollectionObjectTypeID < 20";
        String qrySQL = "SELECT CollectionObjectCatalogID, CatalogSeriesID FROM collectionobjectcatalog WHERE CollectionObjectTypeID > 8 AND CollectionObjectTypeID < 20";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "CollectionObject", "CollectionObjectID", "CollectionObject", "CollectionObjectID", "collectionobjectcatalog_CollectionObjectCatalogID");
    }

    protected boolean fixCollectionObjectCitations() {
        String cntSQL = "SELECT COUNT(cit.CollectionObjectCitationID) FROM collectionobjectcatalog AS c Inner Join collectionobjectcitation AS cit ON c.CollectionObjectCatalogID = cit.BiologicalObjectID WHERE c.CollectionObjectTypeID > 8 AND c.CollectionObjectTypeID < 20";
        String qrySQL = "SELECT cit.CollectionObjectCitationID, c.CatalogSeriesID FROM collectionobjectcatalog AS c Inner Join collectionobjectcitation AS cit ON c.CollectionObjectCatalogID = cit.BiologicalObjectID WHERE c.CollectionObjectTypeID > 8 AND c.CollectionObjectTypeID < 20";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "CollectionObjectCitation", "CollectionObjectCitationID", "CollectionObjectCitation", "CollectionObjectCitationID");
    }

    protected boolean fixCollectionObjectAttributes() {
        String cntSQL = "SELECT COUNT(b.BiologicalObjectAttributesID) FROM collectionobjectcatalog AS cc Inner Join biologicalobjectattributes AS b ON cc.CollectionObjectCatalogID = b.BiologicalObjectTypeID WHERE cc.CollectionObjectTypeID > 8 AND cc.CollectionObjectTypeID < 20";
        String qrySQL = "SELECT b.BiologicalObjectAttributesID, cc.CatalogSeriesID FROM collectionobjectcatalog AS cc Inner Join biologicalobjectattributes AS b ON cc.CollectionObjectCatalogID = b.BiologicalObjectTypeID WHERE cc.CollectionObjectTypeID > 8 AND cc.CollectionObjectTypeID < 20";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "BiologicalObjectAttributes", "BiologicalObjectAttributesID", "CollectionObjectAttribute", "CollectionObjectAttributeID");
    }

    protected boolean fixPrepartions() {
        String cntSQL = "SELECT COUNT(co.CollectionObjectID) FROM collectionobject AS co Inner Join collectionobjectcatalog AS cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE co.CollectionObjectTypeID < 9 OR co.CollectionObjectTypeID > 19";
        String qrySQL = "SELECT co.CollectionObjectID, cc.CatalogSeriesID FROM collectionobject AS co Inner Join collectionobjectcatalog AS cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE co.CollectionObjectTypeID < 9 OR co.CollectionObjectTypeID > 19";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "Preparation", "CollectionObjectID", "Preparation", "PreparationID", "collectionobject_CollectionObjectID");
    }

    protected boolean fixPrepartionAttributes() {
        String cntSQL = "SELECT COUNT(b.BiologicalObjectAttributesID) FROM collectionobjectcatalog AS cc Inner Join biologicalobjectattributes AS b ON cc.CollectionObjectCatalogID = b.BiologicalObjectTypeID WHERE cc.CollectionObjectTypeID >  8 AND cc.CollectionObjectTypeID <  20";
        String qrySQL = "SELECT b.BiologicalObjectAttributesID, cc.CatalogSeriesID FROM collectionobjectcatalog AS cc Inner Join biologicalobjectattributes AS b ON cc.CollectionObjectCatalogID = b.BiologicalObjectTypeID WHERE cc.CollectionObjectTypeID >  8 AND cc.CollectionObjectTypeID <  20";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "BiologicalObjectAttributes", "BiologicalObjectTypeID", "CollectionObjectAttribute", "CollectionObjectAttributeID");
    }

    protected boolean fixOtherIdentifiers() {
        String cntSQL = "SELECT COUNT(oi.OtherIdentifierID) FROM otheridentifier AS oi Inner Join collectionobjectcatalog AS cc ON oi.CollectionObjectID = cc.CollectionObjectCatalogID";
        String qrySQL = "SELECT oi.OtherIdentifierID, cc.CatalogSeriesID FROM otheridentifier AS oi Inner Join collectionobjectcatalog AS cc ON oi.CollectionObjectID = cc.CollectionObjectCatalogID";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "OtherIdentifier", "OtherIdentifierID", "OtherIdentifier", "OtherIdentifierID");
    }

    protected boolean fixProjects() {
        String cntSQL = "SELECT DISTINCT p.ProjectID, cc.CatalogSeriesID FROM projectcollectionobjects AS p Inner Join collectionobjectcatalog AS cc ON p.CollectionObjectID = cc.CollectionObjectCatalogID";
        String qrySQL = "SELECT DISTINCT p.ProjectID, cc.CatalogSeriesID FROM projectcollectionobjects AS p Inner Join collectionobjectcatalog AS cc ON p.CollectionObjectID = cc.CollectionObjectCatalogID";
        return this.fixTableWithColMemId(cntSQL, qrySQL, "Project", "ProjectID", "Project", "ProjectID");
    }

    protected boolean fixPaleoContext() {
        String cntSQL = "SELECT COUNT(PaleoContextID) FROM collectionobject WHERE PaleoContextID IS NOT NULL";
        int cnt = BasicSQLUtils.getCountAsInt(this.newDBConn, cntSQL);
        if (cnt == 0) {
            return true;
        }
        String qrySQL = "SELECT PaleoContextID, CollectionMemberID FROM collectionobject WHERE PaleoContextID IS NOT NULL";
        Statement stmt = null;
        Statement pStmt = null;
        try {
            stmt = this.newDBConn.createStatement(1004, 1007);
            pStmt = this.newDBConn.prepareStatement("UPDATE paleocontext SET CollectionMemberID=? WHERE PaleoContextID=?");
            ResultSet rs = stmt.executeQuery(qrySQL);
            int count = 0;
            while (rs.next()) {
                String msg = null;
                pStmt.setInt(1, rs.getInt(2));
                pStmt.setInt(2, rs.getInt(1));
                if (pStmt.executeUpdate() != 1) {
                    msg = String.format("Error updating PaleoContextID %d", rs.getInt(1));
                }
                if (msg != null) {
                    log.error(msg);
                    this.tblWriter.logError(msg);
                }
                ++count;
            }
            rs.close();
            this.tblWriter.log(String.format("Updated %d records in table PaleoContext", count));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public void checkTables() {
        String[] fields;
        this.tblWriter.startTable();
        this.tblWriter.logHdr("Table", "Field", "Count");
        String[] stringArray = fields = new String[]{"CollectionMemberID", "DisciplineID", "DivisionID", "CollectionID"};
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                Integer cnt;
                if (ti.getFieldByColumnName(field) == null || (cnt = BasicSQLUtils.getCount("SELECT COUNT(*) FROM " + ti.getName() + " WHERE " + field + " IS NULL")) == null || cnt <= 0) continue;
                this.tblWriter.log(field, ti.getName(), cnt.toString());
            }
            ++n2;
        }
        this.tblWriter.endTable();
    }

    public boolean doFixTables() {
        int cnt = 0;
        if (this.fixCollectingObjectAttributesAfterConv()) {
            ++cnt;
        }
        return cnt == 0;
    }

    protected boolean fixTableWithColMemId(String cntSQL, String qrySQL, String oldClassName, String oldIdName, String newClassName, String newIdName) {
        return this.fixTable(cntSQL, qrySQL, oldClassName, oldIdName, newClassName, newIdName, "CollectionMemberID", null);
    }

    protected boolean fixTableWithColMemId(String cntSQL, String qrySQL, String oldClassName, String oldIdName, String newClassName, String newIdName, String mapperName) {
        return this.fixTable(cntSQL, qrySQL, oldClassName, oldIdName, newClassName, newIdName, "CollectionMemberID", mapperName);
    }

    protected boolean fixTableWithColMemId(String cntSQL, String qrySQL, String oldClassName, String oldIdName, String newClassName, String newIdName, String mapperName, String mapperSQL) {
        return this.fixTable(cntSQL, qrySQL, oldClassName, oldIdName, newClassName, newIdName, "CollectionMemberID", mapperName, mapperSQL);
    }

    protected boolean fixTableWithDisciplineId(String cntSQL, String qrySQL, String oldClassName, String oldIdName, String newClassName, String newIdName) {
        return this.fixTable(cntSQL, qrySQL, oldClassName, oldIdName, newClassName, newIdName, "DisciplineID", null);
    }

    protected boolean fixTable(String cntSQL, String qrySQL, String oldClassName, String oldIdName, String newClassName, String newIdName, String colToFix, String mapperName) {
        return this.fixTable(cntSQL, qrySQL, oldClassName, oldIdName, newClassName, newIdName, colToFix, mapperName, null);
    }

    protected boolean fixTable(String cntSQL, String qrySQL, String oldClassName, String oldIdName, String newClassName, String newIdName, String colToFix, String mapperName, String mapperSQL) {
        IdMapperIFace idMapper;
        int cnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, cntSQL);
        if (cnt == 0) {
            return true;
        }
        String newIdFieldName = newIdName == null ? oldIdName : newIdName;
        IdMapperIFace idMapperIFace = idMapper = mapperName == null ? IdMapperMgr.getInstance().get(oldClassName, oldIdName) : IdMapperMgr.getInstance().get(mapperName);
        if (idMapper == null && ((idMapper = IdMapperMgr.getInstance().addTableMapper(oldClassName, oldIdName, mapperSQL, false)) == null || idMapper.size() == 0)) {
            log.error((Object)("**** No Mapper for[" + oldClassName + "_" + oldIdName + "]"));
            return false;
        }
        Statement stmt = null;
        Statement pStmt = null;
        try {
            stmt = this.oldDBConn.createStatement(1004, 1007);
            String pStr = String.format("UPDATE %s SET %s=? WHERE %s=?", newClassName.toLowerCase(), colToFix, newIdFieldName);
            log.debug((Object)pStr);
            pStmt = this.newDBConn.prepareStatement(pStr);
            log.debug((Object)qrySQL);
            ResultSet rs = stmt.executeQuery(qrySQL);
            int count = 0;
            while (rs.next()) {
                String msg = null;
                Integer recId = rs.getInt(1);
                if (recId != null) {
                    Integer newId = idMapper.get(recId);
                    if (newId != null) {
                        Integer colMemId = this.catSerTypeToCollMemId.get(rs.getInt(2));
                        if (colMemId != null) {
                            try {
                                pStmt.setInt(1, colMemId);
                                pStmt.setInt(2, newId);
                                int upCnt = pStmt.executeUpdate();
                                if (upCnt != 1) {
                                    msg = String.format("Error updating %s for Old %s with new ID %d", colToFix, oldIdName, newId);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            msg = String.format("The CatalogSeriesID %d wasn't mapped to %s for Old %s %d", rs.getInt(2), colToFix, oldIdName, rs.getInt(1));
                        }
                    } else {
                        msg = String.format("The old %s ID: %d wasn't mapped.", oldIdName, rs.getInt(1));
                    }
                } else {
                    msg = String.format("The old %s ID: is NULL", oldIdName);
                }
                if (msg != null) {
                    log.error((Object)msg);
                    this.tblWriter.logError(msg);
                }
                ++count;
            }
            rs.close();
            this.tblWriter.log(String.format("Updated %d records in table %s", count, oldClassName));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    protected boolean fixBorrows() {
        int cnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM borrow");
        if (cnt > 0) {
            UIRegistry.showError("There are %d Borrows and we don't have a converter for them.");
        }
        return false;
    }
}

