/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.CollectionInfoModel;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.util.Pair;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectionInfo
implements Comparable<CollectionInfo> {
    protected static final Logger log = Logger.getLogger(CollectionInfo.class);
    protected static Vector<CollectionInfo> collectionInfoList = new Vector();
    protected static boolean askForFix = false;
    protected static PrintWriter pw = null;
    protected static int pwPassCnt = 1;
    public static boolean DOING_ACCESSSION = false;
    protected boolean isIncluded = true;
    protected Integer colObjTypeId;
    protected String colObjTypeName;
    protected int colObjCnt = 0;
    protected Integer catSeriesDefId;
    protected Integer catSeriesId;
    protected String catSeriesName;
    protected String catSeriesPrefix;
    protected String catSeriesRemarks;
    protected String catSeriesLastEditedBy;
    protected String combinedCatSeries;
    protected Integer taxonomyTypeId;
    protected String taxonomyTypeName;
    protected Integer taxonomicUnitTypeID;
    protected int kingdomId;
    protected TaxonTreeDef taxonTreeDef = null;
    protected Integer taxonNameId;
    protected String taxonName;
    protected Integer disciplineId;
    protected Discipline discipline = null;
    protected Integer collectionId;
    protected Collection collection = null;
    protected int taxonNameCnt;
    protected int colObjDetTaxCnt;
    protected long srcHostTaxonCnt;
    protected DisciplineType disciplineTypeObj;
    protected String determinationTaxonType = null;
    protected ArrayList<Integer> detTaxonTypeIdList = new ArrayList();
    protected HashMap<Integer, Taxon> placeHolderTreeHash = new HashMap();
    protected List<TaxonTreeDefItem> treeDefItems = null;
    protected HashMap<Integer, TaxonTreeDefItem> treeDefItemHash = new HashMap();
    protected HashMap<Integer, Integer> rankParentHash = new HashMap();
    protected Integer taxonRootId = null;
    protected Connection oldDBConn;

    public CollectionInfo(Connection oldDBConn) {
        this.oldDBConn = oldDBConn;
    }

    public HashMap<Integer, Taxon> getPlaceHolderTreeHash() {
        return this.placeHolderTreeHash;
    }

    public List<TaxonTreeDefItem> getTreeDefItems() {
        this.buildPlaceHolderInfo();
        return this.treeDefItems;
    }

    public Integer getTaxonRootId() {
        return this.taxonRootId;
    }

    public void setTaxonRootId(Integer taxonRootId) {
        this.taxonRootId = taxonRootId;
    }

    private void buildPlaceHolderInfo() {
        if (this.treeDefItems == null) {
            try {
                this.treeDefItems = new Vector<TaxonTreeDefItem>(this.taxonTreeDef.getTreeDefItems());
                Collections.sort(this.treeDefItems);
                int i = 0;
                for (TaxonTreeDefItem item : this.treeDefItems) {
                    if (i > 0) {
                        this.rankParentHash.put(item.getRankId(), this.treeDefItems.get(i - 1).getRankId());
                    }
                    ++i;
                    this.treeDefItemHash.put(item.getRankId(), item);
                }
                this.buildPlaceHolders();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void buildPlaceHolders() {
        if (this.placeHolderTreeHash.size() == 0) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    this.taxonTreeDef = session.get(TaxonTreeDef.class, this.taxonTreeDef.getId());
                    String msg = "SELECT TaxonID FROM taxon WHERE RankID = 0 AND TaxonTreeDefID = " + this.taxonTreeDef.getId();
                    log.debug((Object)msg);
                    Integer taxonId = BasicSQLUtils.getCount(msg);
                    if (taxonId != null) {
                        Taxon txRoot;
                        Taxon parent = txRoot = (Taxon)session.getData("FROM Taxon WHERE id = " + taxonId);
                        for (TaxonTreeDefItem item : this.treeDefItems) {
                            if (item.getRankId() <= 0) continue;
                            Taxon taxon = new Taxon();
                            taxon.initialize();
                            taxon.setRankId(item.getRankId());
                            taxon.setName("Placeholder");
                            taxon.setFullName(taxon.getName());
                            taxon.setDefinition(this.taxonTreeDef);
                            taxon.setDefinitionItem(item);
                            taxon.setParent(parent);
                            parent = taxon;
                            Object trans = null;
                            try {
                                session.beginTransaction();
                                session.save(taxon);
                                session.commit();
                                this.placeHolderTreeHash.put(item.getRankId(), taxon);
                            }
                            catch (Exception ex) {
                                if (trans == null) continue;
                                trans.rollback();
                            }
                        }
                    } else {
                        log.error((Object)"Couldn't find the Root Taxon Node");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    public HashMap<Integer, TaxonTreeDefItem> getTreeDefItemHash() {
        this.buildPlaceHolderInfo();
        return this.treeDefItemHash;
    }

    public HashMap<Integer, Integer> getRankParentHash() {
        this.buildPlaceHolderInfo();
        return this.rankParentHash;
    }

    public static Pair<CollectionInfo, DisciplineType> getDisciplineType(Connection oldDBConn) {
        int max = 0;
        CollectionInfo colInfo = null;
        int inx = 0;
        for (CollectionInfo ci : CollectionInfo.getCollectionInfoList(oldDBConn, true)) {
            if (ci.getColObjCnt() > max || DOING_ACCESSSION) {
                max = ci.getColObjCnt();
                colInfo = ci;
            }
            ++inx;
        }
        if (colInfo != null) {
            return new Pair<CollectionInfo, DisciplineType>(colInfo, DisciplineType.getDiscipline(colInfo.getColObjTypeName().toLowerCase()));
        }
        return null;
    }

    public static boolean isAskForFix() {
        return askForFix;
    }

    public static Vector<CollectionInfo> getCollectionInfoList(Connection oldDBConn) {
        return CollectionInfo.getCollectionInfoList(oldDBConn, false);
    }

    private static void logSQL(String desc, String sql) {
        pw.println(String.format("----------- %s -----------", desc));
        pw.println(sql);
        pw.println();
    }

    /*
     * Exception decompiling
     */
    public static Vector<CollectionInfo> getCollectionInfoList(Connection oldDBConn, boolean doSkipCheck) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getDeterminationTaxonType() {
        return this.determinationTaxonType;
    }

    public void setDeterminationTaxonType(String determinationTaxonType) {
        this.determinationTaxonType = determinationTaxonType;
        if (StringUtils.isNotEmpty((String)determinationTaxonType)) {
            String[] stringArray = StringUtils.split((String)determinationTaxonType, (char)',');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (StringUtils.isNumeric((String)str)) {
                    Integer id = Integer.parseInt(str);
                    this.detTaxonTypeIdList.add(id);
                }
                ++n2;
            }
        } else {
            determinationTaxonType = null;
        }
    }

    public List<Integer> getDetTaxonTypeIdList() {
        return this.detTaxonTypeIdList;
    }

    public boolean isTaxonomicUnitTypeInUse() {
        String sql = "SELECT COUNT(*) FROM taxonname WHERE TaxonomicUnitTypeID = " + this.taxonomicUnitTypeID;
        log.debug((Object)sql);
        int count = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM taxonname WHERE TaxonomicUnitTypeID = " + this.taxonomicUnitTypeID);
        log.debug((Object)("Count: " + count));
        return count > 0;
    }

    public static void dump() {
        for (CollectionInfo ci : collectionInfoList) {
            System.out.println("-----------------\n" + ci.toString());
        }
    }

    @Override
    public int compareTo(CollectionInfo o) {
        return this.taxonNameId.compareTo(o.taxonNameId);
    }

    public static Vector<CollectionInfo> getCollectionInfoList() {
        return collectionInfoList;
    }

    public static Vector<CollectionInfo> getFilteredCollectionInfoList() {
        if (DOING_ACCESSSION) {
            return new Vector<CollectionInfo>(collectionInfoList);
        }
        Vector<CollectionInfo> colList = new Vector<CollectionInfo>();
        for (CollectionInfo ci : collectionInfoList) {
            if (ci.getColObjCnt() <= 0 && ci.getSrcHostTaxonCnt() <= 0L) continue;
            colList.add(ci);
        }
        return colList;
    }

    public static DefaultTableModel getCollectionInfoTableModel(boolean doFilter) {
        CollectionInfoModel model = doFilter ? new CollectionInfoModel(CollectionInfo.getFilteredCollectionInfoList()) : new CollectionInfoModel(collectionInfoList);
        return model;
    }

    public static CollectionInfo getCollectionObjectTypeForNewCollection(Collection collection) {
        for (CollectionInfo ci : CollectionInfo.getFilteredCollectionInfoList()) {
            log.debug((Object)(String.valueOf(ci.toString()) + "  " + collection.getId()));
        }
        for (CollectionInfo ci : CollectionInfo.getFilteredCollectionInfoList()) {
            log.debug((Object)(String.valueOf(ci.getCatSeriesName()) + " " + ci.getCollectionId() + "  " + collection.getId()));
            if (!ci.getCollectionId().equals(collection.getId())) continue;
            return ci;
        }
        return null;
    }

    public int getTaxonNameCnt() {
        return this.taxonNameCnt;
    }

    public Integer getTaxonomicUnitTypeID() {
        return this.taxonomicUnitTypeID;
    }

    public void setTaxonomicUnitTypeID(Integer taxonomicUnitTypeID) {
        this.taxonomicUnitTypeID = taxonomicUnitTypeID;
    }

    public Integer getTaxonNameId() {
        return this.taxonNameId;
    }

    public int getColObjCnt() {
        return this.colObjCnt;
    }

    public void setColObjCnt(int colObjCnt) {
        this.colObjCnt = colObjCnt;
    }

    public long getSrcHostTaxonCnt() {
        return this.srcHostTaxonCnt;
    }

    public void setSrcHostTaxonCnt(long srcHostTaxonCnt) {
        this.srcHostTaxonCnt = srcHostTaxonCnt;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    public void setTaxonNameCnt(int taxonNameCnt) {
        this.taxonNameCnt = taxonNameCnt;
    }

    public int getColObjDetTaxCnt() {
        return this.colObjDetTaxCnt;
    }

    public void setColObjDetTaxCnt(int colObjDetTaxCnt) {
        this.colObjDetTaxCnt = colObjDetTaxCnt;
    }

    public TaxonTreeDef getTaxonTreeDef() {
        return this.taxonTreeDef;
    }

    public String getCatSeriesLastEditedBy() {
        return this.catSeriesLastEditedBy;
    }

    public void setCatSeriesLastEditedBy(String catSeriesLastEditedBy) {
        this.catSeriesLastEditedBy = catSeriesLastEditedBy;
    }

    public String getCatSeriesRemarks() {
        return this.catSeriesRemarks;
    }

    public void setCatSeriesRemarks(String catSeriesRemarks) {
        this.catSeriesRemarks = catSeriesRemarks;
    }

    public String getCatSeriesPrefix() {
        return this.catSeriesPrefix;
    }

    public void setCatSeriesPrefix(String catSeriesPrefix) {
        this.catSeriesPrefix = catSeriesPrefix;
    }

    public String getCatSeriesName() {
        return this.catSeriesName;
    }

    public void setCatSeriesName(String catSeriesName) {
        this.catSeriesName = catSeriesName;
    }

    public Integer getColObjTypeId() {
        return this.colObjTypeId;
    }

    public void setColObjTypeId(Integer colObjTypeId) {
        this.colObjTypeId = colObjTypeId;
    }

    public String getColObjTypeName() {
        return this.colObjTypeName;
    }

    public void setColObjTypeName(String colObjTypeName) {
        this.colObjTypeName = colObjTypeName;
    }

    public Integer getCatSeriesDefId() {
        return this.catSeriesDefId;
    }

    public void setCatSeriesDefId(Integer catSeriesDefId) {
        this.catSeriesDefId = catSeriesDefId;
    }

    public Integer getCatSeriesId() {
        return this.catSeriesId;
    }

    public void setCatSeriesId(Integer catSeriesId) {
        this.catSeriesId = catSeriesId;
    }

    public Integer getTaxonomyTypeId() {
        return this.taxonomyTypeId;
    }

    public void setTaxonomyTypeId(Integer taxonomyTypeId) {
        this.taxonomyTypeId = taxonomyTypeId;
    }

    public String getTaxonomyTypeName() {
        return this.taxonomyTypeName;
    }

    public void setTaxonomyTypeName(String taxonomyTypeName) {
        this.taxonomyTypeName = taxonomyTypeName;
    }

    public int getKingdomId() {
        return this.kingdomId;
    }

    public boolean isInUse() {
        return this.taxonNameCnt > 0;
    }

    public void setTaxonTreeDef(TaxonTreeDef taxonTreeDef) {
        this.taxonTreeDef = taxonTreeDef;
    }

    public void setKingdomId(int kingdomId) {
        this.kingdomId = kingdomId;
    }

    public void setTaxonNameId(int taxonNameId) {
        this.taxonNameId = taxonNameId;
    }

    public String getTaxonName() {
        return this.taxonName;
    }

    public void setTaxonName(String taxonName) {
        this.taxonName = taxonName;
    }

    public Integer getDisciplineId() {
        return this.disciplineId;
    }

    public void setDisciplineId(Integer disciplineId) {
        this.disciplineId = disciplineId;
    }

    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    public Integer getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(Integer collectionId) {
        this.collectionId = collectionId;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public DisciplineType getDisciplineTypeObj() {
        return this.disciplineTypeObj;
    }

    public void setDisciplineTypeObj(DisciplineType disciplineTypeObj) {
        this.disciplineTypeObj = disciplineTypeObj;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public String getCombinedCatSeries() {
        return this.combinedCatSeries;
    }

    public void setCombinedCatSeries(String combinedCatSeries) {
        this.combinedCatSeries = combinedCatSeries;
    }

    public String toString() {
        try {
            String result = "";
            Class<?> cls = this.getClass();
            Field[] fieldlist = cls.getDeclaredFields();
            int i = 0;
            while (i < fieldlist.length) {
                Field fld = fieldlist[i];
                if (!Modifier.isStatic(fld.getModifiers())) {
                    result = String.valueOf(result) + fld.getName() + " = " + fld.get(this) + "\n";
                }
                ++i;
            }
            result = String.valueOf(result) + "\n";
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return super.toString();
        }
    }
}

