/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException;
import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtilsMapValueIFace;
import edu.ku.brc.specify.conversion.FieldMetaData;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.PartialDateConv;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.ClobImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BasicSQLUtils {
    protected static final Logger log = Logger.getLogger(BasicSQLUtils.class);
    protected static TableWriter tblWriter = null;
    public static SERVERTYPE myDestinationServerType = SERVERTYPE.MySQL;
    public static SERVERTYPE mySourceServerType = SERVERTYPE.MySQL;
    public static final int HIDE_ALL_ERRORS = 0;
    public static final int SHOW_NAME_MAPPING_ERROR = 1;
    public static final int SHOW_VAL_MAPPING_ERROR = 2;
    public static final int SHOW_NULL_FK = 4;
    public static final int SHOW_FK_LOOKUP = 8;
    public static final int SHOW_NULL_PM = 16;
    public static final int SHOW_PM_LOOKUP = 32;
    public static final int SHOW_COPY_TABLE = 64;
    public static final int SHOW_ALL = 63;
    protected static int showErrors = 63;
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Calendar calendar = new GregorianCalendar();
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected static int currentYear;
    protected static Map<String, String> ignoreMappingFieldNames;
    protected static Map<String, String> ignoreMappingFieldIDs;
    protected static Map<String, String> oneToOneIDHash;
    protected static Hashtable<String, BasicSQLUtilsMapValueIFace> columnValueMapper;
    protected static Connection dbConn;
    protected static ProgressFrame frame;
    protected static boolean ignoreMySQLduplicates;
    protected static boolean skipTrackExceptions;
    protected static PartialDateConv datePair;
    protected static PrintWriter missingPW;

    static {
        ignoreMappingFieldNames = null;
        ignoreMappingFieldIDs = null;
        oneToOneIDHash = null;
        columnValueMapper = new Hashtable();
        dbConn = null;
        frame = null;
        ignoreMySQLduplicates = true;
        skipTrackExceptions = false;
        datePair = new PartialDateConv();
        missingPW = null;
        currentYear = calendar.get(1);
    }

    protected BasicSQLUtils() {
    }

    public static int getShowErrors() {
        return showErrors;
    }

    public static void setShowErrors(int showErrors) {
        BasicSQLUtils.showErrors = showErrors;
    }

    public static void setSkipTrackExceptions(boolean skipTrackExceptions) {
        BasicSQLUtils.skipTrackExceptions = skipTrackExceptions;
    }

    public static boolean isSkipTrackExceptions() {
        return skipTrackExceptions;
    }

    public static void setDBConnection(Connection connection) {
        dbConn = connection;
    }

    public static void setFrame(ProgressFrame frame) {
        BasicSQLUtils.frame = frame;
    }

    public static void setProcess(int min, int max) {
        if (frame != null) {
            frame.setProcess(min, max);
        }
    }

    public static void setProcess(int value) {
        if (frame != null) {
            frame.setProcess(value);
        }
    }

    public static TableWriter getTblWriter() {
        return tblWriter;
    }

    public static void setTblWriter(TableWriter tblWriter) {
        BasicSQLUtils.tblWriter = tblWriter;
    }

    public static void setOneToOneIDHash(Map<String, String> oneToOneIDHash) {
        BasicSQLUtils.oneToOneIDHash = oneToOneIDHash;
    }

    public static void clearValueMapper() {
        columnValueMapper.clear();
    }

    public static void addToValueMapper(String newFieldName, BasicSQLUtilsMapValueIFace mapper) {
        columnValueMapper.put(newFieldName, mapper);
    }

    protected static Map<String, String> configureIgnoreMap(String[] fieldNames, Map<String, String> ignoreMap) {
        Map<String, String> ignoreMapLocal = ignoreMap;
        if (fieldNames == null) {
            if (ignoreMapLocal != null) {
                ignoreMapLocal.clear();
                ignoreMapLocal = null;
            }
        } else {
            if (ignoreMapLocal == null) {
                ignoreMapLocal = UIHelper.createMap();
            } else {
                ignoreMapLocal.clear();
            }
            String[] stringArray = fieldNames;
            int n = fieldNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ignoreMapLocal.put(name, "X");
                ++n2;
            }
        }
        return ignoreMapLocal;
    }

    public static void setFieldsToIgnoreWhenMappingNames(String[] fieldNames) {
        ignoreMappingFieldNames = BasicSQLUtils.configureIgnoreMap(fieldNames, ignoreMappingFieldNames);
    }

    public static boolean hasIgnoreFields() {
        return ignoreMappingFieldNames != null;
    }

    public static void setFieldsToIgnoreWhenMappingIDs(String[] fieldNames) {
        ignoreMappingFieldIDs = BasicSQLUtils.configureIgnoreMap(fieldNames, ignoreMappingFieldIDs);
    }

    public static int exeUpdateCmd(Statement stmt, String cmdStr) {
        try {
            stmt.setEscapeProcessing(true);
            return stmt.executeUpdate(cmdStr);
        }
        catch (Exception ex) {
            if (ex instanceof MySQLIntegrityConstraintViolationException && cmdStr.contains("INSERT INTO accessionagent")) {
                log.error((Object)("ignoring a record because it makes a MySQLIntegrityConstraintViolation: " + ex.getStackTrace().toString()));
                log.error((Object)(String.valueOf(cmdStr) + "\n"));
                ex.printStackTrace();
                return 0;
            }
            if (cmdStr.contains("INSERT INTO accessionagent")) {
                log.error((Object)("ignoring a record because it makes a uncatchable SQL Exception: " + ex.getMessage()));
                log.error((Object)("    " + cmdStr + "\n"));
                return 0;
            }
            log.error((Object)ex.getMessage());
            log.error((Object)(String.valueOf(cmdStr) + "\n"));
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static Integer getInsertedId(Statement stmt) {
        ResultSet resultSet = null;
        try {
            resultSet = stmt.getGeneratedKeys();
            if (resultSet != null && resultSet.next()) {
                Integer n = resultSet.getInt(1);
                return n;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    public static int deleteAllRecordsFromTable(String tableName, SERVERTYPE currentServerType) {
        int count = 0;
        try {
            Connection connection = dbConn != null ? dbConn : DBConnection.getInstance().createConnection();
            count = BasicSQLUtils.deleteAllRecordsFromTable(connection, tableName, currentServerType);
            if (dbConn == null) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static Integer getCount(String sql) {
        return BasicSQLUtils.getCount(dbConn != null ? dbConn : DBConnection.getInstance().getConnection(), sql);
    }

    public static int getCountAsInt(String sql) {
        return BasicSQLUtils.getCountAsInt(dbConn != null ? dbConn : DBConnection.getInstance().getConnection(), sql);
    }

    public static int getCountAsInt(Connection conn, String sql) {
        Integer cnt = BasicSQLUtils.getCount(conn, sql);
        return cnt == null ? 0 : cnt;
    }

    public static Integer getCount(Connection connection, String sql) {
        Integer count = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                count = rs.getInt(1);
                Integer n = rs.wasNull() ? null : count;
                return n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public static String getString(String sql) {
        return BasicSQLUtils.getString(dbConn != null ? dbConn : DBConnection.getInstance().getConnection(), sql);
    }

    public static String getString(Connection connection, String sql) {
        String str;
        block13: {
            str = null;
            Statement stmt = null;
            try {
                try {
                    stmt = connection.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        str = rs.getString(1);
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (stmt == null) break block13;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return str;
    }

    public static Object[] getRow(String sql) {
        return BasicSQLUtils.getRow(dbConn != null ? dbConn : DBConnection.getInstance().getConnection(), sql);
    }

    public static Object[] getRow(Connection connection, String sql) {
        Object[] row;
        block14: {
            row = null;
            Statement stmt = null;
            try {
                try {
                    stmt = connection.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        row = new Object[rs.getMetaData().getColumnCount()];
                        int i = 1;
                        while (i <= rs.getMetaData().getColumnCount()) {
                            row[i - 1] = rs.getObject(i);
                            ++i;
                        }
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return row;
    }

    public static Object[] queryForRow(String sql) {
        return BasicSQLUtils.queryForRow(dbConn != null ? dbConn : DBConnection.getInstance().getConnection(), sql);
    }

    public static Object[] queryForRow(Connection connection, String sql) {
        Object[] row;
        block14: {
            row = null;
            Statement stmt = null;
            try {
                try {
                    stmt = connection.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        row = new Object[rs.getMetaData().getColumnCount()];
                        int i = 1;
                        while (i <= rs.getMetaData().getColumnCount()) {
                            row[i - 1] = rs.getObject(i);
                            ++i;
                        }
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return row;
    }

    public static Vector<Object[]> query(String sql) {
        return BasicSQLUtils.query(null, sql, false);
    }

    public static Vector<Object[]> query(Connection conn, String sql) {
        return BasicSQLUtils.query(conn, sql, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector<Object[]> query(Connection conn, String sql, boolean includeHeaderRow) {
        list = new Vector<Object[]>();
        stmt = null;
        connection = null;
        doCloseConn = false;
        doSkipConnSet = false;
        isStale = true;
        tries = 0;
        while (isStale != false) {
            block42: {
                if (tries >= 3) {
                    return list;
                }
                try {
                    if (!doSkipConnSet) {
                        if (conn != null) {
                            connection = conn;
                        } else if (BasicSQLUtils.dbConn != null) {
                            connection = BasicSQLUtils.dbConn;
                        } else {
                            connection = DBConnection.getInstance().createConnection();
                            doCloseConn = true;
                        }
                    }
                    if (connection == null) {
                        var16_26 = list;
                        if (stmt == null) return var16_26;
                    }
                    ** GOTO lbl-1000
                }
                catch (CommunicationsException ex) {
                    connection = DBConnection.getInstance().createConnection();
                    doCloseConn = true;
                    doSkipConnSet = true;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception var17_21) {}
                    }
                    break block42;
                }
                catch (MySQLSyntaxErrorException e) {
                    e.printStackTrace();
                    if (!BasicSQLUtils.skipTrackExceptions) {
                        UsageTracker.incrSQLUsageCount();
                        ExceptionTracker.getInstance().capture(BasicSQLUtils.class, (Exception)e);
                    }
                    break block42;
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        if (!BasicSQLUtils.skipTrackExceptions) {
                            UsageTracker.incrSQLUsageCount();
                            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                        }
                        if (stmt == null) break block42;
                        try {
                            stmt.close();
                        }
                        catch (Exception var17_23) {}
                        break block42;
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception var17_22) {}
                        }
                    }
                }
                try {
                    stmt.close();
                    return var16_26;
                }
                catch (Exception var17_20) {
                    // empty catch block
                }
                return var16_26;
lbl-1000:
                // 1 sources

                {
                    ++tries;
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(sql);
                    metaData = rs.getMetaData();
                    numCols = metaData.getColumnCount();
                    if (includeHeaderRow) {
                        colData = new Object[numCols];
                        list.add(colData);
                        i = 0;
                        while (i < numCols) {
                            colData[i] = metaData.getColumnName(i + 1);
                            ++i;
                        }
                    }
                    block26: while (true) {
                        if (!rs.next()) {
                            rs.close();
                            isStale = false;
                            break;
                        }
                        colData = new Object[numCols];
                        list.add(colData);
                        i = 0;
                        while (true) {
                            if (i >= numCols) continue block26;
                            colData[i] = rs.getObject(i + 1);
                            ++i;
                        }
                        break;
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception var17_25) {
                        // empty catch block
                    }
                }
            }
            if (isStale || connection == null || !doCloseConn) continue;
            try {
                connection.close();
            }
            catch (Exception var10_14) {
                // empty catch block
            }
        }
        return list;
    }

    public static Vector<Object> querySingleCol(String sql) {
        return BasicSQLUtils.querySingleCol(null, sql);
    }

    public static Vector<Object> querySingleCol(Connection conn, String sql) {
        Vector<Object> list = new Vector<Object>();
        Statement stmt = null;
        Connection connection = null;
        boolean doCloseConn = false;
        boolean doSkipConnSet = false;
        boolean isStale = true;
        int tries = 0;
        while (isStale && tries < 3) {
            block30: {
                try {
                    if (!doSkipConnSet) {
                        if (conn != null) {
                            connection = conn;
                        } else if (dbConn != null) {
                            connection = dbConn;
                        } else {
                            connection = DBConnection.getInstance().createConnection();
                            doCloseConn = true;
                        }
                    }
                    ++tries;
                    if (connection != null) {
                        stmt = connection.createStatement();
                        ResultSet rs = stmt.executeQuery(sql);
                        ResultSetMetaData metaData = rs.getMetaData();
                        int numCols = metaData.getColumnCount();
                        if (numCols > 1) {
                            log.warn((Object)("Query has " + numCols + " columns and should only have one."));
                        }
                        while (rs.next()) {
                            list.add(rs.getObject(1));
                        }
                        rs.close();
                        isStale = false;
                    } else {
                        isStale = true;
                    }
                }
                catch (CommunicationsException ex) {
                    connection = DBConnection.getInstance().createConnection();
                    doCloseConn = true;
                    doSkipConnSet = true;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block30;
                }
                catch (SQLException ex) {
                    try {
                        ex.printStackTrace();
                        if (!skipTrackExceptions) {
                            UsageTracker.incrSQLUsageCount();
                            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                        }
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (stmt == null) break block30;
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isStale || connection == null || !doCloseConn) continue;
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public static <T> T querySingleObj(String sql) {
        return BasicSQLUtils.querySingleObj(null, sql);
    }

    public static <T> T querySingleObj(Connection conn, String sql) {
        Vector<Object> list = BasicSQLUtils.querySingleCol(conn, sql);
        if (list.size() > 1) {
            log.warn((Object)("The query [" + sql + "] returned more than one object."));
        }
        return (T)(list.size() > 0 ? list.get(0) : null);
    }

    public static Vector<Integer> queryForInts(String sql) {
        return BasicSQLUtils.queryForInts(null, sql);
    }

    public static Vector<Integer> queryForInts(Connection conn, String sql) {
        Vector<Integer> list = new Vector<Integer>();
        Statement stmt = null;
        Connection connection = null;
        boolean doCloseConn = false;
        boolean doSkipConnSet = false;
        boolean isStale = true;
        int tries = 0;
        while (isStale && tries < 3) {
            block28: {
                try {
                    if (!doSkipConnSet) {
                        if (conn != null) {
                            connection = conn;
                        } else if (dbConn != null) {
                            connection = dbConn;
                        } else {
                            connection = DBConnection.getInstance().createConnection();
                            doCloseConn = true;
                        }
                    }
                    ++tries;
                    stmt = connection.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    ResultSetMetaData metaData = rs.getMetaData();
                    int numCols = metaData.getColumnCount();
                    if (numCols > 1) {
                        log.warn((Object)("Query has " + numCols + " columns and should only have one."));
                    }
                    while (rs.next()) {
                        list.add(rs.getInt(1));
                    }
                    rs.close();
                    isStale = false;
                }
                catch (CommunicationsException ex) {
                    connection = DBConnection.getInstance().createConnection();
                    doCloseConn = true;
                    doSkipConnSet = true;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block28;
                }
                catch (SQLException ex) {
                    try {
                        ex.printStackTrace();
                        if (!skipTrackExceptions) {
                            UsageTracker.incrSQLUsageCount();
                            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                        }
                        break block28;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (stmt == null) break block28;
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isStale || connection == null || !doCloseConn) continue;
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public static int update(String sql) {
        return BasicSQLUtils.update(null, sql);
    }

    public static int update(Connection conn, String sql) {
        Statement stmt = null;
        try {
            Connection connection = conn != null ? conn : (dbConn != null ? dbConn : DBConnection.getInstance().getConnection());
            stmt = connection.createStatement();
            int n = stmt.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            if (!skipTrackExceptions) {
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return -1;
    }

    public static int deleteAllRecordsFromTable(Connection connection, String tableName, SERVERTYPE currentServerType) {
        block4: {
            Integer count;
            block5: {
                if (!BasicSQLUtils.doesTableExist(connection, tableName)) break block4;
                count = BasicSQLUtils.getCount(connection, "SELECT COUNT(*) FROM " + tableName);
                if (count != null && count != 0) break block5;
                return 0;
            }
            try {
                Statement stmt = connection.createStatement(1004, 1007);
                if (currentServerType != SERVERTYPE.MS_SQLServer) {
                    BasicSQLUtils.removeForeignKeyConstraints(stmt.getConnection(), currentServerType);
                }
                int retVal = BasicSQLUtils.exeUpdateCmd(stmt, "delete from " + tableName);
                stmt.clearBatch();
                stmt.close();
                log.info((Object)("Deleted " + count + " records from " + tableName));
                return retVal;
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
        return 0;
    }

    public static boolean doesTableExist(Connection connection, String tableName) {
        ResultSet rs;
        block3: {
            DatabaseMetaData mdm = connection.getMetaData();
            rs = mdm.getColumns(connection.getCatalog(), connection.getCatalog(), tableName, null);
            if (!rs.next()) break block3;
            rs.close();
            return true;
        }
        try {
            rs.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void cleanAllTables(SERVERTYPE currentServerType) {
        try {
            Connection connection = dbConn != null ? dbConn : DBConnection.getInstance().createConnection();
            BasicSQLUtils.cleanAllTables(connection, currentServerType);
            if (dbConn == null) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)ex);
        }
    }

    public static String getDatabaseName(Connection connection) {
        String databaseName = null;
        try {
            databaseName = connection.getCatalog();
            return databaseName;
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
            return databaseName;
        }
    }

    public static void cleanAllTables(Connection connection, SERVERTYPE currentServerType) {
        try {
            Statement stmt = connection.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery("show tables");
            if (rs.first()) {
                do {
                    String tableName = rs.getString(1);
                    BasicSQLUtils.deleteAllRecordsFromTable(connection, tableName, currentServerType);
                } while (rs.next());
            }
            rs.close();
            stmt.clearBatch();
            stmt.close();
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
    }

    public static String getStrValue(Object obj) {
        return BasicSQLUtils.getStrValue(obj, null);
    }

    public static String getStrValue(Boolean val) {
        return Integer.toString(val == false ? 0 : 1);
    }

    public static String getEscapedSQLStrExpr(String str) {
        if (str != null) {
            String delimiter = "'";
            return String.valueOf(delimiter) + BasicSQLUtils.escapeStringLiterals(str, delimiter) + delimiter;
        }
        return null;
    }

    public static String escapeStringLiterals(String str) {
        return BasicSQLUtils.escapeStringLiterals(str, "'");
    }

    public static String escapeStringLiterals(String str, String enclosingChar) {
        if (str != null) {
            String s = str;
            if (s.indexOf("\\") >= 0 && myDestinationServerType != SERVERTYPE.MS_SQLServer) {
                s = s.replaceAll("\\\\", "\\\\\\\\");
            }
            if (enclosingChar.equals("\"") && s.indexOf("\"") >= 0) {
                s = s.replaceAll("\"", "\\\"\"");
            }
            if (enclosingChar.equals("'") && s.indexOf("'") >= 0) {
                s = s.replaceAll("'", "''");
            }
            return s;
        }
        return null;
    }

    public static Date getDateObj(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            BasicSQLUtils.getPartialDate(obj, datePair);
            if (!datePair.isNull()) {
                try {
                    java.util.Date d = dateFormatter.parse(datePair.getDateStr());
                    if (d != null) {
                        return new Date(d.getTime());
                    }
                    return null;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        if (obj instanceof java.util.Date) {
            return new Date(((java.util.Date)obj).getTime());
        }
        return null;
    }

    public static String getStrValue(Object obj, String newFieldType) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof ClobImpl) {
            String str = "";
            ClobImpl clob = (ClobImpl)obj;
            try {
                str = clob.getSubString(1L, (int)clob.length());
                return BasicSQLUtils.getEscapedSQLStrExpr(str);
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                log.error((Object)"error occurred trying to get string from clob for SQL Server driver");
                ex.printStackTrace();
                System.exit(0);
                return obj.toString();
            }
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return BasicSQLUtils.getEscapedSQLStrExpr(str);
        }
        if (obj instanceof Integer) {
            if (newFieldType != null) {
                if (newFieldType.toLowerCase().indexOf("date") == 0) {
                    BasicSQLUtils.getPartialDate(obj, datePair);
                    return datePair.getDateStr();
                }
                if (newFieldType.equalsIgnoreCase("bit") || newFieldType.equalsIgnoreCase("tinyint") || newFieldType.equalsIgnoreCase("boolean")) {
                    int val = (Integer)obj;
                    return Integer.toString(val == 0 ? 0 : 1);
                }
                if (newFieldType.equalsIgnoreCase("bit(1)") || newFieldType.equalsIgnoreCase("tinyint(1)")) {
                    int val = (Integer)obj;
                    return Integer.toString(val == 0 ? 0 : 1);
                }
                return ((Integer)obj).toString();
            }
            return ((Integer)obj).toString();
        }
        if (obj instanceof java.util.Date) {
            return String.valueOf('\"') + dateTimeFormatter.format((java.util.Date)obj) + '\"';
        }
        if (obj instanceof Float) {
            return ((Float)obj).toString();
        }
        if (obj instanceof Double) {
            return ((Double)obj).toString();
        }
        if (obj instanceof Character) {
            return String.valueOf('\"') + ((Character)obj).toString() + '\"';
        }
        return obj.toString();
    }

    public static List<String> getFieldNamesFromSchema(Connection connection, String tableName) {
        try {
            ArrayList<String> fields = new ArrayList<String>();
            DatabaseMetaData mdm = connection.getMetaData();
            ResultSet rs = mdm.getColumns(connection.getCatalog(), connection.getCatalog(), tableName, null);
            while (rs.next()) {
                fields.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            return fields;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List<String> getFieldNamesFromSchema(Connection connection, String tableName, List<String> fields) {
        try {
            DatabaseMetaData mdm = connection.getMetaData();
            ResultSet rs = mdm.getColumns(connection.getCatalog(), connection.getCatalog(), tableName, null);
            while (rs.next()) {
                fields.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            return fields;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List<String> getTableNames(Connection connection) {
        try {
            ArrayList<String> fields = new ArrayList<String>();
            DatabaseMetaData mdm = connection.getMetaData();
            ResultSet rs = mdm.getTables(connection.getCatalog(), connection.getCatalog(), null, new String[]{"TABLE"});
            while (rs.next()) {
                fields.add(rs.getString("TABLE_NAME"));
            }
            rs.close();
            return fields;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List<FieldMetaData> getFieldMetaDataFromSchema(Connection connection, String tableName) {
        try {
            ArrayList<FieldMetaData> fields = new ArrayList<FieldMetaData>();
            DatabaseMetaData mdm = connection.getMetaData();
            ResultSet rs = mdm.getColumns(connection.getCatalog(), connection.getCatalog(), tableName, null);
            while (rs.next()) {
                String typeStr = rs.getString("TYPE_NAME");
                FieldMetaData fmd = new FieldMetaData(rs.getString("COLUMN_NAME"), typeStr, typeStr.startsWith("DATE"), false, StringUtils.contains((String)typeStr.toLowerCase(), (String)"varchar"));
                fmd.setSqlType(rs.getInt("DATA_TYPE"));
                fields.add(fmd);
            }
            rs.close();
            return fields;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setData(PreparedStatement pStmt, int type, int colInx, Object data) throws SQLException {
        if (data == null) {
            pStmt.setObject(colInx, null);
            return;
        }
        boolean isStr = data instanceof String;
        switch (type) {
            case -6: 
            case 4: 
            case 5: {
                if (isStr) {
                    pStmt.setString(colInx, (String)data);
                    break;
                }
                pStmt.setInt(colInx, (Integer)data);
                break;
            }
            case 6: {
                if (isStr) {
                    pStmt.setString(colInx, (String)data);
                    break;
                }
                pStmt.setFloat(colInx, ((Float)data).floatValue());
                break;
            }
            case -16: 
            case -15: 
            case -1: 
            case 1: 
            case 12: {
                if (isStr) {
                    pStmt.setString(colInx, (String)data);
                    break;
                }
                pStmt.setString(colInx, (String)data);
                break;
            }
            case 7: 
            case 8: {
                if (isStr) {
                    pStmt.setString(colInx, (String)data);
                    break;
                }
                pStmt.setDouble(colInx, (Double)data);
                break;
            }
            case 91: {
                if (isStr) {
                    pStmt.setString(colInx, (String)data);
                    break;
                }
                pStmt.setDate(colInx, (Date)data);
                break;
            }
            case 93: {
                if (isStr) {
                    pStmt.setString(colInx, (String)data);
                    break;
                }
                pStmt.setTimestamp(colInx, (Timestamp)data);
                break;
            }
            case 16: {
                if (isStr) {
                    String val = (String)data;
                    pStmt.setBoolean(colInx, !val.equalsIgnoreCase("true"));
                    break;
                }
                pStmt.setBoolean(colInx, (Boolean)data);
                break;
            }
            case -7: {
                if (data instanceof Boolean) {
                    pStmt.setBoolean(colInx, (Boolean)data);
                    break;
                }
                pStmt.setBoolean(colInx, (Integer)data != 0);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Missing case for SQL Type %d for Column: %d Data[%s]", type, colInx, data.getClass().getSimpleName()));
            }
        }
    }

    public static Map<String, FieldMetaData> getFieldMetaDataFromSchemaHash(Connection connection, String tableName) {
        Hashtable<String, FieldMetaData> fieldMetaDataMap = new Hashtable<String, FieldMetaData>();
        for (FieldMetaData fmd : BasicSQLUtils.getFieldMetaDataFromSchema(connection, tableName)) {
            fieldMetaDataMap.put(fmd.getName(), fmd);
        }
        return fieldMetaDataMap;
    }

    public static java.util.Date convertIntToDate(int iDate, StringBuilder verbatimDate) {
        calendar.clear();
        int year = iDate / 20000;
        if (year > 1600) {
            int tmp = iDate - year * 20000;
            int month = tmp / 100;
            int day = tmp - month * 100;
            if (month == 0 || day == 0) {
                verbatimDate.setLength(0);
                verbatimDate.append(Integer.toString(iDate));
                if (month == 0) {
                    month = 7;
                }
                if (day == 0) {
                    day = 1;
                }
            }
            calendar.set(year, month - 1, day);
        } else {
            calendar.setTimeInMillis(0L);
        }
        return calendar.getTime();
    }

    protected static void writeErrLog(String msg) {
        if (tblWriter != null) {
            tblWriter.logError(msg);
            tblWriter.flush();
        } else if (missingPW != null) {
            missingPW.println(msg);
            missingPW.flush();
        }
    }

    public static boolean copyTable(Connection fromConn, Connection toConn, String tableName, Map<String, String> colNewToOldMap, Map<String, String> verbatimDateMapper, SERVERTYPE sourceServerType, SERVERTYPE destServerType) {
        return BasicSQLUtils.copyTable(fromConn, toConn, "select * from " + tableName, tableName, tableName, colNewToOldMap, verbatimDateMapper, sourceServerType, destServerType);
    }

    public static boolean copyTable(Connection fromConn, Connection toConn, String fromTableName, String toTableName, Map<String, String> colNewToOldMap, Map<String, String> verbatimDateMapper, SERVERTYPE sourceServerType, SERVERTYPE destServerType) {
        return BasicSQLUtils.copyTable(fromConn, toConn, "select * from " + fromTableName, fromTableName, toTableName, colNewToOldMap, verbatimDateMapper, sourceServerType, destServerType);
    }

    public static boolean copyTable(Connection conn, String fromTableName, String toTableName, Map<String, String> colNewToOldMap, Map<String, String> verbatimDateMapper, SERVERTYPE sourceServerType, SERVERTYPE destServerType) {
        return BasicSQLUtils.copyTable(conn, conn, "select * from " + fromTableName, fromTableName, toTableName, colNewToOldMap, verbatimDateMapper, sourceServerType, destServerType);
    }

    public static boolean copyTable(Connection fromConn, Connection toConn, String sql, String fromTableName, String toTableName, Map<String, String> colNewToOldMap, Map<String, String> verbatimDateMapper, SERVERTYPE sourceServerType, SERVERTYPE destServerType) {
        String sqlStr = sql == null ? "SELECT * FROM " + fromTableName : sql;
        return BasicSQLUtils.copyTable(fromConn, toConn, sqlStr, fromTableName, toTableName, colNewToOldMap, verbatimDateMapper, null, sourceServerType, destServerType);
    }

    public static boolean copyTable(Connection fromConn, Connection toConn, String sql, String fromTableName, String toTableName, Map<String, String> colNewToOldMap, Map<String, String> verbatimDateMapper, Map<String, String> newColDefValues, SERVERTYPE sourceServerType, SERVERTYPE destServerType) {
        return BasicSQLUtils.copyTable(fromConn, toConn, sql, null, fromTableName, toTableName, colNewToOldMap, verbatimDateMapper, newColDefValues, sourceServerType, destServerType);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyTable(Connection fromConn, Connection toConn, String sql, String countSQL, String fromTableName, String toTableName, Map<String, String> colNewToOldMap, Map<String, String> verbatimDateMapper, Map<String, String> newColDefValues, SERVERTYPE sourceServerType, SERVERTYPE destServerType) {
        idMapperMgr = IdMapperMgr.getInstance();
        if (BasicSQLUtils.frame != null) {
            BasicSQLUtils.frame.setDesc("Copying Table " + fromTableName);
        }
        BasicSQLUtils.log.info((Object)("Copying Table " + fromTableName));
        fromFieldNameList = BasicSQLUtils.getFieldNamesFromSchema(fromConn, fromTableName);
        sqlStr = String.valueOf(sql) + " ORDER BY " + fromTableName + "." + fromFieldNameList.get(0);
        BasicSQLUtils.log.debug((Object)sqlStr);
        numRecs = countSQL == null ? BasicSQLUtils.getNumRecords(fromConn, fromTableName) : BasicSQLUtils.getCountAsInt(fromConn, countSQL);
        BasicSQLUtils.setProcess(0, numRecs);
        tblInfo = DBTableIdMgr.getInstance().getInfoByTableName(toTableName);
        updateStatement = null;
        id = "";
        try {
            block83: {
                updateStatement = toConn.createStatement(1004, 1007);
                if (BasicSQLUtils.myDestinationServerType != SERVERTYPE.MS_SQLServer) {
                    BasicSQLUtils.removeForeignKeyConstraints(toConn, BasicSQLUtils.myDestinationServerType);
                }
                newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(toConn, toTableName);
                stmt = fromConn.createStatement(1004, 1007);
                rs = stmt.executeQuery(sqlStr);
                rsmd = rs.getMetaData();
                dateColumns = new Vector<Integer>();
                fromHash = new Hashtable<String, Integer>();
                i = 1;
                while (true) {
                    if (i > rsmd.getColumnCount()) {
                        oldNameToNewNameHash = new Hashtable<String, String>();
                        if (colNewToOldMap != null) {
                            var26_28 = colNewToOldMap.keySet().iterator();
                            break;
                        }
                        break block83;
                    }
                    colName = rsmd.getColumnName(i);
                    fromHash.put(colName, i);
                    if (rsmd.getColumnType(i) == 91 || colName.toLowerCase().endsWith("date") || colName.toLowerCase().startsWith("date")) {
                        dateColumns.add(i);
                    }
                    ++i;
                }
                while (var26_28.hasNext()) {
                    newName = var26_28.next();
                    oldName = colNewToOldMap.get(newName);
                    System.out.println("Mapping oldName[" + (oldName == null ? newName : oldName) + " -> " + newName);
                    oldNameToNewNameHash.put(oldName == null ? newName : oldName, newName);
                }
            }
            dateMap = new Hashtable<String, PartialDateConv>();
            insertSQL = null;
            timestampModifiedInx = (Integer)fromHash.get("TimestampModified");
            timestampCreatedInx = (Integer)fromHash.get("TimestampCreated");
            isAccessionTable = fromTableName.equals("accession");
            str = new StringBuffer(1024);
            count = 0;
            if (true) ** GOTO lbl86
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            BasicSQLUtils.log.error((Object)sqlStr);
            BasicSQLUtils.log.error((Object)ex);
            BasicSQLUtils.log.error((Object)("ID: " + id));
            try {
                updateStatement.clearBatch();
                updateStatement.close();
            }
            catch (SQLException var48_59) {}
        }
        catch (Throwable var47_62) {
            try {
                updateStatement.clearBatch();
                updateStatement.close();
                throw var47_62;
            }
            catch (SQLException var48_60) {
                // empty catch block
            }
            throw var47_62;
        }
lbl76:
        // 1 sources

        while (true) {
            try {
                updateStatement.clearBatch();
                updateStatement.close();
                return false;
            }
            catch (SQLException var48_58) {
                // empty catch block
            }
            return false;
        }
        {
            block85: {
                block84: {
                    while (true) {
                        block89: {
                            block88: {
                                block87: {
                                    block86: {
                                        ++count;
lbl86:
                                        // 2 sources

                                        if (!rs.next()) {
                                            if (BasicSQLUtils.frame == null) break block84;
                                            BasicSQLUtils.frame.setProcess(count);
                                            break block85;
                                        }
                                        skipRecord = false;
                                        dateMap.clear();
                                        var34_37 = dateColumns.iterator();
                                        while (true) {
                                            if (!var34_37.hasNext()) {
                                                timestampCreatedCached = BasicSQLUtils.now;
                                                timestampModifiedCached /* !! */  = BasicSQLUtils.now;
                                                if (timestampModifiedInx == null || timestampCreatedInx == null) break block86;
                                                timestampModifiedCached /* !! */  = rs.getDate(timestampModifiedInx);
                                                timestampCreatedCached = rs.getDate(timestampCreatedInx);
                                                if (timestampModifiedCached /* !! */  != null || timestampCreatedCached != null) break;
                                                timestampCreatedCached = Calendar.getInstance().getTime();
                                                timestampModifiedCached /* !! */  = Calendar.getInstance().getTime();
                                                break block87;
                                            }
                                            i = (Integer)var34_37.next();
                                            oldColName = rsmd.getColumnName(i);
                                            oldColIndex = (Integer)fromHash.get(oldColName);
                                            if (oldColIndex == null) {
                                                BasicSQLUtils.log.error((Object)("Couldn't find new column for old column for date for Table[" + fromTableName + "] Col Name[" + newFieldMetaData.get(i).getName() + "]"));
                                                continue;
                                            }
                                            if (oldColIndex > newFieldMetaData.size()) continue;
                                            v0 = newColName = colNewToOldMap != null ? (String)oldNameToNewNameHash.get(oldColName) : null;
                                            if (newColName == null) {
                                                newColName = oldColName;
                                            }
                                            if (!((dataObj = rs.getObject(i)) instanceof Integer)) continue;
                                            datep = new PartialDateConv();
                                            BasicSQLUtils.getPartialDate((Integer)dataObj, datep);
                                            dateMap.put(newColName, datep);
                                        }
                                        if (timestampModifiedCached /* !! */  == null && timestampCreatedCached != null) {
                                            timestampModifiedCached /* !! */  = new java.util.Date(timestampCreatedCached.getTime());
                                            break block87;
                                        } else {
                                            timestampCreatedCached = timestampModifiedCached /* !! */  != null ? new java.util.Date(timestampModifiedCached /* !! */ .getTime()) : new java.util.Date();
                                        }
                                        break block87;
                                    }
                                    if (timestampModifiedInx != null && (timestampModifiedCached /* !! */  = rs.getDate(timestampModifiedInx)) == null) {
                                        timestampModifiedCached /* !! */  = BasicSQLUtils.now;
                                    }
                                    if (timestampCreatedInx != null && (timestampCreatedCached = rs.getDate(timestampCreatedInx)) == null) {
                                        timestampCreatedCached = BasicSQLUtils.now;
                                    }
                                }
                                str.setLength(0);
                                if (insertSQL == null) {
                                    fieldList = new StringBuffer();
                                    fieldList.append("( ");
                                    i = 0;
                                    while (true) {
                                        if (i >= newFieldMetaData.size()) {
                                            fieldList.append(")");
                                            str.append("INSERT INTO " + toTableName + " " + fieldList + " VALUES (");
                                            insertSQL = str.toString();
                                            BasicSQLUtils.log.debug((Object)str);
                                            break block88;
                                        }
                                        if (i > 0 && i < newFieldMetaData.size()) {
                                            fieldList.append(", ");
                                        }
                                        newFieldName = newFieldMetaData.get(i).getName();
                                        fieldList.append(String.valueOf(newFieldName) + " ");
                                        ++i;
                                    }
                                }
                                str.append(insertSQL);
                            }
                            id = rs.getString(1);
                            i = 0;
                            while (true) {
                                block90: {
                                    block102: {
                                        block101: {
                                            block100: {
                                                block93: {
                                                    block99: {
                                                        block96: {
                                                            block98: {
                                                                block97: {
                                                                    block94: {
                                                                        block95: {
                                                                            block92: {
                                                                                block91: {
                                                                                    if (i >= newFieldMetaData.size()) {
                                                                                        str.append(")");
                                                                                        if (BasicSQLUtils.frame == null) break;
                                                                                        if (count % 500 == 0) {
                                                                                            BasicSQLUtils.frame.setProcess(count);
                                                                                        }
                                                                                        break block89;
                                                                                    }
                                                                                    newFldMetaData = newFieldMetaData.get(i);
                                                                                    newColName = newFldMetaData.getName();
                                                                                    oldMappedColName = null;
                                                                                    columnIndex = (Integer)fromHash.get(newColName);
                                                                                    if (columnIndex != null || colNewToOldMap == null) break block91;
                                                                                    oldMappedColName = colNewToOldMap.get(newColName);
                                                                                    if (oldMappedColName != null) {
                                                                                        columnIndex = (Integer)fromHash.get(oldMappedColName);
                                                                                        break block92;
                                                                                    } else if (BasicSQLUtils.isOptionOn(1) && (BasicSQLUtils.ignoreMappingFieldNames == null || BasicSQLUtils.ignoreMappingFieldNames.get(newColName) == null)) {
                                                                                        msg = "No Map for table [" + fromTableName + "] from New Name[" + newColName + "] to Old Name[" + oldMappedColName + "]";
                                                                                        BasicSQLUtils.log.error((Object)msg);
                                                                                        BasicSQLUtils.writeErrLog(msg);
                                                                                    }
                                                                                    break block92;
                                                                                }
                                                                                oldMappedColName = newColName;
                                                                            }
                                                                            verbatimDateFieldName = null;
                                                                            if (verbatimDateMapper != null) {
                                                                                verbatimDateFieldName = verbatimDateMapper.get(newColName);
                                                                            }
                                                                            if (columnIndex == null) break block93;
                                                                            if (i > 0) {
                                                                                str.append(", ");
                                                                            }
                                                                            dataObj = rs.getObject(columnIndex);
                                                                            if (idMapperMgr == null || oldMappedColName == null || !oldMappedColName.endsWith("ID")) break block94;
                                                                            idMapper = idMapperMgr.get(fromTableName, oldMappedColName);
                                                                            if (idMapper == null) break block95;
                                                                            showNullOption = 4;
                                                                            showFkLookUpOption = 8;
                                                                            oldPrimaryKeyId = rs.getInt(columnIndex);
                                                                            if (oldMappedColName.equalsIgnoreCase(String.valueOf(fromTableName) + "id")) {
                                                                                showNullOption = 16;
                                                                                showFkLookUpOption = 32;
                                                                            }
                                                                            if (rs.wasNull()) {
                                                                                dataObj = null;
                                                                                if (BasicSQLUtils.isOptionOn(showNullOption)) {
                                                                                    msg = "Unable to Map " + (showNullOption == 4 ? "Foreign" : "Primary") + " Key Id[NULL] old Name[" + oldMappedColName + "]   colInx[" + columnIndex + "]   newColName[" + newColName + "]";
                                                                                    BasicSQLUtils.log.error((Object)msg);
                                                                                    BasicSQLUtils.writeErrLog(msg);
                                                                                    skipRecord = true;
                                                                                }
                                                                                break block94;
                                                                            } else {
                                                                                dataObj = idMapper.get(oldPrimaryKeyId);
                                                                                if (dataObj == null && BasicSQLUtils.isOptionOn(showFkLookUpOption)) {
                                                                                    msg = "Unable to Map Primary Id[" + oldPrimaryKeyId + "] old Name[" + oldMappedColName + "] table[" + fromTableName + "]";
                                                                                    BasicSQLUtils.log.error((Object)msg);
                                                                                    BasicSQLUtils.writeErrLog(msg);
                                                                                    skipRecord = true;
                                                                                }
                                                                            }
                                                                            break block94;
                                                                        }
                                                                        if (BasicSQLUtils.isOptionOn(1) && (BasicSQLUtils.ignoreMappingFieldIDs == null || BasicSQLUtils.ignoreMappingFieldIDs.get(oldMappedColName) == null) && !oldMappedColName.equals("RankID")) {
                                                                            msg = "No ID Map for [" + fromTableName + "] Old Column Name[" + oldMappedColName + "]";
                                                                            BasicSQLUtils.log.error((Object)msg);
                                                                            BasicSQLUtils.writeErrLog(msg);
                                                                            skipRecord = true;
                                                                        }
                                                                    }
                                                                    if (dataObj != null) break block96;
                                                                    if (!newFldMetaData.getName().equals("TimestampCreated")) break block97;
                                                                    if (timestampCreatedInx != null) {
                                                                        if (isAccessionTable) {
                                                                            date = UIHelper.convertIntToDate(rs.getInt((Integer)fromHash.get("DateAccessioned")));
                                                                            str.append(date != null ? BasicSQLUtils.getStrValue(date) : BasicSQLUtils.getStrValue(timestampCreatedCached, newFldMetaData.getType()));
                                                                            break block90;
                                                                        } else {
                                                                            str.append(BasicSQLUtils.getStrValue(timestampCreatedCached, newFldMetaData.getType()));
                                                                        }
                                                                        break block90;
                                                                    } else {
                                                                        str.append(BasicSQLUtils.getStrValue(timestampCreatedCached, newFldMetaData.getType()));
                                                                    }
                                                                    break block90;
                                                                }
                                                                if (!newFldMetaData.getName().equals("TimestampModified")) break block98;
                                                                if (timestampModifiedInx != null) {
                                                                    if (isAccessionTable) {
                                                                        date = UIHelper.convertIntToDate(rs.getInt((Integer)fromHash.get("DateAccessioned")));
                                                                        str.append(date != null ? BasicSQLUtils.getStrValue(date) : BasicSQLUtils.getStrValue(timestampCreatedCached, newFldMetaData.getType()));
                                                                        break block90;
                                                                    } else {
                                                                        str.append(BasicSQLUtils.getStrValue(timestampModifiedCached /* !! */ , newFldMetaData.getType()));
                                                                    }
                                                                    break block90;
                                                                } else {
                                                                    str.append(BasicSQLUtils.getStrValue(timestampModifiedCached /* !! */ , newFldMetaData.getType()));
                                                                }
                                                                break block90;
                                                            }
                                                            str.append("NULL");
                                                            break block90;
                                                        }
                                                        if (!(dataObj instanceof Integer) || newFldMetaData.getSqlType() != 91 && !newColName.toLowerCase().endsWith("date") && !newColName.toLowerCase().startsWith("date")) break block99;
                                                        datePr = (PartialDateConv)dateMap.get(newColName);
                                                        if (datePr != null) {
                                                            str.append(datePr.getDateStr());
                                                            break block90;
                                                        } else {
                                                            str.append("NULL");
                                                        }
                                                        break block90;
                                                    }
                                                    if (verbatimDateFieldName != null) {
                                                        datePr = (PartialDateConv)dateMap.get(newColName);
                                                        str.append(datePr != null ? datePr.getVerbatim() : "NULL");
                                                        break block90;
                                                    } else if (dataObj instanceof Number) {
                                                        fi = tblInfo.getFieldByColumnName(newColName);
                                                        type = newFldMetaData.getType().toLowerCase().startsWith("tiny") != false ? fi.getType() : newFldMetaData.getType();
                                                        str.append(BasicSQLUtils.getStrValue(dataObj, type));
                                                        break block90;
                                                    } else {
                                                        if (BasicSQLUtils.columnValueMapper != null && (valueMapper = BasicSQLUtils.columnValueMapper.get(newColName)) != null) {
                                                            dataObj = valueMapper.mapValue(dataObj);
                                                        }
                                                        if (dataObj instanceof String && newFldMetaData.isString()) {
                                                            fi = tblInfo.getFieldByColumnName(newColName);
                                                            s = (String)dataObj;
                                                            if (s.length() > fi.getLength()) {
                                                                msg = String.format("Truncating Table '%s' Field '%s' with Length %d, db len %d Value[%s]", new Object[]{toTableName, newColName, s.length(), fi.getLength(), s});
                                                                BasicSQLUtils.tblWriter.logError(msg);
                                                                BasicSQLUtils.log.error((Object)msg);
                                                                dataObj = s.substring(0, fi.getLength());
                                                            }
                                                        }
                                                        str.append(BasicSQLUtils.getStrValue(dataObj, newFldMetaData.getType()));
                                                    }
                                                    break block90;
                                                }
                                                if (!newColName.endsWith("Version")) break block100;
                                                if (i > 0) {
                                                    str.append(", ");
                                                }
                                                str.append("0");
                                                break block90;
                                            }
                                            if (!newColName.endsWith("DatePrecision")) break block101;
                                            if (i > 0) {
                                                str.append(", ");
                                            }
                                            if ((datePr = (PartialDateConv)dateMap.get(cName = newColName.substring(0, newColName.length() - 9))) != null) {
                                                str.append(datePr.getPartial());
                                                break block90;
                                            } else {
                                                str.append("NULL");
                                            }
                                            break block90;
                                        }
                                        if (idMapperMgr == null || !newColName.endsWith("ID") || BasicSQLUtils.oneToOneIDHash == null || BasicSQLUtils.oneToOneIDHash.get(newColName) == null) break block102;
                                        idMapper = idMapperMgr.get(toTableName, newColName);
                                        if (idMapper != null) {
                                            idMapper.setShowLogErrors(false);
                                            newPrimaryId = idMapper.get(Integer.parseInt(id));
                                            if (newPrimaryId != null) {
                                                if (i > 0) {
                                                    str.append(", ");
                                                }
                                                str.append(newPrimaryId);
                                                break block90;
                                            } else {
                                                if (i > 0) {
                                                    str.append(", ");
                                                }
                                                str.append("NULL");
                                                if (BasicSQLUtils.isOptionOn(2)) {
                                                    msg = "For Table[" + fromTableName + "] mapping new Column Name[" + newColName + "] ID[" + id + "] was not mapped";
                                                    BasicSQLUtils.log.error((Object)msg);
                                                    BasicSQLUtils.writeErrLog(msg);
                                                    skipRecord = true;
                                                }
                                            }
                                        }
                                        break block90;
                                    }
                                    newColValue = null;
                                    if (newColDefValues != null) {
                                        newColValue = newColDefValues.get(newColName);
                                    }
                                    if (newColValue == null) {
                                        newColValue = "NULL";
                                        if (BasicSQLUtils.isOptionOn(1) && (BasicSQLUtils.ignoreMappingFieldNames == null || BasicSQLUtils.ignoreMappingFieldNames.get(newColName) == null)) {
                                            msg = "For Table[" + fromTableName + "] mapping new Column Name[" + newColName + "] was not mapped";
                                            BasicSQLUtils.log.error((Object)msg);
                                            BasicSQLUtils.writeErrLog(msg);
                                            skipRecord = true;
                                        }
                                    }
                                    if (i > 0) {
                                        str.append(", ");
                                    }
                                    if ((valueMapper = BasicSQLUtils.columnValueMapper.get(newFldMetaData.getName())) != null) {
                                        newColValue = valueMapper.mapValue(newColValue);
                                    }
                                    str.append(newColValue);
                                }
                                ++i;
                            }
                            if (count % 2000 == 0) {
                                BasicSQLUtils.log.info((Object)(String.valueOf(toTableName) + " processed: " + count));
                            }
                        }
                        if (skipRecord) continue;
                        if (BasicSQLUtils.isOptionOn(64)) {
                            BasicSQLUtils.log.debug((Object)("executing: " + str));
                        }
                        if ((retVal = BasicSQLUtils.exeUpdateCmd(updateStatement, str.toString())) == -1) break;
                    }
                    rs.close();
                    stmt.clearBatch();
                    stmt.close();
                    ** continue;
                }
                BasicSQLUtils.log.info((Object)(String.valueOf(fromTableName) + " processed " + count + " records."));
            }
            rs.close();
            stmt.clearBatch();
            stmt.close();
        }
        try {
            updateStatement.clearBatch();
            updateStatement.close();
        }
        catch (SQLException var48_61) {
            // empty catch block
        }
        BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(null);
        return true;
    }

    public static void fixTimestamps(String newFieldName, String type, Object data, StringBuilder sb) {
        if (newFieldName.equals("TimestampModified") || newFieldName.equals("TimestampModified")) {
            if (BasicSQLUtils.getStrValue(data, type).toString().toLowerCase().equals("null")) {
                sb.append("'" + nowStr + "'");
            } else {
                sb.append(BasicSQLUtils.getStrValue(data, type));
            }
        } else {
            sb.append(BasicSQLUtils.getStrValue(data, type));
        }
    }

    public static void getPartialDate(Object data, PartialDateConv partialDateConv) {
        BasicSQLUtils.getPartialDate(data, partialDateConv, true);
    }

    public static void getPartialDate(Object data, PartialDateConv partialDateConv, boolean includeQuotes) {
        partialDateConv.setAllNullStrs();
        if (data != null && (Integer)data > 0) {
            java.util.Date dateObj = null;
            String dateStr = ((Integer)data).toString();
            String partial = "1";
            String verbatim = "NULL";
            if (dateStr.length() == 8) {
                String yearStr = dateStr.substring(0, 4);
                if (yearStr.equals("0000") || yearStr.equals("9999") || yearStr.equals("1111")) {
                    verbatim = dateStr;
                    dateStr = "NULL";
                    partial = "NULL";
                } else {
                    Integer yr = Integer.parseInt(yearStr);
                    if (yr < 1700 || yr > currentYear) {
                        dateStr = "NULL";
                        partial = "NULL";
                        verbatim = dateStr;
                    } else {
                        int fndInx = dateStr.substring(4, 8).indexOf("00");
                        if (fndInx > -1) {
                            if (fndInx == 0) {
                                dateStr = String.valueOf(dateStr.substring(0, 4)) + "0101";
                                dateObj = UIHelper.convertIntToDate(Integer.parseInt(dateStr));
                                partial = "3";
                            } else if (fndInx == 2) {
                                dateStr = String.valueOf(dateStr.substring(0, 6)) + "01";
                                dateObj = UIHelper.convertIntToDate(Integer.parseInt(dateStr));
                                partial = "2";
                            } else {
                                dateObj = UIHelper.convertIntToDate((Integer)data);
                                partial = "1";
                            }
                        } else {
                            dateObj = UIHelper.convertIntToDate((Integer)data);
                            partial = "1";
                        }
                        dateStr = dateObj == null ? "NULL" : String.valueOf(includeQuotes ? "\"" : "") + dateFormatter.format(dateObj) + (includeQuotes ? "\"" : "");
                    }
                }
                partialDateConv.set(dateStr, partial, verbatim);
            } else {
                log.error((Object)("Partial Date was't 8 digits! [" + dateStr + "]"));
            }
        }
    }

    public static String buildSelectFieldList(List<String> list) {
        return BasicSQLUtils.buildSelectFieldList(list, null);
    }

    public static String buildSelectFieldList(List<String> list, String tableName) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                str.append(", ");
            }
            if (tableName != null) {
                str.append(tableName);
                str.append('.');
            }
            str.append(list.get(i));
            ++i;
        }
        return str.toString();
    }

    public static String buildSelectFieldMetaDataList(List<FieldMetaData> list, String tableName) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                str.append(", ");
            }
            if (tableName != null) {
                str.append(tableName);
                str.append('.');
            }
            str.append(list.get(i).getName());
            ++i;
        }
        return str.toString();
    }

    public static Map<String, String> createFieldNameMap(String[] pairs) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        int i = 0;
        while (i < pairs.length) {
            map.put(pairs[i], pairs[i + 1]);
            ++i;
            ++i;
        }
        return map;
    }

    public static int getNumRecords(Connection connection, String tableName) {
        ResultSet rs;
        Statement cntStmt;
        Integer count;
        block3: {
            try {
                count = 0;
                cntStmt = connection.createStatement(1004, 1007);
                rs = cntStmt.executeQuery("select count(*) from " + tableName);
                if (!rs.first() || (count = Integer.valueOf(rs.getInt(1))) != null) break block3;
                return -1;
            }
            catch (SQLException ex) {
                log.error((Object)ex);
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                return -1;
            }
        }
        rs.close();
        cntStmt.close();
        return count;
    }

    public static int getNumRecords(String sql) {
        log.debug((Object)sql);
        Connection conn = DBConnection.getInstance().createConnection();
        try {
            int count = BasicSQLUtils.getNumRecords(sql, conn);
            conn.close();
            return count;
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getNumRecords(String sql, Connection conn) {
        Statement cntStmt = null;
        try {
            int count = 0;
            if (conn != null) {
                cntStmt = conn.createStatement(1004, 1007);
                if (cntStmt != null) {
                    ResultSet rs = cntStmt.executeQuery(sql);
                    if (rs.first()) {
                        count = rs.getInt(1);
                    }
                    rs.close();
                }
                cntStmt.close();
            }
            int n = count;
            return n;
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)ex);
        }
        finally {
            try {
                if (cntStmt != null) {
                    cntStmt.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    public static int getHighestId(Connection connection, String idColName, String tableName) {
        try {
            Statement cntStmt = connection.createStatement(1004, 1007);
            ResultSet rs = cntStmt.executeQuery("select " + idColName + " from " + tableName + " order by " + idColName + " asc");
            int id = 0;
            id = rs.last() ? rs.getInt(1) : 1;
            rs.close();
            cntStmt.close();
            return id;
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)ex);
            return -1;
        }
    }

    public static boolean isOptionOn(int opt) {
        return (showErrors & opt) == opt;
    }

    public static String getServerTypeSpecificSQL(String mySQLFormatedStr, SERVERTYPE currentServerType) {
        String mySQLFormatedString = mySQLFormatedStr;
        if (currentServerType == SERVERTYPE.MS_SQLServer) {
            mySQLFormatedString = BasicSQLUtils.stripSingleQuotes(mySQLFormatedString);
            mySQLFormatedString = BasicSQLUtils.stripEngineCharSet(mySQLFormatedString);
            mySQLFormatedString = BasicSQLUtils.stripIntSize(mySQLFormatedString);
        }
        return mySQLFormatedString;
    }

    private static String stripSingleQuotes(String str) {
        return str.replace("`", "");
    }

    private static String stripEngineCharSet(String strArg) {
        String str = strArg;
        str = str.replaceAll("ENGINE=InnoDB", "");
        str = str.replaceAll("DEFAULT CHARSET=latin1", "");
        return str;
    }

    private static String stripIntSize(String str) {
        return str.replaceAll("\\(11\\)", "");
    }

    public static String createIndexFieldStatment(String name, SERVERTYPE currentServerType) {
        if (currentServerType == SERVERTYPE.MS_SQLServer) {
            return "create INDEX INX_" + name + " ON " + name + " (NewID)";
        }
        if (currentServerType == SERVERTYPE.MySQL) {
            return "alter table " + name + " add index INX_" + name + " (NewID)";
        }
        return "alter table " + name + " add index INX_" + name + " (NewID)";
    }

    public static void setIdentityInsertONCommandForSQLServer(Connection connection, String tableName, SERVERTYPE currentServerType) {
        BasicSQLUtils.setIdentityInserCommandForSQLServer(connection, tableName, "ON", currentServerType);
    }

    public static void setIdentityInsertOFFCommandForSQLServer(Connection connection, String tableName, SERVERTYPE currentServerType) {
        BasicSQLUtils.setIdentityInserCommandForSQLServer(connection, tableName, "OFF", currentServerType);
    }

    public static void setIdentityInserCommandForSQLServer(Connection connection, String tableName, String mySwitch, SERVERTYPE currentServerType) {
        if (currentServerType == SERVERTYPE.MS_SQLServer) {
            try {
                Statement cntStmt = connection.createStatement(1004, 1007);
                String str = "SET IDENTITY_INSERT " + tableName + " " + mySwitch;
                cntStmt.execute(str);
                str = "SET QUOTED_IDENTIFIER OFF";
                cntStmt.execute(str);
                cntStmt.close();
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
                System.exit(0);
            }
        }
    }

    public static void removeForeignKeyConstraints(Connection connection, String tableName, SERVERTYPE currentServerType) {
        try {
            if (currentServerType == SERVERTYPE.MS_SQLServer) {
                Statement cntStmt = connection.createStatement(1004, 1007);
                String str = "ALTER TABLE " + tableName + " NOCHECK CONSTRAINT ALL";
                cntStmt.execute(str);
                cntStmt.close();
            } else {
                Statement cntStmt = connection.createStatement(1004, 1007);
                String str = "SET FOREIGN_KEY_CHECKS = 0";
                cntStmt.execute(str);
                cntStmt.close();
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)"Error encountered trying to turn off foreign key constraints on database");
            log.error((Object)ex);
        }
    }

    public static void removeForeignKeyConstraints(Connection connection, SERVERTYPE currentServerType) {
        try {
            if (currentServerType == SERVERTYPE.MS_SQLServer) {
                List<String> myTables = BasicSQLUtils.getTableNames(connection);
                for (String s : myTables) {
                    Statement cntStmt = connection.createStatement(1004, 1007);
                    String str = "ALTER TABLE " + s + " NOCHECK CONSTRAINT ALL";
                    cntStmt.execute(str);
                    cntStmt.close();
                }
            } else {
                Statement cntStmt = connection.createStatement(1004, 1007);
                String str = "SET FOREIGN_KEY_CHECKS = 0";
                cntStmt.execute(str);
                cntStmt.close();
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(BasicSQLUtils.class, ex);
            log.error((Object)ex);
        }
    }

    public static enum SERVERTYPE {
        MySQL,
        MS_SQLServer;

    }
}

