/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationAttr;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class AttrUtils {
    protected static final Logger log = Logger.getLogger(BasicSQLUtils.class);

    public static PrepType loadPrepType(String name, Collection collection) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            PrepType prepType = new PrepType();
            prepType.initialize();
            prepType.setName(name);
            collection.addReference(prepType, "prepTypes");
            session.save((Object)prepType);
            session.saveOrUpdate((Object)collection);
            HibernateUtil.commitTransaction();
            return prepType;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AttrUtils.class, e);
            log.warn((Object)("******* " + e));
            HibernateUtil.rollbackTransaction();
            return null;
        }
    }

    public static List<AttributeDef> loadAttrDefs(Discipline discipline, GenericDBConversion.TableType tableType, PrepType prepType, String[] attrNames, short[] dataTypes) {
        if (attrNames.length == dataTypes.length) {
            ArrayList<AttributeDef> list = new ArrayList<AttributeDef>();
            try {
                Session session = HibernateUtil.getCurrentSession();
                int i = 0;
                while (i < attrNames.length) {
                    HibernateUtil.beginTransaction();
                    AttributeDef attrsDef = new AttributeDef();
                    attrsDef.setTableType(tableType.getType());
                    attrsDef.setDiscipline(discipline);
                    attrsDef.setPrepType(prepType);
                    attrsDef.setFieldName(attrNames[i]);
                    attrsDef.setDataType(dataTypes[i]);
                    discipline.getAttributeDefs().add(attrsDef);
                    session.save((Object)attrsDef);
                    list.add(attrsDef);
                    ++i;
                }
                session.saveOrUpdate((Object)discipline);
                HibernateUtil.commitTransaction();
                return list;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AttrUtils.class, e);
                log.warn((Object)("******* " + e));
                e.printStackTrace();
                HibernateUtil.rollbackTransaction();
            }
        } else {
            log.error((Object)("Names length: " + attrNames.length + " doesn't match Types length " + dataTypes.length));
        }
        return null;
    }

    protected static PreparationAttr createPrepsInsert(AttributeDef attrDef, Preparation preparation, String strValue, Double dblValue) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            PreparationAttr prepAttr = new PreparationAttr();
            prepAttr.setDefinition(attrDef);
            prepAttr.setPreparation(preparation);
            prepAttr.setDblValue(dblValue);
            prepAttr.setPreparation(null);
            prepAttr.setStrValue(strValue);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            prepAttr.setTimestampCreated(now);
            session.save((Object)prepAttr);
            HibernateUtil.commitTransaction();
            return prepAttr;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AttrUtils.class, e);
            log.warn((Object)("******* " + e));
            HibernateUtil.rollbackTransaction();
            return null;
        }
    }

    protected static String createPrepsInsert(int prepAttrsID, String name, String strValue, Integer intValue, Short fieldType, Short unit, Date timeStamp, Date modifiedDate, String remarks, int prepsObjID, Integer parasiteTaxonNameID) {
        StringBuilder strBuf = new StringBuilder(128);
        strBuf.setLength(0);
        strBuf.append("INSERT INTO prepattrs VALUES (");
        strBuf.append(prepAttrsID);
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(name));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(strValue));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(intValue));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(fieldType));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(unit));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(timeStamp));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(modifiedDate));
        strBuf.append(',');
        strBuf.append(BasicSQLUtils.getStrValue(remarks));
        strBuf.append(',');
        strBuf.append(prepsObjID);
        strBuf.append(',');
        strBuf.append(parasiteTaxonNameID);
        strBuf.append(')');
        return strBuf.toString();
    }
}

