/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.BasicSQLUtilsMapValueIFace;
import edu.ku.brc.specify.conversion.DisciplineDuplicator;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.Triple;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AgentConverter {
    protected static final Logger log = Logger.getLogger(AgentConverter.class);
    protected IdMapperMgr idMapperMgr = null;
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected static boolean shouldCreateMapTables = true;
    protected GenericDBConversion conv;
    protected Statement gStmt;
    protected Statement updateStmtNewDB;
    protected HashMap<Integer, AgentInfo> agentHash = new HashMap();
    protected Pair<String, String> namePair = new Pair();
    protected Triple<String, String, String> nameTriple = new Triple();
    protected TableWriter tblWriter;
    protected List<AgentNameInfo> names = new Vector<AgentNameInfo>();
    protected Stack<AgentNameInfo> recycler = new Stack();

    public AgentConverter(GenericDBConversion conv, IdMapperMgr idMapperMgr, boolean shouldCreateMapTables) throws SQLException {
        this.conv = conv;
        this.idMapperMgr = idMapperMgr;
        this.oldDBConn = conv.getOldDBConn();
        this.newDBConn = conv.getNewDBConn();
        this.gStmt = this.oldDBConn.createStatement();
        this.updateStmtNewDB = this.newDBConn.createStatement();
        this.tblWriter = conv.getConvLogger().getWriter("AgentConv.html", "Agents");
    }

    public AgentConverter() {
    }

    private void dumpInfo(String fileName, HashMap<Integer, AddressInfo> addressHash) {
        try {
            File file = new File(fileName);
            PrintWriter pw = new PrintWriter(file);
            pw.println("------- AgentInfo Dump-------- ");
            for (AgentInfo agentInfo : this.agentHash.values()) {
                pw.println(agentInfo.toString());
                for (Integer agtAdrId : agentInfo.getAddrs().keySet()) {
                    pw.println("    AgentAddrId: " + agtAdrId + "    AddrId: " + agentInfo.getAddrs().get(agtAdrId));
                }
            }
            pw.println("\n------- AddressInfo Dump-------- ");
            for (AddressInfo addrInfo : addressHash.values()) {
                pw.println(addrInfo.toString());
            }
            pw.println("\n");
            pw.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public boolean convertAgents(boolean doFixAgents) {
        boolean debugAgents = false;
        log.debug((Object)"convert Agents");
        BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
        IdTableMapper agentIDMapper = this.idMapperMgr.addTableMapper("agent", "AgentID");
        IdTableMapper agentAddrIDMapper = this.idMapperMgr.addTableMapper("agentaddress", "AgentAddressID");
        agentIDMapper.setInitialIndex(4);
        if (shouldCreateMapTables) {
            log.info((Object)"Mapping Agent Ids");
            agentIDMapper.mapAllIds("SELECT AgentID FROM agent ORDER BY AgentID");
        }
        ArrayList<String> oldFieldNames = new ArrayList<String>();
        StringBuilder agtAdrSQL = new StringBuilder("SELECT ");
        List<String> agentAddrFieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "agentaddress");
        agtAdrSQL.append(BasicSQLUtils.buildSelectFieldList(agentAddrFieldNames, "agentaddress"));
        agtAdrSQL.append(", ");
        GenericDBConversion.addNamesWithTableName(oldFieldNames, agentAddrFieldNames, "agentaddress");
        List<String> agentFieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "agent");
        agtAdrSQL.append(BasicSQLUtils.buildSelectFieldList(agentFieldNames, "agent"));
        log.debug((Object)("MAIN: " + agtAdrSQL));
        agtAdrSQL.append(", ");
        GenericDBConversion.addNamesWithTableName(oldFieldNames, agentFieldNames, "agent");
        List<String> addrFieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "address");
        log.debug((Object)agtAdrSQL);
        agtAdrSQL.append(BasicSQLUtils.buildSelectFieldList(addrFieldNames, "address"));
        GenericDBConversion.addNamesWithTableName(oldFieldNames, addrFieldNames, "address");
        HashMap<String, Integer> indexFromNameMap = new HashMap<String, Integer>();
        agtAdrSQL.append(" FROM agent INNER JOIN agentaddress ON agentaddress.AgentID = agent.AgentID INNER JOIN address ON agentaddress.AddressID = address.AddressID Order By agentaddress.AgentAddressID Asc");
        String[] agentColumns = new String[]{"agent.AgentID", "agent.TimestampModified", "agent.AgentType", "agentaddress.JobTitle", "agent.FirstName", "agent.LastName", "agent.MiddleInitial", "agent.Title", "agent.Interests", "agent.Abbreviation", "agentaddress.Email", "agentaddress.URL", "agent.Remarks", "agent.TimestampCreated", "agent.ParentOrganizationID"};
        HashMap<Integer, AddressInfo> addressHash = new HashMap<Integer, AddressInfo>();
        try {
            log.info((Object)"Hashing Address Ids");
            Integer agentCnt = BasicSQLUtils.getCount(this.oldDBConn, "SELECT COUNT(AddressID) FROM address ORDER BY AddressID");
            Statement stmtX = this.oldDBConn.createStatement(1004, 1007);
            ResultSet rsX = stmtX.executeQuery("SELECT AgentAddressID, AddressID FROM agentaddress ORDER BY AgentAddressID");
            this.conv.setProcess(0, agentCnt);
            int cnt = 0;
            while (rsX.next()) {
                int agentAddrId = rsX.getInt(1);
                int addrId = rsX.getInt(2);
                addressHash.put(addrId, new AddressInfo(agentAddrId, addrId));
                if (cnt % 100 == 0) {
                    this.conv.setProcess(0, cnt);
                }
                ++cnt;
            }
            rsX.close();
            stmtX.close();
            this.conv.setProcess(0, 0);
            log.info((Object)"Hashing Agent Ids");
            stmtX = this.oldDBConn.createStatement(1004, 1007);
            agentCnt = BasicSQLUtils.getCount(this.oldDBConn, "SELECT COUNT(*) FROM agent ORDER BY AgentID");
            rsX = stmtX.executeQuery("SELECT AgentID, AgentType, LastName, Name, FirstName FROM agent ORDER BY AgentID");
            this.conv.setProcess(0, agentCnt);
            cnt = 0;
            while (rsX.next()) {
                int agentId = rsX.getInt(1);
                this.agentHash.put(agentId, new AgentInfo(agentId, agentIDMapper.get(agentId), rsX.getByte(2), rsX.getString(3), rsX.getString(4), rsX.getString(5)));
                if (cnt % 100 == 0) {
                    this.conv.setProcess(0, cnt);
                }
                ++cnt;
            }
            rsX.close();
            stmtX.close();
            this.conv.setProcess(0, 0);
            log.info((Object)"Cross Mapping Agents and Addresses");
            String post = " FROM agentaddress WHERE AddressID IS NOT NULL and AgentID IS NOT NULL";
            agentCnt = BasicSQLUtils.getCount(this.oldDBConn, "SELECT COUNT(AgentAddressID)" + post);
            stmtX = this.oldDBConn.createStatement(1004, 1007);
            String asSQL = "SELECT AgentAddressID, AgentID" + post;
            log.debug((Object)asSQL);
            rsX = stmtX.executeQuery(asSQL);
            this.conv.setProcess(0, agentCnt);
            cnt = 0;
            while (rsX.next()) {
                int agentAddrId = rsX.getInt(1);
                int agentId = rsX.getInt(2);
                AgentInfo agentInfo = this.agentHash.get(agentId);
                if (agentInfo == null) {
                    String msg = "The AgentID [" + agentId + "] in AgentAddress table id[" + agentAddrId + "] desn't exist";
                    log.error((Object)msg);
                    this.tblWriter.logError(msg);
                } else {
                    agentInfo.add(agentAddrId, agentAddrId);
                }
                if (cnt % 100 == 0) {
                    this.conv.setProcess(0, cnt);
                }
                ++cnt;
            }
            rsX.close();
            stmtX.close();
            this.conv.setProcess(0, 0);
            log.info((Object)"Checking for null Agents");
            agentCnt = BasicSQLUtils.getCount(this.oldDBConn, "SELECT COUNT(AgentAddressID) FROM agentaddress a where AddressID IS NOT NULL and AgentID is null");
            if (agentCnt != null && agentCnt > 0) {
                UIRegistry.showError("There are " + agentCnt + " AgentAddress Records where the AgentID is null and the AddressId IS NOT NULL!");
            }
            log.info((Object)agtAdrSQL.toString());
            Statement stmt = this.oldDBConn.createStatement(1004, 1007);
            log.debug((Object)("AgentAddress: " + agtAdrSQL.toString()));
            int inx = 1;
            for (String fldName : oldFieldNames) {
                indexFromNameMap.put(fldName, inx++);
            }
            Statement updateStatement = this.newDBConn.createStatement();
            int agentIdInx = (Integer)indexFromNameMap.get("agent.AgentID");
            int agentTypeInx = (Integer)indexFromNameMap.get("agent.AgentType");
            int lastEditInx = (Integer)indexFromNameMap.get("agent.LastEditedBy");
            int nameInx = (Integer)indexFromNameMap.get("agent.Name");
            int lastNameInx = (Integer)indexFromNameMap.get("agent.LastName");
            int firstNameInx = (Integer)indexFromNameMap.get("agent.FirstName");
            int recordCnt = 0;
            ResultSet rs = stmt.executeQuery(agtAdrSQL.toString());
            while (rs.next()) {
                int agentAddressId = rs.getInt(1);
                int agentId = rs.getInt(agentIdInx);
                String lastEditedBy = rs.getString(lastEditInx);
                AgentInfo agentInfo = this.agentHash.get(agentId);
                String lastName = rs.getString(lastNameInx);
                String name = rs.getString(nameInx);
                this.namePair.second = StringUtils.isNotEmpty((String)name) && StringUtils.isEmpty((String)lastName) ? name : lastName;
                this.namePair.first = rs.getString(firstNameInx);
                if (shouldCreateMapTables) {
                    agentAddrIDMapper.setShowLogErrors(false);
                    if (debugAgents) {
                        log.info((Object)String.format("Map - agentAddressId (Old) %d  to Agent -> New ID: %d", agentAddressId, agentInfo.getNewAgentId()));
                    }
                    if (agentAddrIDMapper.get(agentAddressId) == null) {
                        agentAddrIDMapper.put(agentAddressId, agentInfo.getNewAgentId());
                    } else {
                        log.debug((Object)String.format("ERROR - agentAddressId %d  Already mapped to  New ID:  %d", agentAddressId, agentInfo.getNewAgentId()));
                    }
                    agentAddrIDMapper.setShowLogErrors(true);
                }
                if (!agentInfo.wasAdded()) {
                    agentInfo.setWasAdded(true);
                    BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
                    StringBuilder sqlStr = new StringBuilder();
                    sqlStr.append("INSERT INTO agent ");
                    sqlStr.append("(AgentID, DivisionId, TimestampModified, AgentType, JobTitle, FirstName, LastName, MiddleInitial, ");
                    sqlStr.append("Title, Interests, Abbreviation, Email, URL, Remarks, TimestampCreated, ");
                    sqlStr.append("ParentOrganizationID, CreatedByAgentID, ModifiedByAgentID, Version)");
                    sqlStr.append(" VALUES (");
                    int i = 0;
                    while (i < agentColumns.length) {
                        if (i > 0) {
                            sqlStr.append(",");
                        }
                        if (i == 0) {
                            if (debugAgents) {
                                log.info((Object)("Adding: " + agentColumns[i] + "  New ID: " + agentInfo.getNewAgentId()));
                            }
                            sqlStr.append(agentInfo.getNewAgentId());
                            sqlStr.append(",");
                            sqlStr.append(this.conv.getCurDivisionID());
                        } else if (agentColumns[i].equals("agent.ParentOrganizationID")) {
                            Object obj = rs.getObject((Integer)indexFromNameMap.get(agentColumns[i]));
                            if (obj != null) {
                                int oldId = rs.getInt(agentColumns[i]);
                                Integer newID = agentIDMapper.get(oldId);
                                if (newID == null) {
                                    log.error((Object)("Couldn't map ParentOrganizationID [" + oldId + "]"));
                                }
                                sqlStr.append(BasicSQLUtils.getStrValue(newID));
                            } else {
                                sqlStr.append("NULL");
                            }
                        } else if (agentColumns[i].equals("agent.LastName") || agentColumns[i].equals("LastName")) {
                            int lastNameLen = 120;
                            String lstName = (String)this.namePair.second;
                            lstName = lstName == null ? null : (lstName.length() <= lastNameLen ? lstName : lstName.substring(0, lastNameLen));
                            sqlStr.append(BasicSQLUtils.getStrValue(lstName));
                        } else if (agentColumns[i].equals("agent.FirstName") || agentColumns[i].equals("FirstName")) {
                            sqlStr.append(BasicSQLUtils.getStrValue(this.namePair.first));
                        } else {
                            inx = (Integer)indexFromNameMap.get(agentColumns[i]);
                            sqlStr.append(BasicSQLUtils.getStrValue(rs.getObject(inx)));
                        }
                        ++i;
                    }
                    sqlStr.append("," + this.conv.getCreatorAgentIdForAgent(lastEditedBy) + "," + this.conv.getModifiedByAgentIdForAgent(lastEditedBy) + ",0");
                    sqlStr.append(")");
                    try {
                        if (debugAgents) {
                            log.info((Object)sqlStr.toString());
                        }
                        updateStatement.executeUpdate(sqlStr.toString());
                        Integer newAgentId = BasicSQLUtils.getInsertedId(updateStatement);
                        if (newAgentId == null) {
                            throw new RuntimeException("Couldn't get the Agent's inserted ID");
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)sqlStr.toString());
                        log.error((Object)("Count: " + recordCnt));
                        e.printStackTrace();
                        log.error((Object)e);
                        System.exit(0);
                        throw new RuntimeException(e);
                    }
                }
                BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
                if (recordCnt % 250 == 0) {
                    log.info((Object)("AgentAddress Records: " + recordCnt));
                }
                ++recordCnt;
            }
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "address", BasicSQLUtils.myDestinationServerType);
            log.info((Object)("AgentAddress Records: " + recordCnt));
            rs.close();
            stmt.close();
            log.info((Object)"******** Doing AgentAddress JUST Agent");
            int newRecordsAdded = 0;
            StringBuilder justAgentSQL = new StringBuilder();
            justAgentSQL.setLength(0);
            justAgentSQL.append("SELECT ");
            justAgentSQL.append(BasicSQLUtils.buildSelectFieldList(agentAddrFieldNames, "agentaddress"));
            justAgentSQL.append(", ");
            BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "agent", agentFieldNames);
            justAgentSQL.append(BasicSQLUtils.buildSelectFieldList(agentFieldNames, "agent"));
            justAgentSQL.append(" FROM agent INNER JOIN agentaddress ON agentaddress.AgentID = agent.AgentID WHERE agentaddress.AddressID IS NULL ORDER BY agentaddress.AgentAddressID ASC");
            log.info((Object)justAgentSQL.toString());
            stmt = this.oldDBConn.createStatement(1004, 1007);
            rs = stmt.executeQuery(justAgentSQL.toString());
            oldFieldNames.clear();
            GenericDBConversion.addNamesWithTableName(oldFieldNames, agentAddrFieldNames, "agentaddress");
            GenericDBConversion.addNamesWithTableName(oldFieldNames, agentFieldNames, "agent");
            indexFromNameMap.clear();
            inx = 1;
            for (String fldName : oldFieldNames) {
                indexFromNameMap.put(fldName, inx++);
            }
            agentIdInx = (Integer)indexFromNameMap.get("agent.AgentID");
            lastEditInx = (Integer)indexFromNameMap.get("agent.LastEditedBy");
            agentTypeInx = (Integer)indexFromNameMap.get("agent.AgentType");
            recordCnt = 0;
            while (rs.next()) {
                byte agentType = rs.getByte(agentTypeInx);
                int agentAddressId = rs.getInt(1);
                int agentId = rs.getInt(agentIdInx);
                String lastEditedBy = rs.getString(lastEditInx);
                AgentInfo agentInfo = this.agentHash.get(agentId);
                if (shouldCreateMapTables) {
                    agentAddrIDMapper.put(agentAddressId, agentInfo.getNewAgentId());
                }
                ++recordCnt;
                if (!agentInfo.wasAdded()) {
                    agentInfo.setWasAdded(true);
                    BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
                    StringBuilder sqlStr = new StringBuilder("INSERT INTO agent ");
                    sqlStr.append("(AgentID, DivisionID, TimestampModified, AgentType, JobTitle, FirstName, LastName, MiddleInitial, Title, Interests, ");
                    sqlStr.append("Abbreviation, Email, URL, Remarks, TimestampCreated, ParentOrganizationID, ");
                    sqlStr.append("CreatedByAgentID, ModifiedByAgentID, Version)");
                    sqlStr.append(" VALUES (");
                    int i = 0;
                    while (i < agentColumns.length) {
                        if (i > 0) {
                            sqlStr.append(",");
                        }
                        if (i == 0) {
                            if (debugAgents) {
                                log.info((Object)agentColumns[i]);
                            }
                            sqlStr.append(agentInfo.getNewAgentId());
                            sqlStr.append(",");
                            sqlStr.append(this.conv.getCurDivisionID());
                        } else if (i != lastEditInx) {
                            if (agentColumns[i].equals("agent.LastName")) {
                                if (debugAgents) {
                                    log.info((Object)agentColumns[i]);
                                }
                                int srcColInx = agentType != 1 ? nameInx : lastNameInx;
                                String lName = BasicSQLUtils.getStrValue(rs.getObject(srcColInx));
                                sqlStr.append(lName);
                            } else {
                                if (debugAgents) {
                                    log.info((Object)agentColumns[i]);
                                }
                                inx = (Integer)indexFromNameMap.get(agentColumns[i]);
                                sqlStr.append(BasicSQLUtils.getStrValue(rs.getObject(inx)));
                            }
                        }
                        ++i;
                    }
                    sqlStr.append("," + this.conv.getCreatorAgentIdForAgent(lastEditedBy) + "," + this.conv.getModifiedByAgentIdForAgent(lastEditedBy) + ", 0");
                    sqlStr.append(")");
                    try {
                        if (debugAgents) {
                            log.info((Object)sqlStr.toString());
                        }
                        updateStatement.executeUpdate(sqlStr.toString());
                        Integer newAgentId = BasicSQLUtils.getInsertedId(updateStatement);
                        if (newAgentId == null) {
                            throw new RuntimeException("Couldn't get the Agent's inserted ID");
                        }
                        ++newRecordsAdded;
                    }
                    catch (SQLException e) {
                        log.error((Object)sqlStr.toString());
                        log.error((Object)("Count: " + recordCnt));
                        e.printStackTrace();
                        log.error((Object)e);
                        throw new RuntimeException(e);
                    }
                }
                if (recordCnt % 250 != 0) continue;
                log.info((Object)("AgentAddress (Agent Only) Records: " + recordCnt));
            }
            log.info((Object)("AgentAddress (Agent Only) Records: " + recordCnt + "  newRecordsAdded " + newRecordsAdded));
            rs.close();
            updateStatement.close();
            this.conv.setProcess(0, BasicSQLUtils.getNumRecords(this.oldDBConn, "agent"));
            this.conv.setDesc("Adding Agents");
            stmt = this.oldDBConn.createStatement(1004, 1007);
            rs = stmt.executeQuery("SELECT AgentID FROM agent");
            recordCnt = 0;
            while (rs.next()) {
                Integer agentId = rs.getInt(1);
                AgentInfo agentInfo = this.agentHash.get(agentId);
                if (agentInfo == null || !agentInfo.wasAdded()) {
                    this.copyAgentFromOldToNew(agentId, agentIDMapper);
                }
                if (++recordCnt % 50 != 0) continue;
                this.conv.setProcess(recordCnt);
            }
            this.conv.setProcess(recordCnt);
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
            this.conv.setProcess(0);
            stmt = this.oldDBConn.createStatement(1004, 1007);
            rs = stmt.executeQuery("SELECT AgentID FROM agent");
            recordCnt = 0;
            while (rs.next()) {
                Integer agentId = rs.getInt(1);
                Integer newId = agentIDMapper.get(agentId);
                if (newId != null) {
                    Integer isThere = BasicSQLUtils.getCount(this.newDBConn, "SELECT COUNT(*) FROM agent WHERE AgentID = " + newId);
                    if (isThere == null || isThere == 0) {
                        this.copyAgentFromOldToNew(agentId, agentIDMapper);
                    }
                } else {
                    this.tblWriter.logError("Mapping missing for old Agent id[" + agentId + "]");
                }
                if (++recordCnt % 50 != 0) continue;
                this.conv.setProcess(recordCnt);
            }
            this.conv.setProcess(recordCnt);
            if (doFixAgents) {
                this.fixAgentsLFirstLastName();
            }
            StringBuilder sqlStr1 = new StringBuilder("INSERT INTO address ");
            sqlStr1.append("(TimestampModified, Address, Address2, City, State, Country, PostalCode, Remarks, TimestampCreated, ");
            sqlStr1.append("IsPrimary, IsCurrent, Phone1, Phone2, Fax, RoomOrBuilding, PositionHeld, AgentID, CreatedByAgentID, ModifiedByAgentID, Version, Ordinal)");
            sqlStr1.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            PreparedStatement pStmt = this.newDBConn.prepareStatement(sqlStr1.toString());
            String addrSQL = "SELECT a.TimestampModified, a.Address, a.City, a.State, a.Country, a.Postalcode, a.Remarks, a.TimestampCreated, aa.Phone1, aa.Phone2, aa.Fax, aa.RoomOrBuilding , aa.IsCurrent, a.LastEditedBy, aa.JobTitle FROM address AS a INNER JOIN agentaddress AS aa ON a.AddressID = aa.AddressID WHERE aa.AgentAddressID = %d";
            BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "address", BasicSQLUtils.myDestinationServerType);
            int fixCnt = 0;
            for (AgentInfo agentInfo : this.agentHash.values()) {
                HashMap<Integer, Integer> addrs = agentInfo.getAddrs();
                for (Integer oldAgentAddrId : addrs.keySet()) {
                    String adrSQL = String.format(addrSQL, oldAgentAddrId);
                    rs = stmt.executeQuery(adrSQL);
                    if (!rs.next()) {
                        rs.close();
                        continue;
                    }
                    String lastEditedBy = rs.getString(14);
                    String posHeld = rs.getString(15);
                    if (posHeld != null && posHeld.length() > 32) {
                        posHeld = posHeld.substring(0, 32);
                    }
                    pStmt.setTimestamp(1, rs.getTimestamp(1));
                    pStmt.setString(2, rs.getString(2));
                    pStmt.setString(3, null);
                    pStmt.setString(4, rs.getString(3));
                    pStmt.setString(5, rs.getString(4));
                    pStmt.setString(6, rs.getString(5));
                    pStmt.setString(7, rs.getString(6));
                    pStmt.setString(8, rs.getString(7));
                    pStmt.setTimestamp(9, rs.getTimestamp(8));
                    pStmt.setBoolean(10, rs.getByte(13) != 0);
                    pStmt.setBoolean(11, rs.getByte(13) != 0);
                    pStmt.setString(12, rs.getString(9));
                    pStmt.setString(13, rs.getString(10));
                    pStmt.setString(14, rs.getString(11));
                    pStmt.setString(15, rs.getString(12));
                    pStmt.setString(16, posHeld);
                    pStmt.setInt(17, agentInfo.getNewAgentId());
                    pStmt.setInt(18, this.conv.getCreatorAgentIdForAgent(lastEditedBy));
                    pStmt.setInt(19, this.conv.getModifiedByAgentIdForAgent(lastEditedBy));
                    pStmt.setInt(20, 0);
                    pStmt.setInt(21, agentInfo.addrOrd);
                    Integer newID = BasicSQLUtils.getInsertedId(pStmt);
                    log.debug((Object)String.format("Saved New Id %d", newID));
                    ++agentInfo.addrOrd;
                    rs.close();
                    try {
                        if (debugAgents) {
                            log.info((Object)sqlStr1.toString());
                        }
                        if (pStmt.executeUpdate() == 1) continue;
                        log.error((Object)"Error inserting address.)");
                    }
                    catch (SQLException e) {
                        log.error((Object)sqlStr1.toString());
                        log.error((Object)("Count: " + recordCnt));
                        e.printStackTrace();
                        log.error((Object)e);
                        throw new RuntimeException(e);
                    }
                }
            }
            log.info((Object)String.format("Added %d new Addresses", fixCnt));
            pStmt.close();
            stmt.close();
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
            return true;
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            ex.printStackTrace();
            System.exit(0);
            throw new RuntimeException(ex);
        }
    }

    protected boolean parseName(String name, Triple<String, String, String> np) {
        np.first = null;
        np.second = null;
        np.third = null;
        String[] toks = StringUtils.split((String)name, (char)' ');
        switch (toks.length) {
            case 1: {
                np.third = toks[0];
                break;
            }
            case 2: {
                np.first = toks[0];
                np.third = toks[1];
                break;
            }
            case 3: {
                np.first = toks[0];
                np.second = toks[1];
                np.third = toks[2];
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void duplicateAddress(Connection newDBConnArg, Integer oldAddrId, Integer newAddrId, Integer newAgentId) throws SQLException {
        log.info((Object)String.format("Duplicating oldAddrId[%d]    newAddrId[%d] to newAgentId[%d]", oldAddrId, newAddrId, newAgentId));
        String addFieldNames = DisciplineDuplicator.getFieldNameList(this.newDBConn, "address");
        String insertSQL = String.format("INSERT INTO address (%s) (SELECT %s FROM address WHERE AddressID = %d)", addFieldNames, addFieldNames, newAddrId);
        try {
            Statement updateStatement = newDBConnArg.createStatement();
            updateStatement.executeUpdate(insertSQL);
            int insertedAddrID = BasicSQLUtils.getInsertedId(updateStatement);
            String sql = String.format("UPDATE address SET AgentID=%d WHERE AddressID = %d", newAgentId, insertedAddrID);
            updateStatement.executeUpdate(sql);
            updateStatement.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void copyAgentFromOldToNew(Integer oldAgentId, IdTableMapper agentIDMapper) {
        boolean doDebug = false;
        DBTableInfo agentTI = DBTableIdMgr.getInstance().getByShortClassName("Agent");
        DBFieldInfo lastNameField = agentTI.getFieldByColumnName("LastName");
        DBFieldInfo firstNameField = agentTI.getFieldByColumnName("FirstName");
        StringBuilder sql = new StringBuilder("SELECT ");
        if (BasicSQLUtils.myDestinationServerType != BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
            BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
        }
        BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
        List<String> oldAgentFieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "agent");
        String oldFieldListStr = BasicSQLUtils.buildSelectFieldList(oldAgentFieldNames, "agent");
        sql.append(oldFieldListStr);
        sql.append(" FROM agent WHERE AgentID = " + oldAgentId);
        List<String> newAgentFieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.newDBConn, "agent");
        String newFieldListStr = BasicSQLUtils.buildSelectFieldList(newAgentFieldNames, "agent");
        int lastNameLen = 120;
        HashMap<String, Integer> oldIndexFromNameMap = new HashMap<String, Integer>();
        int inx = 1;
        for (String fldName : oldAgentFieldNames) {
            oldIndexFromNameMap.put(fldName, inx++);
        }
        HashMap<String, Integer> newIndexFromNameMap = new HashMap<String, Integer>();
        inx = 1;
        for (String fldName : newAgentFieldNames) {
            newIndexFromNameMap.put(fldName, inx++);
        }
        try {
            Statement stmtX = this.oldDBConn.createStatement(1004, 1007);
            ResultSet rsX = stmtX.executeQuery(sql.toString());
            int agentIDInx = (Integer)oldIndexFromNameMap.get("AgentID");
            int agentTypeInx = (Integer)oldIndexFromNameMap.get("AgentType");
            int nameInx = (Integer)oldIndexFromNameMap.get("Name");
            int lastNameInx = (Integer)oldIndexFromNameMap.get("LastName");
            int firstNameInx = (Integer)oldIndexFromNameMap.get("FirstName");
            int cnt = 0;
            while (rsX.next()) {
                int agentId = rsX.getInt(1);
                StringBuilder sqlStr = new StringBuilder();
                sqlStr.append("INSERT INTO agent ");
                sqlStr.append("(" + newFieldListStr);
                sqlStr.append(")");
                sqlStr.append(" VALUES (");
                int fCnt = 0;
                for (String fieldName : newAgentFieldNames) {
                    if (fCnt > 0) {
                        sqlStr.append(", ");
                    }
                    if (StringUtils.contains((String)fieldName.toLowerCase(), (String)"disciplineid")) {
                        sqlStr.append(this.conv.getDisciplineId());
                    } else if (StringUtils.contains((String)fieldName, (String)"FirstName")) {
                        String firstName = rsX.getString(firstNameInx);
                        if (firstName != null && firstName.length() > firstNameField.getLength()) {
                            String str = firstName.substring(0, firstNameField.getLength());
                            this.tblWriter.logError("Agent id: " + rsX.getString(agentIDInx) + " - Concatinating First Name FROM [" + firstName + "] to [" + str + "]");
                            firstName = str;
                        }
                        sqlStr.append(BasicSQLUtils.getStrValue(firstName));
                    } else if (StringUtils.contains((String)fieldName, (String)"LastName")) {
                        String lstName;
                        int oldType = rsX.getInt(agentTypeInx);
                        int srcColInx = oldType != 1 ? nameInx : lastNameInx;
                        String lName = rsX.getString(srcColInx);
                        if (lName == null && oldType != 1) {
                            lName = rsX.getString(lastNameInx);
                        }
                        if (lName != null && lName.length() > lastNameField.getLength()) {
                            String str = lName.substring(0, firstNameField.getLength());
                            this.tblWriter.logError("Agent id: " + rsX.getString(agentIDInx) + " - Concatinating Last Name FROM [" + lName + "] to [" + str + "]");
                            lName = str;
                        }
                        lName = (lstName = lName) == null ? null : (lstName.length() <= lastNameLen ? lstName : lstName.substring(0, lastNameLen));
                        sqlStr.append(BasicSQLUtils.getStrValue(lName));
                    } else {
                        String value = "";
                        Integer index = fieldName.equals("ModifiedByAgentID") ? (Integer)oldIndexFromNameMap.get("LastEditedBy") : (Integer)oldIndexFromNameMap.get(fieldName);
                        value = index == null ? "NULL" : (fCnt == 0 ? agentIDMapper.get(agentId).toString() : BasicSQLUtils.getStrValue(rsX.getObject(index)));
                        BasicSQLUtilsMapValueIFace valueMapper = this.conv.getColumnValueMapper().get(fieldName);
                        if (valueMapper != null) {
                            value = valueMapper.mapValue(value);
                        }
                        sqlStr.append(value);
                    }
                    ++fCnt;
                }
                sqlStr.append(")");
                Statement updateStatement = this.newDBConn.createStatement();
                if (doDebug) {
                    log.info((Object)sqlStr.toString());
                }
                updateStatement.executeUpdate(sqlStr.toString());
                Integer newAgentId = BasicSQLUtils.getInsertedId(updateStatement);
                if (newAgentId == null) {
                    throw new RuntimeException("Couldn't get the Agent's inserted ID");
                }
                updateStatement.clearBatch();
                updateStatement.close();
                updateStatement = null;
                ++cnt;
                BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "agent", BasicSQLUtils.myDestinationServerType);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
            ex.printStackTrace();
            System.exit(0);
        }
    }

    protected void dropCollectorsTable() {
        try {
            this.gStmt.executeUpdate("DROP TABLE agent_collectors");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createCollectorsTable() {
        try {
            this.dropCollectorsTable();
            String sql = "CREATE TABLE `agent_collectors` (`KeyID` int(11) NOT NULL, `OldID` int(11) NOT NULL, `Name` varchar(255) DEFAULT NULL, `Ids` varchar(255) DEFAULT NULL,  PRIMARY KEY (`KeyID`), KEY `AgentNameIDX` (`Name`), ) ENGINE=InnoDB DEFAULT CHARSET=latin1";
            log.info((Object)("sql query: " + sql));
            this.gStmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            ex.printStackTrace();
        }
    }

    protected void addAgentCollectors(String name, int oldId, int[] ids) {
        try {
            StringBuilder sb = new StringBuilder("INSERT INTO agent_collectors (Name, OldID, Ids) VALUES('" + name + "', " + oldId + ",'");
            int i = 0;
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(id);
                ++i;
                ++n2;
            }
            sb.append("')");
            this.gStmt.executeUpdate(sb.toString());
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            ex.printStackTrace();
        }
    }

    protected int[] getAgentCollectors(String name) {
        try {
            String sql = "SELECT OldID, Ids FROM agent_collectors WHERE Name = '" + name + "'";
            ResultSet rs = this.gStmt.executeQuery(sql);
            if (rs.next()) {
                int oldId = rs.getInt(1);
                String idsStr = rs.getString(2);
                String[] toks = StringUtils.split((String)idsStr, (String)",");
                int[] ids = new int[toks.length + 1];
                ids[0] = oldId;
                int i = 1;
                while (i < toks.length + 1) {
                    ids[i] = Integer.valueOf(toks[i]);
                    ++i;
                }
                return ids;
            }
            rs.close();
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            ex.printStackTrace();
        }
        return null;
    }

    public void fixAgentsLFirstLastName() {
        try {
            Integer numAgents = BasicSQLUtils.getCount("SELECT COUNT(*) FROM agent WHERE AgentType = 1");
            Integer numBadAgents = BasicSQLUtils.getCount("SELECT COUNT(*) FROM agent WHERE FirstName is NULL AND LastName IS NOT NULL AND NOT (LastName LIKE '%&%') AND AgentType = 1");
            double percent = (double)numBadAgents.intValue() / (double)numAgents.intValue();
            if (percent > 0.25) {
                log.info((Object)("Bad Agents > 25% => " + percent));
            }
            this.tblWriter.log("<H4>Person Names not Fixed</H4>");
            this.tblWriter.startTable();
            this.tblWriter.logHdr("New Agent ID", "Old Last Name");
            String sql = "SELECT AgentID, LastName FROM agent WHERE FirstName is NULL AND LastName IS NOT NULL AND (LastName LIKE '%&%') AND AgentType = 1";
            ResultSet rs = this.gStmt.executeQuery(sql);
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String lastName = rs.getString(2);
                this.tblWriter.log(id.toString(), lastName);
            }
            rs.close();
            this.tblWriter.endTable();
            this.tblWriter.log("<BR><H4>Person Names not Fixed</H4>");
            this.tblWriter.startTable();
            this.tblWriter.logHdr("Old Last Name", "New First Name", "New Last Name");
            StringBuilder sb = new StringBuilder();
            sql = "SELECT AgentID, LastName FROM agent WHERE FirstName is NULL AND LastName IS NOT NULL AND NOT (LastName LIKE '%&%') AND AgentType = 1";
            rs = this.gStmt.executeQuery(sql);
            while (rs.next()) {
                int id = rs.getInt(1);
                String lastName = rs.getString(2);
                String[] toks = StringUtils.split((String)lastName, (String)" ");
                if (toks.length <= 1) continue;
                String firstName = toks[0];
                sb.setLength(0);
                int i = 1;
                while (i < toks.length) {
                    sb.append(toks[i]);
                    if (i < toks.length - 1) {
                        sb.append(' ');
                    }
                    ++i;
                }
                this.tblWriter.log(lastName, firstName, sb.toString());
                sql = "UPDATE agent SET FirstName=\"" + firstName + "\", LastName=\"" + sb.toString() + "\" WHERE AgentID = " + id;
                log.debug((Object)sql);
                this.updateStmtNewDB.executeUpdate(sql);
            }
            rs.close();
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            ex.printStackTrace();
        }
        this.tblWriter.endTable();
    }

    protected void fixupForCollectors(Division divisionArg, Discipline disciplineArg) {
        Session session = HibernateUtil.getNewSession();
        Transaction trans = null;
        try {
            try {
                Division division = (Division)session.createQuery("FROM Division WHERE id = " + divisionArg.getId()).list().iterator().next();
                Discipline discipline = (Discipline)session.createQuery("FROM Discipline WHERE id = " + disciplineArg.getId()).list().iterator().next();
                Agent createdByAgent = (Agent)session.createQuery("FROM Agent WHERE id = " + this.conv.getCreatorAgentIdForAgent(null)).list().iterator().next();
                this.tblWriter.log("<H4>Splitting Mutliple Collectors names into Multiple Agents</H4>");
                this.tblWriter.startTable();
                this.tblWriter.logHdr("New Agent ID", "Old Last Name", "Description");
                Vector<Integer> agentToDelete = new Vector<Integer>();
                this.conv.setProcess(0, this.agentHash.values().size());
                int cnt = 0;
                for (AgentInfo agentInfo : this.agentHash.values()) {
                    String lastNameText;
                    String string = lastNameText = agentInfo.getAgentType() != 1 ? agentInfo.getName() : agentInfo.getLastName();
                    if ((StringUtils.contains((String)lastNameText, (String)",") || StringUtils.contains((String)lastNameText, (String)";")) && !StringUtils.contains((String)lastNameText, (String)"'")) {
                        String sql = "SELECT c.CollectorID, c.CollectingEventID FROM collector c INNER JOIN agent ON c.AgentID = agent.AgentID WHERE agent.AgentID = " + agentInfo.getNewAgentId();
                        ResultSet rs = this.gStmt.executeQuery(sql);
                        if (rs.next()) {
                            int highestOrder = 0;
                            Integer colID = rs.getInt(1);
                            Integer ceId = rs.getInt(2);
                            this.tblWriter.log(ceId + " / " + colID + " / " + agentInfo.getNewAgentId().toString(), lastNameText, "&nbsp;");
                            sql = "SELECT ce.CollectingEventID, c.CollectorID, c.OrderNumber, c.IsPrimary FROM collector c INNER JOIN collectingevent ce ON c.CollectingEventID = ce.CollectingEventID WHERE c.CollectorID = " + colID + " ORDER BY c.OrderNumber DESC";
                            ResultSet rs2 = this.gStmt.executeQuery(sql);
                            if (rs2.next()) {
                                highestOrder = rs2.getInt(3);
                            }
                            rs.close();
                            CollectingEvent ce = (CollectingEvent)session.createQuery("FROM CollectingEvent WHERE id = " + ceId).list().get(0);
                            Agent origAgent = (Agent)session.createQuery("FROM Agent WHERE id = " + agentInfo.getNewAgentId()).list().get(0);
                            String[] lastNames = StringUtils.split((String)lastNameText, (String)",;");
                            int i = 0;
                            while (i < lastNames.length) {
                                if (this.parseName(lastNames[i], this.nameTriple)) {
                                    String firstName = (String)this.nameTriple.first;
                                    String middle = (String)this.nameTriple.second;
                                    String lastName = (String)this.nameTriple.third;
                                    List agts = session.createQuery("FROM Agent WHERE firstName = " + (firstName != null ? "'" + firstName + "'" : "NULL") + " AND middleInitial = " + (middle != null ? "'" + middle + "'" : "NULL") + " AND lastName = " + (lastName != null ? "'" + lastName + "'" : "NULL")).list();
                                    Agent existingAgent = agts != null && agts.size() > 0 ? (Agent)agts.get(0) : null;
                                    trans = session.beginTransaction();
                                    if (i == 0) {
                                        if (existingAgent != null) {
                                            Collector collector = (Collector)session.createQuery("FROM Collector WHERE id = " + colID).list().get(0);
                                            collector.setAgent(existingAgent);
                                            existingAgent.getCollectors().add(collector);
                                            this.tblWriter.log(agentInfo.getNewAgentId().toString(), String.valueOf(firstName) + ", " + lastName, "reusing collector,using existing agent");
                                            agentToDelete.add(origAgent.getId());
                                            session.saveOrUpdate((Object)existingAgent);
                                            session.saveOrUpdate((Object)collector);
                                            session.saveOrUpdate((Object)division);
                                            session.saveOrUpdate((Object)discipline);
                                        } else {
                                            origAgent.setFirstName(firstName);
                                            origAgent.setLastName(lastName);
                                            origAgent.setAgentType((byte)1);
                                            this.tblWriter.log(agentInfo.getNewAgentId().toString(), String.valueOf(firstName) + ", " + lastName, "resetting agent names - reclaiming");
                                            session.saveOrUpdate((Object)origAgent);
                                        }
                                    } else {
                                        Agent agent;
                                        ++highestOrder;
                                        if (existingAgent == null) {
                                            agent = new Agent();
                                            agent.initialize();
                                            agent.setAgentType((byte)1);
                                            agent.setCreatedByAgent(createdByAgent);
                                            agent.setDivision(division);
                                            agent.setFirstName((String)this.nameTriple.first);
                                            agent.setMiddleInitial((String)this.nameTriple.second);
                                            agent.setLastName((String)this.nameTriple.third);
                                            division.getMembers().add(agent);
                                            this.tblWriter.log(agentInfo.getNewAgentId().toString(), String.valueOf(firstName) + ", " + lastName, "new agent, new collector");
                                        } else {
                                            agent = existingAgent;
                                            this.tblWriter.log(agentInfo.getNewAgentId().toString(), String.valueOf(firstName) + ", " + lastName, "reusing, new collector");
                                        }
                                        Collector collector = new Collector();
                                        collector.initialize();
                                        collector.setCreatedByAgent(createdByAgent);
                                        collector.setOrderNumber(highestOrder);
                                        ce.getCollectors().add(collector);
                                        collector.setCollectingEvent(ce);
                                        collector.setAgent(agent);
                                        agent.getCollectors().add(collector);
                                        collector.setIsPrimary(false);
                                        session.saveOrUpdate((Object)agent);
                                        session.saveOrUpdate((Object)collector);
                                        session.saveOrUpdate((Object)division);
                                        session.saveOrUpdate((Object)discipline);
                                    }
                                    trans.commit();
                                }
                                ++i;
                            }
                        }
                        rs.close();
                    }
                    this.conv.setProcess(++cnt);
                }
                this.tblWriter.endTable();
                Collections.sort(agentToDelete);
                this.tblWriter.log("<H4>Removing Original Agents</H4>");
                this.tblWriter.startTable();
                this.tblWriter.logHdr("New Agent ID", "LastName", "FirstName");
                for (Integer id : agentToDelete) {
                    System.out.println("Deleting Agent[" + id + "]");
                    Vector<Object[]> rows = BasicSQLUtils.query("SELECT AgentID, LastName, MiddleInitial, FirstName FROM agent WHERE AgentID = " + id);
                    Object[] row = (Object[])rows.get(0);
                    this.tblWriter.log(id.toString(), String.valueOf(row[1] == null ? "&nbsp;" : row[1].toString()) + (row[2] == null ? "" : " " + row[2].toString()), row[3] == null ? "&nbsp;" : row[3].toString());
                    this.updateStmtNewDB.executeUpdate("DELETE FROM agent WHERE AgentID = " + id);
                }
                this.tblWriter.endTable();
            }
            catch (Exception ex) {
                try {
                    if (trans != null) {
                        trans.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ex.printStackTrace();
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
    }

    public void fixAddressOfRecord() {
        String oldAcc = "SELECT ac.AccessionID, aa.AgentID, adr.Address, adr.City, adr.State, adr.Country, adr.Postalcode, adr.Remarks, adr.TimestampModified, adr.TimestampCreated FROM accession AS ac INNER JOIN accessionagents AS aca ON ac.AccessionID = aca.AccessionID INNER JOIN agentaddress AS aa ON aca.AgentAddressID = aa.AgentAddressID INNER JOIN address AS adr ON aa.AddressID = adr.AddressID ORDER BY ac.Number ASC";
        String oldCntAcc = "SELECT COUNT(*) FROM accession AS ac INNER JOIN accessionagents AS aca ON ac.AccessionID = aca.AccessionID INNER JOIN agentaddress AS aa ON aca.AgentAddressID = aa.AgentAddressID INNER JOIN address AS adr ON aa.AddressID = adr.AddressID ORDER BY ac.Number ASC";
        String oldLoan = "SELECT l.LoanID, aa.AgentID, adr.Address, adr.City, adr.State, adr.Country, adr.Postalcode, adr.Remarks, adr.TimestampModified, adr.TimestampCreated FROM loan AS l INNER JOIN loanagents AS la ON l.LoanID = la.LoanID INNER JOIN agentaddress AS aa ON la.AgentAddressID = aa.AgentAddressID INNER JOIN address AS adr ON aa.AddressID = adr.AddressID WHERE Category = 0 ORDER BY l.LoanNumber ASC";
        String oldCntLoan = "SELECT COUNT(*) FROM loan AS l INNER JOIN loanagents AS la ON l.LoanID = la.LoanID INNER JOIN agentaddress AS aa ON la.AgentAddressID = aa.AgentAddressID INNER JOIN address AS adr ON aa.AddressID = adr.AddressID WHERE Category = 0 ORDER BY l.LoanNumber ASC";
        String oldGift = StringUtils.replace((String)oldLoan, (String)"0", (String)"1");
        String oldCntGift = StringUtils.replace((String)oldCntLoan, (String)"0", (String)"1");
        this.conv.setDesc("Fixing Accession Address Of Record");
        this.doAddressOfRecord(oldCntAcc, oldAcc, "Accession", "accession_AccessionID");
        this.conv.setDesc("Fixing Loan Address Of Record");
        this.doAddressOfRecord(oldCntLoan, oldLoan, "Loan", "loan_LoanID");
        this.conv.setDesc("Fixing Gift Address Of Record");
        this.doAddressOfRecord(oldCntGift, oldGift, "Gift", "loan_LoanID");
    }

    private void doAddressOfRecord(String cntSQL, String sql, String tableName, String mapperName) {
        IdMapperIFace agentMapper = IdMapperMgr.getInstance().get("agent_AgentID");
        Session session = HibernateUtil.getNewSession();
        Transaction trans = null;
        try {
            try {
                this.conv.setProcess(0, BasicSQLUtils.getCountAsInt(this.oldDBConn, cntSQL));
                IdMapperIFace loanMapper = IdMapperMgr.getInstance().get(mapperName);
                Statement stmt = this.oldDBConn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                int cnt = 0;
                while (rs.next()) {
                    List list;
                    int col = 1;
                    Integer loanID = rs.getInt(col++);
                    Integer agentID = rs.getInt(col++);
                    String address = rs.getString(col++);
                    String city = rs.getString(col++);
                    String state = rs.getString(col++);
                    String country = rs.getString(col++);
                    String postalCode = rs.getString(col++);
                    String remarks = rs.getString(col++);
                    Timestamp timestampModified = rs.getTimestamp(col++);
                    Timestamp timestampCreated = rs.getTimestamp(col++);
                    Integer newAgentId = agentMapper.get(agentID);
                    if (newAgentId != null && (list = session.createQuery("FROM Agent WHERE id = " + newAgentId).list()) != null && list.size() == 1) {
                        Agent agent = (Agent)list.get(0);
                        Integer newLoanId = loanMapper.get(loanID);
                        if (newLoanId != null && (list = session.createQuery("FROM " + tableName + " WHERE id = " + newLoanId).list()) != null && list.size() == 1) {
                            trans = session.beginTransaction();
                            AddressOfRecord aor = new AddressOfRecord();
                            aor.initialize();
                            aor.setAddress(address);
                            aor.setAgent(agent);
                            aor.setCity(city);
                            aor.setCountry(country);
                            aor.setPostalCode(postalCode);
                            aor.setRemarks(remarks);
                            aor.setState(state);
                            aor.setTimestampCreated(timestampCreated);
                            aor.setTimestampModified(timestampModified);
                            FormDataObjIFace parentObj = (FormDataObjIFace)list.get(0);
                            DataModelObjBase.setDataMember(parentObj, "addressOfRecord", aor);
                            session.saveOrUpdate((Object)parentObj);
                            trans.commit();
                        }
                    }
                    if (cnt % 100 == 0) {
                        this.conv.setProcess(0, cnt);
                    }
                    ++cnt;
                }
                rs.close();
                stmt.close();
            }
            catch (Exception ex) {
                try {
                    if (trans != null) {
                        trans.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ex.printStackTrace();
                log.error((Object)ex);
                session.close();
            }
        }
        finally {
            session.close();
        }
    }

    public void fixMissingAddrsFromConv() {
        IdTableMapper agentIDMapper = this.idMapperMgr.addTableMapper("agent", "AgentID", false);
        IdTableMapper addrIDMapper = this.idMapperMgr.addTableMapper("address", "AddressID", false);
        String sql = "SELECT ag.AgentID, aa.AgentAddressID, ad.AddressID FROM agent ag INNER JOIN agentaddress aa ON ag.AgentID = aa.AgentID INNER JOIN address ad ON aa.AddressID = ad.AddressID ";
        sql = "SELECT AddressID FROM (SELECT aa.AddressID, COUNT(aa.AddressID) as cnt FROM agentaddress aa INNER JOIN address ON aa.AddressID = address.AddressID GROUP BY aa.AddressID) T1 WHERE cnt > 1 ";
        int numFixed = 0;
        for (Integer oldAddrId : BasicSQLUtils.queryForInts(this.oldDBConn, sql)) {
            sql = "SELECT a.AgentID FROM address ad INNER JOIN agentaddress aa ON ad.AddressID = aa.AddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE ad.AddressID = " + oldAddrId;
            Integer newAddrID = addrIDMapper.get(oldAddrId);
            log.info((Object)"-------------------------------- fixMissingAddrsFromConv -------------------------------- ");
            for (Integer oldAgentId : BasicSQLUtils.queryForInts(this.oldDBConn, sql)) {
                Integer newAgentID = agentIDMapper.get(oldAgentId);
                sql = "SELECT ad.AddressID FROM agent a LEFT JOIN address ad ON a.AgentID = ad.AgentID WHERE a.AgentID = " + newAgentID;
                Integer addrID = BasicSQLUtils.getCount(this.newDBConn, sql);
                if (addrID != null) continue;
                try {
                    this.duplicateAddress(this.newDBConn, addrID, newAddrID, newAgentID);
                    ++numFixed;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("---------------------------------------------");
        System.out.println("Number of Addresses Duplicated: " + numFixed);
        System.out.println("---------------------------------------------");
    }

    protected void parseAndFixMultiLineAddresses() {
        String whereStr = " FROM address a WHERE Address like '%\r\n%'";
        String sql = "SELECT COUNT(*)" + whereStr;
        if (BasicSQLUtils.getCountAsInt(sql) < 1) {
            return;
        }
        sql = "SELECT AddressID, Address" + whereStr;
        Statement stmt = null;
        try {
            stmt = this.newDBConn.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(sql);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            while (rs.next()) {
                String[] toks = StringUtils.split((String)rs.getString(2), (String)"\r\n");
                hashSet.add(toks.length);
            }
            rs.close();
            Integer[] integerArray = (Integer[])hashSet.toArray();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer i = integerArray[n2];
                System.out.println(i);
                ++n2;
            }
            System.out.println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<AgentNameInfo> parseName(String firstName, String lastName, char innerSep, char nameSep, boolean isLastNameFieldFirst, boolean isLastNameFirst, boolean trimAfterComma) {
        String[] toks;
        this.recycler.addAll(this.names);
        this.names.clear();
        String fullName = isLastNameFieldFirst ? String.valueOf(lastName) + (firstName != null ? " " + firstName : "") : String.valueOf(firstName != null ? String.valueOf(firstName) + " " : "") + lastName;
        String[] stringArray = toks = StringUtils.split((String)fullName, (char)nameSep);
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            int inx;
            String name = stringArray[n2];
            if (trimAfterComma && (inx = name.indexOf(44)) > -1) {
                name = name.substring(0, inx);
            }
            ++n2;
        }
        return this.names;
    }

    class AddressInfo {
        Integer oldAgentAddrId;
        Integer oldAddrId;
        boolean isUsed = false;
        boolean wasAdded = false;

        public AddressInfo(Integer oldAgentAddrId, Integer oldAddrId) {
            this.oldAgentAddrId = oldAgentAddrId;
            this.oldAddrId = oldAddrId;
        }

        public Integer getOldAddrId() {
            return this.oldAddrId;
        }

        public boolean isUsed() {
            return this.isUsed;
        }

        public void setUsed(boolean isUsed) {
            this.isUsed = isUsed;
        }

        public boolean wasAdded() {
            return this.wasAdded;
        }

        public void setWasAdded(boolean wasAddedArg) {
            this.wasAdded = wasAddedArg;
        }

        public String toString() {
            IdMapperIFace agentAddrIDMapper = AgentConverter.this.idMapperMgr.get("agentaddress", "AgentAddressID");
            Integer newAddrId = agentAddrIDMapper.get(this.oldAgentAddrId);
            return String.format("AddressInfo [oldAddrId=%d, newAddrId=%d,  isUsed=%s,  wasAdded=%s]", this.oldAddrId, newAddrId, this.isUsed ? "Y" : "N", this.wasAdded ? "Y" : "N");
        }
    }

    class AgentInfo {
        Integer oldAgentId;
        Integer newAgentId;
        Byte agentType;
        HashMap<Integer, Integer> addrs = new HashMap();
        boolean isUsed = false;
        boolean wasAdded = false;
        String lastName;
        String firstName;
        String name;
        int addrOrd = 0;
        HashSet<Integer> addrsWritten = new HashSet();

        public AgentInfo(Integer oldAgentId, Integer newAgentId, byte agentType, String lastName, String firstName, String name) {
            this.oldAgentId = oldAgentId;
            this.newAgentId = newAgentId;
            this.agentType = agentType;
            this.lastName = lastName;
            this.firstName = firstName;
            this.name = name;
        }

        public HashMap<Integer, Integer> getAddrs() {
            return this.addrs;
        }

        public void add(Integer agtAdrId, Integer adrId) {
            this.addrs.put(agtAdrId, adrId);
        }

        public Integer getNewAgentId() {
            return this.newAgentId;
        }

        public Integer getOldAgentId() {
            return this.oldAgentId;
        }

        public boolean isUsed() {
            return this.isUsed;
        }

        public void setUsed(boolean isUsed) {
            this.isUsed = isUsed;
        }

        public boolean wasAdded() {
            return this.wasAdded;
        }

        public void setWasAdded(boolean wasAddedArg) {
            this.wasAdded = wasAddedArg;
        }

        public void addWrittenAddrOldId(Integer addrId) {
            this.addrsWritten.add(addrId);
        }

        public HashSet<Integer> getUnwrittenOldAddrIds() {
            HashSet<Integer> unwrittenIds = new HashSet<Integer>();
            for (Integer agentAddrs : this.addrs.keySet()) {
                if (this.addrsWritten.contains(agentAddrs)) continue;
                unwrittenIds.add(agentAddrs);
            }
            return unwrittenIds;
        }

        public Byte getAgentType() {
            return this.agentType;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.format("AgentInfo [oldAgentId=%d, newAgentId=%d, lastName=%s, firstName=%s,  isUsed=%s,  wasAdded=%s, addrs=%d]", this.oldAgentId != null ? this.oldAgentId : -1, this.newAgentId != null ? this.newAgentId : -1, this.lastName, this.firstName, this.isUsed ? "Y" : "N", this.wasAdded ? "Y" : "N", this.addrs.size());
        }
    }

    class AgentNameInfo {
        protected String firstName;
        protected String lastName;
        protected String middle;

        public AgentNameInfo(String firstName, String lastName, String middle) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.middle = middle;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getMiddle() {
            return this.middle;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public void setMiddle(String middle) {
            this.middle = middle;
        }
    }
}

