/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init.secwiz;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.helpers.EMailHelper;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.PrintTableHelper;
import edu.ku.brc.specify.config.init.secwiz.MasterLoginPanel;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;

public class UserPanel
extends BaseSetupPanel {
    protected JList dbList = null;
    protected JList otherDBList = null;
    protected JScrollPane dbScrollPane;
    protected JScrollPane odbScrollPane;
    protected JLabel label;
    protected JLabel otherDBLbl;
    protected JTable userTable = null;
    protected UserTableModel userModel;
    protected JScrollPane userScrollPane;
    protected JButton saveBtn = null;
    protected JButton mkKeysBtn = null;
    protected JButton copyKeyBtn = null;
    protected JButton sendKeysBtn = null;
    protected JButton showKeysBtn = null;
    protected JButton printKeysBtn = null;
    protected JButton[] btns = null;
    protected JButton gainAccessBtn = null;
    protected JButton loseAccessBtn = null;
    protected MasterLoginPanel masterPanel;
    protected String databaseName = null;
    protected String otherDBName = null;
    protected boolean changedEMail = false;

    public UserPanel(String panelName, String helpContext, JButton nextBtn, JButton prevBtn, boolean makeStretchy, MasterLoginPanel masterPanel) {
        super(panelName, helpContext, nextBtn, prevBtn, makeStretchy);
        this.masterPanel = masterPanel;
        this.createUI();
    }

    protected void createUI() {
        this.dbList = new JList(new DefaultListModel());
        this.otherDBList = new JList(new DefaultListModel());
        this.userModel = new UserTableModel(null);
        this.userTable = new JTable(this.userModel);
        CellConstraints cc = new CellConstraints();
        this.saveBtn = UIHelper.createButton("Save");
        this.mkKeysBtn = UIHelper.createButton("Make Keys");
        this.copyKeyBtn = UIHelper.createButton("Copy Master Key");
        this.sendKeysBtn = UIHelper.createButton("Send Keys");
        this.showKeysBtn = UIHelper.createButton("Show Summary");
        this.printKeysBtn = UIHelper.createButton("Print");
        this.btns = new JButton[]{this.saveBtn, this.sendKeysBtn, this.copyKeyBtn, this.showKeysBtn, this.printKeysBtn};
        String colDef = UIHelper.createDuplicateJGoodiesDef("p", "8px", this.btns.length);
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("f:p:g," + colDef, "p"));
        int x = 2;
        JButton[] jButtonArray = this.btns;
        int n = this.btns.length;
        int n2 = 0;
        while (n2 < n) {
            JButton b = jButtonArray[n2];
            btnPB.add((Component)b, cc.xy(x, 1));
            x += 2;
            ++n2;
        }
        this.saveBtn.setEnabled(false);
        this.copyKeyBtn.setEnabled(false);
        this.label = UIHelper.createLabel("", 0);
        this.gainAccessBtn = UIHelper.createIconBtn("Unmap", "", null);
        this.loseAccessBtn = UIHelper.createIconBtn("Map", "", null);
        PanelBuilder bpb = new PanelBuilder(new FormLayout("p", "f:p:g,p,8px,p,f:p:g"));
        bpb.add((Component)this.gainAccessBtn, cc.xy(1, 2));
        bpb.add((Component)this.loseAccessBtn, cc.xy(1, 4));
        PanelBuilder tpb = new PanelBuilder(new FormLayout("f:p:g,10px,p,10px,f:p:g", "p,4px,f:p:g"));
        tpb.add((Component)UIHelper.createI18NLabel("MSTR_HAS_PERM", 0), cc.xy(1, 1));
        this.otherDBLbl = UIHelper.createI18NLabel("MSTR_HAS_NOPERM", 0);
        tpb.add((Component)this.otherDBLbl, cc.xy(5, 1));
        this.dbScrollPane = UIHelper.createScrollPane(this.dbList);
        tpb.add((Component)this.dbScrollPane, cc.xy(1, 3));
        tpb.add((Component)bpb.getPanel(), cc.xy(3, 3));
        this.odbScrollPane = UIHelper.createScrollPane(this.otherDBList);
        tpb.add((Component)this.odbScrollPane, cc.xy(5, 3));
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p", "f:p:g,20px,p,8px,p,4px,f:p:g,4px,p,20px,p"), (JPanel)this);
        this.sendKeysBtn.setVisible(false);
        int y = 1;
        pb.add((Component)tpb.getPanel(), cc.xyw(1, y, 2));
        y += 2;
        pb.add((Component)this.label, cc.xyw(1, y += 2, 2));
        this.userScrollPane = UIHelper.createScrollPane(this.userTable);
        pb.add((Component)this.userScrollPane, cc.xyw(1, y += 2, 2));
        pb.add((Component)btnPB.getPanel(), cc.xy(2, y += 2));
        pb.addSeparator("", cc.xyw(1, y += 2, 2));
        y += 2;
        this.dbList.setVisibleRowCount(8);
        this.otherDBList.setVisibleRowCount(8);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension size = UserPanel.this.userTable.getPreferredScrollableViewportSize();
                size.height = 10 * UserPanel.this.userTable.getRowHeight();
                UserPanel.this.userTable.setPreferredScrollableViewportSize(size);
            }
        });
        this.updateBtnUI(false);
        this.dbList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    UserPanel.this.loadData(false);
                    UserPanel.this.gainAccessBtn.setEnabled(UserPanel.this.otherDBList.getSelectedIndex() > -1);
                    UserPanel.this.loseAccessBtn.setEnabled(UserPanel.this.dbList.getSelectedIndex() > -1);
                }
            }
        });
        this.userTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    UserPanel.this.doUserSelected();
                }
            }
        });
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.saveUserData();
            }
        });
        this.sendKeysBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.sendKeys();
            }
        });
        this.mkKeysBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.makeKeys();
            }
        });
        this.copyKeyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int inx = UserPanel.this.userTable.getSelectedRow();
                if (inx > -1) {
                    String masterKey = UserPanel.this.userModel.getUserData().get(inx).getMasterKey();
                    UIHelper.setTextToClipboard(masterKey);
                }
            }
        });
        this.showKeysBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.displayData();
            }
        });
        this.printKeysBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.printUserData();
            }
        });
        this.gainAccessBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.changeMasterAccess(true);
            }
        });
        this.loseAccessBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.changeMasterAccess(false);
            }
        });
        this.otherDBList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    UserPanel.this.otherDBName = (String)UserPanel.this.otherDBList.getSelectedValue();
                    UserPanel.this.gainAccessBtn.setEnabled(UserPanel.this.otherDBList.getSelectedIndex() > -1);
                    UserPanel.this.loseAccessBtn.setEnabled(UserPanel.this.dbList.getSelectedIndex() > -1);
                }
            }
        });
    }

    private void updateBtnUI(boolean enabled) {
        this.saveBtn.setEnabled(enabled && this.userModel.isChanged());
        this.mkKeysBtn.setEnabled(enabled && this.userModel.isPwdChanged());
        int inx = this.userTable.getSelectedRow();
        if (inx > -1) {
            this.copyKeyBtn.setEnabled(enabled && this.userModel.getUserData().get(inx).isChanged());
        }
    }

    private void saveUserData() {
        boolean hasErrors;
        block26: {
            hasErrors = false;
            DBMSUserMgr mgr = DBMSUserMgr.getInstance();
            Statement pStmtSp = null;
            Statement pStmtAg = null;
            try {
                try {
                    String dbUserName = this.properties.getProperty("dbUserName");
                    String dbPassword = this.properties.getProperty("dbPassword");
                    String hostName = this.properties.getProperty("hostName");
                    if (mgr.connect(dbUserName, dbPassword, hostName, this.databaseName)) {
                        pStmtSp = mgr.getConnection().prepareStatement("UPDATE specifyuser SET EMail=?, Password=? WHERE SpecifyUserID = ?");
                        pStmtAg = mgr.getConnection().prepareStatement("UPDATE agent SET Email=? WHERE AgentID = ?");
                        for (UserData ud : this.userModel.getUserData()) {
                            if (!ud.isChanged()) continue;
                            if (StringUtils.isNotEmpty((String)ud.getEmail())) {
                                pStmtSp.setString(1, ud.getEmail());
                            } else {
                                pStmtSp.setObject(1, null);
                            }
                            pStmtSp.setString(2, ud.getPassword());
                            pStmtSp.setInt(3, ud.getId());
                            int rv = pStmtSp.executeUpdate();
                            if (rv == 1) {
                                ud.setChanged(false);
                            } else {
                                System.err.println("Error " + pStmtSp.getWarnings());
                            }
                            if (!StringUtils.isNotEmpty((String)ud.getEmail())) continue;
                            String sql = String.format("SELECT AgentID FROM agent WHERE SpecifyUserID = %d AND (Email IS NULL OR Email <> '%s')", ud.getId(), ud.getEmail());
                            Vector<Integer> agentIds = BasicSQLUtils.queryForInts(mgr.getConnection(), sql);
                            for (Integer agentId : agentIds) {
                                pStmtAg.setString(1, ud.getEmail());
                                pStmtAg.setInt(2, agentId);
                            }
                            if (pStmtSp.executeUpdate() == 1) continue;
                            hasErrors = true;
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        if (pStmtSp != null) {
                            pStmtSp.close();
                        }
                        if (pStmtAg != null) {
                            pStmtAg.close();
                        }
                        mgr.close();
                    }
                    catch (SQLException sQLException) {}
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pStmtSp != null) {
                        pStmtSp.close();
                    }
                    if (pStmtAg != null) {
                        pStmtAg.close();
                    }
                    mgr.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (pStmtSp != null) {
                    pStmtSp.close();
                }
                if (pStmtAg != null) {
                    pStmtAg.close();
                }
                mgr.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!hasErrors) {
            this.userModel.setPwdChanged(false);
            this.userModel.setChanged(false);
            this.saveBtn.setEnabled(false);
            this.mkKeysBtn.setEnabled(false);
            if (this.changedEMail) {
                this.changedEMail = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIRegistry.loadAndPushResourceBundle("specifydbsetupwiz");
                        UIRegistry.showLocalizedMsg(1, "SEC_EML_TITLE", "SEC_EML_MSG", new Object[0]);
                        UIRegistry.popResourceBundle();
                    }
                });
            }
        }
    }

    protected int[] getSelectedIds() {
        int[] selectedIds = this.userTable.getSelectedRows();
        if (this.userTable.getSelectedRowCount() > 0) {
            selectedIds = this.userTable.getSelectedRows();
        } else {
            selectedIds = new int[this.userTable.getRowCount()];
            int i = 0;
            while (i < this.userTable.getRowCount()) {
                selectedIds[i] = i;
                ++i;
            }
        }
        return selectedIds;
    }

    private void makeKeys() {
        String saPassword = this.properties.getProperty("saPassword");
        for (UserData ud : this.userModel.getUserData()) {
            String encryptedPwd;
            String pwd = ud.getPassword();
            if (!ud.isChanged() || !StringUtils.isNotEmpty((String)pwd) || UIHelper.isAllCaps(pwd) && pwd.length() >= 25 || !StringUtils.isNotEmpty((String)(encryptedPwd = Encryption.encrypt(saPassword, pwd)))) continue;
            ud.setPassword(encryptedPwd);
            ud.setChanged(true);
            this.userModel.setChanged(true);
            ud.setClearTextPassword(pwd);
        }
        this.saveBtn.setEnabled(this.userModel.isChanged());
        this.mkKeysBtn.setEnabled(false);
    }

    private void sendKeys() {
        Hashtable<String, String> emailPrefs = new Hashtable<String, String>();
        if (!EMailHelper.isEMailPrefsOK(emailPrefs)) {
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("NO_EMAIL_PREF_INFO"), UIRegistry.getResourceString("NO_EMAIL_PREF_INFO_TITLE"), 2);
            return;
        }
        int[] selectedIds = this.getSelectedIds();
        Vector<UserData> items = this.userModel.getUserData();
        int[] nArray = selectedIds;
        int n = selectedIds.length;
        int n2 = 0;
        while (n2 < n) {
            EMailHelper.ErrorType status;
            int inx = nArray[n2];
            StringBuilder sb = new StringBuilder();
            String text = String.valueOf(emailPrefs.get("bodytext").replace("\n", "<br>")) + "<BR><BR>" + sb.toString();
            UIRegistry.displayLocalizedStatusBarText("SENDING_EMAIL", new Object[0]);
            String password = Encryption.decrypt(emailPrefs.get("password"));
            if (StringUtils.isEmpty((String)password)) {
                password = EMailHelper.askForPassword((Frame)UIRegistry.getTopWindow());
            }
            if (StringUtils.isNotEmpty((String)password) && (status = EMailHelper.sendMsg(emailPrefs.get("smtp"), emailPrefs.get("username"), password, emailPrefs.get("email"), emailPrefs.get("to"), emailPrefs.get("subject"), text, "text/html", emailPrefs.get("port"), emailPrefs.get("security"), null)) != EMailHelper.ErrorType.Cancel) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIRegistry.displayLocalizedStatusBarText(status == EMailHelper.ErrorType.Error ? "EMAIL_SENT_ERROR" : "EMAIL_SENT_OK", new Object[0]);
                    }
                });
            }
            ++n2;
        }
    }

    protected void displayData() {
        StringBuilder sb = new StringBuilder();
        String[] headers = new String[]{"Username", "Passsword", "MasterKey", "Last Name", "First Name", "EMail", "New Password"};
        int i = 0;
        Object[][] pValueObjs = new Object[this.userModel.getUserData().size()][6];
        for (UserData ud : this.userModel.getUserData()) {
            pValueObjs[i++] = ud.getData();
        }
        sb.append("<HTML><BODY><TABLE border=1><TR>");
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String hd = stringArray[n2];
            sb.append("<TH>");
            sb.append(hd);
            sb.append("</TH>");
            ++n2;
        }
        sb.append("</TR>");
        stringArray = pValueObjs;
        n = pValueObjs.length;
        n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            sb.append("<TR>");
            i = 0;
            while (i < headers.length) {
                sb.append("<TD>");
                sb.append((Object)(row[i] == null ? "&nbsp;" : row[i]));
                sb.append("</TD>");
                ++i;
            }
            sb.append("</TR>");
            ++n2;
        }
        sb.append("</TABLE></BODY></HTML>");
        JEditorPane htmlPane = new JEditorPane("text/html", sb.toString());
        final JScrollPane scrollPane = UIHelper.createScrollPane(htmlPane);
        htmlPane.setEditable(false);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)scrollPane, "Center");
        p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), "Summary", true, 1, (Component)p);
        dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        dlg.createUI();
        dlg.setSize(dlg.getPreferredSize().width, 768);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        UIHelper.centerAndShow(dlg);
    }

    private void printUserData() {
        JTable printTable = new JTable();
        int i = 0;
        Object[][] pValueObjs = new Object[this.userModel.getUserData().size()][6];
        for (UserData ud : this.userModel.getUserData()) {
            pValueObjs[i++] = ud.getData();
        }
        Object[] headers = new String[]{"Username", "Passsword", "Last Name", "First Name", "EMail", "New Password"};
        DefaultTableModel model = new DefaultTableModel(pValueObjs, headers){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
        printTable.setModel(model);
        PrintTableHelper pth = new PrintTableHelper(printTable);
        pth.printGrid(UIRegistry.getResourceString("SUMMARY"));
    }

    private void changeMasterAccess(boolean doGainAccess) {
        int[] inxs;
        String dbName;
        String msg = UIRegistry.getResourceString(doGainAccess ? "DO_GAIN_ACCESS" : "DO_LOOSE_ACCESS");
        if (UIRegistry.askYesNoLocalized("YES", "NO", msg, "WARNING") == 1) {
            return;
        }
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String dbUserName = this.properties.getProperty("dbUserName");
        String dbPassword = this.properties.getProperty("dbPassword");
        String saUserName = this.properties.getProperty("saUserName");
        String hostName = this.properties.getProperty("hostName");
        String string = dbName = doGainAccess ? this.otherDBName : this.databaseName;
        if (mgr.getConnection() == null && !mgr.connectToDBMS(dbUserName, dbPassword, hostName)) {
            UIRegistry.showError("Unable to login.");
            return;
        }
        ArrayList<String> changedNames = new ArrayList<String>();
        ArrayList<String> noChangeNames = new ArrayList<String>();
        JList list = doGainAccess ? this.otherDBList : this.dbList;
        int[] nArray = inxs = list.getSelectedIndices();
        int n = inxs.length;
        int n2 = 0;
        while (n2 < n) {
            int inx = nArray[n2];
            String dbNm = (String)list.getModel().getElementAt(inx);
            if (mgr.setPermissions(saUserName, dbNm, doGainAccess ? 31 : 0)) {
                changedNames.add(dbNm);
            } else {
                noChangeNames.add(dbNm);
            }
            ++n2;
        }
        for (String nm : changedNames) {
            if (doGainAccess) {
                ((DefaultListModel)this.otherDBList.getModel()).removeElement(nm);
                ((DefaultListModel)this.dbList.getModel()).addElement(nm);
                continue;
            }
            ((DefaultListModel)this.otherDBList.getModel()).addElement(nm);
            ((DefaultListModel)this.dbList.getModel()).removeElement(nm);
        }
        if (inxs.length == 1) {
            UIRegistry.showLocalizedMsg(1, "MSTR_PERM_CHGED_TITLE", doGainAccess ? "MSTR_PERM_ADDED" : "MSTR_PERM_DEL", saUserName, dbName);
            final int selInx = inxs[0];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserPanel.this.dbList.setSelectedIndex(selInx);
                }
            });
        } else {
            UIRegistry.showLocalizedMsg(1, "MSTR_PERM_CHGED_TITLE", doGainAccess ? "MSTR_NUM_PERM_ADDED" : "MSTR_NUM_PERM_DEL", saUserName, changedNames.size());
        }
        mgr.close();
    }

    private void doUserSelected() {
        int index = this.userTable.getSelectedRow();
        this.updateBtnUI(index > -1);
    }

    @Override
    public void doingNext() {
        super.doingNext();
        this.loadData(true);
    }

    @Override
    public void aboutToLeave() {
        String msg;
        if (this.userModel.isChanged() && UIRegistry.askYesNoLocalized("SAVE", "EXIT", msg = UIRegistry.getResourceString("MSTR_SAVE_CHANGES"), "SAVE") == 0) {
            this.saveUserData();
        }
        super.aboutToLeave();
    }

    private void loadData(boolean isInitial) {
        this.label.setText("");
        String hostName = this.properties.getProperty("hostName");
        String dbUserName = this.properties.getProperty("dbUserName");
        String dbPassword = this.properties.getProperty("dbPassword");
        int index = 0;
        List<String> dbNamesList = this.masterPanel.getDbNamesForMaster();
        List<String> otherNamesList = this.masterPanel.getDbNameList();
        if (dbNamesList == null || dbNamesList.size() == 0) {
            return;
        }
        Vector<String> items = new Vector<String>(dbNamesList);
        Collections.sort(items);
        if (!isInitial && (index = this.dbList.getSelectedIndex()) == -1) {
            return;
        }
        this.databaseName = isInitial ? items.get(0) : (String)this.dbList.getSelectedValue();
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        while (true) {
            if (mgr.connect(dbUserName, dbPassword, hostName, this.databaseName)) {
                if (isInitial) {
                    HashSet<String> dbNameHashSet = new HashSet<String>();
                    DefaultListModel<String> model = new DefaultListModel<String>();
                    for (String nm : items) {
                        model.addElement(nm);
                        dbNameHashSet.add(nm);
                    }
                    this.dbList.setModel(model);
                    model = new DefaultListModel();
                    for (String nm : otherNamesList) {
                        if (dbNameHashSet.contains(nm)) continue;
                        model.addElement(nm);
                    }
                    this.otherDBList.setModel(model);
                }
                this.label.setText(UIRegistry.getFormattedResStr("MSTR_USR_DB", this.databaseName));
                if (!mgr.doesDBHaveTable(this.databaseName, "specifyuser")) {
                    items.remove(0);
                    this.databaseName = isInitial ? items.get(0) : (String)this.dbList.getSelectedValue();
                    continue;
                }
                Vector<UserData> userDataList = new Vector<UserData>();
                String sql = "SELECT SpecifyUserId, Name, Password, EMail FROM specifyuser";
                Vector<Object[]> data = BasicSQLUtils.query(mgr.getConnection(), sql);
                for (Object[] c : data) {
                    UserData ud = new UserData((Integer)c[0], (String)c[1], (String)c[2], "(On user's machine)", (String)c[3]);
                    userDataList.add(ud);
                    sql = String.format("SELECT LastName, FirstName, EMail FROM agent WHERE SpecifyUserID = %d ORDER BY TimestampModified, TimestampCreated LIMIT 0,1", ud.getId());
                    Vector<Object[]> uData = BasicSQLUtils.query(mgr.getConnection(), sql);
                    if (uData.size() <= 0) continue;
                    Object[] d = uData.get(0);
                    ud.setLastName((String)d[0]);
                    ud.setFirstName((String)d[1]);
                    String email = (String)d[2];
                    if (!StringUtils.isNotEmpty((String)email) || !StringUtils.isEmpty((String)ud.getEmail())) continue;
                    ud.setEmail(email);
                }
                mgr.close();
                this.userModel.setUserData(userDataList);
                UIHelper.calcColumnWidths(this.userTable);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Window window = UIRegistry.getTopWindow();
                        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
                        Rectangle screenRect = window.getGraphicsConfiguration().getBounds();
                        screenRect.height -= screenInsets.top + screenInsets.bottom;
                        screenRect.width -= screenInsets.left + screenInsets.right;
                        Rectangle rect = window.getBounds();
                        Dimension size = window.getPreferredSize();
                        size.width = Math.min(size.width, screenRect.width);
                        size.height = Math.min(size.height, screenRect.height);
                        if (size.height > rect.height || size.width > rect.width) {
                            window.setBounds(rect.x, rect.y, size.width, size.height);
                            UIHelper.centerWindow(UIRegistry.getTopWindow());
                        }
                    }
                });
                if (!isInitial || items.size() <= 0) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UserPanel.this.dbList.setSelectedIndex(0);
                    }
                });
                break;
            }
            if (items.size() <= 1) break;
            items.remove(0);
            this.databaseName = isInitial ? items.get(0) : (String)this.dbList.getSelectedValue();
        }
    }

    @Override
    public void doingPrev() {
        super.doingPrev();
    }

    @Override
    public String getPanelName() {
        return super.getPanelName();
    }

    @Override
    public void getValues(Properties props) {
    }

    @Override
    public boolean isUIValid() {
        return true;
    }

    @Override
    public void setValues(Properties values) {
        super.setValues(values);
    }

    @Override
    public void updateBtnUI() {
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        return null;
    }

    private void makeNewMasterKey(UserData ud, String newPwd, int row) {
        String masterUsr = this.properties.getProperty("dbUserName");
        String masterPwd = this.properties.getProperty("dbPassword");
        String masterKey = UserAndMasterPasswordMgr.encrypt(masterUsr, masterPwd, newPwd);
        ud.setMasterKey(masterKey);
        this.userModel.fireTableRowsUpdated(row, row);
    }

    private void changedPWD(final UserData ud, final String newPwd, final int row) {
        ud.setPassword(newPwd);
        ud.setChanged(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserPanel.this.makeNewMasterKey(ud, newPwd, row);
            }
        });
    }

    class UserData {
        protected boolean isChanged = false;
        protected int id;
        protected String userName;
        protected String password;
        protected String masterKey;
        protected String lastName;
        protected String firstName;
        protected String email;
        protected String clearTextPassword;
        protected String cachedEmail;

        public UserData(int id, String userName, String password, String masterKey, String email) {
            this.id = id;
            this.userName = userName;
            this.password = password;
            this.masterKey = masterKey;
            this.lastName = "";
            this.firstName = "";
            this.email = email;
            this.clearTextPassword = null;
            this.cachedEmail = email;
        }

        public Object[] getData() {
            int i = 0;
            Object[] data = new Object[7];
            data[i++] = this.userName;
            data[i++] = this.password;
            data[i++] = this.masterKey;
            data[i++] = this.lastName;
            data[i++] = this.firstName;
            data[i++] = this.email;
            data[i++] = this.clearTextPassword;
            return data;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public void setChanged(boolean isChanged) {
            this.isChanged = isChanged;
        }

        public String getCachedEmail() {
            return this.cachedEmail;
        }

        public String getClearTextPassword() {
            return this.clearTextPassword;
        }

        public void setClearTextPassword(String clearTextPassword) {
            this.clearTextPassword = clearTextPassword;
        }

        public String getMasterKey() {
            return this.masterKey;
        }

        public void setMasterKey(String masterKey) {
            this.masterKey = masterKey;
        }
    }

    class UserTableModel
    extends DefaultTableModel {
        protected String[] headers = new String[]{"Changed", "Username", "Passsword", "Master Key", "Last Name", "First Name", "EMail"};
        protected Vector<UserData> items = new Vector();
        protected boolean isChanged = false;
        protected boolean isPwdChanged = false;

        public UserTableModel(List<UserData> items) {
            if (items != null) {
                this.items.addAll(items);
            }
        }

        @Override
        public int getColumnCount() {
            return this.headers != null ? this.headers.length : 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers != null ? this.headers[column] : "";
        }

        @Override
        public int getRowCount() {
            return this.items != null ? this.items.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            UserData ud = this.items.get(row);
            if (ud != null) {
                switch (column) {
                    case 0: {
                        return ud.isChanged();
                    }
                    case 1: {
                        return ud.getUserName();
                    }
                    case 2: {
                        return ud.getPassword();
                    }
                    case 3: {
                        return ud.getMasterKey();
                    }
                    case 4: {
                        return ud.getLastName();
                    }
                    case 5: {
                        return ud.getFirstName();
                    }
                    case 6: {
                        return ud.getEmail();
                    }
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        public Vector<?> getDataVector() {
            return this.items;
        }

        public Vector<UserData> getUserData() {
            return this.items;
        }

        public void setChanged(boolean isChanged) {
            this.isChanged = isChanged;
            this.fireTableDataChanged();
        }

        public void setUserData(List<UserData> list) {
            if (this.items != null) {
                this.items.clear();
                this.items.addAll(list);
                this.fireTableDataChanged();
                this.isChanged = false;
                this.isPwdChanged = false;
                UserPanel.this.updateBtnUI(false);
            }
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public boolean isPwdChanged() {
            return this.isPwdChanged;
        }

        public void setPwdChanged(boolean isPwdChanged) {
            this.isPwdChanged = isPwdChanged;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            UserData ud = this.items.get(row);
            switch (column) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            UserData ud = this.items.get(row);
            if (ud != null) {
                switch (column) {
                    case 0: {
                        ud.setChanged((Boolean)aValue);
                        ud.setEmail(ud.getCachedEmail());
                        this.isChanged = true;
                        this.fireTableDataChanged();
                        break;
                    }
                    case 2: {
                        UserPanel.this.changedPWD(ud, (String)aValue, row);
                        this.isPwdChanged = true;
                        this.isChanged = true;
                        this.fireTableDataChanged();
                        break;
                    }
                    case 3: {
                        ud.setMasterKey((String)aValue);
                        ud.setChanged(true);
                        this.isChanged = true;
                        this.fireTableDataChanged();
                        break;
                    }
                    case 6: {
                        this.isChanged = true;
                        ud.setEmail((String)aValue);
                        ud.setChanged(true);
                        this.fireTableDataChanged();
                        UserPanel.this.changedEMail = true;
                    }
                }
            }
            UserPanel.this.updateBtnUI(true);
        }
    }
}

