/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init.secwiz;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.launcher.SplashScreen;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.ProcessListUtil;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.SchemaUpdateService;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.config.init.secwiz.SpecifyDBSecurityWizard;
import edu.ku.brc.specify.datamodel.SpVersion;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;

public class SpecifyDBSecurityWizardFrame
extends JFrame
implements FrameworkAppIFace {
    private String appVersion = "6.0";
    private String appBuildVersion = "(Unknown)";

    public SpecifyDBSecurityWizardFrame() throws HeadlessException {
        UIRegistry.loadAndPushResourceBundle("specifydbsetupwiz");
        new MacOSAppHandler(this);
        UIRegistry.setTopWindow(this);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        AppPrefsCache.setUseLocalOnly(true);
        SpecifyAppPrefs.setSkipRemotePrefs(true);
        SpecifyAppPrefs.initialPrefs();
        ImageIcon helpIcon = IconManager.getIcon(SpecifyDBSecurityWizard.getIconName(), IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        JMenuBar menuBar = this.createMenus();
        if (menuBar != null) {
            this.setJMenuBar(menuBar);
        }
        UIRegistry.register("menubar", menuBar);
        this.setIconImage(IconManager.getIcon(SpecifyDBSecurityWizard.getIconName(), IconManager.IconSize.NonStd).getImage());
        this.setDefaultCloseOperation(2);
        SpecifyDBSecurityWizard wizPanel = new SpecifyDBSecurityWizard(new SpecifyDBSecurityWizard.WizardListener(){

            @Override
            public void cancelled() {
                SpecifyDBSecurityWizardFrame.this.setVisible(false);
                SpecifyDBSecurityWizardFrame.this.doExit(true);
            }

            @Override
            public void hide() {
                SpecifyDBSecurityWizardFrame.this.setVisible(false);
            }

            @Override
            public void finished() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpecifyDBSecurityWizardFrame.this.dispose();
                        SpecifyDBSecurityWizardFrame.this.doExit(true);
                    }
                });
            }

            @Override
            public void panelChanged(String title) {
                SpecifyDBSecurityWizardFrame.this.setTitle(SpecifyDBSecurityWizardFrame.this.getAppTitle(title));
            }
        });
        this.setTitle(this.getAppTitle(UIRegistry.getResourceString("MAIN_TITLE")));
        this.setContentPane(wizPanel);
        this.pack();
    }

    protected String getAppTitle(String titleStr) {
        String resAppVersion = UIRegistry.getAppVersion();
        if (StringUtils.isNotEmpty((String)resAppVersion)) {
            this.appVersion = resAppVersion;
        }
        return AppBase.getTitle(this.appVersion, this.appBuildVersion, titleStr);
    }

    private static List<Integer> checkForMySQLPrc() {
        return UIHelper.isWindows() ? ProcessListUtil.getProcessIdWithText("_data/bin/mysqld") : ProcessListUtil.getProcessIdWithText("3337");
    }

    public static PROC_STATUS checkForMySQLProcesses() {
        PROC_STATUS status = PROC_STATUS.None;
        List<Integer> ids = SpecifyDBSecurityWizardFrame.checkForMySQLPrc();
        if (ids.size() > 0) {
            status = PROC_STATUS.FoundNotKilled;
            if (UIHelper.promptForAction("CONTINUE", "CANCEL", "WARNING", UIRegistry.getResourceString("Specify.EMBD_KILL_PROCS"))) {
                for (Integer id : ids) {
                    ProcessListUtil.killProcess(id);
                }
                status = PROC_STATUS.FoundAndKilled;
            }
        }
        return status;
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        if (DBConnection.getInstance().getConnection() != null) {
            String resAppVersion = UIRegistry.getAppVersion();
            String dbVersion = SchemaUpdateService.getInstance().getDBSchemaVersionFromXML();
            SpVersion.createInitialRecord(DBConnection.getInstance().getConnection(), resAppVersion, dbVersion);
            if (UIRegistry.isMobile()) {
                DBConnection.setCopiedToMachineDisk(true);
            }
        }
        DBConnection.shutdown();
        HibernateUtil.shutdown();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIRegistry.isEmbedded().booleanValue() || UIRegistry.isMobile()) {
                    DBConnection.shutdownFinalConnection(true, false);
                } else {
                    System.exit(0);
                }
            }
        });
        return true;
    }

    @Override
    public void doAbout() {
        Specify specify = new Specify();
        specify.doAbout();
    }

    @Override
    public void doPreferences() {
    }

    public JMenuBar createMenus() {
        JMenuItem mi;
        JMenuBar mb = new JMenuBar();
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            JMenu menu = UIHelper.createLocalizedMenu(mb, "Specify.FILE_MENU", "Specify.FILE_MNEU");
            menu.addSeparator();
            String title = "Specify.EXIT";
            String mnu = "Specify.Exit_MNEU";
            mi = UIHelper.createLocalizedMenuItem(menu, title, mnu, title, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SpecifyDBSecurityWizardFrame.this.doExit(true);
                }
            });
        }
        JMenu helpMenu = UIHelper.createLocalizedMenu(mb, "Specify.HELP_MENU", "Specify.HELP_MNEU");
        HelpMgr.createHelpMenuItem(helpMenu, "Specify");
        helpMenu.addSeparator();
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            String ttle = "Specify.ABOUT";
            String mneu = "Specify.ABOUTMNEU";
            String desc = "Specify.ABOUT";
            mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SpecifyDBSecurityWizardFrame.this.doAbout();
                }
            });
        }
        return mb;
    }

    public static void setUpSystemProperties() {
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
        System.setProperty("RecordSetFactory", "edu.ku.brc.specify.config.SpecifyRecordSetFactory");
        System.setProperty("edu.ku.brc.dbsupport.DBTableIdMgr", "edu.ku.brc.specify.config.SpecifyDBTableIdMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty("edu.ku.brc.af.core.db.BackupServiceFactory", "edu.ku.brc.af.core.db.MySQLBackupService");
        System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
    }

    public static void main(String[] args) {
        UIRegistry.setAppName("Specify");
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
        try {
            if (!System.getProperty("os.name").equals("Mac OS X")) {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyDBSecurityWizard.class, e);
            e.printStackTrace();
        }
        AppBase.processArgs(args);
        AppBase.setupTeeForStdErrStdOut(true, false);
        System.setProperty("appdatadir", "..");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String EXTRA_CHECK;
                IconManager.setApplicationClass(Specify.class);
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
                AppPreferences localPrefs = AppPreferences.getLocalPrefs();
                localPrefs.setDirPath(UIRegistry.getAppDataDir());
                String VERSION_CHECK = "version_check.auto";
                if (localPrefs.getBoolean(VERSION_CHECK, null) == null) {
                    localPrefs.putBoolean(VERSION_CHECK, true);
                }
                if (localPrefs.getBoolean(EXTRA_CHECK = "extra.check", null) == null) {
                    localPrefs.putBoolean(EXTRA_CHECK, true);
                }
                if (UIHelper.isLinux()) {
                    Specify.checkForSpecifyAppsRunning();
                }
                if (UIRegistry.isEmbedded().booleanValue()) {
                    SpecifyDBSecurityWizardFrame.checkForMySQLProcesses();
                }
                SpecifyDBSecurityWizardFrame.setUpSystemProperties();
                final SpecifyDBSecurityWizardFrame wizardFrame = new SpecifyDBSecurityWizardFrame();
                if (localPrefs.getBoolean(VERSION_CHECK, true).booleanValue() && localPrefs.getBoolean(EXTRA_CHECK, true).booleanValue()) {
                    try {
                        SplashScreen.hide();
                        ApplicationLauncher.Callback callback = new ApplicationLauncher.Callback(){

                            public void exited(int exitValue) {
                                UIHelper.centerAndShow(wizardFrame);
                            }

                            public void prepareShutdown() {
                            }
                        };
                        ApplicationLauncher.launchApplication((String)"100", null, (boolean)true, (ApplicationLauncher.Callback)callback);
                    }
                    catch (Exception ex) {
                        UIHelper.centerAndShow(wizardFrame);
                    }
                } else {
                    UIHelper.centerAndShow(wizardFrame);
                }
            }
        });
    }

    public static enum PROC_STATUS {
        None,
        FoundAndKilled,
        FoundNotKilled;

    }
}

