/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init.secwiz;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.UserInfoPanel;
import edu.ku.brc.specify.config.init.secwiz.DatabasePanel;
import edu.ku.brc.specify.config.init.secwiz.MasterLoginPanel;
import edu.ku.brc.specify.config.init.secwiz.UserPanel;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class SpecifyDBSecurityWizard
extends JPanel {
    private static final Logger log = Logger.getLogger(SpecifyDBSecurityWizard.class);
    protected WizardListener listener;
    protected final String HOSTNAME = "localhost";
    protected boolean doLoginOnly = false;
    protected Properties props = new Properties();
    protected JButton helpBtn;
    protected JButton backBtn;
    protected JButton nextBtn;
    protected JButton cancelBtn;
    protected DatabasePanel dbPanel;
    protected UserInfoPanel userInfoPanel;
    protected int step = 0;
    protected int lastStep = 0;
    protected boolean isCancelled;
    protected JPanel cardPanel;
    protected CardLayout cardLayout = new CardLayout();
    protected Vector<BaseSetupPanel> panels = new Vector();
    protected String setupXMLPath;
    protected JProgressBar progressBar;
    protected ProgressFrame progressFrame;

    public SpecifyDBSecurityWizard(final WizardListener listener) {
        this.listener = listener;
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        HelpMgr.setLoadingPage("Load");
        this.cardPanel = new JPanel(this.cardLayout);
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        this.backBtn = UIHelper.createButton(UIRegistry.getResourceString("BACK"));
        this.nextBtn = UIHelper.createButton(UIRegistry.getResourceString("NEXT"));
        CellConstraints cc = new CellConstraints();
        PanelBuilder bbpb = new PanelBuilder(new FormLayout("f:p:g,p,4px,p,4px,p,4px,p,4px", "p"));
        bbpb.add((Component)this.helpBtn, cc.xy(2, 1));
        bbpb.add((Component)this.backBtn, cc.xy(4, 1));
        bbpb.add((Component)this.nextBtn, cc.xy(6, 1));
        bbpb.add((Component)this.cancelBtn, cc.xy(8, 1));
        JPanel btnBar = bbpb.getPanel();
        boolean doTesting = AppPreferences.getLocalPrefs().getBoolean("wizard.defaults", false);
        if (doTesting) {
            this.props.put("hostName", "localhost");
            this.props.put("dbName", "testfish");
            this.props.put("dbUserName", "root");
            this.props.put("dbPassword", "root");
            this.props.put("saUserName", "Master");
            this.props.put("saPassword", "Master");
            this.props.put("firstName", "Test");
            this.props.put("lastName", "User");
            this.props.put("middleInitial", "a");
            this.props.put("email", "tester@ku.edu");
            this.props.put("usrUsername", "testuser");
            this.props.put("usrPassword", "testuser");
            this.props.put("instName", "KU natural History Museum");
            this.props.put("instAbbrev", "KU-NHM");
            this.props.put("divName", "Fish");
            this.props.put("divAbbrev", "IT");
            this.props.put("collName", "Fish");
            this.props.put("collPrefix", "KUFSH");
            this.props.put("addr1", "1345 Jayhawk Blvd");
            this.props.put("addr2", "606 Dyche Hall");
            this.props.put("city", "Lawrence");
            this.props.put("state", "KS");
            this.props.put("country", "USA");
            this.props.put("zip", "66044");
            this.props.put("phone", "785-864-5555");
            this.props.put("addtaxon", (Object)true);
        } else {
            this.props.put("hostName", "localhost");
            this.props.put("dbName", "specify");
        }
        this.props.put("userType", SpecifyUserTypes.UserType.Manager.toString());
        UIFieldFormatterMgr.setDoingLocal(true);
        this.dbPanel = new DatabasePanel(this.nextBtn, this.backBtn, "security_wiz1", true);
        this.panels.add(this.dbPanel);
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.dbPanel.getHelpContext());
        MasterLoginPanel masterLoginPanel = new MasterLoginPanel("SA", "ENTER_SA_INFO", "security_wiz2", new String[]{"SA_USERNAME", "SA_PASSWORD"}, new String[]{"saUserName", "saPassword"}, new Integer[]{32, 32}, this.nextBtn, this.backBtn, true);
        this.panels.add(masterLoginPanel);
        this.panels.add(new UserPanel("SECURITY", "security_wiz3", this.nextBtn, this.backBtn, true, masterLoginPanel));
        this.lastStep = this.panels.size();
        if (this.backBtn != null) {
            this.backBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SpecifyDBSecurityWizard.this.step > 0) {
                        --SpecifyDBSecurityWizard.this.step;
                        SpecifyDBSecurityWizard.this.panels.get(SpecifyDBSecurityWizard.this.step).doingPrev();
                        HelpMgr.registerComponent((AbstractButton)SpecifyDBSecurityWizard.this.helpBtn, SpecifyDBSecurityWizard.this.panels.get(SpecifyDBSecurityWizard.this.step).getHelpContext());
                        SpecifyDBSecurityWizard.this.cardLayout.show(SpecifyDBSecurityWizard.this.cardPanel, Integer.toString(SpecifyDBSecurityWizard.this.step));
                    }
                    SpecifyDBSecurityWizard.this.updateBtnBar();
                    if (listener != null) {
                        listener.panelChanged(UIRegistry.getResourceString(String.valueOf(SpecifyDBSecurityWizard.this.panels.get(SpecifyDBSecurityWizard.this.step).getPanelName()) + ".TITLE"));
                    }
                }
            });
            this.backBtn.setEnabled(false);
        }
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SpecifyDBSecurityWizard.this.step < SpecifyDBSecurityWizard.this.lastStep - 1) {
                    SpecifyDBSecurityWizard.this.panels.get(SpecifyDBSecurityWizard.this.step).getValues(SpecifyDBSecurityWizard.this.props);
                    SpecifyDBSecurityWizard.this.panels.get(SpecifyDBSecurityWizard.this.step).aboutToLeave();
                    SpecifyDBSecurityWizard.this.advanceToNextPanel();
                } else {
                    SpecifyDBSecurityWizard.this.panels.get(SpecifyDBSecurityWizard.this.step).aboutToLeave();
                    SpecifyDBSecurityWizard.this.nextBtn.setEnabled(false);
                    SpecifyDBSecurityWizard.this.listener.finished();
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SpecifyDBSecurityWizard.this.listener != null) {
                    if (SpecifyDBSecurityWizard.this.step == SpecifyDBSecurityWizard.this.lastStep) {
                        SpecifyDBSecurityWizard.this.listener.finished();
                    } else if (UIHelper.promptForAction("QUIT", "NO", "CANCEL", UIRegistry.getResourceString("SURE_QUIT"))) {
                        SpecifyDBSecurityWizard.this.listener.cancelled();
                    }
                }
            }
        });
        int i = 0;
        while (i < this.panels.size()) {
            this.cardPanel.add(Integer.toString(i), this.panels.get(i));
            this.panels.get(i).setValues(this.props);
            ++i;
        }
        this.cardLayout.show(this.cardPanel, "0");
        if (this.dbPanel != null) {
            this.dbPanel.updateBtnUI();
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,10px,p"));
        builder.add((Component)this.cardPanel, cc.xy(1, 1));
        builder.add((Component)btnBar, cc.xy(1, 3));
        builder.setDefaultDialogBorder();
        this.setLayout(new BorderLayout());
        PanelBuilder iconBldr = new PanelBuilder(new FormLayout("20px, f:p:g,p,f:p:g,8px", "20px,t:p,f:p:g, 8px"));
        JLabel iconLbl = new JLabel(IconManager.getIcon(SpecifyDBSecurityWizard.getIconName()));
        iconLbl.setVerticalAlignment(1);
        iconBldr.add((Component)iconLbl, cc.xy(2, 3));
        this.add((Component)iconBldr.getPanel(), "West");
        this.add((Component)builder.getPanel(), "Center");
        this.progressBar = new JProgressBar(0, this.lastStep - 1);
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "South");
        this.panels.get(0).updateBtnUI();
    }

    public static String getIconName() {
        return IconManager.makeIconName("SpecifySecWiz");
    }

    protected void advanceToNextPanel() {
        ++this.step;
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.panels.get(this.step).getHelpContext());
        this.panels.get(this.step).doingNext();
        this.cardLayout.show(this.cardPanel, Integer.toString(this.step));
        this.updateBtnBar();
        if (this.listener != null) {
            this.listener.panelChanged(UIRegistry.getResourceString(String.valueOf(this.panels.get(this.step).getPanelName()) + ".TITLE"));
        }
    }

    public void setListener(WizardListener listener) {
        this.listener = listener;
    }

    protected void updateBtnBar() {
        this.progressBar.setValue(this.step);
        this.progressBar.setString(String.valueOf(String.format("%d", (int)((double)this.step * 100.0 / (double)(this.lastStep - 1)))) + UIRegistry.getResourceString("MSTR_PERCENT_COMPLETE"));
        if (this.step == this.lastStep - 1) {
            this.nextBtn.setEnabled(this.panels.get(this.step).isUIValid());
            this.nextBtn.setText(UIRegistry.getResourceString("DONE"));
            this.cancelBtn.setVisible(false);
        } else {
            this.cancelBtn.setVisible(true);
            this.nextBtn.setEnabled(this.panels.get(this.step).isUIValid());
            this.nextBtn.setText(UIRegistry.getResourceString("NEXT"));
        }
        this.backBtn.setEnabled(this.step > 0 && this.panels.get(this.step).enablePreviousBtn());
    }

    protected String stripSpecifyDir(String path) {
        String appPath = path;
        int endInx = appPath.indexOf("Specify.app");
        if (endInx > -1) {
            appPath = appPath.substring(0, endInx - 1);
        }
        return appPath;
    }

    protected void configSetup() {
        log.debug((Object)("********** WORK[" + UIRegistry.getDefaultWorkingPath() + "]"));
        log.debug((Object)("********** USER LOC[" + this.stripSpecifyDir(UIRegistry.getAppDataDir()) + "]"));
        String baseAppDir = UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX ? this.stripSpecifyDir(UIRegistry.getAppDataDir()) : UIRegistry.getDefaultWorkingPath();
        baseAppDir = UIHelper.stripSubDirs(baseAppDir, 1);
        UIRegistry.setDefaultWorkingPath(baseAppDir);
        log.debug((Object)("********** Working path for App [" + baseAppDir + "]"));
    }

    protected void setupLoginPrefs() {
        String userName = this.props.getProperty("usrUsername");
        String password = this.props.getProperty("usrPassword");
        String saUserName = this.props.getProperty("saUserName");
        String saPassword = this.props.getProperty("saPassword");
        String encryptedMasterUP = UserAndMasterPasswordMgr.encrypt(saUserName, saPassword, password);
        DatabaseDriverInfo driverInfo = this.dbPanel.getDriver();
        AppPreferences ap = AppPreferences.getLocalPrefs();
        ap.put(String.valueOf(userName) + "_master.islocal", "true");
        ap.put(String.valueOf(userName) + "_master.path", encryptedMasterUP);
        ap.put("login.dbdriver_selected", driverInfo.getName());
        ap.put("login.username", this.props.getProperty("usrUsername"));
        ap.put("login.databases_selected", this.dbPanel.getDbName());
        ap.put("login.databases", this.dbPanel.getDbName());
        ap.put("login.servers", this.props.getProperty("hostName"));
        ap.put("login.servers_selected", this.props.getProperty("hostName"));
        ap.put("login.rememberuser", "true");
        ap.put("extra.check", "true");
        ap.put("version_check.auto", "true");
        try {
            ap.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public void configureDatabase() {
        this.setupLoginPrefs();
        if (this.listener != null) {
            this.listener.hide();
        }
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            protected boolean isOK = false;

            @Override
            protected Integer doInBackground() throws Exception {
                try {
                    String dbName = SpecifyDBSecurityWizard.this.props.getProperty("dbName");
                    String hostName = SpecifyDBSecurityWizard.this.props.getProperty("hostName");
                    DatabaseDriverInfo driverInfo = (DatabaseDriverInfo)SpecifyDBSecurityWizard.this.props.get("driverObj");
                    String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, hostName, dbName);
                    if (connStr == null) {
                        connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, dbName);
                    }
                    String saUserName = SpecifyDBSecurityWizard.this.props.getProperty("saUserName");
                    String saPassword = SpecifyDBSecurityWizard.this.props.getProperty("saPassword");
                    BuildSampleDatabase bsd = new BuildSampleDatabase();
                    SpecifyDBSecurityWizard.this.progressFrame = bsd.createProgressFrame(UIRegistry.getResourceString("CREATE_DIV"));
                    SpecifyDBSecurityWizard.this.progressFrame.adjustProgressFrame();
                    SpecifyDBSecurityWizard.this.progressFrame.setProcessPercent(true);
                    SpecifyDBSecurityWizard.this.progressFrame.setOverall(0, 12);
                    UIRegistry.pushWindow(SpecifyDBSecurityWizard.this.progressFrame);
                    UIHelper.centerAndShow(SpecifyDBSecurityWizard.this.progressFrame);
                    if (!UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, saUserName, saPassword)) {
                        this.isOK = false;
                        return null;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.isOK) {
                    if (UIRegistry.isMobile()) {
                        DBConnection.setCopiedToMachineDisk(true);
                    }
                    HibernateUtil.shutdown();
                    DBConnection.shutdown();
                }
                if (SpecifyDBSecurityWizard.this.listener != null) {
                    SpecifyDBSecurityWizard.this.listener.hide();
                    SpecifyDBSecurityWizard.this.listener.finished();
                }
            }
        };
        worker.execute();
    }

    public static interface WizardListener {
        public void panelChanged(String var1);

        public void cancelled();

        public void hide();

        public void finished();
    }
}

