/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init.secwiz;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.specify.config.init.GenericFormPanel;
import edu.ku.brc.specify.config.init.secwiz.DatabasePanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;

public class MasterLoginPanel
extends GenericFormPanel {
    private static final String HELP_CONTEXT = "security_wiz1";
    protected String propName = "next";
    protected Boolean isOK = null;
    protected JLabel label;
    protected String errorKey = null;
    protected JButton skipStepBtn;
    protected boolean manualLoginOK = false;
    protected JLabel advLabel;
    protected JButton resetMasterBtn;
    protected JButton resetMasterPermsBtn;
    protected boolean isEmbedded = false;
    protected List<String> dbNamesForMaster = null;
    protected List<String> dbNameList = null;

    public MasterLoginPanel(String name, String title, String helpContext, String[] labels, String[] fields, Integer[] numColumns, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        super(name, title, helpContext, labels, fields, numColumns, nextBtn, prevBtn, makeStretchy);
        this.helpContext = HELP_CONTEXT;
    }

    @Override
    protected void init(String title, String[] fields, boolean[] required, String[] types, Integer[] numColumns) {
        super.init(title, fields, required, types, numColumns);
        this.helpContext = HELP_CONTEXT;
        PanelBuilder panelPB = new PanelBuilder(new FormLayout("f:p:g", "20px,p,2px,p"));
        panelPB.add((Component)this.getProgressBar(), this.cc.xy(1, 2));
        this.label = UIHelper.createLabel("  ");
        panelPB.add((Component)this.label, this.cc.xy(1, 4));
        this.builder.add((Component)panelPB.getPanel(), this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.advLabel = UIHelper.createI18NLabel("SEC_ADV_MSTR_DESC", 0);
        this.skipStepBtn = UIHelper.createI18NButton("ADV_MU_TEST");
        this.builder.add((Component)this.advLabel, this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.builder.add((Component)this.advLabel, this.cc.xyw(3, this.row, 2));
        this.row += 2;
        JComponent helpComponent = DatabasePanel.createHelpPanel(this.getBackground(), "master");
        this.resetMasterBtn = UIHelper.createI18NButton("SEC_RESET_BTN");
        this.resetMasterPermsBtn = UIHelper.createI18NButton("SEC_RESET_PERMS_BTN");
        PanelBuilder tstPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p,4px,p,0px,p,10px,f:p:g"));
        tstPB.add((Component)this.skipStepBtn, this.cc.xy(2, 1));
        tstPB.add((Component)this.resetMasterBtn, this.cc.xy(2, 3));
        tstPB.add((Component)this.resetMasterPermsBtn, this.cc.xy(2, 5));
        tstPB.add((Component)helpComponent, this.cc.xyw(1, 7, 3));
        this.resetMasterBtn.setVisible(false);
        this.resetMasterPermsBtn.setVisible(false);
        final JTextField pwdTF = (JTextField)this.comps.get("saPassword");
        pwdTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MasterLoginPanel.this.skipStepBtn.setEnabled(pwdTF.getText().length() > 0);
            }
        });
        this.builder.add((Component)tstPB.getPanel(), this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.skipStepBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterLoginPanel.this.skipStepBtn.setEnabled(false);
                boolean ok = MasterLoginPanel.this.skipDBCreate();
                if (ok) {
                    ok = MasterLoginPanel.this.checkForPermissions();
                }
                MasterLoginPanel.this.nextBtn.setEnabled(ok);
                MasterLoginPanel.this.advLabel.setText(UIRegistry.getResourceString(ok ? "ADV_DB_OK" : "ADV_DB_ERR"));
                MasterLoginPanel.this.advLabel.setForeground(ok ? Color.BLACK : Color.RED);
            }
        });
        this.resetMasterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterLoginPanel.this.skipStepBtn.setEnabled(false);
                boolean ok = MasterLoginPanel.this.doResetMaster(null);
                MasterLoginPanel.this.skipStepBtn.setEnabled(!ok);
                MasterLoginPanel.this.nextBtn.setEnabled(ok);
                MasterLoginPanel.this.advLabel.setText(UIRegistry.getResourceString(ok ? "SEC_RESET_DB_OK" : "SEC_RESET_DB_ERR"));
                MasterLoginPanel.this.advLabel.setForeground(ok ? Color.BLACK : Color.RED);
            }
        });
        this.resetMasterPermsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterLoginPanel.this.skipStepBtn.setEnabled(false);
                boolean ok = MasterLoginPanel.this.doResetMasterPerms();
                MasterLoginPanel.this.nextBtn.setEnabled(ok);
                MasterLoginPanel.this.skipStepBtn.setEnabled(!ok);
                MasterLoginPanel.this.advLabel.setText(UIRegistry.getResourceString(ok ? "SEC_RESET_PERMS_OK" : "SEC_RESET_PERMS_ERR"));
                MasterLoginPanel.this.advLabel.setForeground(ok ? Color.BLACK : Color.RED);
            }
        });
        this.progressBar.setVisible(false);
        if (UIRegistry.isMobile()) {
            this.skipStepBtn.setVisible(false);
            this.advLabel.setVisible(false);
        }
    }

    @Override
    public void doingNext() {
        this.advLabel.setText(UIRegistry.getResourceString("SEC_ADV_MSTR_DESC"));
        this.advLabel.setForeground(Color.BLACK);
        this.skipStepBtn.setEnabled(true);
        this.skipStepBtn.setVisible(true);
        this.resetMasterBtn.setVisible(false);
        this.resetMasterPermsBtn.setVisible(false);
        this.isEmbedded = DBConnection.getInstance().isEmbedded();
        if (this.isEmbedded) {
            ((JTextField)this.comps.get("saUserName")).setText(this.properties.getProperty("dbUserName"));
            ((JTextField)this.comps.get("saPassword")).setText(this.properties.getProperty("dbPassword"));
            ((JTextField)this.comps.get("saUserName")).setEnabled(false);
            ((JTextField)this.comps.get("saPassword")).setEnabled(false);
        }
    }

    @Override
    protected Pair<String, String> getRowColDefs() {
        String rowDef = "p,5px" + (this.fieldsNames.length > 0 ? "," + UIHelper.createDuplicateJGoodiesDef("p", "2px", this.fieldsNames.length) : "") + this.getAdditionalRowDefs() + ",2px,p,2px,p,8px,p";
        return new Pair<String, String>("p,2px,p,f:p:g", rowDef);
    }

    @Override
    public void doingPrev() {
        this.advLabel.setText("");
        this.skipStepBtn.setEnabled(true);
        this.skipStepBtn.setVisible(true);
        this.resetMasterBtn.setVisible(false);
        this.resetMasterPermsBtn.setVisible(false);
    }

    protected boolean skipDBCreate() {
        this.getValues(this.properties);
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String hostName = this.properties.getProperty("hostName");
        String saUserName = ((JTextField)this.comps.get("saUserName")).getText();
        String saPassword = ((JTextField)this.comps.get("saPassword")).getText();
        if (!this.isEmbedded) {
            if (mgr.connectToDBMS(saUserName, saPassword, hostName)) {
                this.nextBtn.setEnabled(true);
                mgr.close();
                return true;
            }
        } else {
            this.nextBtn.setEnabled(true);
            return true;
        }
        this.resetMasterBtn.setVisible(true);
        return false;
    }

    private List<String> getSpecifyDatabases(DBMSUserMgr mgr, List<String> dbNames) {
        if (dbNames != null && dbNames.size() > 0) {
            ArrayList<String> specifyDBs = new ArrayList<String>(dbNames.size());
            for (String dbName : dbNames) {
                if (!mgr.doesDBHaveTable(dbName, "specifyuser")) continue;
                specifyDBs.add(dbName);
            }
            return specifyDBs;
        }
        return new ArrayList<String>();
    }

    public List<String> getDatabaseList(DBMSUserMgr mgr) {
        List<String> dbList = this.getSpecifyDatabases(mgr, mgr.getDatabaseList());
        ToggleButtonChooserDlg<String> dlg = new ToggleButtonChooserDlg<String>((Frame)UIRegistry.getTopWindow(), "SEC_SELECT_DBS", "SEC_SELECT_DBS_DESC", dbList, 7, ToggleButtonChooserPanel.Type.Checkbox);
        dlg.setHelpContext("security_wizreset");
        dlg.setAddSelectAll(true);
        dlg.setUseScrollPane(true);
        dlg.createUI();
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            return dlg.getSelectedObjects();
        }
        return null;
    }

    private boolean checkForPermissions() {
        this.getValues(this.properties);
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String dbUserName = this.properties.getProperty("dbUserName");
        String dbPassword = this.properties.getProperty("dbPassword");
        String hostName = this.properties.getProperty("hostName");
        if (mgr.connectToDBMS(dbUserName, dbPassword, hostName)) {
            boolean isResetOK;
            Vector<String> badDBs = new Vector<String>();
            String saUserName = this.properties.getProperty("saUserName");
            boolean doFix = false;
            this.dbNameList = new ArrayList<String>();
            List<String> mastersDBNames = mgr.getDatabaseListForUser(saUserName);
            List<String> allSp6DBs = this.getSpecifyDatabases(mgr, mgr.getDatabaseList());
            HashSet<String> sp6DBNameHash = new HashSet<String>(allSp6DBs);
            HashSet<String> mstrDBNameHash = new HashSet<String>(mastersDBNames);
            if (this.dbNamesForMaster == null) {
                this.dbNamesForMaster = new ArrayList<String>();
            } else {
                this.dbNamesForMaster.clear();
            }
            for (String dbName : mastersDBNames) {
                if (!sp6DBNameHash.contains(dbName) || !mgr.doesDBExists(dbName)) continue;
                this.dbNamesForMaster.add(dbName);
            }
            for (String dbName : allSp6DBs) {
                if (mstrDBNameHash.contains(dbName) || !mgr.doesDBExists(dbName)) continue;
                this.dbNameList.add(dbName);
            }
            if (this.dbNamesForMaster.size() == 0) {
                int rv = UIRegistry.askYesNoLocalized("SEC_FIX_PERMS", "CANCEL", UIRegistry.getResourceString("SEC_NO_DBS_PERMS"), "WARNING");
                doFix = rv == 0;
            } else {
                for (String dbn : this.dbNamesForMaster) {
                    int perms = mgr.getPermissionsForAccess(saUserName, dbn);
                    if ((perms & 0x1F) == 31) continue;
                    badDBs.add(dbn);
                }
                if (badDBs.size() > 0) {
                    PanelBuilder pb = new PanelBuilder(new FormLayout("f:MAX(300px; p):g", "p,8px,f:MAX(300px; p):g"));
                    JList<String> list = new JList<String>(badDBs);
                    pb.add((Component)UIHelper.createI18NLabel("SEC_BAD_DBS_PERMS"), this.cc.xy(1, 1));
                    pb.add((Component)UIHelper.createScrollPane(list), this.cc.xy(1, 3));
                    pb.setDefaultDialogBorder();
                    CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WARNING"), true, pb.getPanel());
                    dlg.setOkLabel(UIRegistry.getResourceString("SEC_FIX_PERMS"));
                    UIHelper.centerAndShow(dlg);
                    doFix = !dlg.isCancelled();
                } else {
                    mgr.close();
                    return true;
                }
            }
            if (doFix && (isResetOK = this.doResetMaster(badDBs))) {
                this.dbNamesForMaster = mgr.getDatabaseListForUser(saUserName);
                this.advLabel.setText(UIRegistry.getResourceString("SEC_RESET_PERMS_OK"));
                mgr.close();
                return true;
            }
            mgr.close();
        } else {
            UIRegistry.showLocalizedError("SEC_UNEX_ERR_LGN");
        }
        return false;
    }

    protected boolean doResetMaster(Vector<String> databaseNames) {
        if (this.dbNameList != null) {
            this.dbNameList.clear();
        }
        this.getValues(this.properties);
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String dbUserName = this.properties.getProperty("dbUserName");
        String dbPassword = this.properties.getProperty("dbPassword");
        String hostName = this.properties.getProperty("hostName");
        String saUserName = ((JTextField)this.comps.get("saUserName")).getText();
        String saPassword = ((JTextField)this.comps.get("saPassword")).getText();
        if (!this.isEmbedded) {
            if (mgr.connectToDBMS(dbUserName, dbPassword, hostName)) {
                List<String> dbNames = databaseNames;
                if (!(dbNames != null && dbNames.size() != 0 || (dbNames = this.getDatabaseList(mgr)) != null && dbNames.size() != 0)) {
                    return false;
                }
                boolean dropUserOK = true;
                if (mgr.doesUserExists(saUserName)) {
                    dropUserOK = mgr.dropUser(saUserName);
                }
                if (dropUserOK) {
                    int okCnt = 0;
                    for (String dbnm : dbNames) {
                        if (!mgr.createUser(saUserName, saPassword, dbnm, 31)) {
                            UIRegistry.showLocalizedError("MSTR_ERR_SETDB", dbnm);
                            continue;
                        }
                        ++okCnt;
                    }
                    String key = okCnt > 0 ? "MSTR_PERMS_SET_OK" : "MSTR_PERMS_SET_ERR";
                    this.advLabel.setText(UIRegistry.getResourceString(key));
                    if (okCnt > 0) {
                        this.nextBtn.setEnabled(true);
                        this.skipStepBtn.setEnabled(true);
                        this.resetMasterBtn.setVisible(false);
                        mgr.close();
                        return true;
                    }
                    this.advLabel.setText("There was an error setting the Master User's username and password.");
                } else {
                    UIRegistry.showLocalizedError("SEC_ERR_DROP_USER");
                }
                mgr.close();
            } else {
                UIRegistry.showLocalizedError("SEC_UNEX_ERR_LGN");
            }
        } else {
            this.nextBtn.setEnabled(true);
            return true;
        }
        this.resetMasterBtn.setVisible(true);
        return false;
    }

    private boolean doResetMasterPerms() {
        this.getValues(this.properties);
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String dbUserName = this.properties.getProperty("dbUserName");
        String dbPassword = this.properties.getProperty("dbPassword");
        String hostName = this.properties.getProperty("hostName");
        String saUserName = ((JTextField)this.comps.get("saUserName")).getText();
        String saPassword = ((JTextField)this.comps.get("saPassword")).getText();
        if (!this.isEmbedded) {
            if (mgr.connectToDBMS(dbUserName, dbPassword, hostName)) {
                if (mgr.dropUser(saUserName)) {
                    List<String> dbNames = this.getDatabaseList(mgr);
                    if (dbNames != null) {
                        boolean rv = false;
                        if (mgr.createUser(saUserName, saPassword, dbNames.get(0), 31)) {
                            int i = 1;
                            while (i < dbNames.size()) {
                                rv = mgr.setPermissions(saUserName, dbNames.get(i), 31);
                                if (!rv) {
                                    this.advLabel.setText("Master User's username and password have been reset.");
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (rv) {
                            this.nextBtn.setEnabled(true);
                            mgr.close();
                            return true;
                        }
                        this.advLabel.setText("There was an error setting the Master User's username and password.");
                    }
                } else {
                    UIRegistry.showLocalizedError("SEC_ERR_DROP_USER");
                }
                mgr.close();
            } else {
                UIRegistry.showLocalizedError("SEC_UNEX_ERR_LGN");
            }
        } else {
            this.nextBtn.setEnabled(true);
            return true;
        }
        this.resetMasterBtn.setVisible(true);
        return false;
    }

    @Override
    public void getValues(Properties props) {
        super.getValues(props);
    }

    @Override
    protected String getAdditionalRowDefs() {
        return ",2px,p";
    }

    @Override
    public boolean isUIValid() {
        boolean isValid = super.isUIValid();
        if (this.properties != null) {
            String dbUsername = this.properties.getProperty("dbUserName");
            String saUserName = ((JTextField)this.comps.get("saUserName")).getText();
            String saPassword = ((JTextField)this.comps.get("saPassword")).getText();
            if (!DatabasePanel.checkForValidText(this.label, saUserName, "ERR_BAD_USRNAME", "NO_SPC_USRNAME", false) || !DatabasePanel.checkForValidText(this.label, saPassword, null, "NO_SPC_PWDNAME", false)) {
                this.isOK = false;
                return false;
            }
            if (dbUsername.equals(saUserName) && !this.isEmbedded) {
                this.label.setForeground(Color.RED);
                this.label.setText(UIRegistry.getResourceString("DB_SA_USRNAME_MATCH"));
                return false;
            }
            this.label.setText("");
        }
        return isValid && this.isOK != null && this.isOK != false;
    }

    protected void setUIEnabled(boolean enable) {
        for (JComponent c : this.compList) {
            c.setEnabled(enable);
        }
    }

    @Override
    protected void textChanged(JTextField txt) {
        super.textChanged(txt);
        if (this.isOK != null && !this.isOK.booleanValue()) {
            this.isOK = null;
            this.label.setText(" ");
            this.properties.put("masterChanged", (Object)true);
        }
    }

    public List<String> getDbNamesForMaster() {
        String hostName;
        String dbPassword;
        String dbUserName;
        DBMSUserMgr mgr;
        if ((this.dbNamesForMaster == null || this.dbNamesForMaster.size() == 0) && (mgr = DBMSUserMgr.getInstance()).connectToDBMS(dbUserName = this.properties.getProperty("dbUserName"), dbPassword = this.properties.getProperty("dbPassword"), hostName = this.properties.getProperty("hostName"))) {
            String saUserName = this.properties.getProperty("saUserName");
            if (saUserName != null) {
                this.dbNamesForMaster = mgr.getDatabaseListForUser(saUserName);
            }
            mgr.close();
        }
        return this.dbNamesForMaster;
    }

    public List<String> getDbNameList() {
        String hostName;
        String dbPassword;
        String dbUserName;
        DBMSUserMgr mgr;
        if ((this.dbNameList == null || this.dbNameList.size() == 0) && (mgr = DBMSUserMgr.getInstance()).connectToDBMS(dbUserName = this.properties.getProperty("dbUserName"), dbPassword = this.properties.getProperty("dbPassword"), hostName = this.properties.getProperty("hostName"))) {
            this.dbNameList = this.getSpecifyDatabases(mgr, mgr.getDatabaseList());
            mgr.close();
        }
        return this.dbNameList;
    }
}

