/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import edu.ku.brc.af.ui.PasswordStrengthUI;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.config.init.DatabasePanel;
import edu.ku.brc.specify.config.init.GenericFormPanel;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class UserInfoPanel
extends GenericFormPanel {
    private JTextField encryptedTF;
    private JLabel statusLbl;

    public UserInfoPanel(String name, String title, String helpContext, String[] labels, String[] fields, boolean[] isReq, Integer[] numColumns, JButton nextBtn, JButton prevBtn) {
        super(name, title, helpContext, labels, fields, isReq, numColumns, nextBtn, prevBtn, true);
    }

    @Override
    protected String getAdditionalRowDefs() {
        return ",2px,p,20px,p";
    }

    @Override
    protected void init(String title, String[] fields, boolean[] required, String[] types, Integer[] numColumns) {
        super.init(title, fields, required, types, numColumns);
        this.statusLbl = UIHelper.createLabel("");
        PasswordStrengthUI pwdStrength = new PasswordStrengthUI();
        this.builder.add((Component)UIHelper.createI18NFormLabel("PWDSTRENGTH"), this.cc.xy(1, this.row));
        this.builder.add((Component)pwdStrength, this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.builder.add((Component)this.statusLbl, this.cc.xyw(3, this.row, 2));
        this.row += 2;
        final JTextField pwdTF = (JTextField)this.comps.get("usrPassword");
        ValPlainTextDocument valDoc = new ValPlainTextDocument(64);
        pwdTF.setDocument(valDoc);
        valDoc.addDocumentListener(this.createDocChangeAdaptor(pwdTF));
        pwdStrength.setPasswordField(pwdTF, null);
        this.encryptedTF = UIHelper.createTextField(20);
        ViewFactory.changeTextFieldUIForDisplay(this.encryptedTF, false);
        this.encryptedTF.setDocument(new ValPlainTextDocument(64));
        pwdTF.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                UserInfoPanel.this.encryptedTF.setText(Encryption.encrypt(pwdTF.getText()));
            }
        });
    }

    @Override
    public boolean isUIValid() {
        boolean isValid = super.isUIValid();
        if (this.properties != null) {
            String dbUsername = this.properties.getProperty("dbUserName");
            String saUserName = this.properties.getProperty("saUserName");
            String usrUserName = ((JTextField)this.comps.get("usrUsername")).getText();
            String usrPassword = ((JTextField)this.comps.get("usrPassword")).getText();
            if (!DatabasePanel.checkForValidText(this.statusLbl, usrUserName, "ERR_BAD_USRNAME", "NO_SPC_USRNAME", false) || !DatabasePanel.checkForValidText(this.statusLbl, usrPassword, null, "NO_SPC_PWDNAME", false)) {
                this.nextBtn.setEnabled(false);
                return false;
            }
            if (usrUserName.equals(saUserName)) {
                this.statusLbl.setText(UIRegistry.getResourceString("UR_SA_USRNAME_MATCH"));
                this.nextBtn.setEnabled(false);
                return false;
            }
            if (usrUserName.equals(dbUsername)) {
                this.statusLbl.setText(UIRegistry.getResourceString("UR_DB_USRNAME_MATCH"));
                this.nextBtn.setEnabled(false);
                return false;
            }
            this.nextBtn.setEnabled(true);
            this.statusLbl.setText("");
        }
        return isValid;
    }
}

