/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.DisciplinePanel;
import edu.ku.brc.specify.config.init.SetupPanelIFace;
import edu.ku.brc.specify.config.init.TreeDefRow;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class TreeDefSetupPanel
extends BaseSetupPanel
implements SetupPanelIFace {
    protected Class<?> classType;
    protected String classTitle;
    protected JTable table;
    protected DefaultTableModel model;
    protected JComboBox directionCBX;
    protected JEditorPane fullnameDisplayTxt;
    protected DisciplinePanel disciplinePanel;
    protected Vector<TreeDefRow> treeDefList = new Vector();

    public TreeDefSetupPanel(Class<?> classType, String classTitle, String panelName, String helpContext, String descKey, JButton nextBtn, JButton prevBtn, DisciplinePanel disciplinePanel) {
        super(panelName, helpContext, nextBtn, prevBtn);
        this.classType = classType;
        this.classTitle = classTitle;
        this.disciplinePanel = disciplinePanel;
        if (classType == TaxonTreeDef.class || classType == GeographyTreeDef.class || classType == StorageTreeDef.class) {
            this.model = new TreeDefTableModel();
            if (classType != TaxonTreeDef.class) {
                this.loadTree(disciplinePanel != null && disciplinePanel.getDisciplineType() != null ? disciplinePanel.getDisciplineType().getDisciplineType() : null);
            }
            this.table = new JTable(this.model);
            this.directionCBX = UIHelper.createComboBox(new String[]{UIRegistry.getResourceString("FORWARD"), UIRegistry.getResourceString("REVERSE")});
            this.fullnameDisplayTxt = new JEditorPane();
            this.fullnameDisplayTxt.setBackground(Color.WHITE);
            this.fullnameDisplayTxt.setOpaque(true);
            this.fullnameDisplayTxt.setContentType("text/html");
            this.fullnameDisplayTxt.setEditable(false);
            this.table.setRowSelectionAllowed(false);
            this.table.setColumnSelectionAllowed(false);
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    TreeDefSetupPanel.this.updateBtnUI();
                }
            });
            JScrollPane spex = new JScrollPane(this.fullnameDisplayTxt, 20, 30);
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,250px,f:p:g", "p,4px,min(p;250px),4px,p,4px,65px,2px,p"), (JPanel)this);
            JScrollPane sp = UIHelper.createScrollPane(this.table);
            sp.getViewport().setBackground(Color.WHITE);
            String lbl = UIRegistry.getLocalizedMessage(descKey, classTitle);
            pb.add((Component)UIHelper.createLabel(lbl, 0), cc.xyw(1, 1, 4));
            pb.add((Component)sp, cc.xyw(1, 3, 5));
            pb.add((Component)UIHelper.createI18NFormLabel("DIRECTION"), cc.xy(1, 5));
            pb.add((Component)this.directionCBX, cc.xy(3, 5));
            pb.add((Component)UIHelper.createI18NFormLabel("EXAMPLE"), cc.xy(1, 7));
            pb.add((Component)spex, cc.xywh(3, 7, 2, 3));
            UIHelper.makeTableHeadersCentered(this.table, true);
            this.directionCBX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeDefSetupPanel.this.updateBtnUI();
                }
            });
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        TreeDefSetupPanel.this.updateBtnUI();
                        int inx = TreeDefSetupPanel.this.table.getSelectedColumn();
                        if (inx > -1) {
                            TreeDefRow row = TreeDefSetupPanel.this.treeDefList.get(TreeDefSetupPanel.this.table.getSelectedRow());
                            String msgKey = null;
                            if (row.isRequired() && (inx == 1 || inx == 3)) {
                                msgKey = inx == 1 ? "NO_CHANGE_INCL" : "NO_CHANGE_REQ";
                            } else if (inx == 4 && !row.isIncluded()) {
                                msgKey = "NO_CHANGE_INFN";
                            }
                            if (msgKey != null) {
                                final String mk = msgKey;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        UIRegistry.showLocalizedMsg(mk);
                                    }
                                });
                            }
                        }
                    }
                }
            });
            this.updateBtnUI();
        }
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    private void loadTree(DisciplineType.STD_DISCIPLINES disciplineType) {
        this.treeDefList.clear();
        DisciplineType dType = disciplineType == null ? null : DisciplineType.getDiscipline(disciplineType);
        String fileName = null;
        if (this.classType == TaxonTreeDef.class) {
            fileName = String.valueOf(dType.getFolder()) + File.separator + "taxon_init.xml";
        } else if (this.classType == GeographyTreeDef.class) {
            fileName = "common" + File.separator + "geography_init.xml";
        } else if (this.classType == StorageTreeDef.class) {
            fileName = "common" + File.separator + "storage_init.xml";
        }
        Locale currLocale = SchemaI18NService.getCurrentLocale();
        File file = XMLHelper.getConfigDir(fileName);
        if (file.exists()) {
            try {
                Element root = XMLHelper.readFileToDOM4J(file);
                for (Object levelObj : root.selectNodes("/tree/treedef/level")) {
                    Element level = (Element)levelObj;
                    String name = XMLHelper.getAttr(level, "name", null);
                    int rank = XMLHelper.getAttr(level, "rank", -1);
                    boolean enforced = XMLHelper.getAttr(level, "enforced", false);
                    boolean isInFullName = XMLHelper.getAttr(level, "infullname", false);
                    String title = name;
                    Object text = null;
                    for (Object localeObj : level.selectNodes("locale")) {
                        Element locale = (Element)localeObj;
                        String lang = XMLHelper.getAttr(locale, "lang", null);
                        String country = XMLHelper.getAttr(locale, "country", null);
                        String var = XMLHelper.getAttr(locale, "var", null);
                        if (!StringUtils.isNotEmpty((String)lang) || !StringUtils.isNotEmpty((String)currLocale.getLanguage()) || !lang.equals(currLocale.getLanguage())) continue;
                        title = XMLHelper.getAttr(locale, "text", null);
                        if (!StringUtils.isNotEmpty((String)country) || !StringUtils.isNotEmpty((String)currLocale.getCountry()) || !country.equals(currLocale.getCountry())) continue;
                        title = XMLHelper.getAttr(locale, "text", null);
                        if (!StringUtils.isNotEmpty((String)var) || !StringUtils.isNotEmpty((String)currLocale.getVariant()) || !var.equals(currLocale.getVariant())) continue;
                        title = XMLHelper.getAttr(locale, "text", null);
                    }
                    if (rank <= -1) continue;
                    boolean required = false;
                    required = this.classType == TaxonTreeDef.class ? TaxonTreeDef.isStdRequiredLevel(rank) || rank == 0 : (this.classType == GeographyTreeDef.class ? GeographyTreeDef.isStdRequiredLevel(rank) || rank == 0 : rank == 0);
                    String sep = this.classType == TaxonTreeDef.class ? " " : ", ";
                    this.treeDefList.add(new TreeDefRow(name, title, rank, required, enforced, required && isInFullName, required || rank == 0, sep));
                }
                if (this.model != null) {
                    this.model.fireTableDataChanged();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void doingNext() {
        if (this.disciplinePanel != null) {
            this.loadTree(this.disciplinePanel.getDisciplineType().getDisciplineType());
        }
        this.updateBtnUI();
    }

    @Override
    public void doingPrev() {
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    @Override
    public void getValues(Properties props) {
        XStream xstream = new XStream();
        TreeDefRow.configXStream(xstream);
        props.put(String.valueOf(this.classType.getSimpleName()) + ".treedefs", xstream.toXML(this.treeDefList));
    }

    @Override
    public boolean isUIValid() {
        boolean isEnforced = false;
        boolean isInFullName = false;
        for (TreeDefRow row : this.treeDefList) {
            if (row.isEnforced()) {
                isEnforced = true;
            }
            if (!row.isInFullName()) continue;
            isInFullName = true;
        }
        return isEnforced && isInFullName;
    }

    @Override
    public void setValues(Properties values) {
    }

    @Override
    public void updateBtnUI() {
        this.nextBtn.setEnabled(this.isUIValid());
        String lastSep = "";
        StringBuilder sb = new StringBuilder("<html>");
        StringBuilder subbdlr = new StringBuilder();
        for (TreeDefRow row : this.treeDefList) {
            if (!row.isInFullName()) continue;
            subbdlr.setLength(0);
            subbdlr.append("<i>");
            subbdlr.append(row.getTitle());
            subbdlr.append("</i>");
            subbdlr.append(row.getSeparator());
            lastSep = row.getSeparator();
            if (this.directionCBX.getSelectedIndex() == 0) {
                sb.append(subbdlr.toString());
                continue;
            }
            sb.insert(6, subbdlr.toString());
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - lastSep.length());
        }
        if (this.fullnameDisplayTxt != null) {
            this.fullnameDisplayTxt.setText(sb.toString());
        }
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        int i = 0;
        while (i < this.model.getRowCount()) {
            if (((Boolean)this.model.getValueAt(i, 1)).booleanValue()) {
                list.add(new Pair<String, String>(this.classTitle, this.model.getValueAt(i, 0).toString()));
            }
            ++i;
        }
        return list;
    }

    class TreeDefTableModel
    extends DefaultTableModel {
        protected String[] header = new String[]{"LEVEL", "INCLUDED", "ISREQ", "ISENFORCED", "ISFULLNAME", "SEPARATOR"};

        public TreeDefTableModel() {
            int i = 0;
            while (i < this.header.length) {
                this.header[i] = UIRegistry.getResourceString(this.header[i]);
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.header != null ? this.header.length : 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.header[column];
        }

        @Override
        public int getRowCount() {
            return TreeDefSetupPanel.this.treeDefList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            TreeDefRow trd = TreeDefSetupPanel.this.treeDefList.get(row);
            switch (column) {
                case 0: {
                    return trd.getTitle();
                }
                case 1: {
                    return trd.isIncluded();
                }
                case 2: {
                    return trd.isRequired() ? UIRegistry.getResourceString("YES") : "  ";
                }
                case 3: {
                    return trd.isRequired() ? true : trd.isEnforced();
                }
                case 4: {
                    return trd.isInFullName();
                }
                case 5: {
                    return trd.getSeparator();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            TreeDefRow trd = TreeDefSetupPanel.this.treeDefList.get(row);
            switch (column) {
                case 0: 
                case 2: {
                    return false;
                }
                case 1: {
                    return !trd.isRequired();
                }
                case 3: {
                    return !trd.isRequired() && trd.isIncluded();
                }
                case 4: {
                    return trd.isIncluded();
                }
                case 5: {
                    return trd.isIncluded();
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            TreeDefRow trd = TreeDefSetupPanel.this.treeDefList.get(row);
            switch (column) {
                case 1: {
                    Boolean isOn = (Boolean)value;
                    trd.setIncluded(isOn);
                    if (isOn.booleanValue()) break;
                    trd.setEnforced(false);
                    this.fireTableCellUpdated(row, 3);
                    trd.setInFullName(false);
                    this.fireTableCellUpdated(row, 4);
                    break;
                }
                case 0: 
                case 2: {
                    break;
                }
                case 3: {
                    trd.setEnforced((Boolean)value);
                    break;
                }
                case 4: {
                    trd.setInFullName((Boolean)value);
                    break;
                }
                case 5: {
                    trd.setSeparator((String)value);
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 2: 
                case 5: {
                    return String.class;
                }
                case 1: 
                case 3: 
                case 4: {
                    return Boolean.class;
                }
            }
            return String.class;
        }
    }
}

