/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.TaxonDownloadDlg;
import edu.ku.brc.specify.utilapps.TaxonFileDesc;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class TaxonLoadSetupPanel
extends BaseSetupPanel {
    private static final String XLS = "xls";
    private static final String DWNLD_TAX_URL = "DWNLD_TAX_URL";
    private static final String BAD_TAXON_DEF_NC = "BAD_TAXON_DEF_NC";
    private static final String BAD_TAXON_URL = "BAD_TAXON_URL";
    private static final String BAD_TAXON_DEF_DL = "BAD_TAXON_DEF_DL";
    protected JCheckBox preloadChk;
    protected JLabel fileLbl;
    protected JComboBox fileCBX;
    protected JLabel srcLbl;
    protected JTextField srcTF;
    protected JLabel coverageLbl;
    protected JTextField coverageTF;
    protected JLabel descLbl;
    protected JTextArea descTA;
    protected JLabel otherLbl;
    protected ValBrowseBtnPanel otherBrw;
    protected ValTextField otherTF;
    protected Component stdSep;
    protected Component othSep;
    protected boolean firstTime = true;
    protected String downloadedFileName = null;

    public TaxonLoadSetupPanel(String helpContext, JButton nextBtn, JButton prevBtn) {
        super("PRELOADTXN", helpContext, nextBtn, prevBtn);
        String header = UIRegistry.getResourceString("PRELOADTXN_INFO");
        CellConstraints cc = new CellConstraints();
        String rowDef = "p,10px," + UIHelper.createDuplicateJGoodiesDef("p", "2px", 8) + ",p:g";
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p:g", rowDef), (JPanel)this);
        int row = 1;
        this.stdSep = builder.add((Component)UIHelper.createLabel(header, 0), cc.xywh(1, row, 3, 1));
        row += 2;
        this.fileCBX = UIHelper.createComboBox();
        this.srcTF = UIHelper.createTextField("");
        this.coverageTF = UIHelper.createTextField("");
        this.descTA = UIHelper.createTextArea();
        this.otherTF = new ValTextField();
        this.otherBrw = new ValBrowseBtnPanel(this.otherTF, false, true);
        this.otherBrw.setUseNativeFileDlg(true);
        this.descTA.setEditable(false);
        this.descTA.setColumns(30);
        this.descTA.setRows(5);
        this.descTA.setWrapStyleWord(true);
        this.descTA.setLineWrap(true);
        ViewFactory.changeTextFieldUIForDisplay(this.srcTF, false);
        ViewFactory.changeTextFieldUIForDisplay(this.coverageTF, false);
        this.preloadChk = UIHelper.createI18NCheckBox("TFD_LOAD_TAXON");
        builder.add((Component)this.preloadChk, cc.xy(1, row));
        builder.addSeparator(UIRegistry.getResourceString("TFD_SEP_STD"), cc.xyw(1, row += 2, 3));
        this.fileLbl = UIHelper.createI18NFormLabel("TFD_FILE_LBL");
        builder.add((Component)this.fileLbl, cc.xy(1, row += 2));
        builder.add((Component)this.fileCBX, cc.xy(3, row));
        this.srcLbl = UIHelper.createI18NFormLabel("TFD_SRC_LBL");
        builder.add((Component)this.srcLbl, cc.xy(1, row += 2));
        builder.add((Component)this.srcTF, cc.xy(3, row));
        this.coverageLbl = UIHelper.createI18NFormLabel("TFD_CVRG_LBL");
        builder.add((Component)this.coverageLbl, cc.xy(1, row += 2));
        builder.add((Component)this.coverageTF, cc.xy(3, row));
        this.descLbl = UIHelper.createI18NFormLabel("TFD_DESC_LBL");
        builder.add((Component)this.descLbl, cc.xy(1, row += 2));
        builder.add((Component)UIHelper.createScrollPane(this.descTA), cc.xy(3, row));
        this.othSep = builder.addSeparator(UIRegistry.getResourceString("TFD_SEP_OTH"), cc.xyw(1, row += 2, 3));
        this.otherLbl = UIHelper.createI18NFormLabel("TFD_OTHER_LBL");
        builder.add((Component)this.otherLbl, cc.xy(1, row += 2));
        builder.add((Component)this.otherBrw, cc.xy(3, row));
        row += 2;
        this.updateBtnUI();
        this.otherTF.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                TaxonLoadSetupPanel.this.updateBtnUI();
            }
        });
        this.preloadChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean checked = TaxonLoadSetupPanel.this.preloadChk.isSelected();
                if (checked) {
                    if (TaxonLoadSetupPanel.this.fileCBX.getModel().getSize() > 0 && TaxonLoadSetupPanel.this.fileCBX.getSelectedIndex() == -1) {
                        TaxonLoadSetupPanel.this.fileCBX.setSelectedIndex(0);
                    }
                    TaxonLoadSetupPanel.this.enableUI(TaxonLoadSetupPanel.this.otherTF.getText().isEmpty(), true, true);
                } else {
                    TaxonLoadSetupPanel.this.enableUI(false, true, false);
                }
            }
        });
        this.otherTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TaxonLoadSetupPanel.this.updateBtnUI();
            }
        });
        this.otherBrw.setNativeDlgFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(TaxonLoadSetupPanel.XLS);
            }
        });
    }

    @Override
    public void getValues(Properties props) {
        TaxonFileDesc tfd;
        String fileName = this.otherTF.getText();
        if (fileName.isEmpty() && (tfd = (TaxonFileDesc)this.fileCBX.getSelectedItem()) != null && FilenameUtils.isExtension((String)tfd.getFileName().toLowerCase(), (String)XLS)) {
            fileName = tfd.getFileName();
        }
        if (!this.otherTF.getText().isEmpty() || StringUtils.isNotEmpty((String)fileName)) {
            props.put("othertaxonfile", (Object)(!this.otherTF.getText().isEmpty() ? 1 : 0));
            props.put("taxonfilename", fileName != null ? fileName : "");
            props.put("preloadtaxon", (Object)this.preloadChk.isSelected());
        }
    }

    @Override
    public void setValues(Properties values) {
        super.setValues(values);
        this.updateBtnUI();
    }

    private String getTaxonDOMStr() {
        try {
            String downloadHTTP = UIRegistry.getResourceString(DWNLD_TAX_URL);
            if (StringUtils.isNotEmpty((String)downloadHTTP)) {
                String line;
                URL url = new URL(String.valueOf(downloadHTTP) + "/taxonfiles.xml");
                URLConnection conn = url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
                in.close();
                return sb.toString();
            }
            UIRegistry.showLocalizedError(BAD_TAXON_URL);
        }
        catch (SocketException e) {
            UIRegistry.showLocalizedError(BAD_TAXON_DEF_NC);
        }
        catch (UnknownHostException e) {
            UIRegistry.showLocalizedError(BAD_TAXON_DEF_NC);
        }
        catch (Exception e) {
            e.printStackTrace();
            UIRegistry.showLocalizedError(BAD_TAXON_DEF_DL);
        }
        return null;
    }

    private Vector<TaxonFileDesc> readTaxonLoadFiles() {
        String taxonXML = this.getTaxonDOMStr();
        while (taxonXML == null || taxonXML.length() < 1024) {
            int rv = UIRegistry.askYesNoLocalized("DWNLD_TRY_AGAIN", "SKIP", UIRegistry.getResourceString(BAD_TAXON_DEF_DL), "WARNING");
            if (rv == 1) {
                return null;
            }
            taxonXML = this.getTaxonDOMStr();
        }
        XStream xstream = new XStream();
        TaxonFileDesc.configXStream(xstream);
        return (Vector)xstream.fromXML(taxonXML);
    }

    @Override
    public void doingNext() {
        super.doingNext();
        DisciplineType disciplineType = (DisciplineType)this.properties.get("disciplineType");
        if (disciplineType != null) {
            DefaultComboBoxModel<TaxonFileDesc> model = new DefaultComboBoxModel<TaxonFileDesc>();
            Vector<TaxonFileDesc> taxonFileDescs = this.readTaxonLoadFiles();
            if (taxonFileDescs != null) {
                for (TaxonFileDesc tfd : taxonFileDescs) {
                    if (!tfd.getDiscipline().equals(disciplineType.getName())) continue;
                    model.addElement(tfd);
                }
                this.fileCBX.setModel(model);
                if (model.getSize() > 0) {
                    this.fileCBX.setSelectedIndex(0);
                }
                if (this.firstTime) {
                    this.firstTime = false;
                    this.fileCBX.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TaxonLoadSetupPanel.this.fileSelected();
                        }
                    });
                }
                this.fileSelected();
            } else {
                this.fileCBX.setEnabled(false);
                this.preloadChk.setEnabled(false);
            }
        }
    }

    @Override
    public void doingPrev() {
        super.doingPrev();
        this.otherBrw.setValue(null, null);
        this.fileCBX.setSelectedIndex(this.fileCBX.getModel().getSize() > 0 ? 0 : -1);
        this.coverageTF.setText("");
        this.srcTF.setText("");
        this.descTA.setText("");
        this.properties.remove("othertaxonfile");
        this.properties.remove("taxonfilename");
        this.properties.remove("preloadtaxon");
        if (this.preloadChk.isSelected()) {
            this.preloadChk.doClick();
        }
    }

    private void fileSelected() {
        TaxonFileDesc tfd = (TaxonFileDesc)this.fileCBX.getSelectedItem();
        if (tfd != null) {
            this.srcTF.setText(tfd.getSrc());
            this.coverageTF.setText(tfd.getCoverage());
            this.descTA.setText(tfd.getDescription());
        }
        this.updateBtnUI();
    }

    @Override
    public void aboutToLeave() {
        File userDataFile;
        File txFile;
        TaxonFileDesc tfd;
        if (this.preloadChk.isSelected() && (tfd = (TaxonFileDesc)this.fileCBX.getSelectedItem()) != null && FilenameUtils.isExtension((String)tfd.getFileName().toLowerCase(), (String)XLS) && ((txFile = TaxonLoadSetupPanel.getFileForTaxon(tfd.getFileName(), false)) == null || !txFile.exists()) && !(userDataFile = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + tfd.getFileName())).exists()) {
            this.doDownloadTaxonFile(tfd.getFileName(), userDataFile, tfd.getSize());
        }
    }

    private void doDownloadTaxonFile(String fileName, File outFile, int fileSize) {
        block7: {
            try {
                String downloadHTTP = UIRegistry.getResourceString(DWNLD_TAX_URL);
                if (StringUtils.isNotEmpty((String)downloadHTTP)) {
                    URL url = new URL(String.valueOf(downloadHTTP) + "/" + fileName);
                    TaxonDownloadDlg dlg = new TaxonDownloadDlg(url, outFile, fileSize);
                    dlg.setModal(true);
                    UIHelper.centerAndShow(dlg);
                    if (dlg.getStatus() == TaxonDownloadDlg.StatusType.eOK) {
                        this.downloadedFileName = fileName;
                        break block7;
                    }
                    this.downloadedFileName = null;
                    try {
                        File file = new File(fileName);
                        if (file.exists()) {
                            file.delete();
                        }
                        break block7;
                    }
                    catch (Exception exception) {}
                    break block7;
                }
                UIRegistry.showLocalizedError(BAD_TAXON_URL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File getFileForTaxon(String fileName, boolean doUserProvidedFile) {
        if (!doUserProvidedFile) {
            File taxonXLSFile = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + fileName);
            if (taxonXLSFile.exists()) {
                return taxonXLSFile;
            }
            return null;
        }
        File file = new File(fileName);
        return file.exists() ? file : null;
    }

    @Override
    public void updateBtnUI() {
        boolean isValid = this.isUIValid();
        if (this.nextBtn != null) {
            this.nextBtn.setEnabled(isValid);
        }
        boolean checked = this.preloadChk.isSelected();
        this.enableUI(this.otherTF.getText().isEmpty() && isValid && checked, true, checked);
    }

    private void enableUI(boolean enabled, boolean doAll, boolean otherEnabled) {
        this.fileLbl.setEnabled(enabled);
        this.fileCBX.setEnabled(enabled);
        this.srcLbl.setEnabled(enabled);
        this.srcTF.setEnabled(enabled);
        this.coverageLbl.setEnabled(enabled);
        this.coverageTF.setEnabled(enabled);
        this.descLbl.setEnabled(enabled);
        this.descTA.setEnabled(enabled);
        this.stdSep.setEnabled(enabled);
        if (doAll) {
            this.othSep.setEnabled(otherEnabled);
            this.otherLbl.setEnabled(otherEnabled);
            this.otherBrw.setEnabled(otherEnabled);
        }
    }

    @Override
    public boolean isUIValid() {
        if (this.preloadChk.isSelected() && this.otherBrw.isEnabled() && !this.otherTF.isFocusOwner()) {
            String filePath = this.otherTF.getText();
            if (!filePath.isEmpty() && FilenameUtils.isExtension((String)filePath.toLowerCase(), (String)XLS)) {
                File f = new File(filePath);
                return f.exists();
            }
            return StringUtils.isEmpty((String)this.otherTF.getText());
        }
        return true;
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        list.add(new Pair<String, String>(UIRegistry.getResourceString("DSP_TYPE"), UIRegistry.getResourceString(this.preloadChk.isSelected() ? "YES" : "NO")));
        return list;
    }
}

