/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import edu.ku.brc.ui.ProgressDialog;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.SwingWorker;

public class TaxonDownloadDlg
extends ProgressDialog {
    private static final String BAD_TAXON_XLS_DL = "BAD_TAXON_XLS_DL";
    private static final String WRSZ_TAXON_XLS_DL = "WRSZ_TAXON_XLS_DL";
    private static String PRG = "PRG";
    private URL url;
    private File outFile;
    private StatusType status = StatusType.eError;
    private int fileSizeInBytes = 0;
    private SwingWorker<StatusType, Object> worker = null;

    public TaxonDownloadDlg(URL url, File outFile, int fileSizeInBytes) {
        super(UIRegistry.getResourceString("DWN_TX_XLS"), false, true);
        this.url = url;
        this.outFile = outFile;
        this.fileSizeInBytes = fileSizeInBytes;
    }

    public StatusType getStatus() {
        return this.status;
    }

    private StatusType downloaddTaxonFile() {
        this.setProcess(0, 100);
        try {
            int numBytesRead;
            URLConnection urlConnection = this.url.openConnection();
            urlConnection.connect();
            InputStream input = this.url.openStream();
            DataInputStream dis = new DataInputStream(input);
            DataOutputStream fos = new DataOutputStream(new FileOutputStream(this.outFile));
            byte[] bytes = new byte[32768];
            int totalBytes = 0;
            while ((numBytesRead = dis.read(bytes)) != -1) {
                fos.write(bytes, 0, numBytesRead);
                this.worker.firePropertyChange(PRG, numBytesRead, totalBytes += numBytesRead);
            }
            fos.flush();
            fos.close();
            this.status = totalBytes != this.fileSizeInBytes ? StatusType.eBadFileSize : StatusType.eOK;
            return this.status;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = StatusType.eError;
            return this.status;
        }
    }

    private void startWork() {
        this.worker = new SwingWorker<StatusType, Object>(){

            @Override
            protected StatusType doInBackground() throws Exception {
                return TaxonDownloadDlg.this.downloaddTaxonFile();
            }

            @Override
            protected void done() {
                TaxonDownloadDlg.this.endWork();
            }
        };
        this.worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PRG.equals(evt.getPropertyName())) {
                    int byteRead = (Integer)evt.getNewValue();
                    int percent = (int)((double)byteRead / (double)TaxonDownloadDlg.this.fileSizeInBytes * 100.0);
                    TaxonDownloadDlg.this.setProcess(percent);
                }
            }
        });
        this.worker.execute();
    }

    protected void endWork() {
        if (this.status == StatusType.eOK) {
            this.setVisible(false);
            this.dispose();
        } else {
            String msg = UIRegistry.getResourceString(this.status == StatusType.eError ? BAD_TAXON_XLS_DL : WRSZ_TAXON_XLS_DL);
            int rv = UIRegistry.askYesNoLocalized("DWNLD_TRY_AGAIN", "SKIP", msg, "ERROR");
            if (rv == 1) {
                this.setVisible(false);
                this.dispose();
            } else {
                this.startWork();
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.isVisible() && b) {
            this.startWork();
        }
        super.setVisible(b);
    }

    public static enum StatusType {
        eError,
        eBadFileSize,
        eOK;

    }
}

