/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.PrintTableHelper;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class SummaryPanel
extends BaseSetupPanel {
    public static final String PRINT_GRID = "RPT.PrintTable";
    protected Vector<BaseSetupPanel> panels;
    protected JTable table;
    protected JTable printTable;

    public SummaryPanel(String panelName, String helpContext, JButton nextBtn, JButton prevBtn, Vector<BaseSetupPanel> panels) {
        super(panelName, helpContext, nextBtn, prevBtn, false);
        this.panels = panels;
        this.table = new JTable();
        this.printTable = new JTable();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,10px,p"), (JPanel)this);
        pb.add((Component)UIHelper.createScrollPane(this.table), cc.xy(1, 1));
        JButton printBtn = UIHelper.createI18NButton("PRINT");
        PanelBuilder lpb = new PanelBuilder(new FormLayout("f:p:g,p", "p"));
        lpb.add((Component)printBtn, cc.xy(2, 1));
        pb.add((Component)lpb.getPanel(), cc.xy(1, 3));
        printBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintTableHelper pth = new PrintTableHelper(SummaryPanel.this.printTable);
                pth.printGrid(UIRegistry.getResourceString("SUMMARY"));
            }
        });
    }

    @Override
    public void doingNext() {
        Vector<Pair<String, String>> values = new Vector<Pair<String, String>>();
        Vector<Pair<String, String>> printValues = new Vector<Pair<String, String>>();
        for (BaseSetupPanel p : this.panels) {
            List<Pair<String, String>> list = p.getSummary();
            if (list != null) {
                values.addAll(list);
                printValues.addAll(list);
            }
            values.add(new Pair<String, String>("", ""));
        }
        int i = 0;
        Object[][] valueObjs = new Object[values.size()][2];
        for (Pair pair : values) {
            valueObjs[i][0] = pair.first;
            valueObjs[i][1] = pair.second;
            ++i;
        }
        i = 0;
        Object[][] objectArray = new Object[printValues.size()][2];
        for (Pair pair : printValues) {
            objectArray[i][0] = pair.first;
            objectArray[i][1] = pair.second;
            ++i;
        }
        String string = UIRegistry.getResourceString("Name");
        String valueStr = UIRegistry.getResourceString("Value");
        DefaultTableModel model = new DefaultTableModel(valueObjs, new String[]{string, valueStr}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(model);
        this.printTable.setModel(new DefaultTableModel(objectArray, new String[]{string, valueStr}));
        UIHelper.makeTableHeadersCentered(this.table, false);
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        return null;
    }

    @Override
    public Component getUIComponent() {
        return null;
    }

    @Override
    public void getValues(Properties props) {
    }

    @Override
    public boolean isUIValid() {
        return true;
    }

    @Override
    public void setValues(Properties values) {
    }

    @Override
    public void updateBtnUI() {
    }
}

