/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.SchemaUpdateService;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.FixDBAfterLogin;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.CollectionPanel;
import edu.ku.brc.specify.config.init.DBLocationPanel;
import edu.ku.brc.specify.config.init.DatabasePanel;
import edu.ku.brc.specify.config.init.DisciplinePanel;
import edu.ku.brc.specify.config.init.DivisionPanel;
import edu.ku.brc.specify.config.init.FormatterPickerPanel;
import edu.ku.brc.specify.config.init.GenericFormPanel;
import edu.ku.brc.specify.config.init.InstSetupPanel;
import edu.ku.brc.specify.config.init.MasterUserPanel;
import edu.ku.brc.specify.config.init.SummaryPanel;
import edu.ku.brc.specify.config.init.TaxonLoadSetupPanel;
import edu.ku.brc.specify.config.init.TreeDefSetupPanel;
import edu.ku.brc.specify.config.init.UserInfoPanel;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpVersion;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Session;

public class SpecifyDBSetupWizard
extends JPanel {
    private static final Logger log = Logger.getLogger(SpecifyDBSetupWizard.class);
    protected WizardType wizardType = WizardType.Institution;
    protected WizardListener listener;
    protected final String HOSTNAME = "localhost";
    protected boolean doLoginOnly = false;
    protected Properties props = new Properties();
    protected JButton helpBtn;
    protected JButton backBtn;
    protected JButton nextBtn;
    protected JButton cancelBtn;
    protected DisciplinePanel disciplinePanel;
    protected DatabasePanel dbPanel;
    protected TreeDefSetupPanel storageTDPanel;
    protected TreeDefSetupPanel taxonTDPanel;
    protected TreeDefSetupPanel geoTDPanel;
    protected DBLocationPanel locationPanel;
    protected UserInfoPanel userInfoPanel;
    protected GenericFormPanel accessionPanel;
    protected FormatterPickerPanel accessionPickerGbl;
    protected FormatterPickerPanel accessionPickerCol;
    protected FormatterPickerPanel catNumPicker;
    protected int step = 0;
    protected int lastStep = 0;
    protected boolean isCancelled;
    protected JPanel cardPanel;
    protected CardLayout cardLayout = new CardLayout();
    protected Vector<BaseSetupPanel> panels = new Vector();
    protected String setupXMLPath;
    protected JProgressBar progressBar;
    protected ProgressFrame progressFrame;

    public SpecifyDBSetupWizard(final WizardType wizardType, final WizardListener listener) {
        String sql;
        Division division;
        this.wizardType = wizardType;
        this.listener = listener;
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        HelpMgr.setLoadingPage("Load");
        this.cardPanel = new JPanel(this.cardLayout);
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        this.backBtn = UIHelper.createButton(UIRegistry.getResourceString("BACK"));
        this.nextBtn = UIHelper.createButton(UIRegistry.getResourceString("NEXT"));
        CellConstraints cc = new CellConstraints();
        PanelBuilder bbpb = new PanelBuilder(new FormLayout("f:p:g,p,4px,p,4px,p,4px,p,4px", "p"));
        bbpb.add((Component)this.helpBtn, cc.xy(2, 1));
        bbpb.add((Component)this.backBtn, cc.xy(4, 1));
        bbpb.add((Component)this.nextBtn, cc.xy(6, 1));
        bbpb.add((Component)this.cancelBtn, cc.xy(8, 1));
        JPanel btnBar = bbpb.getPanel();
        boolean doTesting = AppPreferences.getLocalPrefs().getBoolean("wizard.defaults", false);
        if (doTesting && wizardType == WizardType.Institution) {
            this.props.put("hostName", "localhost");
            this.props.put("dbName", "testfish");
            this.props.put("dbUserName", "Specify");
            this.props.put("dbPassword", "Specify");
            this.props.put("saUserName", "Master");
            this.props.put("saPassword", "Master");
            this.props.put("firstName", "Test");
            this.props.put("lastName", "User");
            this.props.put("middleInitial", "a");
            this.props.put("email", "tester@ku.edu");
            this.props.put("usrUsername", "testuser");
            this.props.put("usrPassword", "testuser");
            this.props.put("instName", "KU natural History Museum");
            this.props.put("instAbbrev", "KU-NHM");
            this.props.put("divName", "Fish");
            this.props.put("divAbbrev", "IT");
            this.props.put("collName", "Fish");
            this.props.put("collPrefix", "KUFSH");
            this.props.put("addr1", "1345 Jayhawk Blvd");
            this.props.put("addr2", "606 Dyche Hall");
            this.props.put("city", "Lawrence");
            this.props.put("state", "KS");
            this.props.put("country", "USA");
            this.props.put("zip", "66044");
            this.props.put("phone", "785-864-5555");
            this.props.put("addtaxon", (Object)true);
        } else {
            this.props.put("hostName", "localhost");
            this.props.put("dbName", "specify");
        }
        this.props.put("userType", SpecifyUserTypes.UserType.Manager.toString());
        UIFieldFormatterMgr.setDoingLocal(true);
        String accessionFmt = null;
        if (wizardType == WizardType.Institution) {
            this.props.put("fromwizard", "true");
            this.dbPanel = new DatabasePanel(this.nextBtn, this.backBtn, this.getHelpCntxt("wizard_mysql_username"), true);
            this.panels.add(this.dbPanel);
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.dbPanel.getHelpContext());
            this.panels.add(new MasterUserPanel("SA", "ENTER_SA_INFO", this.getHelpCntxt("wizard_master_username"), new String[]{"SA_USERNAME", "SA_PASSWORD"}, new String[]{"saUserName", "saPassword"}, new Integer[]{32, 32}, this.nextBtn, this.backBtn, true));
            this.panels.add(new GenericFormPanel("SECURITY", "SECURITY_INFO", this.getHelpCntxt("wizard_security_on"), new String[]{"SECURITY_ON"}, new String[]{"security_on"}, new String[]{"checkbox"}, this.nextBtn, this.backBtn, true));
            String[] stringArray = new String[8];
            stringArray[0] = "FIRSTNAME";
            stringArray[1] = "LASTNAME";
            stringArray[2] = "MIDNAME";
            stringArray[3] = "EMAIL";
            stringArray[5] = "USERLOGININFO";
            stringArray[6] = "USERNAME";
            stringArray[7] = "PASSWORD";
            boolean[] blArray = new boolean[8];
            blArray[0] = true;
            blArray[1] = true;
            blArray[3] = true;
            blArray[4] = true;
            blArray[6] = true;
            blArray[7] = true;
            Integer[] integerArray = new Integer[8];
            integerArray[0] = 50;
            integerArray[1] = 120;
            integerArray[2] = 50;
            integerArray[3] = 50;
            integerArray[6] = 64;
            integerArray[7] = 32;
            this.userInfoPanel = new UserInfoPanel("AGENT", "ENTER_COLMGR_INFO", this.getHelpCntxt("wizard_create_it_user"), stringArray, new String[]{"firstName", "lastName", "middleInitial", "email", " ", "-", "usrUsername", "usrPassword"}, blArray, integerArray, this.nextBtn, this.backBtn);
            this.panels.add(this.userInfoPanel);
            String[] stringArray2 = new String[11];
            stringArray2[0] = "NAME";
            stringArray2[1] = "ABBREV";
            stringArray2[3] = "INST_ADDR";
            stringArray2[4] = "ADDR1";
            stringArray2[5] = "ADDR2";
            stringArray2[6] = "CITY";
            stringArray2[7] = "STATE";
            stringArray2[8] = "COUNTRY";
            stringArray2[9] = "ZIP";
            stringArray2[10] = "PHONE";
            boolean[] blArray2 = new boolean[11];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray2[4] = true;
            blArray2[6] = true;
            blArray2[7] = true;
            blArray2[8] = true;
            blArray2[9] = true;
            blArray2[10] = true;
            Integer[] integerArray2 = new Integer[11];
            integerArray2[0] = 255;
            integerArray2[1] = 32;
            integerArray2[2] = 50;
            integerArray2[4] = 255;
            integerArray2[5] = 255;
            integerArray2[6] = 64;
            integerArray2[7] = 64;
            integerArray2[8] = 64;
            integerArray2[9] = 32;
            integerArray2[10] = 50;
            this.panels.add(new GenericFormPanel("INST", "ENTER_INST_INFO", this.getHelpCntxt("wizard_create_institution"), stringArray2, new String[]{"instName", "instAbbrev", " ", "-", "addr1", "addr2", "city", "state", "country", "zip", "phone"}, blArray2, integerArray2, this.nextBtn, this.backBtn, true));
            this.accessionPanel = new GenericFormPanel("ACCESSIONGLOBALLY", "ENTER_ACC_INFO", this.getHelpCntxt("wizard_choose_accession_level"), new String[]{"ACCGLOBALLY"}, new String[]{"accglobal"}, new String[]{"checkbox"}, this.nextBtn, this.backBtn, true);
            this.panels.add(this.accessionPanel);
            if (wizardType == WizardType.Institution) {
                this.accessionPickerGbl = new FormatterPickerPanel("ACCNOFMT", this.getHelpCntxt("wizard_create_accession_number"), this.nextBtn, this.backBtn, false, null);
                this.panels.add(this.accessionPickerGbl);
            }
            this.storageTDPanel = new TreeDefSetupPanel(StorageTreeDef.class, UIRegistry.getResourceString("Storage"), "Storage", this.getHelpCntxt("wizard_configure_storage_tree"), "CONFIG_TREEDEF", this.nextBtn, this.backBtn, null);
            this.panels.add(this.storageTDPanel);
            this.panels.add(new InstSetupPanel("CREATEINST", "CREATEINST", this.getHelpCntxt("wizard_create_institution"), new String[0], new String[0], new Integer[0], this.nextBtn, this.backBtn, true));
        }
        if (wizardType == WizardType.Institution || wizardType == WizardType.Division) {
            DivisionPanel divPanel = new DivisionPanel("DIV", "ENTER_DIV_INFO", this.getHelpCntxt("wizard_enter_division"), new String[]{"NAME", "ABBREV"}, new String[]{"divName", "divAbbrev"}, new Integer[]{255, 64}, this.nextBtn, this.backBtn, true);
            this.panels.add(divPanel);
            if (wizardType == WizardType.Division) {
                HelpMgr.registerComponent((AbstractButton)this.helpBtn, divPanel.getHelpContext());
            }
        }
        if (wizardType != WizardType.Institution) {
            Institution institution = AppContextMgr.getInstance().getClassObject(Institution.class);
            division = AppContextMgr.getInstance().getClassObject(Division.class);
            if (!institution.getIsAccessionsGlobal().booleanValue()) {
                sql = "SELECT ans.FormatName FROM autonumberingscheme ans  Inner Join autonumsch_div ad ON ans.AutoNumberingSchemeID = ad.AutoNumberingSchemeID INNER JOIN division d ON ad.DivisionID = d.UserGroupScopeId WHERE d.DivisionID = " + division.getId();
                log.debug((Object)sql);
                Vector<Object> rows = BasicSQLUtils.querySingleCol(sql);
                if (rows.size() == 1) {
                    accessionFmt = rows.get(0).toString();
                } else {
                    log.error((Object)("The return " + rows.size()));
                }
            }
        }
        if (wizardType == WizardType.Institution || wizardType == WizardType.Division || wizardType == WizardType.Discipline) {
            this.nextBtn.setEnabled(false);
            this.disciplinePanel = new DisciplinePanel(this.getHelpCntxt("wizard_choose_discipline_type"), this.nextBtn, this.backBtn);
            this.panels.add(this.disciplinePanel);
            if (wizardType == WizardType.Discipline) {
                HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.disciplinePanel.getHelpContext());
            }
            this.taxonTDPanel = new TreeDefSetupPanel(TaxonTreeDef.class, UIRegistry.getResourceString("Taxon"), "Taxon", this.getHelpCntxt("wizard_configure_taxon_tree"), "CONFIG_TREEDEF", this.nextBtn, this.backBtn, this.disciplinePanel);
            this.panels.add(this.taxonTDPanel);
            this.panels.add(new TaxonLoadSetupPanel(this.getHelpCntxt("wizard_preload_taxon"), this.nextBtn, this.backBtn));
            this.geoTDPanel = new TreeDefSetupPanel(GeographyTreeDef.class, UIRegistry.getResourceString("Geography"), "Geography", this.getHelpCntxt("wizard_configure_geography_tree"), "CONFIG_TREEDEF", this.nextBtn, this.backBtn, this.disciplinePanel);
            this.panels.add(this.geoTDPanel);
        }
        CollectionPanel colPanel = new CollectionPanel("COLLECTION", "ENTER_COL_INFO", this.getHelpCntxt("wizard_create_collection"), new String[]{"NAME", "PREFIX"}, new String[]{"collName", "collPrefix"}, new Integer[]{50, 50}, this.nextBtn, this.backBtn, true);
        this.panels.add(colPanel);
        if (wizardType == WizardType.Collection) {
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, colPanel.getHelpContext());
        }
        this.catNumPicker = new FormatterPickerPanel("CATNOFMT", this.getHelpCntxt("wizard_create_catalog_number"), this.nextBtn, this.backBtn, true, null);
        this.panels.add(this.catNumPicker);
        if (wizardType != WizardType.Institution) {
            Institution inst;
            division = AppContextMgr.getInstance().getClassObject(Division.class);
            sql = "SELECT COUNT(*) FROM division d INNER JOIN collection c ON d.UserGroupScopeId = c.DisciplineID WHERE d.UserGroupScopeId = " + division.getId();
            log.debug((Object)sql);
            int numCollectionsByDiv = BasicSQLUtils.getCountAsInt(sql);
            if (numCollectionsByDiv == 0 && (inst = AppContextMgr.getInstance().getClassObject(Institution.class)) != null && !inst.getIsAccessionsGlobal().booleanValue()) {
                this.accessionPickerCol = new FormatterPickerPanel("ACCNOFMT", this.getHelpCntxt("wizard_create_accession_number"), this.nextBtn, this.backBtn, false, accessionFmt);
                this.accessionPickerCol.setDoingDisciplineCollection(wizardType != WizardType.Division);
                this.panels.add(this.accessionPickerCol);
            }
        } else {
            this.accessionPickerCol = new FormatterPickerPanel("ACCNOFMT", this.getHelpCntxt("wizard_create_accession_number"), this.nextBtn, this.backBtn, false, null);
            this.panels.add(this.accessionPickerCol);
        }
        this.panels.add(new SummaryPanel("SUMMARY", this.getHelpCntxt("wizard_summary"), this.nextBtn, this.backBtn, this.panels));
        this.lastStep = this.panels.size();
        if (this.backBtn != null) {
            this.backBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SpecifyDBSetupWizard.this.step > 0) {
                        DisciplineType disciplineType;
                        if (SpecifyDBSetupWizard.this.disciplinePanel != null && (disciplineType = SpecifyDBSetupWizard.this.disciplinePanel.getDisciplineType()) != null && disciplineType.isPaleo()) {
                            boolean cfr_ignored_0 = SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step - 1) instanceof TaxonLoadSetupPanel;
                        }
                        if (SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step - 1) == SpecifyDBSetupWizard.this.accessionPickerGbl && !((Boolean)SpecifyDBSetupWizard.this.props.get("accglobal")).booleanValue()) {
                            --SpecifyDBSetupWizard.this.step;
                        }
                        if (SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step - 1) == SpecifyDBSetupWizard.this.accessionPickerCol) {
                            boolean isAccGlobal;
                            if (SpecifyDBSetupWizard.this.accessionPanel != null) {
                                SpecifyDBSetupWizard.this.accessionPanel.getValues(SpecifyDBSetupWizard.this.props);
                                isAccGlobal = (Boolean)SpecifyDBSetupWizard.this.props.get("accglobal");
                            } else {
                                Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
                                boolean bl = isAccGlobal = inst != null && inst.getIsAccessionsGlobal() == false;
                            }
                            if (isAccGlobal) {
                                --SpecifyDBSetupWizard.this.step;
                            }
                        }
                        --SpecifyDBSetupWizard.this.step;
                        SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step).doingPrev();
                        HelpMgr.registerComponent((AbstractButton)SpecifyDBSetupWizard.this.helpBtn, SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step).getHelpContext());
                        SpecifyDBSetupWizard.this.cardLayout.show(SpecifyDBSetupWizard.this.cardPanel, Integer.toString(SpecifyDBSetupWizard.this.step));
                    }
                    SpecifyDBSetupWizard.this.updateBtnBar();
                    if (listener != null) {
                        listener.panelChanged(UIRegistry.getResourceString(String.valueOf(SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step).getPanelName()) + ".TITLE"));
                    }
                }
            });
            this.backBtn.setEnabled(false);
        }
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SpecifyDBSetupWizard.this.step == SpecifyDBSetupWizard.this.lastStep - 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Container c = SpecifyDBSetupWizard.this.getParent();
                            while (!(c instanceof Window) && c != null) {
                                c = c.getParent();
                            }
                            if (c != null) {
                                ((Window)c).pack();
                            }
                        }
                    });
                }
                if (SpecifyDBSetupWizard.this.step < SpecifyDBSetupWizard.this.lastStep - 1) {
                    DisciplineType disciplineType = null;
                    if (SpecifyDBSetupWizard.this.disciplinePanel == null) {
                        Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
                        disciplineType = DisciplineType.getByName(discipline.getType());
                    } else {
                        disciplineType = SpecifyDBSetupWizard.this.disciplinePanel.getDisciplineType();
                    }
                    SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step).getValues(SpecifyDBSetupWizard.this.props);
                    SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step).aboutToLeave();
                    if (disciplineType != null && disciplineType.isPaleo() && SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step) instanceof TreeDefSetupPanel) {
                        ((TreeDefSetupPanel)SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step)).getClassType();
                    }
                    if (SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step) == SpecifyDBSetupWizard.this.accessionPanel) {
                        SpecifyDBSetupWizard.this.accessionPanel.getValues(SpecifyDBSetupWizard.this.props);
                        if (!((Boolean)SpecifyDBSetupWizard.this.props.get("accglobal")).booleanValue()) {
                            ++SpecifyDBSetupWizard.this.step;
                        }
                    }
                    if (SpecifyDBSetupWizard.this.panels.get(SpecifyDBSetupWizard.this.step) == SpecifyDBSetupWizard.this.catNumPicker && SpecifyDBSetupWizard.this.accessionPanel != null) {
                        SpecifyDBSetupWizard.this.accessionPanel.getValues(SpecifyDBSetupWizard.this.props);
                        boolean isAccGlobal = (Boolean)SpecifyDBSetupWizard.this.props.get("accglobal");
                        if (isAccGlobal) {
                            ++SpecifyDBSetupWizard.this.step;
                        }
                    }
                    SpecifyDBSetupWizard.this.advanceToNextPanel();
                } else {
                    SpecifyDBSetupWizard.this.nextBtn.setEnabled(false);
                    if (wizardType == WizardType.Institution) {
                        SpecifyDBSetupWizard.this.configSetup();
                        SpecifyDBSetupWizard.this.configureDatabase();
                    } else {
                        SpecifyDBSetupWizard.this.listener.finished();
                    }
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SpecifyDBSetupWizard.this.listener != null) {
                    if (SpecifyDBSetupWizard.this.step == SpecifyDBSetupWizard.this.lastStep) {
                        SpecifyDBSetupWizard.this.listener.finished();
                    } else if (UIHelper.promptForAction("QUIT", "NO", "CANCEL", UIRegistry.getResourceString("SURE_QUIT"))) {
                        SpecifyDBSetupWizard.this.listener.cancelled();
                    }
                }
            }
        });
        int i = 0;
        while (i < this.panels.size()) {
            this.cardPanel.add(Integer.toString(i), this.panels.get(i));
            this.panels.get(i).setValues(this.props);
            ++i;
        }
        this.cardLayout.show(this.cardPanel, "0");
        if (this.dbPanel != null) {
            this.dbPanel.updateBtnUI();
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,10px,p"));
        builder.add((Component)this.cardPanel, cc.xy(1, 1));
        builder.add((Component)btnBar, cc.xy(1, 3));
        builder.setDefaultDialogBorder();
        this.setLayout(new BorderLayout());
        PanelBuilder iconBldr = new PanelBuilder(new FormLayout("20px, f:p:g,p,f:p:g,8px", "20px,t:p,f:p:g, 8px"));
        JLabel iconLbl = new JLabel(IconManager.getIcon(SpecifyDBSetupWizard.getIconName()));
        iconLbl.setVerticalAlignment(1);
        iconBldr.add((Component)iconLbl, cc.xy(2, 3));
        this.add((Component)iconBldr.getPanel(), "West");
        this.add((Component)builder.getPanel(), "Center");
        this.progressBar = new JProgressBar(0, this.lastStep - 1);
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "South");
        this.panels.get(0).updateBtnUI();
    }

    private String getHelpCntxt(String hContext) {
        String prefix = "";
        switch (this.wizardType) {
            case Institution: {
                prefix = UIRegistry.isEmbedded() != false ? "ezdb_" : "";
                break;
            }
            case Division: {
                prefix = "div_";
                break;
            }
            case Discipline: {
                prefix = "dis_";
                break;
            }
            case Collection: {
                prefix = "col_";
            }
        }
        return String.valueOf(prefix) + hContext;
    }

    public static String getIconName() {
        return IconManager.makeIconName("WizardIcon");
    }

    protected void advanceToNextPanel() {
        ++this.step;
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.panels.get(this.step).getHelpContext());
        this.panels.get(this.step).doingNext();
        this.cardLayout.show(this.cardPanel, Integer.toString(this.step));
        this.updateBtnBar();
        if (this.listener != null) {
            this.listener.panelChanged(UIRegistry.getResourceString(String.valueOf(this.panels.get(this.step).getPanelName()) + ".TITLE"));
        }
    }

    public DisciplineType getDisciplineType() {
        return this.disciplinePanel.getDisciplineType();
    }

    public void setListener(WizardListener listener) {
        this.listener = listener;
    }

    protected void updateBtnBar() {
        this.progressBar.setValue(this.step);
        this.progressBar.setString(String.valueOf(String.format("%d", (int)((double)this.step * 100.0 / (double)(this.lastStep - 1)))) + "% Complete");
        if (this.step == this.lastStep - 1) {
            String key;
            this.nextBtn.setEnabled(this.panels.get(this.step).isUIValid());
            switch (this.wizardType) {
                case Institution: {
                    key = "FINISHED";
                    break;
                }
                case Division: {
                    key = "FINISHED_DIV";
                    break;
                }
                case Discipline: {
                    key = "FINISHED_DISP";
                    break;
                }
                case Collection: {
                    key = "FINISHED_COL";
                    break;
                }
                default: {
                    key = "FINISHED";
                }
            }
            this.nextBtn.setText(UIRegistry.getResourceString(key));
        } else {
            this.nextBtn.setEnabled(this.panels.get(this.step).isUIValid());
            this.nextBtn.setText(UIRegistry.getResourceString("NEXT"));
        }
        this.backBtn.setEnabled(this.step > 0 && this.panels.get(this.step).enablePreviousBtn());
    }

    protected String stripSpecifyDir(String path) {
        String appPath = path;
        int endInx = appPath.indexOf("Specify.app");
        if (endInx > -1) {
            appPath = appPath.substring(0, endInx - 1);
        }
        return appPath;
    }

    protected boolean saveFormatters(UIFieldFormatterIFace fmt, String prefix, String fileName) {
        if (fmt != null) {
            StringBuilder sb = new StringBuilder();
            fmt.toXML(sb);
            String path = String.valueOf(UIRegistry.getAppDataDir()) + File.separator + (prefix != null ? String.valueOf(prefix) + "_" : "") + fileName;
            try {
                FileUtils.writeStringToFile((File)new File(path), (String)sb.toString());
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            return true;
        }
        return false;
    }

    protected void configSetup() {
        if (this.wizardType == WizardType.Institution) {
            log.debug((Object)("********** WORK[" + UIRegistry.getDefaultWorkingPath() + "]"));
            log.debug((Object)("********** USER LOC[" + this.stripSpecifyDir(UIRegistry.getAppDataDir()) + "]"));
            String baseAppDir = UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX ? this.stripSpecifyDir(UIRegistry.getAppDataDir()) : UIRegistry.getDefaultWorkingPath();
            baseAppDir = UIHelper.stripSubDirs(baseAppDir, 1);
            UIRegistry.setDefaultWorkingPath(baseAppDir);
            log.debug((Object)("********** Working path for App [" + baseAppDir + "]"));
        }
    }

    protected void setupLoginPrefs() {
        String userName = this.props.getProperty("usrUsername");
        String password = this.props.getProperty("usrPassword");
        String saUserName = this.props.getProperty("saUserName");
        String saPassword = this.props.getProperty("saPassword");
        String encryptedMasterUP = UserAndMasterPasswordMgr.encrypt(saUserName, saPassword, password);
        DatabaseDriverInfo driverInfo = this.dbPanel.getDriver();
        AppPreferences ap = AppPreferences.getLocalPrefs();
        ap.put(String.valueOf(userName) + "_master.islocal", "true");
        ap.put(String.valueOf(userName) + "_master.path", encryptedMasterUP);
        ap.put("login.dbdriver_selected", driverInfo.getName());
        ap.put("login.username", this.props.getProperty("usrUsername"));
        ap.put("login.databases_selected", this.dbPanel.getDbName());
        ap.put("login.databases", this.dbPanel.getDbName());
        ap.put("login.servers", this.props.getProperty("hostName"));
        ap.put("login.servers_selected", this.props.getProperty("hostName"));
        ap.put("login.rememberuser", "true");
        ap.put("extra.check", "true");
        ap.put("version_check.auto", "true");
        try {
            ap.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public void processDataForNonBuild() {
        this.saveFormatters();
    }

    protected void saveFormatters() {
        UIFieldFormatterIFace accNumFmt;
        Object catNumFmtObj = this.props.get("catnumfmt");
        Object accNumFmtObj = this.props.get("accnumfmt");
        String collectionName = this.props.getProperty("collName");
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        boolean isAccGlobal = inst != null && inst.getIsAccessionsGlobal() != false;
        UIFieldFormatterIFace catNumFmt = catNumFmtObj instanceof UIFieldFormatterIFace ? (UIFieldFormatterIFace)catNumFmtObj : null;
        UIFieldFormatterIFace uIFieldFormatterIFace = accNumFmt = accNumFmtObj instanceof UIFieldFormatterIFace ? (UIFieldFormatterIFace)accNumFmtObj : null;
        if (catNumFmt != null) {
            this.saveFormatters(catNumFmt, collectionName, "catnumfmt.xml");
        }
        if (accNumFmt != null) {
            this.saveFormatters(accNumFmt, isAccGlobal ? null : collectionName, "accnumfmt.xml");
        }
    }

    public void configureDatabase() {
        if (this.wizardType == WizardType.Institution) {
            this.setupLoginPrefs();
        }
        if (this.listener != null) {
            this.listener.hide();
        }
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            protected boolean isOK = false;

            @Override
            protected Integer doInBackground() throws Exception {
                BuildSampleDatabase bsd;
                block7: {
                    String dbName = SpecifyDBSetupWizard.this.props.getProperty("dbName");
                    String hostName = SpecifyDBSetupWizard.this.props.getProperty("hostName");
                    DatabaseDriverInfo driverInfo = (DatabaseDriverInfo)SpecifyDBSetupWizard.this.props.get("driverObj");
                    String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, hostName, dbName);
                    if (connStr == null) {
                        connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, dbName);
                    }
                    String saUserName = SpecifyDBSetupWizard.this.props.getProperty("saUserName");
                    String saPassword = SpecifyDBSetupWizard.this.props.getProperty("saPassword");
                    bsd = new BuildSampleDatabase();
                    SpecifyDBSetupWizard.this.progressFrame = bsd.createProgressFrame(UIRegistry.getResourceString("CREATE_DIV"));
                    SpecifyDBSetupWizard.this.progressFrame.adjustProgressFrame();
                    SpecifyDBSetupWizard.this.progressFrame.setProcessPercent(true);
                    SpecifyDBSetupWizard.this.progressFrame.setOverall(0, 12);
                    UIRegistry.pushWindow(SpecifyDBSetupWizard.this.progressFrame);
                    UIHelper.centerAndShow(SpecifyDBSetupWizard.this.progressFrame);
                    if (UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, saUserName, saPassword)) break block7;
                    this.isOK = false;
                    return null;
                }
                try {
                    Session session = HibernateUtil.getCurrentSession();
                    bsd.setSession(session);
                    AppContextMgr ac = AppContextMgr.getInstance();
                    Institution institution = ac.getClassObject(Institution.class);
                    SpecifyUser user = ac.getClassObject(SpecifyUser.class);
                    DisciplineType disciplineType = (DisciplineType)SpecifyDBSetupWizard.this.props.get("disciplineType");
                    DataType dataType = AppContextMgr.getInstance().getClassObject(DataType.class);
                    session.lock((Object)institution, LockMode.NONE);
                    session.lock((Object)dataType, LockMode.NONE);
                    bsd.setDataType(dataType);
                    Division division = bsd.createEmptyDivision(institution, disciplineType, user, SpecifyDBSetupWizard.this.props, true, true, true);
                    if (division != null) {
                        this.isOK = division != null;
                        SpecifyDBSetupWizard.this.progressFrame.incOverall();
                        if (this.isOK) {
                            FixDBAfterLogin.fixUserPermissions(true);
                            SpecifyDBSetupWizard.this.saveFormatters();
                        }
                        SpecifyDBSetupWizard.this.progressFrame.setVisible(false);
                        SpecifyDBSetupWizard.this.progressFrame.dispose();
                    } else {
                        this.isOK = false;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            protected void done() {
                if (DBConnection.getInstance().getConnection() != null) {
                    String resAppVersion = UIRegistry.getAppVersion();
                    String dbVersion = SchemaUpdateService.getInstance().getDBSchemaVersionFromXML();
                    SpVersion.createInitialRecord(DBConnection.getInstance().getConnection(), resAppVersion, dbVersion);
                    if (UIRegistry.isMobile()) {
                        DBConnection.setCopiedToMachineDisk(true);
                    }
                }
                JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("BLD_DONE", UIRegistry.getResourceString(this.isOK ? "BLD_OK" : "BLD_NOTOK")), UIRegistry.getResourceString("COMPLETE"), 1);
                if (SpecifyDBSetupWizard.this.listener != null) {
                    SpecifyDBSetupWizard.this.listener.hide();
                    SpecifyDBSetupWizard.this.listener.finished();
                }
            }
        };
        worker.execute();
    }

    public static interface WizardListener {
        public void panelChanged(String var1);

        public void cancelled();

        public void hide();

        public void finished();
    }

    public static enum WizardType {
        Institution,
        Division,
        Discipline,
        Collection;

    }
}

