/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.af.ui.forms.DataSetterForObj;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.config.init.GenericFormPanel;
import edu.ku.brc.specify.config.init.SetupPanelIFace;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SetupDivsionCollection
extends JDialog {
    protected Properties props = new Properties();
    protected JButton helpBtn;
    protected JButton backBtn;
    protected JButton nextBtn;
    protected JButton cancelBtn;
    protected int step = 0;
    protected int lastStep = 3;
    protected boolean isCancelled;
    protected JPanel cardPanel;
    protected CardLayout cardLayout = new CardLayout();
    protected Vector<SetupPanelIFace> panels = new Vector();
    protected String setupXMLPath;
    protected Collection collection = null;

    public SetupDivsionCollection(Division division) {
        this.setModal(true);
        this.props.put("division", division);
        this.setTitle("Configuring");
        this.cardPanel = new JPanel(this.cardLayout);
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        this.backBtn = UIHelper.createButton(UIRegistry.getResourceString("BACK"));
        this.nextBtn = UIHelper.createButton(UIRegistry.getResourceString("NEXT"));
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, "ConfiguringDatabase");
        CellConstraints cc = new CellConstraints();
        PanelBuilder bbpb = new PanelBuilder(new FormLayout("f:p:g,p,4px,p,4px,p,4px,p,4px", "p"));
        bbpb.add((Component)this.helpBtn, cc.xy(2, 1));
        bbpb.add((Component)this.backBtn, cc.xy(4, 1));
        bbpb.add((Component)this.nextBtn, cc.xy(6, 1));
        bbpb.add((Component)this.cancelBtn, cc.xy(8, 1));
        JPanel btnBar = bbpb.getPanel();
        this.lastStep = this.panels.size();
        if (this.backBtn != null) {
            this.backBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SetupDivsionCollection.this.step > 0) {
                        --SetupDivsionCollection.this.step;
                        SetupDivsionCollection.this.panels.get(SetupDivsionCollection.this.step).doingPrev();
                        SetupDivsionCollection.this.cardLayout.show(SetupDivsionCollection.this.cardPanel, Integer.toString(SetupDivsionCollection.this.step));
                    }
                    SetupDivsionCollection.this.updateBtnBar();
                }
            });
            this.backBtn.setEnabled(false);
        }
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SetupDivsionCollection.this.step < SetupDivsionCollection.this.lastStep - 1) {
                    ++SetupDivsionCollection.this.step;
                    SetupDivsionCollection.this.panels.get(SetupDivsionCollection.this.step).doingNext();
                    SetupDivsionCollection.this.cardLayout.show(SetupDivsionCollection.this.cardPanel, Integer.toString(SetupDivsionCollection.this.step));
                    SetupDivsionCollection.this.updateBtnBar();
                } else {
                    SetupDivsionCollection.this.setVisible(false);
                    SetupDivsionCollection.this.saveCollection();
                    SetupDivsionCollection.this.dispose();
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetupDivsionCollection.this.isCancelled = true;
                SetupDivsionCollection.this.setVisible(false);
                SetupDivsionCollection.this.dispose();
            }
        });
        DataGetterForObj getter = new DataGetterForObj();
        DataSetterForObj setter = new DataSetterForObj();
        int i = 0;
        while (i < this.panels.size()) {
            SetupPanelIFace panel = this.panels.get(i);
            this.cardPanel.add(Integer.toString(i), panel.getUIComponent());
            if (this.panels.get(i) instanceof GenericFormPanel) {
                GenericFormPanel p = (GenericFormPanel)this.panels.get(i);
                p.setGetter(getter);
                p.setSetter(setter);
            }
            panel.setValues(this.props);
            ++i;
        }
        this.panels.get(0).doingNext();
        this.cardLayout.show(this.cardPanel, "0");
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,10px,p"));
        builder.add((Component)this.cardPanel, cc.xy(1, 1));
        builder.add((Component)btnBar, cc.xy(1, 3));
        builder.setDefaultDialogBorder();
        this.setDefaultCloseOperation(2);
        this.setContentPane(builder.getPanel());
        this.pack();
        this.nextBtn.setEnabled(false);
    }

    protected void updateBtnBar() {
        if (this.step == this.lastStep - 1) {
            this.nextBtn.setEnabled(this.panels.get(this.step).isUIValid());
            this.nextBtn.setText("Finished");
        } else {
            this.nextBtn.setEnabled(this.panels.get(this.step).isUIValid());
            this.nextBtn.setText("Next");
        }
        this.backBtn.setEnabled(this.step > 0);
    }

    protected String stripSpecifyDir(String path) {
        String appPath = path;
        int endInx = appPath.indexOf("Specify.app");
        if (endInx > -1) {
            appPath = appPath.substring(0, endInx - 1);
        }
        return appPath;
    }

    public void saveCollection() {
        try {
            for (SetupPanelIFace panel : this.panels) {
                panel.getValues(this.props);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SetupDivsionCollection.class, ex);
        }
        try {
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    Division division = (Division)SetupDivsionCollection.this.props.get("division");
                    Discipline discipline = (Discipline)SetupDivsionCollection.this.props.get("discipline");
                    AutoNumberingScheme numScheme = (AutoNumberingScheme)SetupDivsionCollection.this.props.get("numScheme");
                    if (division != null && SetupDivsionCollection.this.collection != null && numScheme != null) {
                        DataProviderSessionIFace session = null;
                        try {
                            try {
                                Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
                                session = DataProviderFactory.getInstance().createSession();
                                session.beginTransaction();
                                if (division.getId() == null) {
                                    Institution institution = session.getData(Institution.class, "id", inst.getId(), DataProviderSessionIFace.CompareType.Equals);
                                    institution.getDivisions().add(division);
                                    division.setInstitution(institution);
                                    session.saveOrUpdate(institution);
                                    session.saveOrUpdate(division);
                                } else {
                                    session.attach(division);
                                }
                                if (discipline.getId() == null) {
                                    discipline.setDivision(division);
                                    session.saveOrUpdate(discipline);
                                } else {
                                    discipline = session.merge(discipline);
                                }
                                if (numScheme.getId() != null) {
                                    numScheme = session.merge(numScheme);
                                }
                                session.saveOrUpdate(division);
                                SetupDivsionCollection.this.collection.setDiscipline(discipline);
                                discipline.getCollections().add(SetupDivsionCollection.this.collection);
                                SetupDivsionCollection.this.collection.getNumberingSchemes().add(numScheme);
                                numScheme.getCollections().add(SetupDivsionCollection.this.collection);
                                session.saveOrUpdate(SetupDivsionCollection.this.collection);
                                session.saveOrUpdate(numScheme);
                                session.saveOrUpdate(discipline);
                                session.commit();
                                session.flush();
                                CommandDispatcher.dispatch(new CommandAction("SystemSetup", "DivisionSaved", division));
                            }
                            catch (Exception ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(SetupDivsionCollection.class, ex);
                                ex.printStackTrace();
                                CommandDispatcher.dispatch(new CommandAction("SystemSetup", "DivisionError", division));
                                if (session != null) {
                                    session.close();
                                }
                            }
                        }
                        finally {
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    return null;
                }

                @Override
                public void finished() {
                }
            };
            worker.start();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SetupDivsionCollection.class, ex);
            ex.printStackTrace();
        }
    }
}

