/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;

public class RegisterSpecify {
    private static final String EXTRA_CHECK = "extra.check";
    private static RegisterSpecify instance = new RegisterSpecify();
    private boolean hasConnection = false;
    private Boolean isFirstReg = null;

    private RegisterSpecify() {
    }

    public static RegisterSpecify getInstance() {
        return instance;
    }

    private boolean askToReg(String typeTitle, String typeName) {
        Object[] options = new Object[]{UIRegistry.getResourceString("YES"), UIRegistry.getResourceString("NO")};
        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("SpReg.DO_REG", typeTitle, typeName), UIRegistry.getResourceString("SpReg.DO_REG_TITLE"), 0, 3, null, options, options[0]);
        return userChoice == 0;
    }

    public static boolean hasInstitutionRegistered() {
        boolean isReg;
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        boolean bl = isReg = inst != null && StringUtils.isNotEmpty((String)inst.getRegNumber());
        if (RegisterSpecify.getInstance().isFirstReg == null) {
            RegisterSpecify.getInstance().isFirstReg = isReg;
        }
        return isReg;
    }

    public static boolean isAnonymous() {
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        return inst != null ? inst.getIsAnonymous() : false;
    }

    public static boolean hasDivisionRegistered() {
        Division division = AppContextMgr.getInstance().getClassObject(Division.class);
        return division != null && StringUtils.isNotEmpty((String)division.getRegNumber());
    }

    public static boolean hasDisciplineRegistered() {
        Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        return discipline != null && StringUtils.isNotEmpty((String)discipline.getRegNumber());
    }

    public static boolean hasCollectionRegistered() {
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        return collection != null && StringUtils.isNotEmpty((String)collection.getRegNumber());
    }

    public static boolean hasConnection() {
        return RegisterSpecify.getInstance().hasConnection;
    }

    private <T> T update(Class<?> cls, Object dataObjArg) {
        Object dataObj = dataObjArg;
        DataModelObjBase.save(dataObj);
        ((DataModelObjBase)dataObj).forceLoad();
        dataObj = DataModelObjBase.getDataObj(cls, ((DataModelObjBase)dataObj).getId());
        if (dataObj != null) {
            AppContextMgr.getInstance().setClassObject(cls, dataObj);
        }
        return (T)dataObj;
    }

    public static Institution setHasBeenAsked() {
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        inst = (Institution)DataModelObjBase.getDataObj(Institution.class, ((DataModelObjBase)inst).getId());
        inst.setHasBeenAsked(true);
        inst = (Institution)RegisterSpecify.getInstance().update(Institution.class, inst);
        return inst;
    }

    public static Institution setIsAnonymous(boolean isAnonymous) {
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        inst.setIsAnonymous(isAnonymous);
        inst = (Institution)RegisterSpecify.getInstance().update(Institution.class, inst);
        return inst;
    }

    private static void setInstitutionHasAutoRegistered(String regNumber, boolean isAnonymous) {
        AppContextMgr acMgr = AppContextMgr.getInstance();
        Institution inst = acMgr.getClassObject(Institution.class);
        inst.setRegNumber(regNumber);
        inst = (Institution)RegisterSpecify.getInstance().update(Institution.class, inst);
        RegisterSpecify.getInstance().isFirstReg = true;
        RegisterSpecify.getInstance().doStartRegister(RegisterType.Division, isAnonymous, false);
    }

    private void setDivisionHasRegistered(String regNumber, boolean isAnonymous) {
        AppContextMgr acMgr = AppContextMgr.getInstance();
        Division division = acMgr.getClassObject(Division.class);
        division.setRegNumber(regNumber);
        this.update(Division.class, division);
        this.doStartRegister(RegisterType.Discipline, isAnonymous, false);
    }

    private void setDisciplineHasRegistered(String regNumber, boolean isAnonymous) {
        AppContextMgr acMgr = AppContextMgr.getInstance();
        Discipline discipline = acMgr.getClassObject(Discipline.class);
        discipline.setRegNumber(regNumber);
        this.update(Discipline.class, discipline);
        this.doStartRegister(RegisterType.Collection, isAnonymous, false);
    }

    private void setCollectionHasRegistered(String regNumber, boolean isAnonymous) {
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        collection.setRegNumber(regNumber);
        this.update(Collection.class, collection);
        if (!this.isFirstReg.booleanValue() && !RegisterSpecify.isAnonymous()) {
            UIRegistry.showLocalizedMsg(1, "SpReg.REG_TITLE", "SpReg.REG_OK", new Object[0]);
        }
    }

    private void doStartRegister(final RegisterType regType, final boolean isAnonymous, final boolean isForISANumber) {
        SwingWorker workerThread = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    return RegisterSpecify.this.doRegisterInternal(regType, isAnonymous, isForISANumber);
                }
                catch (ConnectionException e) {
                    return null;
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RegisterSpecify.class, e);
                    return e;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void finished() {
                Object retVal = this.getValue();
                if (retVal == null) {
                    if (!isForISANumber) return;
                    if (!RegisterSpecify.this.hasConnection) return;
                    UIRegistry.showLocalizedError("SpReg.ISA_ERROR");
                    return;
                }
                if (!(retVal instanceof String)) return;
                if (isForISANumber) {
                    Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                    String isaTitle = UIRegistry.getResourceString("SpReg.ISA_TITLE");
                    collection = (Collection)RegisterSpecify.this.update(Collection.class, collection);
                    UIRegistry.showLocalizedMsg(1, isaTitle, "SpReg.ISA_ACCEPTED", collection.getIsaNumber());
                    return;
                }
                String regNumber = (String)retVal;
                switch (regType) {
                    case Institution: {
                        RegisterSpecify.setInstitutionHasAutoRegistered(regNumber, isAnonymous);
                        return;
                    }
                    case Division: {
                        RegisterSpecify.this.setDivisionHasRegistered(regNumber, isAnonymous);
                        return;
                    }
                    case Discipline: {
                        RegisterSpecify.this.setDisciplineHasRegistered(regNumber, isAnonymous);
                        return;
                    }
                    case Collection: {
                        RegisterSpecify.this.setCollectionHasRegistered(regNumber, isAnonymous);
                    }
                }
            }
        };
        workerThread.start();
    }

    private String doRegisterInternal(RegisterType regType, boolean isAnonymous, boolean isForISANumber) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)RegisterSpecify.class.getName());
        String versionCheckURL = RegisterSpecify.getRegisterURL();
        PostMethod postMethod = new PostMethod(versionCheckURL);
        NameValuePair[] postParams = this.createPostParameters(regType, isAnonymous, isForISANumber);
        postMethod.setRequestBody(postParams);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
        }
        catch (Exception e) {
            this.hasConnection = false;
            e.printStackTrace();
            throw new ConnectionException(e);
        }
        String responseString = postMethod.getResponseBodyAsString();
        if (StringUtils.isNotEmpty((String)responseString)) {
            String[] tokens = StringUtils.split((String)responseString);
            if (tokens.length == 2 && tokens[0].equals("1")) {
                return tokens[1];
            }
            if (isForISANumber && tokens.length == 1 && tokens[0].equals("1")) {
                return tokens[0];
            }
        }
        return null;
    }

    public static String getRegisterURL() {
        String baseURL = UIRegistry.getResourceString("SpReg.REGISTER_URL");
        return baseURL;
    }

    private String fixParam(String value) {
        return value == null ? "" : value;
    }

    private NameValuePair[] createPostParameters(RegisterType regType, boolean isAnonymous, boolean isForISANumber) {
        Vector<NameValuePair> postParams = new Vector<NameValuePair>();
        String installID = UsageTracker.getInstallId();
        postParams.add(new NameValuePair("id", installID));
        postParams.add(new NameValuePair("reg_type", regType.toString()));
        postParams.add(new NameValuePair("os_name", System.getProperty("os.name")));
        postParams.add(new NameValuePair("os_version", System.getProperty("os.version")));
        postParams.add(new NameValuePair("java_version", System.getProperty("java.version")));
        postParams.add(new NameValuePair("java_vendor", System.getProperty("java.vendor")));
        postParams.add(new NameValuePair("is_anonymous", Boolean.toString(isAnonymous)));
        postParams.add(new NameValuePair("is_isa_anonymous", Boolean.toString(isAnonymous)));
        AppContextMgr acMgr = AppContextMgr.getInstance();
        Institution inst = acMgr.getClassObject(Institution.class);
        Division division = acMgr.getClassObject(Division.class);
        Discipline discipline = acMgr.getClassObject(Discipline.class);
        Collection collection = acMgr.getClassObject(Collection.class);
        if (isForISANumber) {
            postParams.add(new NameValuePair("reg_isa", "true"));
            postParams.add(new NameValuePair("reg_number", collection.getRegNumber()));
        }
        switch (regType) {
            case Institution: {
                if (isAnonymous) break;
                postParams.add(new NameValuePair("Institution_name", this.fixParam(inst.getName())));
                break;
            }
            case Division: {
                postParams.add(new NameValuePair("Institution_number", this.fixParam(inst.getRegNumber())));
                if (isAnonymous) break;
                postParams.add(new NameValuePair("Division_name", this.fixParam(division.getName())));
                break;
            }
            case Discipline: {
                postParams.add(new NameValuePair("Institution_number", this.fixParam(inst.getRegNumber())));
                postParams.add(new NameValuePair("Division_number", this.fixParam(division.getRegNumber())));
                if (isAnonymous) break;
                postParams.add(new NameValuePair("Discipline_type", this.fixParam(discipline.getType())));
                break;
            }
            case Collection: {
                postParams.add(new NameValuePair("Institution_number", this.fixParam(inst.getRegNumber())));
                postParams.add(new NameValuePair("Division_number", this.fixParam(division.getRegNumber())));
                postParams.add(new NameValuePair("Discipline_number", this.fixParam(discipline.getRegNumber())));
                postParams.add(new NameValuePair("Collection_number", this.fixParam(collection.getRegNumber())));
                if (isAnonymous) break;
                postParams.add(new NameValuePair("Discipline_type", this.fixParam(discipline.getType())));
                postParams.add(new NameValuePair("Collection_name", this.fixParam(collection.getCollectionName())));
                postParams.add(new NameValuePair("ISA_Number", this.fixParam(collection.getIsaNumber())));
            }
        }
        if (!isAnonymous) {
            SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
            postParams.add(new NameValuePair("User_email", this.fixParam(user.getEmail())));
            Address addr = inst.getAddress();
            if (addr != null) {
                postParams.add(new NameValuePair("Address", this.fixParam(addr.getIdentityTitle())));
                postParams.add(new NameValuePair("Phone", this.fixParam(addr.getPhone1())));
            }
        }
        NameValuePair[] paramArray = new NameValuePair[postParams.size()];
        int i = 0;
        while (i < paramArray.length) {
            paramArray[i] = (NameValuePair)postParams.get(i);
            ++i;
        }
        return paramArray;
    }

    public static void register(final boolean forceRegistration, final int delayInSecs) {
        if (delayInSecs == 0) {
            RegisterSpecify.getInstance().registerInternal(forceRegistration);
        } else {
            javax.swing.SwingWorker<Object, Object> worker = new javax.swing.SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    try {
                        Thread.sleep(delayInSecs * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }

                @Override
                protected void done() {
                    RegisterSpecify.getInstance().registerInternal(forceRegistration);
                    super.done();
                }
            };
            worker.execute();
        }
    }

    private void registerInternal(boolean forceRegistration) {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        if (forceRegistration && !spUser.getUserType().equals(SpecifyUserTypes.UserType.Manager.toString())) {
            if (forceRegistration) {
                UIRegistry.showLocalizedMsg(null, "SpReg.MUSTBECM", new Object[0]);
            }
            return;
        }
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        Boolean hasBeenAsked = inst.getHasBeenAsked();
        boolean isAnonymous = RegisterSpecify.isAnonymous();
        if (!RegisterSpecify.hasInstitutionRegistered() || forceRegistration && isAnonymous) {
            if (forceRegistration) {
                if (!isAnonymous) {
                    UIRegistry.showLocalizedMsg(1, "SpReg.REGISTER", "SpReg.ITMS_REGED", new Object[0]);
                    return;
                }
                RegisterSpecify.setIsAnonymous(false);
                if (!RegisterSpecify.hasInstitutionRegistered()) {
                    this.doStartRegister(RegisterType.Institution, false, false);
                }
                localPrefs.putBoolean(EXTRA_CHECK, true);
                UIRegistry.showLocalizedMsg(1, "SpReg.REGISTER", "SpReg.ITMS_REGED", new Object[0]);
            } else if (!hasBeenAsked.booleanValue()) {
                boolean okToReg = this.askToReg(DBTableIdMgr.getInstance().getTitleForId(Collection.getClassTableId()), collection.getCollectionName());
                RegisterSpecify.setHasBeenAsked();
                if (okToReg) {
                    RegisterSpecify.setIsAnonymous(false);
                    this.doStartRegister(RegisterType.Institution, false, false);
                } else {
                    RegisterSpecify.setIsAnonymous(true);
                    this.doStartRegister(RegisterType.Institution, true, false);
                    localPrefs.putBoolean(EXTRA_CHECK, false);
                }
            }
        } else if (!RegisterSpecify.hasDisciplineRegistered()) {
            this.doStartRegister(RegisterType.Division, isAnonymous, false);
        } else if (!RegisterSpecify.hasDivisionRegistered()) {
            this.doStartRegister(RegisterType.Discipline, isAnonymous, false);
        } else if (!RegisterSpecify.hasCollectionRegistered()) {
            this.doStartRegister(RegisterType.Collection, isAnonymous, false);
        } else if (forceRegistration) {
            this.showRegisteredNumbers(isAnonymous);
        }
    }

    private void showRegisteredNumbers(boolean isAnonymous) {
        if (!RegisterSpecify.hasInstitutionRegistered() || isAnonymous) {
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "10px,p,10px"));
            pb.add((Component)UIHelper.createI18NLabel("SpReg.ITMS_NOT_REGED"), cc.xy(1, 2));
            pb.setDefaultDialogBorder();
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("SpReg.REG_TITLE"), true, 7, (Component)pb.getPanel());
            dlg.setCancelLabel(UIRegistry.getResourceString("CLOSE"));
            dlg.setOkLabel(UIRegistry.getResourceString("SpReg.REGISTER"));
            dlg.setVisible(true);
            if (dlg.getBtnPressed() == 1) {
                RegisterSpecify.setIsAnonymous(false);
                this.doStartRegister(RegisterType.Institution, false, false);
            }
        } else {
            UIRegistry.showLocalizedMsg(1, "SpReg.REGISTER", "SpReg.ITMS_REGED", new Object[0]);
        }
    }

    public static String getISANumber() {
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        return collection.getIsaNumber();
    }

    public static void registerISA() {
        SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        if (!spUser.getUserType().equals(SpecifyUserTypes.UserType.Manager.toString())) {
            UIRegistry.showLocalizedMsg("", "SpReg.MUSTBECM", new Object[0]);
            return;
        }
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        String isaNumber = collection.getIsaNumber();
        String isaTitle = UIRegistry.getResourceString("SpReg.ISA_TITLE");
        if (StringUtils.isNotEmpty((String)isaNumber)) {
            String msg = UIRegistry.getLocalizedMessage("SpReg.ISA_NUM", isaNumber);
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), msg, isaTitle, 1);
        } else {
            final JTextField textField = UIHelper.createTextField(30);
            isaNumber = textField.getText();
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,10px,p"));
            pb.add((Component)UIHelper.createI18NFormLabel("SpReg.ISA_ENT"), cc.xy(1, 1));
            pb.add((Component)textField, cc.xy(3, 1));
            pb.add((Component)UIHelper.createI18NLabel("SpReg.ISA_EXPL"), cc.xyw(1, 3, 3));
            pb.setDefaultDialogBorder();
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), isaTitle, true, pb.getPanel());
            dlg.createUI();
            final JButton okBtn = dlg.getOkBtn();
            okBtn.setEnabled(false);
            textField.getDocument().addDocumentListener(new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    if (StringUtils.isNotEmpty((String)textField.getText()) != okBtn.isEnabled()) {
                        okBtn.setEnabled(!okBtn.isEnabled());
                    }
                }
            });
            dlg.setVisible(true);
            isaNumber = textField.getText();
            if (!dlg.isCancelled() && StringUtils.isNotEmpty((String)isaNumber)) {
                RegisterSpecify.setIsAnonymous(false);
                collection.setIsaNumber(isaNumber);
                RegisterSpecify.getInstance().doStartRegister(RegisterType.Collection, false, true);
                AppPreferences.getLocalPrefs().putBoolean(EXTRA_CHECK, true);
            }
        }
    }

    public static class ConnectionException
    extends IOException {
        public ConnectionException(Throwable e) {
        }
    }

    private static enum RegisterType {
        Institution,
        Division,
        Discipline,
        Collection;

    }
}

