/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.PageSetupDlg;
import edu.ku.brc.specify.tasks.subpane.LabelsPane;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang.StringUtils;

public class PrintTableHelper {
    protected JTable printTable;

    public PrintTableHelper(JTable printTable) {
        this.printTable = printTable;
    }

    public DynamicReport buildReport(TableModel model, PageSetupDlg pageSetupDlg) throws Exception {
        String fontName = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = ge.getAllFonts();
        int n = fontArray.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            String fName = font.getFamily().toLowerCase();
            if (StringUtils.contains((String)fName, (String)"sansserif") || StringUtils.contains((String)fName, (String)"arial") || StringUtils.contains((String)fName, (String)"verdana")) {
                fontName = font.getFamily();
                break;
            }
            ++n2;
        }
        if (fontName == null) {
            fontName = "Times New Roman";
        }
        FastReportBuilder drb = new FastReportBuilder();
        Style columDetail = new Style();
        columDetail.setBorder(Border.THIN);
        Style columDetailWhite = new Style();
        columDetailWhite.setBorder(Border.THIN);
        columDetailWhite.setBackgroundColor(Color.WHITE);
        columDetailWhite.setFont(new ar.com.fdvs.dj.domain.constants.Font(10, fontName, false));
        columDetailWhite.setHorizontalAlign(HorizontalAlign.CENTER);
        columDetailWhite.setBlankWhenNull(true);
        Style columDetailWhiteBold = new Style();
        columDetailWhiteBold.setBorder(Border.THIN);
        columDetailWhiteBold.setBackgroundColor(Color.WHITE);
        Style titleStyle = new Style();
        titleStyle.setFont(new ar.com.fdvs.dj.domain.constants.Font(12, fontName, true));
        Style oddRowStyle = new Style();
        oddRowStyle.setBorder(Border.NO_BORDER);
        oddRowStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        Color veryLightGrey = new Color(240, 240, 240);
        oddRowStyle.setBackgroundColor(veryLightGrey);
        oddRowStyle.setTransparency(Transparency.OPAQUE);
        int i = 0;
        while (i < model.getColumnCount()) {
            String colName = model.getColumnName(i);
            Class<Object> dataClass = model.getColumnClass(i);
            if (dataClass == Object.class && model.getRowCount() > 0) {
                Object data = model.getValueAt(0, i);
                if (data != null) {
                    dataClass = data.getClass();
                } else {
                    int j = 1;
                    while (j < model.getRowCount()) {
                        data = model.getValueAt(j, i);
                        if (dataClass != null) {
                            dataClass = data.getClass();
                            break;
                        }
                        ++j;
                    }
                    if (dataClass == null) {
                        dataClass = String.class;
                    }
                }
            }
            ColumnBuilder colBldr = ColumnBuilder.getInstance().setColumnProperty(colName, dataClass.getName());
            int bracketInx = colName.indexOf(91);
            if (bracketInx > -1) {
                colName = colName.substring(0, bracketInx - 1);
            }
            colBldr.setTitle(colName);
            colBldr.setStyle(columDetailWhite);
            AbstractColumn column = colBldr.build();
            drb.addColumn(column);
            Style headerStyle = new Style();
            headerStyle.setFont(new ar.com.fdvs.dj.domain.constants.Font(11, fontName, true));
            headerStyle.setBorder(Border.THIN);
            headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
            headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
            headerStyle.setBackgroundColor(new Color(80, 80, 80));
            headerStyle.setTransparency(Transparency.OPAQUE);
            headerStyle.setTextColor(new Color(255, 255, 255));
            column.setHeaderStyle(headerStyle);
            ++i;
        }
        drb.setTitle(pageSetupDlg.getPageTitle());
        drb.setTitleStyle(titleStyle);
        drb.setLeftMargin(20);
        drb.setRightMargin(20);
        drb.setTopMargin(10);
        drb.setBottomMargin(10);
        drb.setPrintBackgroundOnOddRows(true);
        drb.setOddRowBackgroundStyle(oddRowStyle);
        drb.setColumnsPerPage(new Integer(1));
        drb.setUseFullPageWidth(true);
        drb.setColumnSpace(new Integer(5));
        Page[] pageSizes = new Page[]{Page.Page_Letter_Portrait(), Page.Page_Legal_Portrait(), Page.Page_A4_Portrait(), Page.Page_Letter_Landscape(), Page.Page_Legal_Landscape(), Page.Page_A4_Landscape()};
        int pageSizeInx = pageSetupDlg.getPageSize() + (pageSetupDlg.isPortrait() ? 0 : 3);
        drb.setPageSizeAndOrientation(pageSizes[pageSizeInx]);
        DynamicReport dr = drb.build();
        return dr;
    }

    public void printGrid(final String pageTitle) {
        final PageSetupDlg pageSetup = new PageSetupDlg();
        pageSetup.createUI();
        pageSetup.setPageTitle(pageTitle);
        pageSetup.setVisible(true);
        if (pageSetup.isCancelled()) {
            return;
        }
        UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getResourceString("JasperReportFilling"), 24);
        SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){
            protected JasperPrint jp = null;

            @Override
            protected Integer doInBackground() throws Exception {
                if (PrintTableHelper.this.printTable != null) {
                    try {
                        DynamicReport dr = PrintTableHelper.this.buildReport(PrintTableHelper.this.printTable.getModel(), pageSetup);
                        JRTableModelDataSource ds = new JRTableModelDataSource(PrintTableHelper.this.printTable.getModel());
                        this.jp = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                UIRegistry.clearSimpleGlassPaneMsg();
                if (this.jp != null) {
                    PrintTableHelper.this.reportFinished(this.jp, pageTitle);
                }
            }
        };
        backupWorker.execute();
    }

    private void reportFinished(JasperPrint print, String pageTitle) {
        try {
            JRViewer jasperViewer = new JRViewer(print);
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)jasperViewer, "Center");
            final CustomFrame frame = new CustomFrame(pageTitle, 1, p);
            frame.setOkLabel(UIRegistry.getResourceString("CLOSE"));
            UIHelper.centerAndShow(frame);
            frame.setSize(800, 800);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIHelper.centerWindow(frame);
                }
            });
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LabelsPane.class, ex);
            ex.printStackTrace();
        }
    }
}

