/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;

public class NumberingSchemeSetupDlg
extends CustomDialog {
    protected JComboBox cbx;
    protected JTextField numSchemeTxt;
    protected JTextField formatNameTxt;
    protected JList collectionList;
    protected AutoNumberingScheme numScheme = null;
    protected JTextField divisionTxt;
    protected JTextField disciplineTxt;
    protected Division division;
    protected Discipline discipline;
    protected Collection collection;
    protected String ansTitle;

    public NumberingSchemeSetupDlg(Frame frame, Division division, Discipline discipline, Collection collection) {
        super(frame, "", true, 1, null);
        this.division = division;
        this.discipline = discipline;
        this.collection = collection;
    }

    public NumberingSchemeSetupDlg(Dialog dialog, Division division, Discipline discipline, Collection collection) {
        super(dialog, "", true, 1, null);
        this.division = division;
        this.discipline = discipline;
        this.collection = collection;
    }

    @Override
    public void createUI() {
        super.createUI();
        DBTableInfo divTblInfo = DBTableIdMgr.getInstance().getInfoById(Division.getClassTableId());
        DBTableInfo dspTblInfo = DBTableIdMgr.getInstance().getInfoById(Discipline.getClassTableId());
        this.ansTitle = DBTableIdMgr.getInstance().getInfoById(AutoNumberingScheme.getClassTableId()).getTitle();
        this.setTitle(this.ansTitle);
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.cbx = new JComboBox(model);
        CellConstraints cc = new CellConstraints();
        PanelBuilder bldr = new PanelBuilder(new FormLayout("p,2px,p", "p,4px,p,10px,p,4px,p,4px,p:g,20px,p"));
        int y = 1;
        bldr.add((Component)UIHelper.createI18NFormLabel(divTblInfo.getTitle()), cc.xy(1, y));
        this.divisionTxt = UIHelper.createTextField("");
        bldr.add((Component)this.divisionTxt, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel(dspTblInfo.getTitle()), cc.xy(1, y += 2));
        this.disciplineTxt = UIHelper.createTextField();
        bldr.add((Component)this.disciplineTxt, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("SEL_NUM_SCHEME"), cc.xy(1, y += 2));
        bldr.add((Component)this.cbx, cc.xy(3, y));
        bldr.addSeparator(" ", cc.xyw(1, y += 2, 3));
        bldr.add((Component)UIHelper.createI18NLabel("NUM_SCHEME_DESC", 2), cc.xyw(1, y += 2, 3));
        bldr.add((Component)UIHelper.createI18NFormLabel(this.ansTitle), cc.xy(1, y += 2));
        this.numSchemeTxt = UIHelper.createTextField("");
        bldr.add((Component)this.numSchemeTxt, cc.xy(3, y));
        y += 2;
        ViewFactory.changeTextFieldUIForDisplay(this.divisionTxt, false);
        ViewFactory.changeTextFieldUIForDisplay(this.disciplineTxt, false);
        ViewFactory.changeTextFieldUIForDisplay(this.numSchemeTxt, false);
        this.divisionTxt.setText(this.division.toString());
        this.disciplineTxt.setText(this.discipline.toString());
        this.load(model);
        this.cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberingSchemeSetupDlg.this.numScheme = null;
                NumberingSchemeSetupDlg.this.okBtn.setEnabled(false);
                if (NumberingSchemeSetupDlg.this.cbx.getSelectedIndex() == 1) {
                    NumberingSchemeSetupDlg.this.createNewAutoNumberingScheme();
                    if (NumberingSchemeSetupDlg.this.numScheme != null) {
                        NumberingSchemeSetupDlg.this.numScheme.setTableNumber(CollectionObject.getClassTableId());
                    }
                } else if (NumberingSchemeSetupDlg.this.cbx.getSelectedIndex() > 1) {
                    NumberingSchemeSetupDlg.this.numScheme = (AutoNumberingScheme)NumberingSchemeSetupDlg.this.cbx.getSelectedItem();
                    NumberingSchemeSetupDlg.this.numSchemeTxt.setText(NumberingSchemeSetupDlg.this.numScheme.getSchemeName());
                    NumberingSchemeSetupDlg.this.okBtn.setEnabled(true);
                }
            }
        });
        bldr.setDefaultDialogBorder();
        this.contentPanel = bldr.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.okBtn.setEnabled(false);
        this.pack();
    }

    protected void load(DefaultComboBoxModel model) {
        model.addElement(UIRegistry.getResourceString("NONE"));
        model.addElement(UIRegistry.getLocalizedMessage("NewRecordTT", this.ansTitle));
        DataProviderSessionIFace localSession = null;
        try {
            try {
                localSession = DataProviderFactory.getInstance().createSession();
                List<?> numSchemes = localSession.getDataList("FROM AutoNumberingScheme");
                if (numSchemes != null) {
                    for (AutoNumberingScheme d : numSchemes) {
                        model.addElement(d);
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NumberingSchemeSetupDlg.class, ex);
                ex.printStackTrace();
                if (localSession != null) {
                    localSession.close();
                }
            }
        }
        finally {
            if (localSession != null) {
                localSession.close();
            }
        }
    }

    protected void createNewAutoNumberingScheme() {
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(AutoNumberingScheme.getClassTableId());
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Dialog)UIRegistry.getMostRecentWindow(), null, "CatAutoNumberingScheme", null, tableInfo.getTitle(), null, AutoNumberingScheme.class.getName(), "id", true, 8);
        this.numScheme = new AutoNumberingScheme();
        this.numScheme.initialize();
        dlg.setData(this.numScheme);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            dlg.getMultiView().getDataFromUI();
            this.numSchemeTxt.setText(this.numScheme.getSchemeName());
            this.okBtn.setEnabled(true);
        } else {
            this.numSchemeTxt.setText("");
            this.cbx.setSelectedIndex(0);
            this.okBtn.setEnabled(false);
            this.numScheme = null;
        }
    }

    public AutoNumberingScheme getNumScheme() {
        return this.numScheme;
    }
}

