/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.init.SetupPanelIFace;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NumberingSchemeSetup
extends JPanel
implements SetupPanelIFace {
    protected JComboBox cbx;
    protected JButton nextBtn;
    protected JLabel numSchemeLbl;
    protected AutoNumberingScheme numScheme = null;
    protected JTextField divisionTxt;
    protected JTextField disciplineTxt;
    protected Properties props = null;

    public NumberingSchemeSetup(final JButton nextBtn) {
        this.nextBtn = nextBtn;
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.cbx = new JComboBox(model);
        CellConstraints cc = new CellConstraints();
        PanelBuilder bldr = new PanelBuilder(new FormLayout("p,2px,p", "p,4px,p,10px,p,4px,p"), (JPanel)this);
        int y = 1;
        bldr.add((Component)UIHelper.createI18NFormLabel("DIVISION"), cc.xy(1, y));
        this.divisionTxt = UIHelper.createTextField("");
        bldr.add((Component)this.divisionTxt, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("DISCILPINE"), cc.xy(1, y += 2));
        this.disciplineTxt = UIHelper.createTextField();
        bldr.add((Component)this.disciplineTxt, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("SEL_NUM_SCHEME"), cc.xy(1, y += 2));
        bldr.add((Component)this.cbx, cc.xy(3, y));
        bldr.add((Component)UIHelper.createI18NFormLabel("AutoNumberingScheme"), cc.xy(1, y += 2));
        this.numSchemeLbl = UIHelper.createLabel("");
        bldr.add((Component)this.numSchemeLbl, cc.xy(3, y));
        y += 2;
        ViewFactory.changeTextFieldUIForDisplay(this.divisionTxt, false);
        ViewFactory.changeTextFieldUIForDisplay(this.disciplineTxt, false);
        this.load(model);
        this.cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberingSchemeSetup.this.numScheme = null;
                nextBtn.setEnabled(false);
                if (NumberingSchemeSetup.this.cbx.getSelectedIndex() == 1) {
                    NumberingSchemeSetup.this.createNewAutoNumberingScheme();
                } else if (NumberingSchemeSetup.this.cbx.getSelectedIndex() > 1) {
                    NumberingSchemeSetup.this.numScheme = (AutoNumberingScheme)NumberingSchemeSetup.this.cbx.getSelectedItem();
                    NumberingSchemeSetup.this.numSchemeLbl.setText(NumberingSchemeSetup.this.numScheme.getSchemeName());
                    nextBtn.setEnabled(true);
                    NumberingSchemeSetup.this.props.put("numScheme", NumberingSchemeSetup.this.numScheme);
                } else {
                    NumberingSchemeSetup.this.props.remove("numScheme");
                }
            }
        });
    }

    @Override
    public void aboutToLeave() {
    }

    @Override
    public boolean enablePreviousBtn() {
        return true;
    }

    @Override
    public String getHelpContext() {
        return null;
    }

    protected void load(DefaultComboBoxModel model) {
        model.addElement(UIRegistry.getResourceString("NONE"));
        model.addElement("CREATE_NEW_NUM_SCHEME");
        DataProviderSessionIFace localSession = null;
        try {
            try {
                localSession = DataProviderFactory.getInstance().createSession();
                List<?> numSchemes = localSession.getDataList("FROM AutoNumberingScheme");
                if (numSchemes != null) {
                    for (AutoNumberingScheme d : numSchemes) {
                        model.addElement(d);
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(NumberingSchemeSetup.class, ex);
                ex.printStackTrace();
                if (localSession != null) {
                    localSession.close();
                }
            }
        }
        finally {
            if (localSession != null) {
                localSession.close();
            }
        }
    }

    protected void createNewAutoNumberingScheme() {
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(AutoNumberingScheme.getClassTableId());
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Dialog)UIRegistry.getMostRecentWindow(), null, "CatAutoNumberingScheme", null, tableInfo.getTitle(), null, AutoNumberingScheme.class.getName(), "id", true, 8);
        this.numScheme = new AutoNumberingScheme();
        this.numScheme.initialize();
        dlg.setData(this.numScheme);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            dlg.getMultiView().getDataFromUI();
            this.numSchemeLbl.setText(this.numScheme.getSchemeName());
            this.nextBtn.setEnabled(true);
            this.props.put("numScheme", this.numScheme);
        } else {
            this.numSchemeLbl.setText("");
            this.cbx.setSelectedIndex(0);
            this.nextBtn.setEnabled(false);
            this.props.remove("numScheme");
        }
    }

    protected boolean isSameDiscipline(Discipline d1, Discipline d2) {
        return d1 != null && d1.getId() != null && d2 != null && d2.getId() != null && d1.getId().equals(d2.getId());
    }

    @Override
    public void doingNext() {
        Division div = (Division)this.props.get("division");
        this.divisionTxt.setText(div != null ? div.toString() : "");
        Discipline dsp = (Discipline)this.props.get("discipline");
        this.disciplineTxt.setText(div != null ? dsp.toString() : "");
    }

    @Override
    public void doingPrev() {
    }

    @Override
    public String getPanelName() {
        return "AutoNumberingSchemeSetup";
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    @Override
    public void getValues(Properties propsArg) {
    }

    @Override
    public boolean isUIValid() {
        return this.numScheme != null;
    }

    @Override
    public void setValues(Properties values) {
        this.props = values;
    }

    @Override
    public void updateBtnUI() {
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        return null;
    }
}

