/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.specify.config.init.DatabasePanel;
import edu.ku.brc.specify.config.init.GenericFormPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;

public class MasterUserPanel
extends GenericFormPanel {
    protected String propName = "next";
    protected Boolean isOK = null;
    protected JButton createMUBtn;
    protected JLabel label;
    protected String errorKey = null;
    protected JButton skipStepBtn;
    protected boolean manualLoginOK = false;
    protected JLabel advLabel;
    protected boolean isEmbedded = false;

    public MasterUserPanel(String name, String title, String helpContext, String[] labels, String[] fields, Integer[] numColumns, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        super(name, title, helpContext, labels, fields, numColumns, nextBtn, prevBtn, makeStretchy);
    }

    @Override
    protected void init(String title, String[] fields, boolean[] required, String[] types, Integer[] numColumns) {
        super.init(title, fields, required, types, numColumns);
        this.label = UIHelper.createLabel(" ", 0);
        this.createMUBtn = UIHelper.createI18NButton("CREATE_MASTER_BTN");
        PanelBuilder tstPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        tstPB.add((Component)this.createMUBtn, this.cc.xy(2, 1));
        PanelBuilder panelPB = new PanelBuilder(new FormLayout("f:p:g", "20px,p,2px,p,2px,p"));
        panelPB.add((Component)tstPB.getPanel(), this.cc.xy(1, 2));
        panelPB.add((Component)this.getProgressBar(), this.cc.xy(1, 4));
        panelPB.add((Component)this.label, this.cc.xy(1, 6));
        this.builder.add((Component)panelPB.getPanel(), this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.advLabel = UIHelper.createI18NLabel("ADV_MU_DESC", 0);
        this.skipStepBtn = UIHelper.createI18NButton("ADV_MU_TEST");
        JComponent sep = this.builder.addSeparator(UIRegistry.getResourceString("ADV_TITLE"), this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.builder.add((Component)this.advLabel, this.cc.xyw(3, this.row, 2));
        this.row += 2;
        tstPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        tstPB.add((Component)this.skipStepBtn, this.cc.xy(2, 1));
        this.builder.add((Component)tstPB.getPanel(), this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.skipStepBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterUserPanel.this.createMUBtn.setEnabled(false);
                MasterUserPanel.this.skipStepBtn.setEnabled(false);
                boolean ok = MasterUserPanel.this.skipDBCreate();
                MasterUserPanel.this.createMUBtn.setEnabled(true);
                MasterUserPanel.this.skipStepBtn.setEnabled(true);
                MasterUserPanel.this.advLabel.setText(UIRegistry.getResourceString(ok ? "ADV_DB_OK" : "ADV_DB_ERR"));
            }
        });
        this.createMUBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterUserPanel.this.createMasterUser();
            }
        });
        this.progressBar.setVisible(false);
        if (UIRegistry.isMobile()) {
            this.skipStepBtn.setVisible(false);
            this.advLabel.setVisible(false);
            sep.setVisible(false);
        }
    }

    @Override
    public void doingNext() {
        this.isEmbedded = DBConnection.getInstance().isEmbedded();
        if (this.isEmbedded) {
            ((JTextField)this.comps.get("saUserName")).setText(this.properties.getProperty("dbUserName"));
            ((JTextField)this.comps.get("saPassword")).setText(this.properties.getProperty("dbPassword"));
            ((JTextField)this.comps.get("saUserName")).setEnabled(false);
            ((JTextField)this.comps.get("saPassword")).setEnabled(false);
        }
    }

    @Override
    protected Pair<String, String> getRowColDefs() {
        String rowDef = "p,5px" + (this.fieldsNames.length > 0 ? "," + UIHelper.createDuplicateJGoodiesDef("p", "2px", this.fieldsNames.length) : "") + this.getAdditionalRowDefs() + ",2px,p,2px,p,8px,p";
        return new Pair<String, String>("p,2px,p,f:p:g", rowDef);
    }

    protected boolean skipDBCreate() {
        this.getValues(this.properties);
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String dbName = this.properties.getProperty("dbName");
        String hostName = this.properties.getProperty("hostName");
        String saUserName = ((JTextField)this.comps.get("saUserName")).getText();
        String saPassword = ((JTextField)this.comps.get("saPassword")).getText();
        if (!this.isEmbedded) {
            if (mgr.connect(saUserName, saPassword, hostName, dbName)) {
                this.nextBtn.setEnabled(true);
                mgr.close();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MasterUserPanel.this.nextBtn.doClick();
                    }
                });
                return true;
            }
        } else {
            this.nextBtn.setEnabled(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MasterUserPanel.this.nextBtn.doClick();
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void getValues(Properties props) {
        super.getValues(props);
    }

    @Override
    protected String getAdditionalRowDefs() {
        return ",2px,p";
    }

    @Override
    public boolean isUIValid() {
        boolean isValid = super.isUIValid();
        if (this.properties != null) {
            String dbUsername = this.properties.getProperty("dbUserName");
            String saUserName = ((JTextField)this.comps.get("saUserName")).getText();
            String saPassword = ((JTextField)this.comps.get("saPassword")).getText();
            if (!DatabasePanel.checkForValidText(this.label, saUserName, "ERR_BAD_USRNAME", "NO_SPC_USRNAME", false) || !DatabasePanel.checkForValidText(this.label, saPassword, null, "NO_SPC_PWDNAME", false)) {
                this.isOK = false;
                this.createMUBtn.setEnabled(false);
                return false;
            }
            if (dbUsername.equals(saUserName) && !this.isEmbedded) {
                this.label.setForeground(Color.RED);
                this.label.setText(UIRegistry.getResourceString("DB_SA_USRNAME_MATCH"));
                this.createMUBtn.setEnabled(false);
                return false;
            }
            this.createMUBtn.setEnabled(true);
            this.label.setText("");
        }
        return isValid && this.isOK != null && this.isOK != false;
    }

    protected void setUIEnabled(boolean enable) {
        for (JComponent c : this.compList) {
            c.setEnabled(enable);
        }
        this.createMUBtn.setEnabled(enable);
    }

    @Override
    protected void textChanged(JTextField txt) {
        super.textChanged(txt);
        if (this.isOK != null && !this.isOK.booleanValue()) {
            this.isOK = null;
            this.createMUBtn.setVisible(true);
            this.label.setText(" ");
            this.properties.put("masterChanged", (Object)true);
        }
    }

    protected void createMasterUser() {
        String saUsrNm = ((JTextField)this.comps.get("saUserName")).getText();
        if (!DBConnection.getInstance().isEmbedded() && StringUtils.isNotEmpty((String)saUsrNm) && saUsrNm.equalsIgnoreCase("root")) {
            UIRegistry.showLocalizedError("MASTER_NO_ROOT");
            ((JTextField)this.comps.get("saUserName")).setText("");
            return;
        }
        if (this.isOK == null || !this.isOK.booleanValue()) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
            this.setUIEnabled(false);
            this.label.setText(UIRegistry.getResourceString("CONN_DB"));
            this.createMUBtn.setVisible(false);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    MasterUserPanel.this.label.setForeground(Color.BLACK);
                    MasterUserPanel.this.isOK = false;
                    if (!MasterUserPanel.this.isEmbedded) {
                        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
                        String dbUserName = MasterUserPanel.this.properties.getProperty("dbUserName");
                        String dbPassword = MasterUserPanel.this.properties.getProperty("dbPassword");
                        String dbName = MasterUserPanel.this.properties.getProperty("dbName");
                        String hostName = MasterUserPanel.this.properties.getProperty("hostName");
                        String saUserName = ((JTextField)MasterUserPanel.this.comps.get("saUserName")).getText();
                        String saPassword = ((JTextField)MasterUserPanel.this.comps.get("saPassword")).getText();
                        if (mgr.connectToDBMS(dbUserName, dbPassword, hostName)) {
                            if (mgr.doesUserExists(saUserName) && !mgr.setPermissions(saUserName, dbName, 31)) {
                                MasterUserPanel.this.errorKey = "ERR_SET_PERM";
                            }
                            if (!mgr.doesUserExists(saUserName)) {
                                this.firePropertyChange(MasterUserPanel.this.propName, 0, 1);
                                MasterUserPanel.this.isOK = mgr.createUser(saUserName, saPassword, dbName, 31);
                                if (!MasterUserPanel.this.isOK.booleanValue()) {
                                    MasterUserPanel.this.errorKey = "ERR_CRE_MASTER";
                                }
                            } else {
                                MasterUserPanel.this.isOK = true;
                            }
                        } else {
                            MasterUserPanel.this.errorKey = "NO_CONN_ROOT";
                            MasterUserPanel.this.isOK = false;
                        }
                        if (mgr != null) {
                            mgr.close();
                        }
                    } else {
                        MasterUserPanel.this.isOK = true;
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    MasterUserPanel.this.progressBar.setIndeterminate(false);
                    MasterUserPanel.this.progressBar.setVisible(false);
                    MasterUserPanel.this.setUIEnabled(true);
                    MasterUserPanel.this.updateBtnUI();
                    MasterUserPanel.this.createMUBtn.setVisible(MasterUserPanel.this.isOK == false);
                    if (MasterUserPanel.this.isOK.booleanValue()) {
                        MasterUserPanel.this.setUIEnabled(false);
                        MasterUserPanel.this.label.setText(UIRegistry.getResourceString("MASTER_CREATED"));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).MasterUserPanel.this.nextBtn.doClick();
                            }
                        });
                    } else {
                        MasterUserPanel.this.label.setText(UIRegistry.getResourceString(MasterUserPanel.this.errorKey));
                        UIRegistry.showLocalizedError(MasterUserPanel.this.errorKey);
                    }
                }
            };
            worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (MasterUserPanel.this.propName.equals(evt.getPropertyName())) {
                        MasterUserPanel.this.label.setText(UIRegistry.getLocalizedMessage("CREATE_MASTER", new Object[0]));
                    }
                }
            });
            worker.execute();
        }
    }
}

