/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.config.init.GenericFormPanel;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;

public class InstSetupPanel
extends GenericFormPanel {
    protected String propName = "next";
    protected Boolean isOK = null;
    protected JButton testBtn;
    protected JLabel label;
    protected DBConnection conn = null;
    protected String errorKey = null;

    public InstSetupPanel(String name, String title, String helpContext, String[] labels, String[] fields, Integer[] numCols, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        super(name, title, helpContext, labels, fields, numCols, nextBtn, prevBtn, makeStretchy);
    }

    @Override
    protected void init(String title, String[] fields, boolean[] required, String[] types, Integer[] numColumns) {
        super.init(title, fields, required, types, numColumns);
        this.label = UIHelper.createLabel("", 0);
        this.testBtn = UIHelper.createI18NButton("CREATEINST_BTN");
        PanelBuilder tstPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        tstPB.add((Component)this.testBtn, this.cc.xy(2, 1));
        PanelBuilder panelPB = new PanelBuilder(new FormLayout("f:p:g", "20px,p,2px,p,2px,p:g,f:p:g"));
        panelPB.add((Component)tstPB.getPanel(), this.cc.xy(1, 2));
        panelPB.add((Component)this.getProgressBar(), this.cc.xy(1, 4));
        panelPB.add((Component)this.label, this.cc.xy(1, 6));
        this.builder.add((Component)panelPB.getPanel(), this.cc.xyw(3, this.row, 2));
        this.row += 2;
        this.testBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstSetupPanel.this.doCreate();
            }
        });
        this.progressBar.setVisible(false);
    }

    @Override
    public boolean enablePreviousBtn() {
        return this.isOK == null || this.isOK == false;
    }

    @Override
    protected String getAdditionalRowDefs() {
        return ",p";
    }

    @Override
    public boolean isUIValid() {
        boolean isValid = super.isUIValid();
        return isValid && this.isOK != null && this.isOK != false;
    }

    protected void setUIEnabled(boolean enable) {
        for (JComponent c : this.compList) {
            c.setEnabled(enable);
        }
        this.testBtn.setEnabled(enable);
    }

    protected void doCreate() {
        if (this.isOK == null || !this.isOK.booleanValue()) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
            this.setUIEnabled(false);
            this.label.setText(UIRegistry.getResourceString("CONN_DB"));
            this.testBtn.setVisible(false);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    block4: {
                        InstSetupPanel.this.isOK = false;
                        InstSetupPanel.this.getValues(InstSetupPanel.this.properties);
                        this.firePropertyChange(InstSetupPanel.this.propName, 0, 1);
                        InstSetupPanel.this.conn = DBConnection.getInstance();
                        AppContextMgr.getInstance().setHasContext(true);
                        BuildSampleDatabase bsd = new BuildSampleDatabase();
                        bsd.setSession(HibernateUtil.getCurrentSession());
                        InstSetupPanel.this.isOK = bsd.createEmptyInstitution(InstSetupPanel.this.properties, false, false, true);
                        AppContextMgr.getInstance().setClassObject(DataType.class, bsd.getDataType());
                        HibernateUtil.closeSession();
                        if (InstSetupPanel.this.isOK.booleanValue()) break block4;
                        InstSetupPanel.this.errorKey = "BAD_INST";
                        return null;
                    }
                    try {
                        String userName = InstSetupPanel.this.properties.getProperty("usrUsername");
                        String password = InstSetupPanel.this.properties.getProperty("usrPassword");
                        String dbName = InstSetupPanel.this.properties.getProperty("dbName");
                        this.firePropertyChange(InstSetupPanel.this.propName, 0, 2);
                        InstSetupPanel.this.isOK = InstSetupPanel.this.tryLogginIn(userName, password, dbName);
                        if (!InstSetupPanel.this.isOK.booleanValue()) {
                            InstSetupPanel.this.errorKey = "BAD_LOGIN";
                            return null;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        InstSetupPanel.this.errorKey = "INST_UNRECOVERABLE";
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    InstSetupPanel.this.progressBar.setIndeterminate(false);
                    InstSetupPanel.this.progressBar.setVisible(false);
                    InstSetupPanel.this.setUIEnabled(true);
                    InstSetupPanel.this.updateBtnUI();
                    InstSetupPanel.this.label.setText(UIRegistry.getResourceString(InstSetupPanel.this.isOK != false ? "INST_CREATED" : (InstSetupPanel.this.errorKey != null ? InstSetupPanel.this.errorKey : "ERR_CRE_INST")));
                    if (InstSetupPanel.this.isOK.booleanValue()) {
                        InstSetupPanel.this.setUIEnabled(false);
                        InstSetupPanel.this.prevBtn.setEnabled(false);
                    }
                }
            };
            worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (InstSetupPanel.this.propName.equals(evt.getPropertyName())) {
                        String key = null;
                        switch ((Integer)evt.getNewValue()) {
                            case 1: {
                                key = "CREATING_INST";
                                break;
                            }
                            case 2: {
                                key = "LOGIN_USER";
                                break;
                            }
                        }
                        if (key != null) {
                            InstSetupPanel.this.label.setText(UIRegistry.getResourceString(key));
                        }
                    }
                }
            });
            worker.execute();
        }
    }

    protected boolean tryLogginIn(String usrName, String userPwd, String databaseName) {
        String encryptedMasterUP = UserAndMasterPasswordMgr.encrypt(this.properties.getProperty("saUserName"), this.properties.getProperty("saPassword"), userPwd);
        AppPreferences ap = AppPreferences.getLocalPrefs();
        ap.put(UserAndMasterPasswordMgr.getIsLocalPrefPath(usrName, databaseName, true), "true");
        ap.put(UserAndMasterPasswordMgr.getMasterPrefPath(usrName, databaseName, true), encryptedMasterUP);
        DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider = new DatabaseLoginPanel.MasterPasswordProviderIFace(){

            @Override
            public boolean hasMasterUserAndPwdInfo(String username, String password, String dbName) {
                if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                    UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                    return UserAndMasterPasswordMgr.getInstance().hasMasterUsernameAndPassword();
                }
                return false;
            }

            @Override
            public Pair<String, String> getUserNamePassword(String username, String password, String dbName) {
                UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                Pair<String, String> usrPwd = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                return usrPwd;
            }

            @Override
            public boolean editMasterInfo(String username, String dbName, boolean askForCredentials) {
                return UserAndMasterPasswordMgr.getInstance().editMasterInfo(username, dbName, askForCredentials);
            }
        };
        Pair<String, String> masterUsrPwd = usrPwdProvider.getUserNamePassword(usrName, userPwd, databaseName);
        if (masterUsrPwd != null) {
            String hostName = this.properties.getProperty("hostName");
            DatabaseDriverInfo driverInfo = (DatabaseDriverInfo)this.properties.get("driverObj");
            String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, hostName, databaseName);
            if (connStr == null) {
                connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, databaseName);
            }
            this.firePropertyChange(this.propName, 0, 2);
            boolean isLoggedIn = UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), databaseName, connStr, (String)masterUsrPwd.first, (String)masterUsrPwd.second);
            return isLoggedIn;
        }
        return false;
    }
}

