/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import edu.ku.brc.helpers.XMLHelper;
import java.util.Hashtable;
import org.dom4j.Element;

public class HiddenTableMgr {
    private Hashtable<String, Hashtable<String, Boolean>> disciplines = new Hashtable();

    public HiddenTableMgr() {
        this.load();
    }

    private void load() {
        Element dom = XMLHelper.readDOMFromConfigDir("hiddentables.xml");
        if (dom != null) {
            for (Element element : dom.selectNodes("/disciplines/discipline")) {
                String dName = XMLHelper.getAttr(element, "name", null);
                Hashtable<String, Boolean> tableHash = this.disciplines.get(dName);
                if (tableHash == null) {
                    tableHash = new Hashtable();
                    this.disciplines.put(dName, tableHash);
                }
                for (Element tbl : element.selectNodes("table")) {
                    String tName = XMLHelper.getAttr(tbl, "name", null);
                    tableHash.put(tName, true);
                }
            }
        }
    }

    public boolean isHidden(String disciplineType, String tableName) {
        Hashtable<String, Boolean> tableHash = this.disciplines.get(disciplineType);
        if (tableHash != null) {
            Boolean isHidden = tableHash.get(tableName);
            return isHidden != null && isHidden != false;
        }
        throw new RuntimeException("The discipline[" + disciplineType + "] was not found.");
    }
}

