/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.af.ui.forms.DataSetterForObj;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class GenericFormPanel
extends BaseSetupPanel {
    protected String[] fieldsNames = null;
    protected Hashtable<String, JComponent> comps = new Hashtable();
    protected FormDataObjIFace dataObj;
    protected DataGetterForObj getter = null;
    protected DataSetterForObj setter = null;
    protected Hashtable<String, Boolean> reqHash = null;
    protected CellConstraints cc = new CellConstraints();
    protected PanelBuilder builder = null;
    protected int row = 1;
    protected String[] labels;
    protected ArrayList<JComponent> compList = new ArrayList();

    public GenericFormPanel(String panelName, String helpContext, JButton nextBtn, JButton prevBtn) {
        this(panelName, helpContext, nextBtn, prevBtn, false);
    }

    public GenericFormPanel(String panelName, String helpContext, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        super(panelName, helpContext, nextBtn, prevBtn, makeStretchy);
    }

    public GenericFormPanel(String name, String title, String helpContext, String[] labels, String[] fields, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        this(null, name, title, helpContext, labels, fields, null, null, nextBtn, prevBtn, makeStretchy);
    }

    public GenericFormPanel(String name, String title, String helpContext, String[] labels, String[] fields, boolean[] required, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        this(null, name, title, helpContext, labels, fields, required, null, nextBtn, prevBtn, makeStretchy);
    }

    public GenericFormPanel(String name, String title, String helpContext, String[] labels, String[] fields, boolean[] required, Integer[] lengths, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        this(null, name, title, helpContext, labels, fields, required, lengths, nextBtn, prevBtn, makeStretchy);
    }

    public GenericFormPanel(FormDataObjIFace dataObj, String name, String title, String helpContext, String[] labels, String[] fields, boolean[] required, Integer[] lengths, JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        super(name, helpContext, nextBtn, prevBtn);
        this.dataObj = dataObj;
        this.fieldsNames = fields;
        this.makeStretchy = makeStretchy;
        this.labels = labels;
        this.init(title, fields, required, null, lengths);
    }

    public GenericFormPanel(String name, String title, String helpContext, String[] labels, String[] fields, String[] types, JButton nextBtn, JButton prevBtnBtn, boolean makeStretchy) {
        super(name, helpContext, nextBtn, prevBtnBtn);
        this.dataObj = null;
        this.fieldsNames = fields;
        this.makeStretchy = makeStretchy;
        this.labels = labels;
        this.init(title, fields, null, types, null);
    }

    public GenericFormPanel(String name, String title, String helpContext, String[] labels, String[] fields, Integer[] lengths, JButton nextBtn, JButton prevBtnBtn, boolean makeStretchy) {
        super(name, helpContext, nextBtn, prevBtnBtn);
        this.dataObj = null;
        this.fieldsNames = fields;
        this.makeStretchy = makeStretchy;
        this.labels = labels;
        this.init(title, fields, null, null, lengths);
    }

    protected void init(String title, String[] fields, boolean[] required, String[] types, Integer[] lens) {
        Pair<String, String> rowCol = this.getRowColDefs();
        this.builder = new PanelBuilder(new FormLayout((String)rowCol.first, (String)rowCol.second), (JPanel)this);
        this.row = 1;
        this.builder.add((Component)UIHelper.createI18NLabel(title, 0), this.cc.xywh(1, this.row, 4, 1));
        this.row += 2;
        if (required != null) {
            this.reqHash = new Hashtable();
        }
        int i = 0;
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String fName = stringArray[n2];
            if (fName.equals("-")) {
                JComponent c = this.builder.addSeparator(UIRegistry.getResourceString(this.labels[i]), this.cc.xyw(1, this.row, 4));
                this.compList.add(c);
            } else if (fName.equals(" ")) {
                JLabel lbl = UIHelper.createLabel("");
                this.builder.add((Component)lbl, this.cc.xyw(1, this.row, 4));
                this.compList.add(lbl);
            } else {
                if (this.reqHash != null) {
                    this.reqHash.put(fName, required[i]);
                }
                JComponent comp = types != null && types[i].equals("checkbox") ? this.createCheckBox(this.builder, this.labels[i], this.row) : this.createField(this.builder, this.labels[i], required != null ? required[i] : true, this.row, lens != null ? lens[i] : null);
                this.compList.add(comp);
                this.comps.put(fName, comp);
            }
            this.row += 2;
            ++i;
            ++n2;
        }
        this.updateBtnUI();
    }

    protected Pair<String, String> getRowColDefs() {
        String rowDef = "p,5px" + (this.fieldsNames.length > 0 ? "," + UIHelper.createDuplicateJGoodiesDef("p", "2px", this.fieldsNames.length) : "") + this.getAdditionalRowDefs() + ",p:g";
        return new Pair<String, String>("p,2px,p,f:p:g", rowDef);
    }

    protected String getAdditionalRowDefs() {
        return "";
    }

    public DataGetterForObj getGetter() {
        return this.getter;
    }

    public void setGetter(DataGetterForObj getter) {
        this.getter = getter;
    }

    public DataSetterForObj getSetter() {
        return this.setter;
    }

    public void setSetter(DataSetterForObj setter) {
        this.setter = setter;
    }

    @Override
    public void getValues(Properties props) {
        for (String fName : this.comps.keySet()) {
            Object dataVal;
            String val = null;
            JComponent comp = this.comps.get(fName);
            if (comp instanceof JTextField) {
                val = ((JTextField)comp).getText();
                props.put(fName, val);
            } else if (comp instanceof JCheckBox) {
                Boolean isChecked = ((JCheckBox)comp).isSelected();
                props.put(fName, isChecked);
            }
            if (this.dataObj == null || this.setter == null || val == null || (dataVal = this.getter.getFieldValue(this.dataObj, fName)) == null || dataVal.toString().equals(val)) continue;
            this.setter.setFieldValue(this.dataObj, fName, val);
        }
    }

    @Override
    public void setValues(Properties values) {
        this.properties = values;
        for (String fName : this.comps.keySet()) {
            Object dataVal;
            JComponent comp = this.comps.get(fName);
            if (!(comp instanceof JTextField)) continue;
            String val = values.getProperty(fName);
            if (this.dataObj != null && this.getter != null && (dataVal = this.getter.getFieldValue(this.dataObj, fName)) != null) {
                val = dataVal.toString();
            }
            ((JTextField)comp).setText(val);
            if (!StringUtils.isNotEmpty((String)val)) continue;
            ((JTextField)comp).setCaretPosition(0);
        }
    }

    @Override
    public boolean isUIValid() {
        int i = 0;
        for (String fName : this.comps.keySet()) {
            JComponent comp = this.comps.get(fName);
            if (comp instanceof JTextField && (this.reqHash == null || this.reqHash.get(fName).booleanValue()) && StringUtils.isEmpty((String)((JTextField)comp).getText())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        int i = 0;
        while (i < this.labels.length) {
            JComponent comp = this.compList.get(i);
            if (comp instanceof JTextField) {
                list.add(new Pair<String, String>(UIRegistry.getResourceString(this.labels[i]), ((JTextField)comp).getText()));
            } else if (comp instanceof JCheckBox) {
                JCheckBox chkbx = (JCheckBox)comp;
                list.add(new Pair<String, String>(UIRegistry.getResourceString(this.labels[i]), UIRegistry.getResourceString(Boolean.toString(chkbx.isSelected()))));
            }
            ++i;
        }
        return list;
    }

    @Override
    public void updateBtnUI() {
        if (this.nextBtn != null) {
            this.nextBtn.setEnabled(this.isUIValid());
        }
    }
}

