/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFormatterEditorDlg;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FormatterPickerPanel
extends BaseSetupPanel {
    protected JCheckBox isNumericChk = UIHelper.createCheckBox(UIRegistry.getResourceString("IS_NUM_CHK"));
    protected JComboBox formatterCBX = UIHelper.createComboBox(new DefaultComboBoxModel());
    protected JLabel isNumericLbl = UIHelper.createLabel(" ");
    protected JLabel patternLbl = UIHelper.createLabel(" ");
    protected JLabel autoIncLbl = UIHelper.createLabel(" ");
    protected boolean doingCatNums;
    protected List<UIFieldFormatterIFace> fmtList;
    protected UIFieldFormatterIFace newFormatter = null;
    protected int newFmtInx = 0;
    protected boolean wasUsed = false;
    protected String currFormatter;
    protected boolean doingDisciplineCollection = false;
    protected UIFieldFormatterMgr uiFldFmtMgr = UIFieldFormatterMgr.getInstance();

    public FormatterPickerPanel(String panelName, String helpContext, JButton nextBtn, JButton prevBtn, boolean doingCatNums, String currFormatter) {
        super(panelName, helpContext, nextBtn, prevBtn);
        this.doingCatNums = doingCatNums;
        this.currFormatter = currFormatter;
        this.formatterCBX.addActionListener(this.createFrmCBXAL());
        this.loadFormatCbx(null);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,4px,p,2px,p,f:p:g", "p,10px,p,4px,p,2px,p,2px,p"), (JPanel)this);
        int y = 1;
        String label = UIRegistry.getResourceString(doingCatNums ? "CHOOSE_FMT_CAT" : "CHOOSE_FMT_ACC");
        pb.add((Component)UIHelper.createLabel(label, 0), cc.xywh(1, y, 6, 1));
        JLabel lbl = UIHelper.createI18NFormLabel("FORMAT", 4);
        lbl.setFont(this.bold);
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.formatterCBX, cc.xy(3, y));
        y += 2;
        if (doingCatNums) {
            pb.add((Component)UIHelper.createI18NFormLabel("IS_NUM", 4), cc.xy(1, y));
            pb.add((Component)this.isNumericLbl, cc.xy(3, y));
            y += 2;
        }
        pb.add((Component)UIHelper.createI18NFormLabel("PATTERN", 4), cc.xy(1, y));
        pb.add((Component)this.patternLbl, cc.xy(3, y));
        pb.add((Component)UIHelper.createI18NFormLabel("IS_AUTO_INC", 4), cc.xy(1, y += 2));
        pb.add((Component)this.autoIncLbl, cc.xy(3, y));
        y += 2;
        nextBtn.setEnabled(false);
    }

    public void setDoingDisciplineCollection(boolean doingDisciplineColl) {
        this.doingDisciplineCollection = doingDisciplineColl;
    }

    protected void addFieldFormatter() {
        DBFieldInfo fieldInfo;
        DBTableInfo ti;
        if (this.doingCatNums) {
            ti = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
            fieldInfo = ti.getFieldByColumnName("CatalogNumber");
        } else {
            ti = DBTableIdMgr.getInstance().getInfoById(Accession.getClassTableId());
            fieldInfo = ti.getFieldByColumnName("AccessionNumber");
        }
        this.newFormatter = new UIFieldFormatter();
        UIFormatterEditorDlg dlg = new UIFormatterEditorDlg(null, fieldInfo, this.newFormatter, true, false, this.uiFldFmtMgr);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            if (this.newFormatter.isIncrementer()) {
                boolean isSingleField = this.newFormatter.getFields().size() == 1;
                AutoNumberIFace autoNum = this.doingCatNums ? UIFieldFormatterMgr.getInstance().createAutoNumber("edu.ku.brc.specify.dbsupport.CollectionAutoNumber", "edu.ku.brc.specify.datamodel.CollectionObject", "catalogNumber", isSingleField) : UIFieldFormatterMgr.getInstance().createAutoNumber("edu.ku.brc.af.core.db.AutoNumberGeneric", "edu.ku.brc.specify.datamodel.Accession", "accessionNumber", isSingleField);
                this.newFormatter.setAutoNumber(autoNum);
            }
        } else {
            this.newFormatter = null;
        }
        this.loadFormatCbx(this.newFormatter);
    }

    protected ActionListener createFrmCBXAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFieldFormatterIFace fmt;
                int index = FormatterPickerPanel.this.formatterCBX.getSelectedIndex();
                if (index > (FormatterPickerPanel.this.doingCatNums ? 0 : 1) && (fmt = FormatterPickerPanel.this.fmtList.get(index - (FormatterPickerPanel.this.doingCatNums ? 1 : 2))) != null) {
                    FormatterPickerPanel.this.isNumericLbl.setText(UIRegistry.getResourceString(fmt.isNumeric() ? "YES" : "NO"));
                    FormatterPickerPanel.this.patternLbl.setText(fmt.toPattern());
                    FormatterPickerPanel.this.autoIncLbl.setText(UIRegistry.getResourceString(fmt.isIncrementer() ? "YES" : "NO"));
                }
                if (FormatterPickerPanel.this.formatterCBX.getSelectedIndex() == FormatterPickerPanel.this.newFmtInx) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FormatterPickerPanel.this.addFieldFormatter();
                            FormatterPickerPanel.this.updateBtnUI();
                        }
                    });
                }
                FormatterPickerPanel.this.updateBtnUI();
            }
        };
    }

    protected void loadFormatCbx(UIFieldFormatterIFace selectedFmt) {
        ((DefaultComboBoxModel)this.formatterCBX.getModel()).removeAllElements();
        ActionListener[] actionListenerArray = this.formatterCBX.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener al = actionListenerArray[n2];
            this.formatterCBX.removeActionListener(al);
            ++n2;
        }
        this.fmtList = new Vector<UIFieldFormatterIFace>(this.uiFldFmtMgr.getFormatterList(this.doingCatNums ? CollectionObject.class : Accession.class));
        if (this.newFormatter != null) {
            this.fmtList.add(this.newFormatter);
        }
        Collections.sort(this.fmtList, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (!this.doingCatNums) {
            ((DefaultComboBoxModel)this.formatterCBX.getModel()).addElement(UIRegistry.getResourceString("NONE"));
            this.newFmtInx = 1;
        }
        ((DefaultComboBoxModel)this.formatterCBX.getModel()).addElement(UIRegistry.getResourceString("CREATE"));
        for (UIFieldFormatterIFace fmt : this.fmtList) {
            ((DefaultComboBoxModel)this.formatterCBX.getModel()).addElement(fmt.getName());
        }
        if (this.currFormatter != null) {
            this.formatterCBX.setSelectedItem(this.currFormatter);
            this.nextBtn.setEnabled(true);
        } else if (selectedFmt != null) {
            this.formatterCBX.setSelectedItem(selectedFmt.getName());
            this.nextBtn.setEnabled(true);
        } else {
            this.formatterCBX.setSelectedIndex(-1);
            this.nextBtn.setEnabled(false);
        }
        this.formatterCBX.addActionListener(this.createFrmCBXAL());
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this.wasUsed = true;
    }

    @Override
    public void getValues(Properties props) {
        if (this.wasUsed) {
            if (this.doingCatNums) {
                props.put("catnumfmt", this.newFormatter != null ? this.newFormatter : this.formatterCBX.getSelectedItem());
            } else if (this.formatterCBX.getSelectedIndex() > 1) {
                props.put("accnumfmt", this.newFormatter != null ? this.newFormatter : this.formatterCBX.getSelectedItem());
            } else {
                props.remove("accnumfmt");
            }
        }
    }

    @Override
    public void setValues(Properties values) {
        super.setValues(values);
        this.doingNext();
    }

    @Override
    public boolean isUIValid() {
        return !this.doingCatNums || this.formatterCBX.getSelectedIndex() > 0;
    }

    @Override
    public void updateBtnUI() {
        int inx = this.formatterCBX.getSelectedIndex();
        boolean enable = this.doingCatNums ? inx > 0 : inx != 1;
        this.nextBtn.setEnabled(enable);
    }

    @Override
    public void doingNext() {
        this.updateBtnUI();
        Institution institution = null;
        Boolean isAccGlobal = null;
        if (!this.doingCatNums) {
            if (AppContextMgr.getInstance() != null && AppContextMgr.getInstance().hasContext() && (institution = AppContextMgr.getInstance().getClassObject(Institution.class)) != null) {
                isAccGlobal = institution.getIsAccessionsGlobal();
            }
            isAccGlobal = isAccGlobal == null && this.properties != null ? Boolean.valueOf((isAccGlobal = (Boolean)this.properties.get("accglobal")) == null ? false : isAccGlobal) : Boolean.valueOf(false);
            if (institution != null && !this.doingDisciplineCollection) {
                this.formatterCBX.setEnabled(isAccGlobal == false);
            } else if (this.currFormatter != null || isAccGlobal.booleanValue() && institution != null || this.doingDisciplineCollection) {
                this.formatterCBX.setEnabled(false);
            }
        }
    }

    @Override
    public void doingPrev() {
        this.updateBtnUI();
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        String lbl = String.valueOf(UIRegistry.getResourceString(this.doingCatNums ? "CollectionObject" : "Accession")) + " " + UIRegistry.getResourceString("Formatter");
        String value = this.formatterCBX.getSelectedIndex() == -1 ? "" : this.formatterCBX.getSelectedItem().toString();
        list.add(new Pair<String, String>(lbl, value));
        return list;
    }
}

