/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class DisciplinePanel
extends BaseSetupPanel {
    protected JTextField disciplineName;
    protected JComboBox disciplines;

    public DisciplinePanel(String helpContext, JButton nextBtn, JButton prevBtn) {
        super("DISCIPLINE", helpContext, nextBtn, prevBtn);
        String header = String.valueOf(UIRegistry.getResourceString("DISP_INFO")) + ":";
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,6px,p,2px,p"), (JPanel)this);
        int row = 1;
        builder.add((Component)UIHelper.createLabel(header, 0), cc.xywh(1, row, 3, 1));
        row += 2;
        Vector<DisciplineType> dispList = new Vector<DisciplineType>();
        for (DisciplineType disciplineType : DisciplineType.getDisciplineList()) {
            if (disciplineType.getType() != 0) continue;
            dispList.add(disciplineType);
        }
        Collections.sort(dispList);
        this.disciplines = UIHelper.createComboBox(dispList);
        this.disciplines.setSelectedIndex(-1);
        JLabel lbl = UIHelper.createI18NFormLabel("DSP_TYPE", 4);
        lbl.setFont(this.bold);
        builder.add((Component)lbl, cc.xy(1, row));
        builder.add((Component)this.disciplines, cc.xy(3, row));
        this.makeStretchy = true;
        this.disciplineName = this.createField(builder, "DISP_NAME", true, row += 2, 64);
        row += 2;
        this.updateBtnUI();
        this.disciplines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisciplinePanel.this.updateBtnUI();
                if (DisciplinePanel.this.disciplines.getSelectedIndex() > -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DisciplineType dt = (DisciplineType)(this).DisciplinePanel.this.disciplines.getSelectedItem();
                            (this).DisciplinePanel.this.disciplineName.setText(dt.getTitle());
                        }
                    });
                }
            }
        });
    }

    @Override
    public void getValues(Properties props) {
        props.put("dispName", this.disciplineName.getText());
        props.put("disciplineType", this.getDisciplineType());
    }

    @Override
    public void setValues(Properties values) {
        this.disciplineName.setText(values.getProperty("dispName"));
    }

    @Override
    public void updateBtnUI() {
        boolean isValid = this.isUIValid();
        if (this.nextBtn != null) {
            this.nextBtn.setEnabled(isValid);
        }
    }

    @Override
    public boolean isUIValid() {
        String name = this.disciplineName.getText();
        if (DBConnection.getInstance().getConnection() != null && StringUtils.isNotEmpty((String)name) && this.disciplines.getSelectedIndex() > -1) {
            int cnt = BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM discipline WHERE Name = '%s'", name));
            if (cnt > 0) {
                UIRegistry.showLocalizedError("DISPNAME_DUP", name);
                return false;
            }
            return true;
        }
        return false;
    }

    public String getDisciplineTitle() {
        return this.disciplineName.getText();
    }

    public DisciplineType getDisciplineType() {
        return (DisciplineType)this.disciplines.getSelectedItem();
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        list.add(new Pair<String, String>(UIRegistry.getResourceString("DSP_TYPE"), this.disciplines.getSelectedItem().toString()));
        list.add(new Pair<String, String>(UIRegistry.getResourceString("DSP_NAME"), this.disciplineName.getText()));
        return list;
    }
}

