/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizardFrame;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.tools.SpecifySchemaGenerator;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DatabasePanel
extends BaseSetupPanel {
    protected final String PROPNAME = "PROPNAME";
    protected final String DBNAME = "dbName";
    protected final String HOSTNAME = "hostName";
    protected final String DBPWD = "dbPassword";
    protected final String DBUSERNAME = "dbUserName";
    protected JTextField usernameTxt;
    protected JTextField passwordTxt;
    protected JTextField dbNameTxt;
    protected JTextField hostNameTxt;
    protected JComboBox drivers;
    protected Vector<DatabaseDriverInfo> driverList;
    protected boolean doSetDefaultValues;
    protected boolean isOKForCreateBtn = false;
    protected Boolean isOK = null;
    protected JButton createDBBtn;
    protected JLabel label;
    protected String errorKey = null;
    protected JButton skipStepBtn;
    protected boolean manualLoginOK = false;
    protected JLabel advLabel;
    protected boolean checkForProcesses = true;

    public DatabasePanel(JButton nextBtn, JButton prevBtn, String helpContext, boolean doSetDefaultValues) {
        super("DATABASE", helpContext, nextBtn, prevBtn);
        this.doSetDefaultValues = doSetDefaultValues;
        String header = String.valueOf(UIRegistry.getResourceString("ENTER_DB_INFO")) + ":";
        CellConstraints cc = new CellConstraints();
        String rowDef = "p,2px," + UIHelper.createDuplicateJGoodiesDef("p", "2px", 5) + ",10px,p,10px,p,4px,p,4px,p";
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p:g", rowDef), (JPanel)this);
        int row = 1;
        builder.add((Component)UIHelper.createLabel(header, 0), cc.xywh(1, row, 3, 1));
        this.usernameTxt = this.createField(builder, "IT_USERNAME", true, row += 2);
        this.passwordTxt = this.createField(builder, "IT_PASSWORD", true, row += 2, true, null);
        this.dbNameTxt = this.createField(builder, "DB_NAME", true, row += 2);
        this.hostNameTxt = this.createField(builder, "HOST_NAME", true, row += 2);
        row += 2;
        this.driverList = DatabaseDriverInfo.getDriversList();
        this.drivers = UIHelper.createComboBox(this.driverList);
        this.drivers.setSelectedItem(DatabaseDriverInfo.getDriver("MySQL"));
        JLabel lbl = UIHelper.createI18NFormLabel("DRIVER", 4);
        lbl.setFont(this.bold);
        builder.add((Component)lbl, cc.xy(1, row));
        builder.add((Component)this.drivers, cc.xy(3, row));
        row += 2;
        this.label = UIHelper.createLabel("", 0);
        this.createDBBtn = UIHelper.createI18NButton("CREATE_DB");
        PanelBuilder tstPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        tstPB.add((Component)this.createDBBtn, cc.xy(2, 1));
        PanelBuilder panelPB = new PanelBuilder(new FormLayout("f:p:g", "20px,p,2px,p,8px,p"));
        panelPB.add((Component)tstPB.getPanel(), cc.xy(1, 2));
        panelPB.add((Component)this.getProgressBar(), cc.xy(1, 4));
        panelPB.add((Component)this.label, cc.xy(1, 6));
        builder.add((Component)panelPB.getPanel(), cc.xy(3, row));
        this.advLabel = UIHelper.createI18NLabel("ADV_DB_DESC", 0);
        this.skipStepBtn = UIHelper.createI18NButton("ADV_DB_TEST");
        JComponent sep = builder.addSeparator(UIRegistry.getResourceString("ADV_TITLE"), cc.xyw(3, row += 2, 1));
        builder.add((Component)this.advLabel, cc.xyw(3, row += 2, 1));
        tstPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p"));
        tstPB.add((Component)this.skipStepBtn, cc.xy(2, 1));
        builder.add((Component)tstPB.getPanel(), cc.xyw(3, row += 2, 1));
        row += 2;
        this.skipStepBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabasePanel.this.createDBBtn.setEnabled(false);
                DatabasePanel.this.skipStepBtn.setEnabled(false);
                boolean ok = DatabasePanel.this.skipDBCreate();
                DatabasePanel.this.createDBBtn.setEnabled(true);
                DatabasePanel.this.skipStepBtn.setEnabled(true);
                DatabasePanel.this.advLabel.setText(UIRegistry.getResourceString(ok ? "ADV_DB_OK" : "ADV_DB_ERR"));
            }
        });
        this.createDBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabasePanel.this.createDB();
            }
        });
        if (UIRegistry.isMobile()) {
            this.skipStepBtn.setVisible(false);
            this.advLabel.setVisible(false);
            sep.setVisible(false);
        }
        this.progressBar.setVisible(false);
        this.updateBtnUI();
    }

    @Override
    public void getValues(Properties props) {
        props.put("dbUserName", this.usernameTxt.getText());
        props.put("dbPassword", this.passwordTxt.getText());
        props.put("dbName", this.dbNameTxt.getText());
        props.put("hostName", this.hostNameTxt.getText());
        props.put("driver", this.drivers.getSelectedItem().toString());
        props.put("driverObj", this.drivers.getSelectedItem());
    }

    @Override
    protected void textChanged(JTextField txt) {
        super.textChanged(txt);
        if (this.isOK != null && !this.isOK.booleanValue()) {
            this.isOK = null;
            this.createDBBtn.setVisible(true);
            this.label.setText(" ");
        }
    }

    protected void setUIEnabled(boolean enable) {
        this.usernameTxt.setEnabled(enable);
        this.passwordTxt.setEnabled(enable);
        this.dbNameTxt.setEnabled(enable);
        this.hostNameTxt.setEnabled(enable);
        this.drivers.setEnabled(enable);
        this.createDBBtn.setEnabled(enable);
        this.skipStepBtn.setEnabled(enable);
    }

    @Override
    public void setValues(Properties values) {
        super.setValues(values);
        this.usernameTxt.setText(values.getProperty("dbUserName"));
        this.passwordTxt.setText(values.getProperty("dbPassword"));
        this.dbNameTxt.setText(values.getProperty("dbName"));
        this.hostNameTxt.setText(values.getProperty("hostName"));
        if (this.doSetDefaultValues) {
            this.drivers.setSelectedIndex(0);
        }
    }

    protected boolean skipDBCreate() {
        this.getValues(this.properties);
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        String dbUserName = this.usernameTxt.getText();
        String dbPwd = this.passwordTxt.getText();
        String hostName = this.hostNameTxt.getText();
        String databaseName = this.dbNameTxt.getText();
        DatabaseDriverInfo driverInfo = (DatabaseDriverInfo)this.drivers.getSelectedItem();
        String newConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, "", dbUserName, dbPwd, driverInfo.getName());
        DBConnection.checkForEmbeddedDir(newConnStr);
        try {
            if (mgr.connectToDBMS(dbUserName, dbPwd, hostName)) {
                newConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, databaseName, dbUserName, dbPwd, driverInfo.getName());
                DBConnection dbc = DBConnection.getInstance();
                dbc.setConnectionStr(newConnStr);
                dbc.setDriver(driverInfo.getDriverClassName());
                dbc.setDialect(driverInfo.getDialectClassName());
                dbc.setDriverName(driverInfo.getName());
                dbc.setServerName(hostName);
                dbc.setUsernamePassword(dbUserName, dbPwd);
                dbc.setDatabaseName(databaseName);
                boolean canCont = this.isOK == null || this.isOK != false || this.manualLoginOK;
                this.nextBtn.setEnabled(canCont);
                if (canCont) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatabasePanel.this.nextBtn.doClick();
                        }
                    });
                }
                mgr.close();
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void createDB() {
        this.getValues(this.properties);
        final String databaseName = this.dbNameTxt.getText();
        final String dbUserName = this.usernameTxt.getText();
        final String dbPwd = this.passwordTxt.getText();
        final String hostName = this.hostNameTxt.getText();
        if (UIRegistry.isMobile()) {
            DBConnection.clearMobileMachineDir();
            File tmpDir = DBConnection.getMobileMachineDir(databaseName);
            UIRegistry.setEmbeddedDBPath(tmpDir.getAbsolutePath());
        }
        final DatabaseDriverInfo driverInfo = (DatabaseDriverInfo)this.drivers.getSelectedItem();
        String connStrInitial = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, databaseName, dbUserName, dbPwd, driverInfo.getName());
        DBConnection.checkForEmbeddedDir("createDB - " + connStrInitial);
        DBConnection.getInstance().setDriverName(driverInfo.getName());
        DBConnection.getInstance().setServerName(hostName);
        VerifyStatus status = this.verifyDatabase(this.properties);
        if (!(this.isOK != null && this.isOK.booleanValue() || status != VerifyStatus.OK)) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
            this.label.setText(UIRegistry.getResourceString("CONN_DB"));
            this.createDBBtn.setVisible(false);
            this.setUIEnabled(false);
            this.label.setForeground(Color.BLACK);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    block17: {
                        DatabasePanel.this.isOK = false;
                        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
                        boolean dbmsOK = false;
                        if (driverInfo.isEmbedded()) {
                            File mobileTmpDir;
                            if (DatabasePanel.this.checkForProcesses) {
                                SpecifyDBSetupWizardFrame.checkForMySQLProcesses();
                                DatabasePanel.this.checkForProcesses = false;
                            }
                            if (UIRegistry.isMobile() && !(mobileTmpDir = DBConnection.getMobileMachineDir()).exists()) {
                                if (!mobileTmpDir.mkdirs()) {
                                    System.err.println("Dir[" + mobileTmpDir.getAbsolutePath() + "] didn't get created!");
                                }
                                DBConnection.setCopiedToMachineDisk(true);
                            }
                            String newConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, databaseName, dbUserName, dbPwd, driverInfo.getName());
                            if (driverInfo.isEmbedded()) {
                                try {
                                    Class.forName(driverInfo.getDriverClassName());
                                    DBConnection testDB = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), databaseName, newConnStr, dbUserName, dbPwd);
                                    testDB.getConnection();
                                    if (testDB != null) {
                                        testDB.close();
                                    }
                                    dbmsOK = true;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                DBConnection.getInstance().setDatabaseName(null);
                            }
                        } else if (mgr.connectToDBMS(dbUserName, dbPwd, hostName)) {
                            mgr.close();
                            dbmsOK = true;
                        }
                        if (dbmsOK) {
                            this.firePropertyChange("PROPNAME", 0, 1);
                            try {
                                SpecifySchemaGenerator.generateSchema(driverInfo, hostName, databaseName, dbUserName, dbPwd);
                                String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, hostName, databaseName);
                                if (connStr == null) {
                                    connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, databaseName);
                                }
                                this.firePropertyChange("PROPNAME", 0, 2);
                                if (UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), DatabasePanel.this.dbNameTxt.getText(), connStr, dbUserName, dbPwd)) {
                                    if (!DatabasePanel.this.checkEngineCharSet(DatabasePanel.this.properties)) {
                                        return false;
                                    }
                                    DatabasePanel.this.isOK = true;
                                    this.firePropertyChange("PROPNAME", 0, 3);
                                    Thumbnailer thumb = new Thumbnailer();
                                    File thumbFile = XMLHelper.getConfigDir("thumbnail_generators.xml");
                                    thumb.registerThumbnailers(thumbFile);
                                    thumb.setQuality(0.5f);
                                    thumb.setMaxHeight(128);
                                    thumb.setMaxWidth(128);
                                    File attLoc = UIRegistry.getAppDataSubDir("AttachmentStorage", true);
                                    FileUtils.cleanDirectory((File)attLoc);
                                    FileStoreAttachmentManager attachMgr = new FileStoreAttachmentManager(attLoc);
                                    AttachmentUtils.setAttachmentManager(attachMgr);
                                    AttachmentUtils.setThumbnailer(thumb);
                                    break block17;
                                }
                                DatabasePanel.this.errorKey = "NO_LOGIN_ROOT";
                            }
                            catch (Exception ex) {
                                DatabasePanel.this.errorKey = "DB_UNRECOVERABLE";
                            }
                        } else {
                            DatabasePanel.this.errorKey = "NO_CONN_ROOT";
                            mgr.close();
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    DatabasePanel.this.setUIEnabled(true);
                    DatabasePanel.this.progressBar.setIndeterminate(false);
                    DatabasePanel.this.progressBar.setVisible(false);
                    DatabasePanel.this.updateBtnUI();
                    DatabasePanel.this.createDBBtn.setVisible(DatabasePanel.this.isOK == false);
                    if (DatabasePanel.this.isOK.booleanValue()) {
                        DatabasePanel.this.label.setText(UIRegistry.getResourceString("DB_CREATED"));
                        DatabasePanel.this.setUIEnabled(false);
                    } else {
                        DatabasePanel.this.label.setText(UIRegistry.getResourceString(DatabasePanel.this.errorKey != null ? DatabasePanel.this.errorKey : "ERR_CRE_DB"));
                        UIRegistry.showLocalizedError(DatabasePanel.this.errorKey != null ? DatabasePanel.this.errorKey : "ERR_CRE_DB");
                    }
                }
            };
            worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("PROPNAME".equals(evt.getPropertyName())) {
                        String key = null;
                        switch ((Integer)evt.getNewValue()) {
                            case 1: {
                                key = "BLD_SCHEMA";
                                break;
                            }
                            case 2: {
                                key = "DB_FRST_LOGIN";
                                break;
                            }
                            case 3: {
                                key = "BLD_CACHE";
                                break;
                            }
                        }
                        if (key != null) {
                            DatabasePanel.this.label.setText(UIRegistry.getResourceString(key));
                        }
                    }
                }
            });
            worker.execute();
        } else if (status == VerifyStatus.ERROR) {
            this.errorKey = "NO_LOGIN_ROOT";
            this.label.setText(UIRegistry.getResourceString(this.errorKey));
            this.label.setForeground(Color.RED);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.getTopWindow().pack();
                }
            });
        }
    }

    @Override
    public void updateBtnUI() {
        boolean isValid = this.isUIValid();
        if (this.nextBtn != null) {
            boolean canCont = isValid && (this.isOK == null || this.isOK != false || this.manualLoginOK);
            this.nextBtn.setEnabled(canCont);
            if (canCont) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DatabasePanel.this.nextBtn.doClick();
                    }
                });
            }
        }
        if (this.createDBBtn != null) {
            this.createDBBtn.setEnabled(this.isOKForCreateBtn);
        }
    }

    public static boolean checkForValidText(JLabel label, String text, String badKeyArg, String errKeyArg, boolean isPwd) {
        String errKey = null;
        if (!(isPwd || text.isEmpty() || StringUtils.isAlpha((String)text.substring(0, 1)))) {
            errKey = badKeyArg;
        } else if (StringUtils.contains((String)text, (char)' ') || StringUtils.contains((String)text, (char)',')) {
            errKey = errKeyArg;
        }
        if (errKey != null) {
            label.setForeground(Color.RED);
            label.setText(UIRegistry.getResourceString(errKeyArg));
            label.setVisible(true);
            return false;
        }
        return true;
    }

    @Override
    public boolean isUIValid() {
        JTextField[] txtFields;
        this.label.setText("");
        JTextField[] jTextFieldArray = txtFields = new JTextField[]{this.usernameTxt, this.passwordTxt, this.dbNameTxt};
        int n = txtFields.length;
        int n2 = 0;
        while (n2 < n) {
            JTextField tf = jTextFieldArray[n2];
            if (StringUtils.isEmpty((String)tf.getText())) {
                this.isOKForCreateBtn = false;
                return false;
            }
            ++n2;
        }
        this.isOKForCreateBtn = true;
        if (!(DatabasePanel.checkForValidText(this.label, this.dbNameTxt.getText(), "ERR_BAD_DBNAME", "NO_SPC_DBNAME", false) && DatabasePanel.checkForValidText(this.label, this.usernameTxt.getText(), "ERR_BAD_USRNAME", "NO_SPC_USRNAME", false) && DatabasePanel.checkForValidText(this.label, this.passwordTxt.getText(), null, "NO_SPC_PWDNAME", false))) {
            this.isOK = false;
            this.isOKForCreateBtn = false;
        }
        return this.isOK != null && this.isOK != false || this.manualLoginOK;
    }

    public DatabaseDriverInfo getDriver() {
        return (DatabaseDriverInfo)this.drivers.getSelectedItem();
    }

    public String getDbName() {
        return this.dbNameTxt.getText();
    }

    public String getPassword() {
        return this.passwordTxt.getText();
    }

    public String getUsername() {
        return this.usernameTxt.getText();
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        String pwd = this.passwordTxt.getText();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pwd.length()) {
            sb.append('*');
            ++i;
        }
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        list.add(new Pair<String, String>(UIRegistry.getResourceString("IT_USERNAME"), this.usernameTxt.getText()));
        list.add(new Pair<String, String>(UIRegistry.getResourceString("IT_PASSWORD"), sb.toString()));
        list.add(new Pair<String, String>(UIRegistry.getResourceString("DB_NAME"), this.dbNameTxt.getText()));
        list.add(new Pair<String, String>(UIRegistry.getResourceString("HOST_NAME"), this.hostNameTxt.getText()));
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected VerifyStatus verifyDatabase(Properties props) {
        boolean isEmbedded = DBConnection.getInstance().isEmbedded();
        String databaseName = props.getProperty("dbName");
        if (isEmbedded) {
            File specifyDataDir = null;
            if (UIRegistry.isMobile()) {
                specifyDataDir = DBConnection.getMobileMachineDir();
                if (specifyDataDir == null) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, new RuntimeException("DBConnection.getMobileTempDir() return null"));
                }
                UIRegistry.setMobileEmbeddedDBPath(UIRegistry.getDefaultMobileEmbeddedDBPath(databaseName));
            } else {
                specifyDataDir = DBConnection.getEmbeddedDataDir();
            }
            if (specifyDataDir != null) {
                if (!specifyDataDir.exists()) return VerifyStatus.OK;
                boolean isOKay = UIHelper.promptForAction("PROCEED", "CANCEL", "DEL_CUR_DB_TITLE", UIRegistry.getLocalizedMessage("DEL_CUR_DB", databaseName));
                if (!isOKay) return VerifyStatus.CANCELLED;
                try {
                    FileUtils.deleteDirectory((File)specifyDataDir);
                    return VerifyStatus.OK;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyDBSetupWizard.class, new Exception("The Embedded Data Dir has not been set"));
                    return VerifyStatus.ERROR;
                }
            } else {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyDBSetupWizard.class, new Exception("The Embedded Data Dir has not been set"));
                return VerifyStatus.ERROR;
            }
        }
        switch (this.isOkToProceed(props)) {
            case ok: 
            case missingDB: {
                return VerifyStatus.OK;
            }
            case error: {
                return VerifyStatus.ERROR;
            }
            case cancelled: {
                return VerifyStatus.CANCELLED;
            }
        }
        return VerifyStatus.ERROR;
    }

    private DBMSUserMgr.DBSTATUS isOkToProceed(Properties props) {
        String databaseName = props.getProperty("dbName");
        String itUsername = props.getProperty("dbUserName");
        String itPassword = props.getProperty("dbPassword");
        String hostName = props.getProperty("hostName");
        return DBMSUserMgr.isOkToProceed(databaseName, hostName, itUsername, itPassword);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkEngineCharSet(Properties props) {
        String databaseName = props.getProperty("dbName");
        DBMSUserMgr mgr = null;
        try {
            String itUsername = props.getProperty("dbUserName");
            String itPassword = props.getProperty("dbPassword");
            String hostName = props.getProperty("hostName");
            if (DBConnection.getInstance().isEmbedded()) return true;
            mgr = DBMSUserMgr.getInstance();
            if (!mgr.connectToDBMS(itUsername, itPassword, hostName)) return false;
            if (mgr.verifyEngineAndCharSet(databaseName)) return true;
            String errMsg = mgr.getErrorMsg();
            if (errMsg == null) return false;
            Object[] options = new Object[]{UIRegistry.getResourceString("CLOSE")};
            JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), errMsg, UIRegistry.getResourceString("DEL_CUR_DB_TITLE"), 0, 3, null, options, options[0]);
            return false;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyDBSetupWizard.class, ex);
            return false;
        }
        finally {
            if (mgr != null) {
                mgr.close();
            }
        }
    }

    private static enum VerifyStatus {
        OK,
        CANCELLED,
        ERROR;

    }
}

