/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.auth.specify.permission.PermissionService;
import edu.ku.brc.af.auth.specify.policy.DatabaseService;
import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.GroupPrincipal;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.init.BldrPickList;
import edu.ku.brc.specify.config.init.BldrPickListItem;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.AccessionAuthorization;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AgentVariant;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.Author;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Borrow;
import edu.ku.brc.specify.datamodel.BorrowAgent;
import edu.ku.brc.specify.datamodel.BorrowMaterial;
import edu.ku.brc.specify.datamodel.BorrowReturnMaterial;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttr;
import edu.ku.brc.specify.datamodel.CollectingTrip;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttr;
import edu.ku.brc.specify.datamodel.CollectionObjectCitation;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Deaccession;
import edu.ku.brc.specify.datamodel.DeaccessionAgent;
import edu.ku.brc.specify.datamodel.DeaccessionPreparation;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.DeterminationCitation;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.GroupPerson;
import edu.ku.brc.specify.datamodel.InfoRequest;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.Journal;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanAgent;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.LoanReturnPreparation;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.LocalityCitation;
import edu.ku.brc.specify.datamodel.LocalityDetail;
import edu.ku.brc.specify.datamodel.OtherIdentifier;
import edu.ku.brc.specify.datamodel.Permit;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationAttr;
import edu.ku.brc.specify.datamodel.Project;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.specify.datamodel.Shipment;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonCitation;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.BaseTask;
import edu.ku.brc.specify.tasks.ExportMappingTask;
import edu.ku.brc.specify.tasks.PermissionOptionPersist;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.hibernate.Session;

public class DataBuilder {
    protected static Calendar startCal = Calendar.getInstance();
    protected static Session session = null;
    protected static Map<String, Pair<String, Byte>> usertypeToDefaultGroup;

    public static Session getSession() {
        return session;
    }

    public static void setSession(Session session) {
        DataBuilder.session = session;
    }

    public static AccessionAgent createAccessionAgent(Accession accession, Agent agent) {
        AccessionAgent accessionAgent = new AccessionAgent();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        accessionAgent.setTimestampCreated(now);
        accessionAgent.setAccession(accession);
        accessionAgent.setAgent(agent);
        DataBuilder.persist(accessionAgent);
        return accessionAgent;
    }

    public static AgentVariant createAgentVariant(Byte varType, String name, Agent agentOwner) {
        AgentVariant av = new AgentVariant();
        av.initialize();
        av.setVarType(varType);
        av.setName(name);
        av.setAgent(agentOwner);
        agentOwner.getVariants().add(av);
        return av;
    }

    public static Institution createInstitution(String name) {
        Institution inst = new Institution();
        inst.initialize();
        inst.setName(name);
        DataBuilder.persist(inst);
        return inst;
    }

    public static Division createDivision(Institution inst, String discipline, String name, String abbrev, String title) {
        Division division = new Division();
        division.initialize();
        division.setName(name);
        division.setDiscipline(discipline);
        division.setAbbrev(abbrev);
        division.setTitle(title);
        inst.addReference(division, "divisions");
        DataBuilder.persist(division);
        return division;
    }

    public static GroupPerson createGroupPerson(Agent group, Agent agent, int order, Division division) {
        GroupPerson groupPerson = new GroupPerson();
        groupPerson.initialize();
        groupPerson.setOrderIndex(order);
        groupPerson.setDivision(division);
        groupPerson.setMember(agent);
        groupPerson.setGroup(group);
        agent.getGroups().add(groupPerson);
        group.getMembers().add(groupPerson);
        return groupPerson;
    }

    public static Agent createAgent(String title, String firstName, String middleInit, String lastName, String abbreviation, String email) {
        return DataBuilder.createAgent(title, firstName, middleInit, lastName, abbreviation, email, null, null);
    }

    public static Agent createAgent(String title, String firstName, String middleInit, String lastName, String abbreviation, String email, Division division, Discipline discipline) {
        Agent agent = new Agent();
        agent.initialize();
        agent.setAgentType((byte)1);
        agent.setFirstName(firstName);
        agent.setLastName(lastName);
        agent.setMiddleInitial(middleInit);
        agent.setAbbreviation(abbreviation);
        agent.setTitle(title);
        agent.setEmail(email);
        if (division == null) {
            Division div = AppContextMgr.getInstance().getClassObject(Division.class);
            if (div == null) {
                throw new RuntimeException("Division is NULL!");
            }
            agent.setDivision(div);
        } else {
            agent.setDivision(division);
        }
        DataBuilder.persist(agent);
        return agent;
    }

    public static Attachment createAttachment(String filename, String mimeType) {
        Attachment attachment = new Attachment();
        attachment.initialize();
        attachment.setOrigFilename(filename);
        attachment.setMimeType(mimeType);
        DataBuilder.persist(attachment);
        return attachment;
    }

    public static SpQuery createQuery(String name, String contextName, int contextTableId, SpecifyUser owner, Agent agent) {
        SpQuery query = new SpQuery();
        query.initialize();
        query.setName(name);
        query.setContextName(contextName);
        query.setContextTableId((short)contextTableId);
        query.setCreatedByAgent(agent);
        query.setSpecifyUser(owner);
        return query;
    }

    public static CollectionRelType createCollectionRelType(String name, Collection leftSideCollection, Collection rightSideCollection) {
        CollectionRelType crt = new CollectionRelType();
        crt.initialize();
        crt.setName(name);
        crt.setLeftSideCollection(leftSideCollection);
        crt.setRightSideCollection(rightSideCollection);
        rightSideCollection.getRightSideRelTypes().add(crt);
        leftSideCollection.getLeftSideRelTypes().add(crt);
        return crt;
    }

    public static SpQueryField createQueryField(SpQuery query, Short position, String fieldName, String fieldAlias, Boolean isNot, Byte operStart, Byte operEnd, String startValue, String endValue, Byte sortType, Boolean isDisplay, String tableList, int contextTableIdent) {
        SpQueryField field = new SpQueryField();
        field.initialize();
        field.setPosition(position);
        field.setFieldName(fieldName);
        field.setColumnAlias(fieldAlias);
        field.setOperStart(operStart);
        field.setOperEnd(operEnd);
        field.setEndValue(endValue);
        field.setIsDisplay(isDisplay);
        field.setIsNot(isNot);
        field.setSortType(sortType);
        field.setStartValue(startValue);
        field.setTableList(tableList);
        field.setContextTableIdent(contextTableIdent);
        field.setIsPrompt(true);
        query.addReference(field, "fields");
        return field;
    }

    public static AttributeDef createAttributeDef(AttributeIFace.FieldType type, String name, Discipline discipline, PrepType prepType) {
        AttributeDef attrDef = new AttributeDef();
        attrDef.initialize();
        attrDef.setDataType(type.getType());
        attrDef.setFieldName(name);
        attrDef.setPrepType(prepType);
        attrDef.setDiscipline(discipline);
        discipline.getAttributeDefs().add(attrDef);
        return attrDef;
    }

    public static Discipline createDiscipline(Division division, String type, String name, DataType dataType, TaxonTreeDef taxonTreeDef, GeographyTreeDef geographyTreeDef, GeologicTimePeriodTreeDef geologicTimePeriodTreeDef, LithoStratTreeDef lithoStratTreeDef) {
        Discipline discipline = new Discipline();
        discipline.initialize();
        discipline.setType(type);
        discipline.setName(name);
        discipline.setDataType(dataType);
        discipline.setTaxonTreeDef(taxonTreeDef);
        discipline.setGeographyTreeDef(geographyTreeDef);
        discipline.setGeologicTimePeriodTreeDef(geologicTimePeriodTreeDef);
        discipline.setLithoStratTreeDef(lithoStratTreeDef);
        geographyTreeDef.getDisciplines().add(discipline);
        geologicTimePeriodTreeDef.getDisciplines().add(discipline);
        lithoStratTreeDef.getDisciplines().add(discipline);
        taxonTreeDef.setDiscipline(discipline);
        division.addReference(discipline, "disciplines");
        DataBuilder.persist(discipline);
        return discipline;
    }

    public static Collection createCollection(String prefix, String name, String catalogNumFormatName, AutoNumberingScheme catalogNumberingScheme, Discipline[] disciplines, boolean isEmbeddedCollectingEvent) {
        Collection collection = new Collection();
        collection.initialize();
        collection.setCatalogNumFormatName(catalogNumFormatName);
        collection.setCode(prefix);
        collection.setModifiedByAgent(null);
        collection.setCollectionName(name);
        collection.setIsEmbeddedCollectingEvent(isEmbeddedCollectingEvent);
        if (catalogNumberingScheme != null) {
            collection.getNumberingSchemes().add(catalogNumberingScheme);
            catalogNumberingScheme.getCollections().add(collection);
        }
        Discipline[] disciplineArray = disciplines;
        int n = disciplines.length;
        int n2 = 0;
        while (n2 < n) {
            Discipline disp = disciplineArray[n2];
            collection.setDiscipline(disp);
            ++n2;
        }
        DataBuilder.persist(collection);
        if (catalogNumberingScheme != null) {
            DataBuilder.persist(catalogNumberingScheme);
        }
        return collection;
    }

    public static Collection createCollection(String prefix, String name, String catalogNumFormatName, AutoNumberingScheme numberingScheme, Discipline discipline) {
        return DataBuilder.createCollection(prefix, name, catalogNumFormatName, numberingScheme, discipline, true);
    }

    public static Collection createCollection(String prefix, String name, String catalogNumFormatName, AutoNumberingScheme numberingScheme, Discipline discipline, boolean isEmbeddedCE) {
        return DataBuilder.createCollection(prefix, name, catalogNumFormatName, numberingScheme, new Discipline[]{discipline}, isEmbeddedCE);
    }

    public static CollectingEvent createCollectingEvent(Locality locality, Calendar startDate, String stationFieldNumber, Collector[] collectors) {
        CollectingEvent colEv = new CollectingEvent();
        colEv.initialize();
        colEv.setStartDate(startDate);
        colEv.setStationFieldNumber(stationFieldNumber);
        HashSet<Collector> collectorSet = new HashSet<Collector>();
        if (collectors != null) {
            Collector[] collectorArray = collectors;
            int n = collectors.length;
            int n2 = 0;
            while (n2 < n) {
                Collector c = collectorArray[n2];
                c.setCollectingEvent(colEv);
                collectorSet.add(c);
                ++n2;
            }
        }
        colEv.setCollectors(collectorSet);
        colEv.setLocality(locality);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        colEv.setTimestampCreated(now);
        DataBuilder.persist(colEv);
        DataBuilder.persist(locality);
        return colEv;
    }

    public static CollectingTrip createCollectingTrip(String collectingTripName, String remarks, CollectingEvent[] events) {
        CollectingTrip trip = new CollectingTrip();
        trip.initialize();
        trip.setCollectingTripName(collectingTripName);
        trip.setRemarks(remarks);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        trip.setTimestampCreated(now);
        Calendar startDate = Calendar.getInstance();
        startDate.set(9999, 12, 31);
        Calendar endDate = Calendar.getInstance();
        endDate.set(1, 1, 1);
        String verStartDate = null;
        String verEndDate = null;
        CollectingEvent[] collectingEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            CollectingEvent e = collectingEventArray[n2];
            if (e.getStartDate().before(startDate)) {
                startDate = e.getStartDate();
                verStartDate = e.getStartDateVerbatim();
            }
            if (e.getEndDate().after(endDate)) {
                endDate = e.getEndDate();
                verEndDate = e.getEndDateVerbatim();
            }
            trip.getCollectingEvents().add(e);
            ++n2;
        }
        trip.setStartDate(startDate);
        trip.setEndDate(endDate);
        trip.setStartDateVerbatim(verStartDate);
        trip.setEndDateVerbatim(verEndDate);
        return trip;
    }

    public static CollectingEventAttr createCollectingEventAttr(CollectingEvent colEv, AttributeDef colObjAttrDef, String strVal, Double dblVal) {
        CollectingEventAttr colEvAttr = new CollectingEventAttr();
        colEvAttr.initialize();
        colEvAttr.setDefinition(colObjAttrDef);
        colObjAttrDef.getCollectingEventAttrs().add(colEvAttr);
        colEvAttr.setCollectingEvent(colEv);
        if (strVal != null) {
            colEvAttr.setStrValue(strVal);
        }
        if (dblVal != null) {
            colEvAttr.setDblValue(dblVal);
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        colEvAttr.setTimestampCreated(now);
        colEv.getAttrs().add(colEvAttr);
        DataBuilder.persist(colEv);
        return colEvAttr;
    }

    public static CollectionObjectAttr createCollectionObjectAttr(CollectionObject colObj, AttributeDef colObjAttrDef, String strVal, Double dblVal) {
        CollectionObjectAttr colObjAttr = new CollectionObjectAttr();
        colObjAttr.initialize();
        colObjAttr.setDefinition(colObjAttrDef);
        colObjAttr.setCollectionObject(colObj);
        if (strVal != null) {
            colObjAttr.setStrValue(strVal);
        }
        if (dblVal != null) {
            colObjAttr.setDblValue(dblVal);
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        colObjAttr.setTimestampCreated(now);
        colObj.getAttrs().add(colObjAttr);
        DataBuilder.persist(colObj);
        return colObjAttr;
    }

    public static Collector createCollector(Agent agent, int orderNum) {
        Collector collector = new Collector();
        collector.initialize();
        collector.setAgent(agent);
        collector.setModifiedByAgent(null);
        collector.setOrderNumber(orderNum);
        collector.setRemarks("");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        collector.setTimestampCreated(now);
        DataBuilder.persist(collector);
        return collector;
    }

    public static CollectionObject createCollectionObject(String catalogNumber, String fieldNumber, Agent cataloger, Collection collection, int count, CollectingEvent collectingEvent, Calendar catalogedDate, String lastEditedBy) {
        return DataBuilder.createCollectionObject(catalogNumber, fieldNumber, cataloger, collection, count, collectingEvent, catalogedDate, UIFieldFormatterIFace.PartialDateEnum.Full, lastEditedBy);
    }

    public static CollectionObject createCollectionObject(String catalogNumber, String fieldNumber, Agent cataloger, Collection collection, int count, CollectingEvent collectingEvent, Calendar catalogedDate, UIFieldFormatterIFace.PartialDateEnum dateType, String lastEditedBy) {
        CollectionObject colObj = new CollectionObject();
        colObj.initialize();
        colObj.setCataloger(cataloger);
        colObj.setCatalogedDate(catalogedDate);
        colObj.setCatalogedDateVerbatim(DateFormat.getInstance().format(catalogedDate.getTime()));
        colObj.setCatalogNumber(catalogNumber);
        colObj.setCatalogedDatePrecision((byte)dateType.ordinal());
        colObj.setCollection(collection);
        colObj.setCollectingEvent(collectingEvent);
        colObj.setCountAmt(count);
        colObj.setFieldNumber(fieldNumber);
        colObj.setModifiedByAgent(cataloger);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        colObj.setTimestampCreated(now);
        if (collectingEvent != null) {
            collectingEvent.getCollectionObjects().add(colObj);
        }
        DataBuilder.persist(colObj);
        if (collectingEvent != null) {
            DataBuilder.persist(collectingEvent);
        }
        return colObj;
    }

    public static Determination createDetermination(CollectionObject collectionObject, Agent determiner, Taxon taxon, boolean isCurrent, Calendar calendar) {
        Determination determination = new Determination();
        determination.initialize();
        determination.setIsCurrent(isCurrent);
        determination.setCollectionObject(collectionObject);
        determination.setDeterminedDate(calendar);
        determination.setDeterminer(determiner);
        determination.setTaxon(taxon);
        collectionObject.getDeterminations().add(determination);
        DataBuilder.persist(collectionObject);
        DataBuilder.persist(determination);
        DataBuilder.persist(taxon);
        return determination;
    }

    public static GeographyTreeDef createGeographyTreeDef(String name) {
        GeographyTreeDef gtd = new GeographyTreeDef();
        gtd.initialize();
        gtd.setName(name);
        gtd.setFullNameDirection(-1);
        DataBuilder.persist(gtd);
        return gtd;
    }

    public static GeographyTreeDefItem createGeographyTreeDefItem(GeographyTreeDefItem parent, GeographyTreeDef gtd, String name, int rankId) {
        GeographyTreeDefItem gtdi = new GeographyTreeDefItem();
        gtdi.initialize();
        gtdi.setName(name);
        gtdi.setParent(parent);
        gtdi.setRankId(rankId);
        gtdi.setIsInFullName(false);
        gtdi.setIsEnforced(false);
        gtdi.setTreeDef(gtd);
        gtdi.setFullNameSeparator(", ");
        if (gtd != null) {
            gtd.getTreeDefItems().add(gtdi);
        }
        DataBuilder.persist(gtdi);
        return gtdi;
    }

    public static Geography createGeography(GeographyTreeDef gtd, Geography parent, String name, int rankId) {
        Geography geography = new Geography();
        geography.initialize();
        geography.setDefinition(gtd);
        geography.setName(name);
        geography.setParent(parent);
        geography.setIsAccepted(true);
        geography.setIsCurrent(true);
        if (parent != null) {
            parent.getChildren().add(geography);
        }
        geography.setRankId(rankId);
        GeographyTreeDefItem defItem = gtd.getDefItemByRank(rankId);
        if (defItem != null) {
            geography.setDefinitionItem(defItem);
        }
        gtd.getTreeEntries().add(geography);
        DataBuilder.persist(geography);
        return geography;
    }

    public static List<Geography> createGeographyChildren(GeographyTreeDef geoTreeDef, Geography parent, String[] childNames, int rankId) {
        Vector<Geography> geos = new Vector<Geography>();
        int i = 0;
        while (i < childNames.length) {
            geos.add(DataBuilder.createGeography(geoTreeDef, parent, childNames[i], rankId));
            ++i;
        }
        return geos;
    }

    public static StorageTreeDef createStorageTreeDef(String name) {
        StorageTreeDef ltd = new StorageTreeDef();
        ltd.initialize();
        ltd.setName(name);
        ltd.setFullNameDirection(-1);
        DataBuilder.persist(ltd);
        return ltd;
    }

    public static StorageTreeDefItem createStorageTreeDefItem(StorageTreeDefItem parent, StorageTreeDef ltd, String name, int rankId) {
        StorageTreeDefItem ltdi = new StorageTreeDefItem();
        ltdi.initialize();
        ltdi.setName(name);
        ltdi.setParent(parent);
        ltdi.setRankId(rankId);
        ltdi.setTreeDef(ltd);
        ltdi.setIsInFullName(false);
        ltdi.setIsEnforced(false);
        ltdi.setFullNameSeparator(", ");
        if (ltd != null) {
            ltd.getTreeDefItems().add(ltdi);
        }
        DataBuilder.persist(ltdi);
        return ltdi;
    }

    public static Storage createStorage(StorageTreeDef ltd, Storage parent, String name, int rankId) {
        StorageTreeDefItem defItem;
        Storage storage = new Storage();
        storage.initialize();
        storage.setDefinition(ltd);
        storage.setName(name);
        storage.setParent(parent);
        storage.setIsAccepted(true);
        if (parent != null) {
            parent.getChildren().add(storage);
        }
        if ((defItem = ltd.getDefItemByRank(rankId)) != null) {
            storage.setDefinitionItem(defItem);
        }
        storage.setRankId(rankId);
        ltd.getTreeEntries().add(storage);
        DataBuilder.persist(storage);
        return storage;
    }

    public static PickList createPickList(String name, Byte type, String tableName, String fieldName, String formatter, boolean readOnly, int sizeLimit, Boolean isSystem, Byte sortType, Collection collectionArg) {
        Collection collection;
        PickList pickList = new PickList();
        pickList.initialize();
        pickList.setName(name);
        pickList.setType(type);
        pickList.setTableName(tableName);
        pickList.setFieldName(fieldName);
        pickList.setFormatter(formatter);
        pickList.setReadOnly(readOnly);
        pickList.setSizeLimit(sizeLimit);
        pickList.setIsSystem(isSystem);
        pickList.setSortType(sortType);
        Collection collection2 = collectionArg != null ? collectionArg : (collection = AppContextMgr.getInstance().hasContext() ? AppContextMgr.getInstance().getClassObject(Collection.class) : null);
        if (collection != null) {
            pickList.setCollection(collection);
            collection.getPickLists().add(pickList);
        }
        DataBuilder.persist(pickList);
        return pickList;
    }

    public static GeologicTimePeriodTreeDef createGeologicTimePeriodTreeDef(String name) {
        GeologicTimePeriodTreeDef gtp = new GeologicTimePeriodTreeDef();
        gtp.initialize();
        gtp.setName(name);
        gtp.setFullNameDirection(-1);
        DataBuilder.persist(gtp);
        return gtp;
    }

    public static GeologicTimePeriodTreeDefItem createGeologicTimePeriodTreeDefItem(GeologicTimePeriodTreeDefItem parent, GeologicTimePeriodTreeDef gtptd, String name, int rankId) {
        GeologicTimePeriodTreeDefItem gtdi = new GeologicTimePeriodTreeDefItem();
        gtdi.initialize();
        gtdi.setName(name);
        gtdi.setParent(parent);
        gtdi.setRankId(rankId);
        gtdi.setTreeDef(gtptd);
        gtdi.setIsInFullName(false);
        gtdi.setIsEnforced(false);
        gtdi.setFullNameSeparator(", ");
        if (gtptd != null) {
            gtptd.getTreeDefItems().add(gtdi);
        }
        DataBuilder.persist(gtdi);
        return gtdi;
    }

    public static GeologicTimePeriod createGeologicTimePeriod(GeologicTimePeriodTreeDef gtptd, GeologicTimePeriod parent, String name, float startMYA, float endMYA, int rankId) {
        GeologicTimePeriod gtp = new GeologicTimePeriod();
        gtp.initialize();
        gtp.setDefinition(gtptd);
        gtp.setDefinition(gtptd);
        gtp.setName(name);
        gtp.setParent(parent);
        gtp.setIsAccepted(true);
        if (parent != null) {
            parent.getChildren().add(gtp);
        }
        gtp.setStartPeriod(Float.valueOf(startMYA));
        gtp.setStartUncertainty(Float.valueOf(0.0f));
        gtp.setEndPeriod(Float.valueOf(endMYA));
        gtp.setEndUncertainty(Float.valueOf(0.0f));
        GeologicTimePeriodTreeDefItem defItem = gtptd.getDefItemByRank(rankId);
        if (defItem != null) {
            gtp.setDefinitionItem(defItem);
        }
        gtp.setRankId(rankId);
        gtptd.getTreeEntries().add(gtp);
        DataBuilder.persist(gtp);
        return gtp;
    }

    public static TaxonTreeDef createTaxonTreeDef(String name) {
        TaxonTreeDef ttd = new TaxonTreeDef();
        ttd.initialize();
        ttd.setName(name);
        ttd.setFullNameDirection(1);
        return ttd;
    }

    public static TaxonTreeDefItem createTaxonTreeDefItem(TaxonTreeDefItem parent, TaxonTreeDef ttd, String name, int rankId) {
        TaxonTreeDefItem ttdi = new TaxonTreeDefItem();
        ttdi.initialize();
        ttdi.setName(name);
        ttdi.setParent(parent);
        ttdi.setRankId(rankId);
        ttdi.setIsInFullName(false);
        ttdi.setIsEnforced(false);
        ttdi.setTreeDef(ttd);
        ttdi.setFullNameSeparator(" ");
        if (ttd != null) {
            ttd.getTreeDefItems().add(ttdi);
        }
        DataBuilder.persist(ttdi);
        return ttdi;
    }

    public static LithoStratTreeDef createLithoStratTreeDef(String name) {
        LithoStratTreeDef lstd = new LithoStratTreeDef();
        lstd.initialize();
        lstd.setName(name);
        lstd.setFullNameDirection(1);
        return lstd;
    }

    public static LithoStratTreeDefItem createLithoStratTreeDefItem(LithoStratTreeDefItem parent, String name, int rankId, boolean inFullName) {
        if (parent != null) {
            LithoStratTreeDef treeDef = parent.getTreeDef();
            if (treeDef != null) {
                LithoStratTreeDefItem lstdi = new LithoStratTreeDefItem();
                lstdi.initialize();
                lstdi.setName(name);
                lstdi.setRankId(rankId);
                lstdi.setIsInFullName(inFullName);
                lstdi.setIsEnforced(false);
                lstdi.setTreeDef(treeDef);
                treeDef.getTreeDefItems().add(lstdi);
                parent.getChildren().add(lstdi);
                lstdi.setParent(parent);
                return lstdi;
            }
            throw new RuntimeException("LithoStratTreeDef is null!");
        }
        throw new RuntimeException("Parent is null!");
    }

    public static LithoStratTreeDefItem createLithoStratTreeDefItem(LithoStratTreeDef treeDef, String name, int rankId, boolean inFullName) {
        if (treeDef != null) {
            LithoStratTreeDefItem lstdi = new LithoStratTreeDefItem();
            lstdi.initialize();
            lstdi.setName(name);
            lstdi.setRankId(rankId);
            lstdi.setIsInFullName(inFullName);
            lstdi.setIsEnforced(false);
            lstdi.setTreeDef(treeDef);
            treeDef.getTreeDefItems().add(lstdi);
            return lstdi;
        }
        throw new RuntimeException("LithoStratTreeDef is null!");
    }

    public static Taxon createTaxon(TaxonTreeDef ttd, Taxon parent, String name, int rankId) {
        return DataBuilder.createTaxon(ttd, parent, name, null, rankId);
    }

    public static Taxon createTaxon(TaxonTreeDef ttd, Taxon parent, String name, String commonName, int rankId) {
        TaxonTreeDefItem defItem;
        Taxon taxon = new Taxon();
        taxon.initialize();
        taxon.setDefinition(ttd);
        taxon.setName(name);
        taxon.setCommonName(commonName);
        taxon.setParent(parent);
        taxon.setIsAccepted(true);
        if (parent != null) {
            parent.getChildren().add(taxon);
        }
        if ((defItem = ttd.getDefItemByRank(rankId)) != null) {
            taxon.setDefinitionItem(defItem);
        }
        taxon.setRankId(rankId);
        ttd.getTreeEntries().add(taxon);
        DataBuilder.persist(taxon);
        return taxon;
    }

    public static List<Object> createTaxonChildren(TaxonTreeDef treeDef, Taxon parent, String[] childNames, String[] commonNames, int rankId) {
        Vector<Object> kids = new Vector<Object>();
        int i = 0;
        while (i < childNames.length) {
            kids.add(DataBuilder.createTaxon(treeDef, parent, childNames[i], commonNames[i], rankId));
            ++i;
        }
        return kids;
    }

    public static Preparation createPreparation(PrepType prepType, Agent preparedBy, CollectionObject colObj, Storage storage, int count, Calendar preparedDate) {
        Preparation prep = new Preparation();
        prep.initialize();
        prep.setCollectionObject(colObj);
        prep.setCountAmt(count);
        prep.setModifiedByAgent(null);
        prep.setStorage(storage);
        prep.setPreparedByAgent(preparedBy);
        prep.setPreparedDate(preparedDate);
        prep.setPrepType(prepType);
        prep.setRemarks(null);
        prep.setStorageLocation(null);
        prep.setText1(null);
        prep.setText2(null);
        colObj.getPreparations().add(prep);
        DataBuilder.persist(prep);
        return prep;
    }

    public static Locality createLocality(String name, Geography geo) {
        Locality locality = new Locality();
        locality.initialize();
        locality.setLocalityName(name);
        locality.setGeography(geo);
        DataBuilder.persist(locality);
        return locality;
    }

    public static PreparationAttr createPreparationAttr(AttributeDef attrDef, Preparation prep, String strVal, Double dblVal) {
        PreparationAttr prepAttr = new PreparationAttr();
        prepAttr.initialize();
        prepAttr.setDefinition(attrDef);
        prepAttr.setPreparation(prep);
        if (strVal != null) {
            prepAttr.setStrValue(strVal);
        } else if (dblVal != null) {
            prepAttr.setDblValue(dblVal);
        }
        prepAttr.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        prep.getAttrs().add(prepAttr);
        DataBuilder.persist(prepAttr);
        return prepAttr;
    }

    public static Address createAddress(Agent agent, String address1, String address2, String city, String state, String country, String postalCode) {
        return DataBuilder.createAddress(agent, address1, address2, city, state, country, postalCode, 0);
    }

    public static Address createAddress(Agent agent, String address1, String address2, String city, String state, String country, String postalCode, int ordinal) {
        Address address = new Address();
        address.initialize();
        address.setAgent(agent);
        address.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        address.setAddress(address1);
        address.setAddress2(address2);
        address.setCity(city);
        address.setCountry(country);
        address.setPostalCode(postalCode);
        address.setState(state);
        address.setIsPrimary(true);
        address.setOrdinal(ordinal);
        agent.getAddresses().add(address);
        DataBuilder.persist(address);
        DataBuilder.persist(agent);
        return address;
    }

    public static Permit createPermit(String permitNumber, String type, Calendar issuedDate, Calendar startDate, Calendar endDate, Calendar renewalDate) {
        Permit permit = new Permit();
        permit.initialize();
        permit.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        permit.setStartDate(startDate);
        permit.setEndDate(endDate);
        permit.setPermitNumber(permitNumber);
        permit.setIssuedDate(issuedDate);
        permit.setRenewalDate(renewalDate);
        permit.setType(type);
        DataBuilder.persist(permit);
        return permit;
    }

    public static Accession createAccession(Division division, String type, String status, String number, String verbatimDate, Calendar dateAccessioned, Calendar dateReceived) {
        Accession accession = new Accession();
        accession.initialize();
        accession.setDivision(division);
        accession.setAccessionNumber(number);
        accession.setVerbatimDate(verbatimDate);
        accession.setDateAccessioned(dateAccessioned);
        accession.setDateReceived(dateReceived);
        accession.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        accession.setStatus(status);
        accession.setType(type);
        DataBuilder.persist(accession);
        return accession;
    }

    public static AccessionAgent createAccessionAgent(String role, Agent agent, Accession accession, RepositoryAgreement repositoryAgreement) {
        AccessionAgent accessionagent = new AccessionAgent();
        accessionagent.initialize();
        accessionagent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        accessionagent.setAccession(accession);
        accessionagent.setRepositoryAgreement(repositoryAgreement);
        accessionagent.setRole(role);
        accessionagent.setAgent(agent);
        DataBuilder.persist(accessionagent);
        return accessionagent;
    }

    public static AccessionAuthorization createAccessionAuthorization(Permit permit, Accession accession, RepositoryAgreement repositoryAgreement) {
        AccessionAuthorization accessionauthorization = new AccessionAuthorization();
        accessionauthorization.initialize();
        accessionauthorization.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        accessionauthorization.setAccession(accession);
        accessionauthorization.setPermit(permit);
        accessionauthorization.setRepositoryAgreement(repositoryAgreement);
        DataBuilder.persist(accessionauthorization);
        return accessionauthorization;
    }

    public static AttributeDef createAttributeDef(Short tableType, String fieldName, Short dataType, Discipline discipline, PrepType prepType) {
        AttributeDef attributedef = new AttributeDef();
        attributedef.initialize();
        attributedef.setDiscipline(discipline);
        attributedef.setPrepType(prepType);
        attributedef.setTableType(tableType);
        attributedef.setFieldName(fieldName);
        attributedef.setDataType(dataType);
        DataBuilder.persist(attributedef);
        return attributedef;
    }

    public static Author createAuthor(Short orderNumber, ReferenceWork referenceWork, Agent agent) {
        Author author = new Author();
        author.initialize();
        author.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        author.setAgent(agent);
        author.setOrderNumber(orderNumber);
        author.setReferenceWork(referenceWork);
        DataBuilder.persist(author);
        return author;
    }

    public static Borrow createBorrow(String invoiceNumber, Calendar receivedDate, Calendar originalDueDate, Calendar dateClosed, Boolean isClosed, Calendar currentDueDate) {
        Borrow borrow = new Borrow();
        borrow.initialize();
        borrow.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        borrow.setInvoiceNumber(invoiceNumber);
        borrow.setReceivedDate(receivedDate);
        borrow.setOriginalDueDate(originalDueDate);
        borrow.setDateClosed(dateClosed);
        borrow.setCurrentDueDate(currentDueDate);
        borrow.setIsClosed(isClosed);
        DataBuilder.persist(borrow);
        return borrow;
    }

    public static BorrowAgent createBorrowAgent(String role, Agent agent, Borrow borrow) {
        BorrowAgent borrowagent = new BorrowAgent();
        borrowagent.initialize();
        borrowagent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        borrowagent.setRole(role);
        borrowagent.setAgent(agent);
        borrowagent.setBorrow(borrow);
        DataBuilder.persist(borrowagent);
        return borrowagent;
    }

    public static BorrowMaterial createBorrowMaterial(String materialNumber, String description, Short quantity, String outComments, String inComments, Short quantityResolved, Short quantityReturned, Borrow borrow) {
        BorrowMaterial borrowmaterial = new BorrowMaterial();
        borrowmaterial.initialize();
        borrowmaterial.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        borrowmaterial.setQuantity(quantity);
        borrowmaterial.setBorrow(borrow);
        borrowmaterial.setMaterialNumber(materialNumber);
        borrowmaterial.setOutComments(outComments);
        borrowmaterial.setInComments(inComments);
        borrowmaterial.setQuantityResolved(quantityResolved);
        borrowmaterial.setQuantityReturned(quantityReturned);
        borrowmaterial.setDescription(description);
        DataBuilder.persist(borrowmaterial);
        return borrowmaterial;
    }

    public static BorrowReturnMaterial createBorrowReturnMaterial(Calendar returnedDate, Short quantity, Agent agent, BorrowMaterial borrowMaterial) {
        BorrowReturnMaterial borrowreturnmaterial = new BorrowReturnMaterial();
        borrowreturnmaterial.initialize();
        borrowreturnmaterial.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        borrowreturnmaterial.setAgent(agent);
        borrowreturnmaterial.setReturnedDate(returnedDate);
        borrowreturnmaterial.setQuantity(quantity);
        borrowreturnmaterial.setBorrowMaterial(borrowMaterial);
        DataBuilder.persist(borrowreturnmaterial);
        return borrowreturnmaterial;
    }

    public static CollectingEvent createCollectingEvent(String stationFieldNumber, String method, String verbatimDate, Calendar startDate, Byte startDatePrecision, String startDateVerbatim, Calendar endDate, Byte endDatePrecision, String endDateVerbatim, Short startTime, Short endTime, String verbatimLocality, Integer groupPermittedToView, Locality locality) {
        CollectingEvent collectingevent = new CollectingEvent();
        collectingevent.initialize();
        collectingevent.setVerbatimDate(verbatimDate);
        collectingevent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        collectingevent.setStartDate(startDate);
        collectingevent.setEndDate(endDate);
        collectingevent.setStationFieldNumber(stationFieldNumber);
        collectingevent.setStartDatePrecision(startDatePrecision);
        collectingevent.setStartDateVerbatim(startDateVerbatim);
        collectingevent.setEndDatePrecision(endDatePrecision);
        collectingevent.setEndDateVerbatim(endDateVerbatim);
        collectingevent.setEndTime(endTime);
        collectingevent.setVerbatimLocality(verbatimLocality);
        collectingevent.setLocality(locality);
        collectingevent.setMethod(method);
        collectingevent.setStartTime(startTime);
        DataBuilder.persist(collectingevent);
        return collectingevent;
    }

    public static CollectingEventAttr createCollectingEventAttr(String strValue, Double dblValue, CollectingEvent collectingEvent, AttributeDef definition) {
        CollectingEventAttr collectingeventattr = new CollectingEventAttr();
        collectingeventattr.initialize();
        collectingeventattr.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        collectingeventattr.setCollectingEvent(collectingEvent);
        collectingeventattr.setStrValue(strValue);
        collectingeventattr.setDblValue(dblValue);
        collectingeventattr.setDefinition(definition);
        DataBuilder.persist(collectingeventattr);
        return collectingeventattr;
    }

    public static Discipline createDiscipline(String name, DataType dataType, GeographyTreeDef geographyTreeDef, GeologicTimePeriodTreeDef geologicTimePeriodTreeDef, TaxonTreeDef taxonTreeDef) {
        Discipline discipline = new Discipline();
        discipline.initialize();
        discipline.setDataType(dataType);
        discipline.setGeographyTreeDef(geographyTreeDef);
        discipline.setGeologicTimePeriodTreeDef(geologicTimePeriodTreeDef);
        discipline.setTaxonTreeDef(taxonTreeDef);
        discipline.setType(name);
        DataBuilder.persist(discipline);
        return discipline;
    }

    public static CollectionObject createCollectionObject(String fieldNumber, String description, Integer countAmt, String name, String modifier, Calendar catalogedDate, String catalogedDateVerbatim, String guid, Integer groupPermittedToView, Boolean deaccessioned, String catalogNumber, CollectingEvent collectingEvent, Collection collection, Accession accession, Agent cataloger, Container container) {
        CollectionObject collectionobject = new CollectionObject();
        collectionobject.initialize();
        collectionobject.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        collectionobject.setFieldNumber(fieldNumber);
        collectionobject.setCountAmt(countAmt);
        collectionobject.setModifier(modifier);
        collectionobject.setCatalogedDate(catalogedDate);
        collectionobject.setCatalogedDateVerbatim(catalogedDateVerbatim);
        collectionobject.setGuid(guid);
        collectionobject.setDeaccessioned(deaccessioned);
        collectionobject.setCatalogNumber(catalogNumber);
        collectionobject.setCollectingEvent(collectingEvent);
        collectionobject.setCollection(collection);
        collectionobject.setAccession(accession);
        collectionobject.setCataloger(cataloger);
        collectionobject.setContainer(container);
        collectionobject.setName(name);
        collectionobject.setDescription(description);
        DataBuilder.persist(collectionobject);
        return collectionobject;
    }

    public static CollectionObjectAttr createCollectionObjectAttr(String strValue, Double dblValue, CollectionObject collectionObject, AttributeDef definition) {
        CollectionObjectAttr collectionobjectattr = new CollectionObjectAttr();
        collectionobjectattr.initialize();
        collectionobjectattr.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        collectionobjectattr.setCollectionObject(collectionObject);
        collectionobjectattr.setStrValue(strValue);
        collectionobjectattr.setDblValue(dblValue);
        collectionobjectattr.setDefinition(definition);
        DataBuilder.persist(collectionobjectattr);
        return collectionobjectattr;
    }

    public static CollectionObjectCitation createCollectionObjectCitation(ReferenceWork referenceWork, CollectionObject collectionObject) {
        CollectionObjectCitation collectionobjectcitation = new CollectionObjectCitation();
        collectionobjectcitation.initialize();
        collectionobjectcitation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        collectionobjectcitation.setCollectionObject(collectionObject);
        collectionobjectcitation.setReferenceWork(referenceWork);
        DataBuilder.persist(collectionobjectcitation);
        return collectionobjectcitation;
    }

    public static Collector createCollector(Integer orderNumber, CollectingEvent collectingEvent, Agent agent) {
        Collector collector = new Collector();
        collector.initialize();
        collector.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        collector.setCollectingEvent(collectingEvent);
        collector.setAgent(agent);
        collector.setOrderNumber(orderNumber);
        DataBuilder.persist(collector);
        return collector;
    }

    public static Container createContainer(Short type, String name, String description, Integer number, CollectionObject colObj, Storage storage) {
        Container container = new Container();
        container.initialize();
        container.setNumber(number);
        container.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        container.getCollectionObjects().add(colObj);
        container.setName(name);
        container.setStorage(storage);
        container.setDescription(description);
        container.setType(type);
        DataBuilder.persist(container);
        return container;
    }

    public static DataType createDataType(String name) {
        DataType datatype = new DataType();
        datatype.initialize();
        datatype.setName(name);
        DataBuilder.persist(datatype);
        return datatype;
    }

    public static Deaccession createDeaccession(String type, String deaccessionNumber, Calendar deaccessionDate) {
        Deaccession deaccession = new Deaccession();
        deaccession.initialize();
        deaccession.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        deaccession.setDeaccessionNumber(deaccessionNumber);
        deaccession.setDeaccessionDate(deaccessionDate);
        deaccession.setType(type);
        DataBuilder.persist(deaccession);
        return deaccession;
    }

    public static DeaccessionAgent createDeaccessionAgent(String role, Agent agent, Deaccession deaccession) {
        DeaccessionAgent deaccessionagent = new DeaccessionAgent();
        deaccessionagent.initialize();
        deaccessionagent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        deaccessionagent.setRole(role);
        deaccessionagent.setAgent(agent);
        deaccessionagent.setDeaccession(deaccession);
        DataBuilder.persist(deaccessionagent);
        return deaccessionagent;
    }

    public static DeaccessionPreparation createDeaccessionPreparation(Short quantity, Deaccession deaccession) {
        DeaccessionPreparation deaccessionpreparation = new DeaccessionPreparation();
        deaccessionpreparation.initialize();
        deaccessionpreparation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        deaccessionpreparation.setQuantity(quantity);
        deaccessionpreparation.setDeaccession(deaccession);
        DataBuilder.persist(deaccessionpreparation);
        return deaccessionpreparation;
    }

    public static Determination createDetermination(boolean isCurrent, String typeStatusName, Calendar determinedDate, String confidence, String method, String featureOrBasis, Taxon taxon, CollectionObject collectionObject, Agent determiner) {
        Determination determination = new Determination();
        determination.initialize();
        determination.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        determination.setIsCurrent(isCurrent);
        determination.setCollectionObject(collectionObject);
        determination.setTypeStatusName(typeStatusName);
        determination.setDeterminedDate(determinedDate);
        determination.setConfidence(confidence);
        determination.setFeatureOrBasis(featureOrBasis);
        determination.setTaxon(taxon);
        determination.setDeterminer(determiner);
        determination.setMethod(method);
        DataBuilder.persist(determination);
        return determination;
    }

    public static DeterminationCitation createDeterminationCitation(ReferenceWork referenceWork, Determination determination) {
        DeterminationCitation determinationcitation = new DeterminationCitation();
        determinationcitation.initialize();
        determinationcitation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        determinationcitation.setReferenceWork(referenceWork);
        determinationcitation.setDetermination(determination);
        DataBuilder.persist(determinationcitation);
        return determinationcitation;
    }

    public static GroupPerson createGroupPerson(Short orderNumber, Agent agentByGroup, Agent agentByMember) {
        GroupPerson groupperson = new GroupPerson();
        groupperson.initialize();
        groupperson.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        groupperson.setOrderNumber(orderNumber);
        groupperson.setGroup(agentByGroup);
        groupperson.setMember(agentByMember);
        DataBuilder.persist(groupperson);
        return groupperson;
    }

    public static InfoRequest createInfoRequest(Integer infoRequestID, String firstName, String lastName, String institution, String email, Calendar requestDate, Calendar replyDate, RecordSet recordSet, Agent agent) {
        InfoRequest infoRequest = new InfoRequest();
        infoRequest.initialize();
        infoRequest.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        infoRequest.setEmail(email);
        infoRequest.setAgent(agent);
        infoRequest.setFirstName(firstName);
        infoRequest.setLastName(lastName);
        infoRequest.setInfoRequestID(infoRequestID);
        infoRequest.setInstitution(institution);
        infoRequest.setRequestDate(requestDate);
        infoRequest.setReplyDate(replyDate);
        infoRequest.addReference(recordSet, "recordSets");
        DataBuilder.persist(infoRequest);
        return infoRequest;
    }

    public static Journal createJournal(String journalName, String journalAbbreviation) {
        Journal journal = new Journal();
        journal.initialize();
        journal.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        journal.setJournalName(journalName);
        journal.setJournalAbbreviation(journalAbbreviation);
        DataBuilder.persist(journal);
        return journal;
    }

    public static Loan createLoan(String loanNumber, Calendar loanDate, Calendar currentDueDate, Calendar originalDueDate, Calendar dateClosed, Boolean isClosed, Shipment shipment) {
        Loan loan = new Loan();
        loan.initialize();
        loan.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        loan.addReference(shipment, "shipments");
        loan.setOriginalDueDate(originalDueDate);
        loan.setDateClosed(dateClosed);
        loan.setCurrentDueDate(currentDueDate);
        loan.setLoanNumber(loanNumber);
        loan.setLoanDate(loanDate);
        loan.setIsClosed(isClosed);
        DataBuilder.persist(loan);
        return loan;
    }

    public static LoanAgent createLoanAgent(String role, Loan loan, Agent agent) {
        LoanAgent loanAgent = new LoanAgent();
        loanAgent.initialize();
        loanAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        loanAgent.setRole(role);
        loanAgent.addReference(agent, "agent");
        loanAgent.setLoan(loan);
        DataBuilder.persist(loanAgent);
        return loanAgent;
    }

    public static LoanPreparation createLoanPreparation(Integer quantity, String descriptionOfMaterial, String outComments, String inComments, Integer quantityResolved, Integer quantityReturned, Preparation preparation, Loan loan) {
        LoanPreparation loanpreparation = new LoanPreparation();
        loanpreparation.initialize();
        loanpreparation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        loanpreparation.setDescriptionOfMaterial(descriptionOfMaterial);
        loanpreparation.setQuantity(quantity);
        loanpreparation.setLoan(loan);
        loanpreparation.setPreparation(preparation);
        loanpreparation.setOutComments(outComments);
        loanpreparation.setInComments(inComments);
        loanpreparation.setQuantityResolved(quantityResolved);
        loanpreparation.setQuantityReturned(quantityReturned);
        loan.getLoanPreparations().add(loanpreparation);
        DataBuilder.persist(loanpreparation);
        return loanpreparation;
    }

    public static LoanReturnPreparation createLoanReturnPreparation(Calendar returnedDate, Integer qtyRet, Integer qtyRes, LoanPreparation loanPreparation, DeaccessionPreparation deaccessionPreparation, Agent agent) {
        LoanReturnPreparation loanreturnpreparation = new LoanReturnPreparation();
        loanreturnpreparation.initialize();
        loanreturnpreparation.setReceivedBy(agent);
        loanreturnpreparation.setReturnedDate(returnedDate);
        loanreturnpreparation.setQuantityReturned(qtyRet);
        loanreturnpreparation.setQuantityResolved(qtyRes);
        loanreturnpreparation.setLoanPreparation(loanPreparation);
        loanreturnpreparation.setDeaccessionPreparation(deaccessionPreparation);
        DataBuilder.persist(loanreturnpreparation);
        return loanreturnpreparation;
    }

    public static Locality createLocality(String namedPlace, String relationToNamedPlace, String localityName, String baseMeridian, String range, String rangeDirection, String township, String townshipDirection, String section, String sectionPart, String verbatimElevation, String originalElevationUnit, Double minElevation, Double maxElevation, String elevationMethod, Double elevationAccuracy, Integer originalLatLongUnit, String latLongType, BigDecimal latitude1, BigDecimal longitude1, BigDecimal latitude2, BigDecimal longitude2, String latLongMethod, Double latLongAccuracy, String datum, Integer groupPermittedToView, String lat1text, String lat2text, String long1text, String long2text, String nationalParkName, String islandGroup, String island, String waterBody, String drainage, Geography geography) {
        Locality locality = new Locality();
        locality.initialize();
        locality.setNamedPlace(namedPlace);
        locality.setRelationToNamedPlace(relationToNamedPlace);
        locality.setLocalityName(localityName);
        locality.setVerbatimElevation(verbatimElevation);
        locality.setOriginalElevationUnit(originalElevationUnit);
        locality.setMinElevation(minElevation);
        locality.setMaxElevation(maxElevation);
        locality.setElevationMethod(elevationMethod);
        locality.setElevationAccuracy(elevationAccuracy);
        locality.setOriginalLatLongUnit(originalLatLongUnit);
        locality.setLatLongType(latLongType);
        locality.setLatitude1(latitude1);
        locality.setLongitude1(longitude1);
        locality.setLatitude2(latitude2);
        locality.setLongitude2(longitude2);
        locality.setLatLongMethod(latLongMethod);
        locality.setLatLongAccuracy(latLongAccuracy);
        locality.setDatum(datum);
        locality.setLat1text(lat1text);
        locality.setLat2text(lat2text);
        locality.setLong1text(long1text);
        locality.setLong2text(long2text);
        locality.setGeography(geography);
        LocalityDetail localityDetail = new LocalityDetail();
        localityDetail.initialize();
        localityDetail.setBaseMeridian(baseMeridian);
        localityDetail.setRangeDesc(range);
        localityDetail.setRangeDirection(rangeDirection);
        localityDetail.setTownship(township);
        localityDetail.setTownshipDirection(townshipDirection);
        localityDetail.setSection(section);
        localityDetail.setSectionPart(sectionPart);
        localityDetail.setNationalParkName(nationalParkName);
        localityDetail.setIslandGroup(islandGroup);
        localityDetail.setIsland(island);
        localityDetail.setWaterBody(waterBody);
        localityDetail.setDrainage(drainage);
        locality.addReference(localityDetail, "localityDetails");
        DataBuilder.persist(locality);
        return locality;
    }

    public static LocalityCitation createLocalityCitation(ReferenceWork referenceWork, Locality locality) {
        LocalityCitation localitycitation = new LocalityCitation();
        localitycitation.initialize();
        localitycitation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        localitycitation.setReferenceWork(referenceWork);
        localitycitation.setLocality(locality);
        DataBuilder.persist(localitycitation);
        return localitycitation;
    }

    public static OtherIdentifier createOtherIdentifier(String identifier, CollectionObject collectionObject) {
        OtherIdentifier otheridentifier = new OtherIdentifier();
        otheridentifier.initialize();
        otheridentifier.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        otheridentifier.setCollectionObject(collectionObject);
        otheridentifier.setIdentifier(identifier);
        DataBuilder.persist(otheridentifier);
        return otheridentifier;
    }

    public static PrepType createPrepType(Collection collection, String name) {
        PrepType preptype = new PrepType();
        preptype.initialize();
        collection.addReference(preptype, "prepTypes");
        preptype.setName(name);
        DataBuilder.persist(preptype);
        return preptype;
    }

    public static Preparation createPreparation(Integer count, String storageLocation, Calendar preparedDate, PrepType prepType, CollectionObject collectionObject, Agent preparedByAgent, Storage storage) {
        Preparation preparation = new Preparation();
        preparation.initialize();
        preparation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        preparation.setCountAmt(count);
        preparation.setStorageLocation(storageLocation);
        preparation.setPreparedDate(preparedDate);
        preparation.setPrepType(prepType);
        preparation.setCollectionObject(collectionObject);
        preparation.setPreparedByAgent(preparedByAgent);
        preparation.setStorage(storage);
        DataBuilder.persist(preparation);
        return preparation;
    }

    public static PreparationAttr createPreparationAttr(String strValue, Double dblValue, AttributeDef definition, Preparation preparation) {
        PreparationAttr preparationattr = new PreparationAttr();
        preparationattr.initialize();
        preparationattr.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        preparationattr.setStrValue(strValue);
        preparationattr.setDblValue(dblValue);
        preparationattr.setDefinition(definition);
        preparationattr.setPreparation(preparation);
        DataBuilder.persist(preparationattr);
        return preparationattr;
    }

    public static Project createProject(String projectName, String projectDescription, String url, Calendar startDate, Calendar endDate, Agent agent) {
        Project project = new Project();
        project.initialize();
        project.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        project.setUrl(url);
        project.setAgent(agent);
        project.setStartDate(startDate);
        project.setEndDate(endDate);
        project.setProjectName(projectName);
        project.setProjectDescription(projectDescription);
        DataBuilder.persist(project);
        return project;
    }

    public static RecordSetIFace createRecordSet(Integer recordSetID, String name, SpecifyUser owner) {
        RecordSet recordset = new RecordSet();
        recordset.initialize();
        recordset.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        recordset.setRecordSetId(recordSetID);
        recordset.setOwner(owner);
        recordset.setName(name);
        DataBuilder.persist(recordset);
        return recordset;
    }

    public static ReferenceWork createReferenceWork(Byte referenceWorkType, String title, String publisher, String placeOfPublication, String workDate, String volume, String pages, String url, String libraryNumber, Boolean isPublished, Journal journal) {
        ReferenceWork referencework = new ReferenceWork();
        referencework.initialize();
        referencework.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        referencework.setUrl(url);
        referencework.setReferenceWorkType(referenceWorkType);
        referencework.setPublisher(publisher);
        referencework.setPlaceOfPublication(placeOfPublication);
        referencework.setWorkDate(workDate);
        referencework.setVolume(volume);
        referencework.setPages(pages);
        referencework.setLibraryNumber(libraryNumber);
        referencework.setIsPublished(isPublished);
        referencework.setJournal(journal);
        referencework.setTitle(title);
        if (journal != null) {
            journal.getReferenceWorks().add(referencework);
        }
        DataBuilder.persist(referencework);
        return referencework;
    }

    public static RepositoryAgreement createRepositoryAgreement(Division division, String number, String status, Calendar startDate, Calendar endDate, Calendar dateReceived, Agent originator) {
        RepositoryAgreement repositoryagreement = new RepositoryAgreement();
        repositoryagreement.initialize();
        repositoryagreement.setDivision(division);
        repositoryagreement.setRepositoryAgreementNumber(number);
        repositoryagreement.setDateReceived(dateReceived);
        repositoryagreement.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        repositoryagreement.setStartDate(startDate);
        repositoryagreement.setEndDate(endDate);
        repositoryagreement.setOriginator(originator);
        repositoryagreement.setStatus(status);
        DataBuilder.persist(repositoryagreement);
        return repositoryagreement;
    }

    public static Shipment createShipment(Calendar shipmentDate, String shipmentNumber, String shipmentMethod, Short numberOfPackages, String weight, String insuredForAmount, Agent shipper, Agent shippedTo, Agent agent) {
        Shipment shipment = new Shipment();
        shipment.initialize();
        shipment.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        shipment.setShippedBy(agent);
        shipment.setShipmentDate(shipmentDate);
        shipment.setShipmentNumber(shipmentNumber);
        shipment.setShipmentMethod(shipmentMethod);
        shipment.setNumberOfPackages(numberOfPackages);
        shipment.setWeight(weight);
        shipment.setInsuredForAmount(insuredForAmount);
        shipment.setShipper(shipper);
        shipment.setShippedTo(shippedTo);
        DataBuilder.persist(shipment);
        return shipment;
    }

    public static SpecifyUser createSpecifyUser(String name, String email, String password, String userType) {
        SpecifyUser specifyuser = new SpecifyUser();
        specifyuser.initialize();
        specifyuser.setEmail(email);
        specifyuser.setPassword(password);
        specifyuser.setName(name);
        specifyuser.setUserType(userType);
        DataBuilder.persist(specifyuser);
        return specifyuser;
    }

    public static SpecifyUser createSpecifyUser(String name, String email, String password, Map<String, SpPrincipal> groupMap, String userType) {
        SpecifyUser specifyuser = new SpecifyUser();
        specifyuser.initialize();
        specifyuser.setEmail(email);
        specifyuser.setPassword(password);
        specifyuser.addUserToSpPrincipalGroup(groupMap.get(userType));
        specifyuser.setName(name);
        specifyuser.setUserType(userType);
        DataBuilder.persist(specifyuser);
        return specifyuser;
    }

    public static SpecifyUser createSpecifyUser(String name, String email, String password, List<SpPrincipal> userGroups) {
        SpecifyUser specifyuser = new SpecifyUser();
        specifyuser.initialize();
        specifyuser.setEmail(email);
        specifyuser.setPassword(password);
        specifyuser.setName(name);
        if (userGroups != null) {
            for (SpPrincipal group : userGroups) {
                specifyuser.addUserToSpPrincipalGroup(group);
            }
        }
        DataBuilder.persist(specifyuser);
        return specifyuser;
    }

    public static SpecifyUser createSpecifyUser(String name, String email, String password, List<SpPrincipal> userGroups, String userType) {
        SpecifyUser specifyuser = new SpecifyUser();
        specifyuser.initialize();
        specifyuser.setEmail(email);
        specifyuser.setPassword(password);
        specifyuser.setName(name);
        specifyuser.setUserType(userType);
        if (userGroups != null) {
            for (SpPrincipal group : userGroups) {
                specifyuser.addUserToSpPrincipalGroup(group);
            }
        }
        DataBuilder.persist(specifyuser);
        return specifyuser;
    }

    public static SpecifyUser createAndAddTesterToCollection(Session sessionArg, String name, String email, String pwd, String title, String first, String middle, String last, String abbrev, Discipline discipline, Division division, Collection collection, Map<String, SpPrincipal> groupMap, String userType) {
        Agent testerAgent = DataBuilder.createAgent(title, first, middle, last, abbrev, email);
        sessionArg.saveOrUpdate((Object)testerAgent);
        testerAgent.setDivision(division);
        SpecifyUser testerUser = DataBuilder.createSpecifyUser(name, email, pwd, groupMap, userType);
        sessionArg.saveOrUpdate((Object)testerUser);
        SpPrincipal testerUserPrincipal = DataBuilder.createUserPrincipal(testerUser, collection);
        sessionArg.saveOrUpdate((Object)testerUserPrincipal);
        testerUser.addUserToSpPrincipalGroup(testerUserPrincipal);
        discipline.addReference(testerAgent, "agents");
        testerUser.addReference(testerAgent, "agents");
        return testerUser;
    }

    public static TaxonCitation createTaxonCitation(ReferenceWork referenceWork, Taxon taxon) {
        TaxonCitation taxoncitation = new TaxonCitation();
        taxoncitation.initialize();
        taxoncitation.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        taxoncitation.setTaxon(taxon);
        taxoncitation.setReferenceWork(referenceWork);
        DataBuilder.persist(taxoncitation);
        return taxoncitation;
    }

    public static SpPrincipal createGroup(String name, String type, int priority, UserGroupScope scope) {
        SpPrincipal usergroup = new SpPrincipal();
        usergroup.initialize();
        usergroup.setName(name);
        usergroup.setPriority(priority);
        usergroup.setGroupType(type);
        usergroup.setGroupSubClass(GroupPrincipal.class.getCanonicalName());
        usergroup.setScope(scope);
        return usergroup;
    }

    public static SpPrincipal createAdminGroup(String name, UserGroupScope scope) {
        SpPrincipal groupPrincipal = new SpPrincipal();
        groupPrincipal.initialize();
        groupPrincipal.setName(name);
        groupPrincipal.setPriority(0);
        groupPrincipal.setScope(scope);
        groupPrincipal.setGroupSubClass(AdminPrincipal.class.getCanonicalName());
        return groupPrincipal;
    }

    public static SpPrincipal createUserPrincipal(SpecifyUser user, Collection scope) {
        SpPrincipal userPrincipal = new SpPrincipal();
        userPrincipal.initialize();
        userPrincipal.setName(user.getName());
        userPrincipal.setPriority(80);
        userPrincipal.setScope(scope);
        userPrincipal.setGroupSubClass(UserPrincipal.class.getCanonicalName());
        user.getSpPrincipals().add(userPrincipal);
        return userPrincipal;
    }

    public static AutoNumberingScheme createAutoNumberingScheme(String schemeName, String schemeClassName, String formatName, boolean isNumericOnly, int tableNumber) {
        AutoNumberingScheme ans = new AutoNumberingScheme();
        ans.initialize();
        ans.setFormatName(formatName);
        ans.setTableNumber(tableNumber);
        ans.setSchemeName(schemeName);
        ans.setSchemeClassName(schemeClassName);
        ans.setIsNumericOnly(isNumericOnly);
        DataBuilder.persist(ans);
        return ans;
    }

    public static SpPermission createPermission(String name, String actions, String permClass, Set<SpPrincipal> groupSet) {
        SpPermission perm = new SpPermission();
        perm.initialize();
        perm.setName(name);
        perm.setActions(actions);
        perm.setPermissionClass(permClass);
        perm.setPrincipals(groupSet);
        DataBuilder.persist(perm);
        return perm;
    }

    private static void loadDefaultGroupDefinitions() {
        if (usertypeToDefaultGroup == null) {
            usertypeToDefaultGroup = new HashMap<String, Pair<String, Byte>>();
            usertypeToDefaultGroup.put(SpecifyUserTypes.UserType.Manager.toString(), new Pair<String, Byte>("Managers", (byte)10));
            usertypeToDefaultGroup.put(SpecifyUserTypes.UserType.FullAccess.toString(), new Pair<String, Byte>("Full Access Users", (byte)20));
            usertypeToDefaultGroup.put(SpecifyUserTypes.UserType.LimitedAccess.toString(), new Pair<String, Byte>("Limited Access Users", (byte)30));
            usertypeToDefaultGroup.put(SpecifyUserTypes.UserType.Guest.toString(), new Pair<String, Byte>("Guests", (byte)40));
        }
    }

    public static Map<String, SpPrincipal> createStandardGroups(Session sessionArg, UserGroupScope scope) {
        DataBuilder.loadDefaultGroupDefinitions();
        HashMap<String, SpPrincipal> groupMap = new HashMap<String, SpPrincipal>();
        for (String usertype : usertypeToDefaultGroup.keySet()) {
            Pair<String, Byte> grpInfo = usertypeToDefaultGroup.get(usertype);
            SpPrincipal group = DataBuilder.createGroup((String)grpInfo.first, usertype, ((Byte)grpInfo.second).byteValue(), scope);
            sessionArg.saveOrUpdate((Object)group);
            groupMap.put(usertype, group);
        }
        DataBuilder.createDefaultPermissions(sessionArg, groupMap);
        return groupMap;
    }

    public static void createDefaultPermissions(Session sessionArg, Map<String, SpPrincipal> groupMap) {
        DataBuilder.createDefaultPermissions(sessionArg, "dataobjs.xml", "DO.", groupMap, null);
        DataBuilder.createDefaultPermissions(sessionArg, "prefsperms.xml", "Prefs.", groupMap, null);
        DataBuilder.createDefaultPermissions(sessionArg, "tasks.xml", "Task.", groupMap, DataBuilder.getTasksAdditionalSecOpts());
    }

    public static void writePerms(Hashtable<String, Hashtable<String, PermissionOptionPersist>> hash, String fileName) {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        if (localPrefs != null && localPrefs.getBoolean("perms.write.xml", false).booleanValue()) {
            XStream xstream = new XStream();
            PermissionOptionPersist.config(xstream);
            try {
                FileUtils.writeStringToFile((File)new File(fileName), (String)xstream.toXML(hash));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void createDefaultPermissions(Session sessionArg, String filename, String prefix, Map<String, SpPrincipal> groupMap, List<SecurityOptionIFace> additionalSecOpts) {
        Hashtable<String, PermissionOptionPersist> hash;
        Hashtable<String, Hashtable<String, PermissionOptionPersist>> mainHash = BaseTask.readDefaultPermsFromXML(filename);
        for (String permName : mainHash.keySet()) {
            PermissionOptionPersist newPermOpts;
            PermissionOptionPersist permOpts;
            String userType = "LimitedAccess";
            Hashtable<String, PermissionOptionPersist> hashtable = mainHash.get(permName);
            if (hashtable.get(userType) == null) {
                permOpts = hashtable.get("Manager");
                newPermOpts = new PermissionOptionPersist(permOpts.getTaskName(), userType, permOpts.isCanView(), permOpts.isCanModify(), permOpts.isCanDel(), permOpts.isCanAdd());
                hashtable.put(userType, newPermOpts);
            }
            userType = "FullAccess";
            Hashtable<String, PermissionOptionPersist> hashtable2 = mainHash.get(permName);
            if (hashtable2.get(userType) != null) continue;
            permOpts = hashtable2.get("Manager");
            newPermOpts = new PermissionOptionPersist(permOpts.getTaskName(), userType, permOpts.isCanView(), permOpts.isCanModify(), permOpts.isCanDel(), permOpts.isCanAdd());
            hashtable2.put(userType, newPermOpts);
        }
        if (additionalSecOpts != null) {
            for (SecurityOptionIFace aso : additionalSecOpts) {
                hash = mainHash.get(aso.getPermissionName());
                if (hash == null) {
                    hash = new Hashtable();
                    mainHash.put(aso.getPermissionName(), hash);
                }
                SpecifyUserTypes.UserType[] userTypeArray = SpecifyUserTypes.UserType.values();
                int newPermOpts = userTypeArray.length;
                int n = 0;
                while (n < newPermOpts) {
                    SpecifyUserTypes.UserType userType = userTypeArray[n];
                    PermissionIFace asoPerm = aso.getDefaultPermissions(userType.toString());
                    if (asoPerm != null) {
                        PermissionOptionPersist newPermOpts2 = new PermissionOptionPersist(aso.getPermissionName(), userType.toString(), asoPerm.canView(), asoPerm.canModify(), asoPerm.canDelete(), asoPerm.canAdd());
                        hash.put(userType.toString(), newPermOpts2);
                    }
                    ++n;
                }
            }
        }
        DataBuilder.writePerms(mainHash, filename);
        for (SpPrincipal p : groupMap.values()) {
            DataBuilder.persist(p);
        }
        for (String permName : mainHash.keySet()) {
            hash = mainHash.get(permName);
            for (String string : hash.keySet()) {
                PermissionOptionPersist tp = hash.get(string);
                SpPermission perm = tp.getSpPermission();
                sessionArg.saveOrUpdate((Object)perm);
                HashSet<SpPrincipal> groupSet = new HashSet<SpPrincipal>();
                groupSet.add(groupMap.get(string));
                perm.setPrincipals(groupSet);
                perm.setName(String.valueOf(prefix) + permName);
            }
        }
    }

    public static Map<String, List<Integer>> mergeStandardGroups(Collection scope) {
        DataBuilder.loadDefaultGroupDefinitions();
        HashMap<String, List<Integer>> groupMap = new HashMap<String, List<Integer>>();
        for (String usertype : usertypeToDefaultGroup.keySet()) {
            Pair<String, Byte> grpInfo = usertypeToDefaultGroup.get(usertype);
            List<Integer> principleIds = DataBuilder.getGroup((String)grpInfo.first, usertype, scope);
            groupMap.put(usertype, principleIds);
        }
        DataBuilder.mergeDefaultPermissions(groupMap);
        return groupMap;
    }

    private static List<SecurityOptionIFace> getTasksAdditionalSecOpts() {
        ArrayList<SecurityOptionIFace> additionalTaskSecOpts = new ArrayList<SecurityOptionIFace>();
        for (Taskable task : TaskMgr.getInstance().getAllTasks()) {
            List<SecurityOptionIFace> list = task.getAdditionalSecurityOptions();
            if (list == null) continue;
            additionalTaskSecOpts.addAll(list);
        }
        return additionalTaskSecOpts;
    }

    private static void mergeDefaultPermissions(Map<String, List<Integer>> groupMap) {
        DataBuilder.mergeDefaultPermissions("dataobjs.xml", "DO.", groupMap);
        DataBuilder.mergeDefaultPermissions("prefsperms.xml", "Prefs.", groupMap);
        DataBuilder.mergeDefaultPermissions("tasks.xml", "Task.", groupMap);
    }

    private static List<Integer> getGroup(String name, String type, Collection scope) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String sql = " SELECT SpPrincipalID FROM spprincipal WHERE Name=? AND groupType=? AND GroupSubClass=? AND userGroupScopeID=?";
        String grpTypeStr = GroupPrincipal.class.getCanonicalName();
        Connection conn = DBConnection.getInstance().getConnection();
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, name);
                pStmt.setString(2, type);
                pStmt.setString(3, grpTypeStr);
                pStmt.setInt(4, scope.getId());
                ResultSet rs = pStmt.executeQuery();
                while (rs.next()) {
                    ids.add(rs.getInt(1));
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return ids;
    }

    public static void mergeDefaultPermissions(String filename, String prefix, Map<String, List<Integer>> groupMap) {
        Hashtable<String, Hashtable<String, PermissionOptionPersist>> mainHash = BaseTask.readDefaultPermsFromXML(filename);
        for (String permName : mainHash.keySet()) {
            PermissionOptionPersist newPermOpts;
            PermissionOptionPersist permOpts;
            Object userType = "LimitedAccess";
            Hashtable<String, PermissionOptionPersist> hash = mainHash.get(permName);
            if (hash.get(userType) == null) {
                permOpts = hash.get("Manager");
                newPermOpts = new PermissionOptionPersist(permOpts.getTaskName(), (String)userType, permOpts.isCanView(), permOpts.isCanModify(), permOpts.isCanDel(), permOpts.isCanAdd());
                hash.put((String)userType, newPermOpts);
            }
            userType = "FullAccess";
            hash = mainHash.get(permName);
            if (hash.get(userType) != null) continue;
            permOpts = hash.get("Manager");
            newPermOpts = new PermissionOptionPersist(permOpts.getTaskName(), (String)userType, permOpts.isCanView(), permOpts.isCanModify(), permOpts.isCanDel(), permOpts.isCanAdd());
            hash.put((String)userType, newPermOpts);
        }
        HashMap<SpPermission, ArrayList<Integer>> prinPermHash = new HashMap<SpPermission, ArrayList<Integer>>();
        for (String permName : mainHash.keySet()) {
            String fullPermName = String.valueOf(prefix) + permName;
            Hashtable<String, PermissionOptionPersist> hash = mainHash.get(permName);
            for (String userType : hash.keySet()) {
                PermissionOptionPersist tp = hash.get(userType);
                SpPermission perm = tp.getSpPermission();
                for (Integer id : groupMap.get(userType)) {
                    String str = "SELECT p.SpPermissionID FROM sppermission AS p Inner Join spprincipal_sppermission AS pp ON p.SpPermissionID = pp.SpPermissionID WHERE p.Name = '%s' AND pp.SpPrincipalID = %d";
                    String sql = String.format(str, fullPermName, id);
                    Integer permId = BasicSQLUtils.getCount(sql);
                    if (permId != null) continue;
                    System.out.println(String.format("Going to create %s for Prin: %d", fullPermName, id));
                    ArrayList<Integer> list = (ArrayList<Integer>)prinPermHash.get(perm);
                    if (list == null) {
                        perm.setName(fullPermName);
                        list = new ArrayList<Integer>();
                        prinPermHash.put(perm, list);
                    }
                    list.add(id);
                }
            }
        }
        if (prinPermHash.size() > 0) {
            Connection conn = null;
            Statement pstmt1 = null;
            Statement pstmt2 = null;
            try {
                try {
                    conn = DatabaseService.getInstance().getConnection();
                    pstmt1 = conn.prepareStatement("INSERT INTO sppermission (Actions, Name, PermissionClass) VALUES (?, ?, ?)");
                    pstmt2 = conn.prepareStatement("INSERT INTO spprincipal_sppermission (SpPermissionID, SpPrincipalID) VALUES (?, ?)");
                    for (SpPermission spPerm : prinPermHash.keySet()) {
                        for (Integer prinId : (List)prinPermHash.get(spPerm)) {
                            pstmt1.setString(1, spPerm.getActions());
                            pstmt1.setString(2, spPerm.getName());
                            pstmt1.setString(3, spPerm.getClass().getName());
                            pstmt1.executeUpdate();
                            Integer newPermId = BasicSQLUtils.getInsertedId(pstmt1);
                            pstmt2.setInt(1, newPermId);
                            pstmt2.setInt(2, prinId);
                            pstmt2.executeUpdate();
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                    try {
                        if (pstmt1 != null) {
                            pstmt1.close();
                        }
                        if (pstmt2 != null) {
                            pstmt2.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        UsageTracker.incrSQLUsageCount();
                        ExceptionTracker.getInstance().capture(PermissionService.class, e2);
                    }
                }
            }
            finally {
                try {
                    if (pstmt1 != null) {
                        pstmt1.close();
                    }
                    if (pstmt2 != null) {
                        pstmt2.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                }
            }
        }
    }

    public static Workbench createWorkbench(SpecifyUser user, String name, String remarks, String exportInstName, WorkbenchTemplate workbenchTemplate) {
        Workbench workbench = new Workbench();
        workbench.initialize();
        workbench.setName(name);
        workbench.setSpecifyUser(user);
        workbench.setRemarks(remarks);
        workbench.setExportInstitutionName(exportInstName);
        workbench.setWorkbenchTemplate(workbenchTemplate);
        DataBuilder.persist(workbench);
        return workbench;
    }

    public static WorkbenchRow createWorkbenchRow(Workbench workbench, short rowNumber) {
        WorkbenchRow workbenchRow = new WorkbenchRow(workbench, rowNumber);
        DataBuilder.persist(workbenchRow);
        return workbenchRow;
    }

    public static WorkbenchDataItem createWorkbenchDataItem(WorkbenchRow workbenchRow, String cellData, Integer columnNumber) {
        WorkbenchDataItem wbdi = workbenchRow.setData(cellData, columnNumber.shortValue(), true);
        if (wbdi != null) {
            wbdi.setRowNumber(workbenchRow.getRowNumber());
            DataBuilder.persist(wbdi);
        }
        return wbdi;
    }

    public static WorkbenchTemplate createWorkbenchTemplate(SpecifyUser user, String name, String remarks) {
        WorkbenchTemplate wbt = new WorkbenchTemplate();
        wbt.initialize();
        wbt.setSpecifyUser(user);
        wbt.setName(name);
        wbt.setRemarks(remarks);
        user.getWorkbenchTemplates().add(wbt);
        DataBuilder.persist(wbt);
        return wbt;
    }

    public static WorkbenchTemplateMappingItem createWorkbenchMappingItem(String tableName, Integer tableId, String fieldName, String caption, int dataLength, Integer viewOrder, Integer dataColumnIndex, WorkbenchTemplate template) {
        WorkbenchTemplateMappingItem wtmi = new WorkbenchTemplateMappingItem();
        wtmi.initialize();
        wtmi.setCaption(caption);
        wtmi.setFieldName(fieldName);
        wtmi.setTableName(tableName.toLowerCase());
        wtmi.setViewOrder(viewOrder.shortValue());
        wtmi.setDataFieldLength((short)dataLength);
        wtmi.setOrigImportColumnIndex(dataColumnIndex.shortValue());
        wtmi.setWorkbenchTemplate(template);
        wtmi.setSrcTableId(tableId);
        template.getWorkbenchTemplateMappingItems().add(wtmi);
        DataBuilder.persist(wtmi);
        return wtmi;
    }

    public static void configXStream(XStream xstream, boolean doExportImport) {
        String[] omit;
        xstream.alias("picklist", BldrPickList.class);
        xstream.alias("picklistitem", BldrPickListItem.class);
        xstream.omitField(BldrPickList.class, "pickListId");
        xstream.omitField(BldrPickList.class, "pickListItems");
        xstream.useAttributeFor(BldrPickList.class, "fieldName");
        xstream.useAttributeFor(BldrPickList.class, "sizeLimit");
        xstream.useAttributeFor(BldrPickList.class, "tableName");
        xstream.useAttributeFor(BldrPickList.class, "readOnly");
        xstream.useAttributeFor(BldrPickList.class, "type");
        xstream.useAttributeFor(BldrPickList.class, "formatter");
        xstream.useAttributeFor(BldrPickList.class, "name");
        xstream.useAttributeFor(BldrPickList.class, "isSystem");
        xstream.useAttributeFor(BldrPickList.class, "sortType");
        xstream.useAttributeFor(BldrPickListItem.class, "title");
        xstream.useAttributeFor(BldrPickListItem.class, "value");
        xstream.useAttributeFor(BldrPickListItem.class, "ordinal");
        xstream.aliasAttribute("readonly", "readOnly");
        xstream.aliasAttribute("tablename", "tableName");
        xstream.aliasAttribute("fieldname", "fieldName");
        xstream.aliasAttribute("sizelimit", "sizeLimit");
        xstream.aliasAttribute("issystem", "isSystem");
        xstream.aliasAttribute("sort", "sortType");
        if (doExportImport) {
            xstream.useAttributeFor(BldrPickList.class, "filterFieldName");
            xstream.useAttributeFor(BldrPickList.class, "filterValue");
        }
        String[] stringArray = omit = new String[]{"timestampCreated", "timestampModified", "version"};
        int n = omit.length;
        int n2 = 0;
        while (n2 < n) {
            String fld = stringArray[n2];
            if (doExportImport) {
                xstream.useAttributeFor(BldrPickList.class, fld);
                xstream.useAttributeFor(BldrPickListItem.class, fld);
            } else {
                xstream.omitField(BldrPickList.class, fld);
                xstream.omitField(BldrPickListItem.class, fld);
            }
            ++n2;
        }
        xstream.omitField(BldrPickListItem.class, "pickListItemId");
        xstream.omitField(BldrPickListItem.class, "pickList");
    }

    public static List<BldrPickList> getBldrPickLists(String disciplineDirName) {
        return DataBuilder.getBldrPickLists(disciplineDirName, null);
    }

    public static List<BldrPickList> getBldrPickLists(String disciplineDirName, File plFile) {
        XStream xstream = new XStream();
        try {
            File pickListFile;
            if (plFile == null) {
                String dirName = disciplineDirName != null ? String.valueOf(disciplineDirName) + File.separator : "";
                pickListFile = new File(XMLHelper.getConfigDirPath(String.valueOf(dirName) + "picklist.xml"));
                DataBuilder.configXStream(xstream, false);
            } else {
                pickListFile = plFile;
                DataBuilder.configXStream(xstream, true);
            }
            if (pickListFile.exists()) {
                List list = (List)xstream.fromXML(FileUtils.readFileToString((File)pickListFile));
                for (BldrPickList pl : list) {
                    if (pl.getSortType() == null) {
                        pl.setSortType((byte)1);
                    }
                    if (!pl.getSortType().equals((byte)2)) continue;
                    int order = 0;
                    for (BldrPickListItem item : pl.getItems()) {
                        item.setOrdinal(order++);
                    }
                }
                return list;
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataBuilder.class, ex);
            ex.printStackTrace();
        }
        return null;
    }

    public static void writePickListsAsXML(File file, List<BldrPickList> pickLists) {
        XStream xstream = new XStream();
        DataBuilder.configXStream(xstream, true);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            xstream.toXML(pickLists, (OutputStream)fos);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataBuilder.class, ex);
            ex.printStackTrace();
        }
    }

    public static void persist(Object transientObject) {
        if (session != null) {
            session.persist(transientObject);
        }
    }

    public static void buildDarwinCoreSchema(Discipline disciplineArg) {
        try {
            ExportMappingTask.importSchemaDefinition(new File(XMLHelper.getConfigDirPath("darwinCoreVertNet.xsd")), "VertNetDarwinCore", "1.21");
            ExportMappingTask.importSchemaDefinition(new File(XMLHelper.getConfigDirPath("tdwg_dw_core.xsd")), "DarwinCoreTDWG", "1.4");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataBuilder.class, ex);
            ex.printStackTrace();
        }
    }

    public static SpecifyUser createAdminGroupAndUser(Session sessionArg, Institution institution, Collection collection, String username, String email, String password, String userType) {
        SpecifyUser specifyAdminUser = DataBuilder.createSpecifyUser(username, email, password, userType);
        sessionArg.saveOrUpdate((Object)specifyAdminUser);
        SpecifyUser spUser = DataBuilder.createAdminGroupWithSpUser(sessionArg, institution, collection, specifyAdminUser);
        sessionArg.saveOrUpdate((Object)spUser);
        return spUser;
    }

    public static SpecifyUser createAdminGroupWithSpUser(Session sessionArg, Institution institution, Collection collection, SpecifyUser specifyAdminUser) {
        SpPrincipal adminGroup = DataBuilder.createAdminGroup("Administrator", institution);
        sessionArg.saveOrUpdate((Object)adminGroup);
        specifyAdminUser.addUserToSpPrincipalGroup(adminGroup);
        if (collection != null) {
            SpPrincipal spPrin = DataBuilder.createUserPrincipal(specifyAdminUser, collection);
            sessionArg.saveOrUpdate((Object)spPrin);
        }
        return specifyAdminUser;
    }

    class FieldMap {
        protected String name;
        protected String table;
        protected String field;
        protected String formatter;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getFormatter() {
            return this.formatter;
        }

        public void setFormatter(String formatter) {
            this.formatter = formatter;
        }
    }
}

