/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.BrowseBtnPanel;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.init.BaseSetupPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

class DBLocationPanel
extends BaseSetupPanel {
    protected BrowseBtnPanel browse;
    protected JRadioButton useCurrentRB;
    protected JRadioButton useHomeRB;
    protected JRadioButton useUserDefinedRB;
    protected JTextField filePath = null;
    protected boolean localDirOK = true;

    public DBLocationPanel(JButton nextBtn) {
        super("Storage", null, nextBtn, null);
        File currentPath = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "specify_tmp.tmp");
        try {
            FileUtils.touch((File)currentPath);
            currentPath.delete();
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DBLocationPanel.class, ex);
            this.localDirOK = false;
        }
        ButtonGroup grp = new ButtonGroup();
        this.useHomeRB = new JRadioButton("<html>Use your home directory: <b>" + UIRegistry.getUserHomeAppDir() + "</b></html>");
        grp.add(this.useHomeRB);
        this.useHomeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBLocationPanel.this.browse != null) {
                    DBLocationPanel.this.browse.setEnabled(false);
                }
                DBLocationPanel.this.updateBtnUI();
            }
        });
        int numRows = 3;
        StringBuilder header = new StringBuilder("<html>This step requires you to select a storage for the database.");
        if (this.localDirOK) {
            header.append("There are three options:</html>");
            this.useCurrentRB = new JRadioButton("<html>Use your current directory: <b>" + UIRegistry.getDefaultWorkingPath() + "</b></html>");
            grp.add(this.useCurrentRB);
            this.useCurrentRB.setSelected(true);
            ++numRows;
        } else {
            header.append("<br>The database cannot be stored on the media you are currently running Workbench from, ");
            header.append("so you can allow it to default to your '<i>home</i>' directory. Or choose a different storage.</html>");
            this.useHomeRB.setSelected(true);
        }
        this.useUserDefinedRB = new JRadioButton("Use other storage:");
        grp.add(this.useUserDefinedRB);
        this.useUserDefinedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBLocationPanel.this.browse.setEnabled(true);
                DBLocationPanel.this.updateBtnUI();
            }
        });
        this.filePath = new JTextField(30);
        this.filePath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DBLocationPanel.this.updateBtnUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DBLocationPanel.this.updateBtnUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DBLocationPanel.this.updateBtnUI();
            }
        });
        this.browse = new BrowseBtnPanel(this.filePath, true, true);
        this.browse.setEnabled(false);
        CellConstraints cc = new CellConstraints();
        JLabel lbl = new JLabel(header.toString());
        PanelBuilder cmtBldr = new PanelBuilder(new FormLayout("f:min(300px;p):g", "f:p:g"));
        cmtBldr.add((Component)lbl, cc.xy(1, 1));
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p:g", "p:g,2px," + UIHelper.createDuplicateJGoodiesDef("p", "2px", numRows) + ",f:p:g"), (JPanel)this);
        int row = 1;
        builder.add((Component)cmtBldr.getPanel(), cc.xywh(1, row, 3, 1));
        builder.add((Component)this.useHomeRB, cc.xy(1, row += 2));
        row += 2;
        if (this.useCurrentRB != null) {
            builder.add((Component)this.useCurrentRB, cc.xy(1, row));
            row += 2;
        }
        builder.add((Component)this.useUserDefinedRB, cc.xy(1, row));
        builder.add((Component)this.browse, cc.xy(1, row += 2));
        row += 2;
    }

    @Override
    public void getValues(Properties props) {
    }

    @Override
    public void setValues(Properties values) {
    }

    @Override
    public void updateBtnUI() {
        this.nextBtn.setEnabled(this.isUIValid());
    }

    @Override
    public boolean enablePreviousBtn() {
        return true;
    }

    @Override
    public boolean isUIValid() {
        if (this.useUserDefinedRB.isSelected()) {
            String path = this.filePath.getText();
            if (StringUtils.isNotEmpty((String)path)) {
                return new File(path).exists();
            }
            return false;
        }
        return true;
    }

    public boolean isUsingUserDefinedDirectory() {
        return this.useUserDefinedRB.isSelected();
    }

    public boolean isUseHomeDirectory() {
        return this.useHomeRB.isSelected();
    }

    public boolean isLocalOKForWriting() {
        return this.localDirOK;
    }

    public String getUserDefinedPath() {
        return this.filePath.getText();
    }

    @Override
    public List<Pair<String, String>> getSummary() {
        return null;
    }
}

