/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config.init;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import edu.ku.brc.af.ui.forms.validation.ValPasswordField;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.specify.config.init.SetupPanelIFace;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public abstract class BaseSetupPanel
extends JPanel
implements SetupPanelIFace {
    protected static final boolean DO_DEBUG = false;
    protected String panelName;
    protected String helpContext;
    protected KeyAdapter keyAdapter;
    protected JButton nextBtn;
    protected JButton prevBtn;
    protected boolean makeStretchy = false;
    protected Font bold = new JLabel().getFont().deriveFont(1);
    protected Properties properties = null;
    protected JProgressBar progressBar = null;

    public BaseSetupPanel(String panelName, String helpContext, JButton nextBtn, JButton prevBtn) {
        this(panelName, helpContext, nextBtn, prevBtn, false);
    }

    public BaseSetupPanel(String panelName, String helpContext, final JButton nextBtn, JButton prevBtn, boolean makeStretchy) {
        this.panelName = panelName;
        this.helpContext = helpContext;
        this.nextBtn = nextBtn;
        this.prevBtn = prevBtn;
        this.makeStretchy = makeStretchy;
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                nextBtn.setEnabled(BaseSetupPanel.this.isUIValid());
            }
        };
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
        }
        return this.progressBar;
    }

    @Override
    public String getHelpContext() {
        return this.helpContext;
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    public abstract void getValues(Properties var1);

    @Override
    public void setValues(Properties values) {
        this.properties = values;
    }

    @Override
    public abstract boolean isUIValid();

    @Override
    public abstract void updateBtnUI();

    @Override
    public void doingNext() {
    }

    @Override
    public void doingPrev() {
    }

    @Override
    public boolean enablePreviousBtn() {
        return true;
    }

    @Override
    public void aboutToLeave() {
    }

    protected JTextField createField(PanelBuilder builder, String label, boolean isReq, int row) {
        return this.createField(builder, label, isReq, row, false, null);
    }

    protected JTextField createField(PanelBuilder builder, String label, boolean isReq, int row, Integer numCols) {
        return this.createField(builder, label, isReq, row, false, numCols);
    }

    protected JTextField createField(PanelBuilder builder, String label, boolean isRequired, int row, boolean isPassword, Integer numColmns) {
        CellConstraints cc = new CellConstraints();
        JTextField tf = null;
        if (isPassword) {
            tf = new ValPasswordField(15);
        } else {
            ValTextField vtf = new ValTextField(15);
            if (numColmns != null) {
                vtf.setLimit(numColmns);
            }
            tf = vtf;
        }
        JLabel lbl = UIHelper.createI18NFormLabel(label, 4);
        if (isRequired) {
            lbl.setFont(this.bold);
        }
        builder.add((Component)lbl, cc.xy(1, row));
        builder.add((Component)tf, cc.xyw(3, row, this.makeStretchy ? 2 : 1));
        if (isRequired) {
            tf.setBackground(new Color(215, 230, 253));
        }
        tf.getDocument().addDocumentListener(this.createDocChangeAdaptor(tf));
        return tf;
    }

    public DocumentAdaptor createDocChangeAdaptor(final JTextField tf) {
        return new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                BaseSetupPanel.this.textChanged(tf);
                BaseSetupPanel.this.updateBtnUI();
            }
        };
    }

    protected void textChanged(JTextField txt) {
    }

    protected JCheckBox createCheckBox(PanelBuilder builder, String label, int row) {
        CellConstraints cc = new CellConstraints();
        JCheckBox checkbox = UIHelper.createCheckBox(UIRegistry.getResourceString(label));
        JLabel lbl = UIHelper.createI18NLabel(" ", 4);
        builder.add((Component)lbl, cc.xy(1, row));
        builder.add((Component)checkbox, cc.xyw(3, row, this.makeStretchy ? 2 : 1));
        return checkbox;
    }

    @Override
    public Component getUIComponent() {
        return this;
    }
}

