/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.io.FileInputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class UserGroupType
implements Comparable<UserGroupType> {
    private static final Logger log = Logger.getLogger(UserGroupType.class);
    protected static SoftReference<Vector<UserGroupType>> userTypeList = null;
    protected static SoftReference<Hashtable<String, UserGroupType>> userTypeHash = null;
    protected String name;

    public UserGroupType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(UserGroupType obj) {
        return this.name.compareTo(obj.name);
    }

    public static UserGroupType getUserType(String name) {
        UserGroupType UserType2 = UserGroupType.getUserTypeHash().get(name);
        if (UserType2 == null) {
            log.error((Object)("Couldn't locate UserType[" + name + "]"));
        }
        return UserType2;
    }

    public static UserGroupType getByName(String name) {
        for (UserGroupType UserType2 : UserGroupType.getUserTypeList()) {
            if (!name.equals(UserType2.getName())) continue;
            return UserType2;
        }
        return null;
    }

    public static Vector<UserGroupType> getUserTypeList() {
        Vector<UserGroupType> list = null;
        if (userTypeList != null) {
            list = userTypeList.get();
        }
        if (list == null) {
            userTypeList = new SoftReference<Vector<UserGroupType>>(UserGroupType.loadUserTypeList());
        }
        return userTypeList.get();
    }

    protected static Vector<UserGroupType> loadUserTypeList() {
        Vector<UserGroupType> list;
        block4: {
            list = new Vector<UserGroupType>();
            try {
                Element root = XMLHelper.readFileToDOM4J(new FileInputStream(XMLHelper.getConfigDirPath("usertypes.xml")));
                if (root != null) {
                    Iterator i = root.elementIterator("UserType");
                    while (i.hasNext()) {
                        Element disciplineNode = (Element)i.next();
                        String name = XMLHelper.getAttr(disciplineNode, "name", null);
                        UserGroupType UserType2 = new UserGroupType(name);
                        list.add(UserType2);
                    }
                    break block4;
                }
                String msg = "The root element for the document was null!";
                log.error((Object)msg);
                throw new ConfigurationException(msg);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UserGroupType.class, ex);
                ex.printStackTrace();
                log.error((Object)ex);
            }
        }
        Collections.sort(list);
        return list;
    }

    public static Hashtable<String, UserGroupType> getUserTypeHash() {
        Hashtable<String, UserGroupType> hash = null;
        if (userTypeHash != null) {
            hash = userTypeHash.get();
        }
        if (hash == null) {
            userTypeHash = new SoftReference<Hashtable<String, UserGroupType>>(UserGroupType.loadUserTypeHash());
        }
        return userTypeHash.get();
    }

    protected static Hashtable<String, UserGroupType> loadUserTypeHash() {
        Hashtable<String, UserGroupType> dispHash = new Hashtable<String, UserGroupType>();
        for (UserGroupType UserType2 : UserGroupType.getUserTypeList()) {
            dispHash.put(UserType2.getName(), UserType2);
        }
        return dispHash;
    }
}

