/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class SpecifyWebLinkMgr
extends WebLinkMgr
implements CommandListener {
    private static final String DISCIPLINE = "Discipline";
    private static final String WEBLINKS = "WebLinks";
    private static final String DISKLOC = "common/weblinks.xml";
    protected static boolean doingLocal = false;

    public SpecifyWebLinkMgr() {
        this.read();
    }

    public SpecifyWebLinkMgr(SpecifyWebLinkMgr specifyWebLinkMgr) {
        super(specifyWebLinkMgr);
        CommandDispatcher.register(DISCIPLINE, this);
        this.read();
    }

    public static void setDoingLocal(boolean doingLocal) {
        SpecifyWebLinkMgr.doingLocal = doingLocal;
    }

    @Override
    public void read() {
        this.reset();
        String xml = null;
        if (doingLocal) {
            File file = XMLHelper.getConfigDir(DISKLOC);
            try {
                xml = FileUtils.readFileToString((File)file);
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyWebLinkMgr.class, ex);
                ex.printStackTrace();
            }
        } else {
            block18: {
                SpecifyAppContextMgr acMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        SpecifyUser user = acMgr.getClassObject(SpecifyUser.class);
                        Discipline discipline = acMgr.getClassObject(Discipline.class);
                        SpAppResourceDir appResDir = acMgr.getAppResDir(session, user, discipline, null, null, false, WEBLINKS, false);
                        if (appResDir != null) {
                            SpAppResource appRes = appResDir.getResourceByName(WEBLINKS);
                            if (appRes != null) {
                                session.close();
                                session = null;
                                xml = AppContextMgr.getInstance().getResourceAsXML(appRes);
                            }
                        } else {
                            File file = XMLHelper.getConfigDir(DISKLOC);
                            try {
                                xml = FileUtils.readFileToString((File)file);
                            }
                            catch (IOException ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(SpecifyWebLinkMgr.class, ex);
                                ex.printStackTrace();
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyUIFieldFormatterMgr.class, ex);
                        if (session != null) {
                            session.close();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            if (xml != null) {
                this.loadFromXML(xml);
            }
        }
    }

    @Override
    public void write() {
        if (this.hasChanged) {
            if (doingLocal) {
                File outputFile = XMLHelper.getConfigDir(DISKLOC);
                try {
                    FileUtils.writeStringToFile((File)outputFile, (String)this.convertToXML());
                    this.hasChanged = false;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyWebLinkMgr.class, ex);
                    ex.printStackTrace();
                }
            } else {
                SpecifyUIFieldFormatterMgr.saveDisciplineResource(AppContextMgr.getInstance(), WEBLINKS, this.convertToXML());
                this.hasChanged = false;
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(DISCIPLINE) && cmdAction.isAction("Changed")) {
            this.read();
        }
    }
}

