/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.DisciplineBasedContainer;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpecifySchemaI18NServiceXML
extends SchemaI18NService {
    private static final Logger log = Logger.getLogger(SpecifySchemaI18NServiceXML.class);
    protected SchemaLocalizerXMLHelper schemaIO = null;

    protected void setNameDesc(Set<SpLocaleItemStr> names, Set<SpLocaleItemStr> descs, DBInfoBase info) {
        for (SpLocaleItemStr str : names) {
            if (!str.getLanguage().equals(currentLocale.getLanguage())) continue;
            info.setTitle(str.getText());
            break;
        }
        for (SpLocaleItemStr str : descs) {
            if (!str.getLanguage().equals(currentLocale.getLanguage())) continue;
            info.setDescription(StringEscapeUtils.unescapeXml((String)str.getText()));
            break;
        }
    }

    @Override
    public void loadWithLocale(Byte schemaType, int disciplineId, DBTableIdMgr tableMgr, Locale locale) {
        this.schemaIO = new SchemaLocalizerXMLHelper(schemaType, tableMgr);
        this.schemaIO.load(true);
        Vector<DisciplineBasedContainer> containers = this.schemaIO.getSpLocaleContainers();
        for (DisciplineBasedContainer container : containers) {
            DBTableInfo ti = tableMgr.getInfoByTableName(container.getName());
            if (ti != null) {
                this.setNameDesc(container.getNames(), container.getDescs(), ti);
                for (SpLocaleContainerItem item : container.getItems()) {
                    DBFieldInfo fi = ti.getFieldByName(item.getName());
                    if (fi != null) {
                        this.setNameDesc(item.getNames(), item.getDescs(), fi);
                        continue;
                    }
                    DBRelationshipInfo ri = ti.getRelationshipByName(item.getName());
                    if (ri != null) {
                        this.setNameDesc(item.getNames(), item.getDescs(), ri);
                        continue;
                    }
                    log.error((Object)("Couldn't find field [" + item.getName() + "] in table [" + ti.getName() + "]"));
                }
                continue;
            }
            log.error((Object)("Couldn't find table [" + container.getName() + "]"));
        }
    }

    @Override
    public List<Locale> getLocalesFromData(Byte schemaType, int disciplineId) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        HashSet<String> hash = new HashSet<String>();
        for (DisciplineBasedContainer container : this.schemaIO.getSpLocaleContainers()) {
            for (SpLocaleItemStr str : container.getNames()) {
                String language = str.getLanguage();
                String country = str.getCountry();
                String variant = str.getVariant();
                String key = String.format("%s_%s_%s", language, country != null ? country : "", variant != null ? variant : "");
                if (hash.contains(key)) continue;
                hash.add(key);
                Locale locale = null;
                if (StringUtils.isNotBlank((String)language) && StringUtils.isNotBlank((String)country) && StringUtils.isNotBlank((String)variant)) {
                    locale = new Locale(language, country, variant);
                } else if (StringUtils.isNotBlank((String)language) && StringUtils.isNotBlank((String)country)) {
                    locale = new Locale(language, country);
                } else if (StringUtils.isNotBlank((String)language)) {
                    locale = new Locale(language);
                }
                if (locale == null) continue;
                locales.add(locale);
            }
        }
        return locales;
    }
}

