/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpecifySchemaI18NService
extends SchemaI18NService {
    private static final Logger log = Logger.getLogger(SpecifySchemaI18NService.class);

    @Override
    public void loadWithLocale(Byte schemaType, int disciplineId, DBTableIdMgr mgr, Locale locale) {
        Boolean isHidden;
        DBTableChildIFace tblChild;
        String nm;
        DBTableInfo ti;
        String sql = String.format("SELECT Name, IsHidden FROM  splocalecontainer WHERE SchemaType = %d AND DisciplineID = %d", schemaType, disciplineId);
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        for (Object[] row : rows) {
            ti = mgr.getInfoByTableName(row[0].toString());
            if (ti != null) {
                Boolean isHidden2 = (Boolean)row[1];
                ti.setHidden(isHidden2 != null ? isHidden2 : false);
                continue;
            }
            log.error((Object)("Couldn't find table [" + row[0] + "]"));
        }
        sql = "SELECT cn.Name, Text, cn.Aggregator, cn.IsUIFormatter, cn.Format FROM splocalecontainer cn INNER JOIN splocaleitemstr ON cn.SpLocaleContainerID = splocaleitemstr.SpLocaleContainerNameID where Language = '" + locale.getLanguage() + "' AND " + "cn.SchemaType = " + schemaType + " AND cn.DisciplineID = " + disciplineId;
        rows = BasicSQLUtils.query(sql);
        for (Object[] row : rows) {
            ti = mgr.getInfoByTableName(row[0].toString());
            if (ti != null) {
                ti.setTitle(row[1].toString());
                ti.setAggregatorName(row[2] != null ? row[2].toString() : null);
                if (row[4] == null) continue;
                if (row[3] != null && ((Boolean)row[3]).booleanValue()) {
                    ti.setUiFormatter(row[4].toString());
                    continue;
                }
                ti.setDataObjFormatter(row[4].toString());
                continue;
            }
            log.error((Object)("Couldn't find table [" + row[0] + "]"));
        }
        sql = "SELECT cn.Name,Text FROM splocalecontainer cn INNER JOIN splocaleitemstr ON cn.SpLocaleContainerID = splocaleitemstr.SpLocaleContainerDescID where Language = '" + locale.getLanguage() + "' AND " + "cn.SchemaType = " + schemaType + " AND cn.DisciplineID = " + disciplineId;
        rows = BasicSQLUtils.query(sql);
        for (Object[] row : rows) {
            ti = mgr.getInfoByTableName(row[0].toString());
            if (ti != null) {
                ti.setDescription(StringEscapeUtils.unescapeXml(row[1] != null ? row[1].toString() : null));
                continue;
            }
            log.error((Object)("Couldn't find table [" + row[0] + "]"));
        }
        sql = "SELECT cn.Name,splocalecontaineritem.Name,splocalecontaineritem.Format, splocalecontaineritem.IsUIFormatter, splocalecontaineritem.PickListName, splocaleitemstr.Text, splocalecontaineritem.IsHidden, splocalecontaineritem.WebLinkName , splocalecontaineritem.IsRequired  FROM splocalecontainer cn INNER JOIN splocalecontaineritem ON cn.SpLocaleContainerID = splocalecontaineritem.SpLocaleContainerID INNER JOIN splocaleitemstr ON splocalecontaineritem.SpLocaleContainerItemID = splocaleitemstr.SpLocaleContainerItemNameID  where splocaleitemstr.Language = '" + locale.getLanguage() + "' AND " + "cn.SchemaType = " + schemaType + " AND cn.DisciplineID = " + disciplineId + " order by cn.Name";
        log.debug((Object)sql);
        String name = "";
        DBTableInfo ti2 = null;
        rows = BasicSQLUtils.query(sql);
        for (Object[] row : rows) {
            nm = row[0].toString();
            if (!name.equals(nm)) {
                ti2 = mgr.getInfoByTableName(nm);
                name = nm;
            }
            if (ti2 != null) {
                tblChild = ti2.getItemByName(row[1].toString());
                if (tblChild != null) {
                    tblChild.setTitle(row[5] != null ? row[5].toString() : null);
                    isHidden = (Boolean)row[6];
                    tblChild.setHidden(isHidden != null ? isHidden : false);
                } else {
                    log.error((Object)("Couldn't find field[" + row[1] + "] for table [" + row[0] + "]"));
                }
                if (!(tblChild instanceof DBFieldInfo)) continue;
                String format = row[2] == null ? null : row[2].toString();
                boolean isUIFmt = row[3] == null ? false : (Boolean)row[3];
                String pickListName = row[4] == null ? null : row[4].toString();
                String webLinkName = row[7] == null ? null : row[7].toString();
                boolean isRequired = row[8] == null ? false : (Boolean)row[8];
                DBFieldInfo fieldInfo = (DBFieldInfo)tblChild;
                fieldInfo.setPickListName(pickListName);
                fieldInfo.setWebLinkName(webLinkName);
                if (!fieldInfo.isRequired() && isRequired) {
                    fieldInfo.setRequired(isRequired);
                }
                if (isUIFmt) {
                    UIFieldFormatterIFace formatter = UIFieldFormatterMgr.getInstance().getFormatter(format);
                    if (formatter != null) {
                        fieldInfo.setFormatter(formatter);
                        continue;
                    }
                    log.error((Object)("Couldn't find UIFieldFormatter with name [" + format + "]"));
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)format)) continue;
                fieldInfo.setFormatStr(format);
                continue;
            }
            log.error((Object)("Couldn't find table [" + row[0] + "]"));
        }
        sql = "SELECT cn.Name, splocalecontaineritem.Name, splocaleitemstr.Text, splocalecontaineritem.IsHidden FROM splocalecontainer cn INNER JOIN splocalecontaineritem ON cn.SpLocaleContainerID = splocalecontaineritem.SpLocaleContainerID INNER JOIN splocaleitemstr ON splocalecontaineritem.SpLocaleContainerItemID = splocaleitemstr.SpLocaleContainerItemDescID  where splocaleitemstr.Language = '" + locale.getLanguage() + "' AND " + "cn.SchemaType = " + schemaType + " AND cn.DisciplineID = " + disciplineId + " order by cn.Name";
        name = "";
        ti2 = null;
        rows = BasicSQLUtils.query(sql);
        for (Object[] row : rows) {
            nm = row[0].toString();
            if (!name.equals(nm)) {
                ti2 = mgr.getInfoByTableName(nm);
                name = nm;
            }
            if (ti2 != null) {
                tblChild = ti2.getItemByName(row[1].toString());
                if (tblChild != null) {
                    tblChild.setDescription(row[2] != null ? row[2].toString() : null);
                    isHidden = (Boolean)row[3];
                    tblChild.setHidden(isHidden != null ? isHidden : false);
                    continue;
                }
                log.error((Object)("Couldn't find field[" + row[1] + "] for table [" + nm + "]"));
                continue;
            }
            log.error((Object)("Couldn't find table [" + nm + "]"));
        }
    }

    @Override
    public List<Locale> getLocalesFromData(Byte schemaType, int disciplineId) {
        ArrayList<Locale> localesList = new ArrayList<Locale>();
        String sql = String.format("SELECT i.Language, i.Country, i.Variant FROM splocalecontainer cn INNER JOIN splocaleitemstr i ON cn.SpLocaleContainerID = i.SpLocaleContainerNameID WHERE cn.SchemaType = %d AND cn.DisciplineID = %d GROUP BY Language, Country, Variant", schemaType, disciplineId);
        for (Object[] row : BasicSQLUtils.query(sql)) {
            String language = (String)row[0];
            String country = (String)row[1];
            String variant = (String)row[2];
            Locale locale = null;
            if (StringUtils.isNotEmpty((String)language) && StringUtils.isNotEmpty((String)country) && StringUtils.isNotEmpty((String)variant)) {
                locale = new Locale(language, country, variant);
            } else if (StringUtils.isNotEmpty((String)language) && StringUtils.isNotEmpty((String)country)) {
                locale = new Locale(language, country);
            } else if (StringUtils.isNotEmpty((String)language)) {
                locale = new Locale(language);
            }
            if (locale == null) continue;
            localesList.add(locale);
        }
        return localesList;
    }
}

