/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.GenericLSIDGeneratorFactory;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class SpecifyLSIDGeneratorFactory
extends GenericLSIDGeneratorFactory {
    protected static String PREF_NAME_PREFIX = "Prefs.LSID.";
    protected static int[] TABLE_IDS = new int[]{1, 4, 3, 100, 2, 5, 69, 51};
    protected String I18NPre = SpecifyLSIDGeneratorFactory.class.getSimpleName();
    protected StringBuilder errMsg = new StringBuilder();
    protected Boolean isReady = null;
    protected String lsidAuthority = null;
    protected String instCode = null;
    protected String colCode = null;

    @Override
    public boolean isReady() {
        if (this.isReady == null) {
            this.errMsg.setLength(0);
            Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
            if (inst != null) {
                this.lsidAuthority = inst.getLsidAuthority();
                if (StringUtils.isEmpty((String)this.lsidAuthority)) {
                    this.errMsg.append(String.valueOf(UIRegistry.getResourceString(String.valueOf(this.I18NPre) + ".ERR_AUTH")) + "\n");
                }
                this.instCode = inst.getCode();
                if (StringUtils.isEmpty((String)this.instCode)) {
                    this.errMsg.append(String.valueOf(UIRegistry.getResourceString(String.valueOf(this.I18NPre) + ".ERR_INCD")) + "\n");
                }
            } else {
                this.errMsg.append("Institution cannot be null to generate the LSID.\n");
                this.isReady = false;
                return this.isReady;
            }
            Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
            if (collection != null) {
                this.colCode = collection.getCode();
                if (StringUtils.isEmpty((String)this.colCode)) {
                    this.errMsg.append(String.valueOf(UIRegistry.getResourceString(String.valueOf(this.I18NPre) + ".ERR_CLCD")) + "\n");
                }
            } else {
                this.errMsg.append("Collection cannot be null to generate the LSID.\n");
                this.isReady = false;
                return this.isReady;
            }
            this.isReady = this.errMsg.length() == 0;
        }
        return this.isReady;
    }

    @Override
    public String getErrorMsg() {
        return super.getErrorMsg();
    }

    @Override
    public void reset() {
        this.isReady = null;
    }

    @Override
    public String createLSID(GenericLSIDGeneratorFactory.CATEGORY_TYPE category, String id) {
        if (this.isReady() && category != null && StringUtils.isNotEmpty((String)id)) {
            return String.format("urn:lsid:%s:%s-%s:%s:%s", this.lsidAuthority, this.instCode, this.colCode, category.toString(), id);
        }
        return null;
    }

    @Override
    public String createLSID(GenericLSIDGeneratorFactory.CATEGORY_TYPE category, String id, int version) {
        if (this.isReady() && category != null && StringUtils.isNotEmpty((String)id)) {
            return String.format("urn:lsid:%s:%s-%s:%s:%s:%d", this.lsidAuthority, this.instCode, this.colCode, category.toString(), id, version);
        }
        return super.createLSID(category, id, version);
    }

    protected GenericLSIDGeneratorFactory.CATEGORY_TYPE getCategoryFromTableId(int tableId) {
        GenericLSIDGeneratorFactory.CATEGORY_TYPE[] cATEGORY_TYPEArray = GenericLSIDGeneratorFactory.CATEGORY_TYPE.values();
        int n = cATEGORY_TYPEArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericLSIDGeneratorFactory.CATEGORY_TYPE cat = cATEGORY_TYPEArray[n2];
            if (tableId == TABLE_IDS[cat.ordinal()]) {
                return cat;
            }
            ++n2;
        }
        return null;
    }

    public boolean isPrefOn(int tableId) {
        GenericLSIDGeneratorFactory.CATEGORY_TYPE cat = this.getCategoryFromTableId(tableId);
        if (cat != null) {
            return AppPreferences.getRemote().getBoolean(String.valueOf(PREF_NAME_PREFIX) + cat.toString(), false);
        }
        return false;
    }

    @Override
    public void buildLSIDs(PropertyChangeListener pcl) {
        DBFieldInfo fi = DBTableIdMgr.getInstance().getInfoById(1).getFieldByColumnName("CatalogNumber");
        UIFieldFormatterIFace formatter = fi.getFormatter();
        if (!formatter.isInBoundFormatter()) {
            formatter = null;
        }
        this.reset();
        if (this.isReady()) {
            boolean doVersioning = true;
            int count = 1;
            GenericLSIDGeneratorFactory.CATEGORY_TYPE[] cATEGORY_TYPEArray = GenericLSIDGeneratorFactory.CATEGORY_TYPE.values();
            int n = cATEGORY_TYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                block14: {
                    GenericLSIDGeneratorFactory.CATEGORY_TYPE cat = cATEGORY_TYPEArray[n2];
                    String pName = String.valueOf(PREF_NAME_PREFIX) + cat.toString();
                    if (pcl != null) {
                        pcl.propertyChange(new PropertyChangeEvent(this, "COUNT", 0, count++));
                    }
                    if (AppPreferences.getRemote().getBoolean(pName, false).booleanValue()) {
                        try {
                            try {
                                this.buildLSIDs(DBConnection.getInstance().getConnection(), cat, doVersioning, formatter);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                if (pcl != null) {
                                    pcl.propertyChange(new PropertyChangeEvent(this, "COUNT", 0, count));
                                }
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            if (pcl != null) {
                                pcl.propertyChange(new PropertyChangeEvent(this, "COUNT", 0, count));
                            }
                            throw throwable;
                        }
                        if (pcl != null) {
                            pcl.propertyChange(new PropertyChangeEvent(this, "COUNT", 0, count));
                        }
                    }
                }
                ++count;
                ++n2;
            }
        } else {
            UIRegistry.showError(this.errMsg.toString());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String setLSIDOnId(FormDataObjIFace data, boolean doVersioning, UIFieldFormatterIFace formatter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int buildLSIDs(Connection connection, GenericLSIDGeneratorFactory.CATEGORY_TYPE category, boolean doVersioning, UIFieldFormatterIFace formatter) {
        Integer count;
        block22: {
            boolean isColObj = category == GenericLSIDGeneratorFactory.CATEGORY_TYPE.Specimen;
            count = 0;
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(TABLE_IDS[category.ordinal()]);
            if (tableInfo != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT COUNT(*) FROM ");
                sb.append(tableInfo.getName());
                sb.append(" WHERE GUID IS NULL OR GUID = 'null' OR GUID = ''");
                count = BasicSQLUtils.getCount(sb.toString());
                if (count != null && count > 0) {
                    sb.setLength(0);
                    sb.append("SELECT ");
                    sb.append(tableInfo.getIdFieldName());
                    sb.append(", Version");
                    if (isColObj) {
                        sb.append(", CatalogNumber");
                    }
                    sb.append(" FROM ");
                    sb.append(tableInfo.getName());
                    sb.append(" WHERE GUID IS NULL OR GUID = 'null' OR GUID = ''");
                    Statement stmt = null;
                    Statement updStmt = null;
                    try {
                        try {
                            stmt = connection.createStatement();
                            updStmt = connection.prepareStatement("UPDATE " + tableInfo.getName() + " SET GUID=? WHERE " + tableInfo.getIdFieldName() + "=?");
                            ResultSet rs = stmt.executeQuery(sb.toString());
                            while (rs.next()) {
                                String catNum;
                                Integer id = rs.getInt(1);
                                int version = rs.getInt(2);
                                String string = catNum = isColObj ? rs.getString(3) : null;
                                if (isColObj && !StringUtils.isNotEmpty((String)catNum)) continue;
                                String idStr = id.toString();
                                if (isColObj) {
                                    idStr = formatter != null ? (String)formatter.formatToUI(catNum) : catNum;
                                }
                                String lsid = doVersioning ? this.createLSID(category, idStr, version) : this.createLSID(category, idStr);
                                updStmt.setString(1, lsid);
                                updStmt.setInt(2, id);
                                if (updStmt.executeUpdate() == 1) continue;
                                String msg = "Error updating table[" + tableInfo.getName() + "] field[" + tableInfo.getIdFieldName() + "] with GUID/LSID.";
                                System.err.println(msg);
                            }
                            rs.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                if (updStmt != null) {
                                    updStmt.close();
                                }
                                break block22;
                            }
                            catch (SQLException sQLException) {}
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (updStmt != null) {
                                updStmt.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (updStmt != null) {
                            updStmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        return count;
    }
}

