/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.FeedBackSenderItem;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;

public class SpecifyExceptionTracker
extends ExceptionTracker {
    protected ImageIcon forwardImgIcon;
    protected ImageIcon downImgIcon;
    protected JPanel stackTracePanel;
    protected CustomDialog dlg;

    @Override
    protected FeedBackSenderItem getFeedBackSenderItem(final Class<?> cls, Exception exception) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,8px,p,2px, p,4px,p,2px,f:p:g"));
        Vector<Taskable> taskItems = new Vector<Taskable>(TaskMgr.getInstance().getAllTasks());
        Collections.sort(taskItems, new Comparator<Taskable>(){

            @Override
            public int compare(Taskable o1, Taskable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        final JTextArea commentsTA = UIHelper.createTextArea(3, 60);
        final JTextArea stackTraceTA = UIHelper.createTextArea(15, 60);
        commentsTA.setWrapStyleWord(true);
        commentsTA.setLineWrap(true);
        JEditorPane desc = new JEditorPane("text/html", UIRegistry.getResourceString("UNHDL_EXCP"));
        desc.setEditable(false);
        desc.setOpaque(false);
        JScrollPane sp = new JScrollPane(stackTraceTA, 22, 32);
        int y = 1;
        pb.add((Component)desc, cc.xyw(1, y, 4));
        pb.add((Component)UIHelper.createI18NFormLabel("UNHDL_EXCP_CMM"), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createScrollPane(commentsTA, true), cc.xyw(1, y += 2, 4));
        y += 2;
        this.forwardImgIcon = IconManager.getIcon("Forward");
        this.downImgIcon = IconManager.getIcon("Down");
        final JCheckBox moreBtn = new JCheckBox(UIRegistry.getResourceString("LOGIN_DLG_MORE"), this.forwardImgIcon);
        UIHelper.setControlSize(moreBtn);
        JButton copyBtn = UIHelper.createI18NButton("UNHDL_EXCP_COPY");
        PanelBuilder innerPB = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,2px,p:g,2px,p"));
        innerPB.add((Component)UIHelper.createI18NLabel("UNHDL_EXCP_STK"), cc.xy(1, 1));
        innerPB.add((Component)sp, cc.xyw(1, 3, 3));
        innerPB.add((Component)copyBtn, cc.xy(1, 5));
        this.stackTracePanel = innerPB.getPanel();
        this.stackTracePanel.setVisible(false);
        pb.add((Component)moreBtn, cc.xyw(1, y, 4));
        pb.add((Component)this.stackTracePanel, cc.xyw(1, y += 2, 4));
        y += 2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exception.printStackTrace(new PrintStream(baos));
        stackTraceTA.setText(baos.toString());
        moreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpecifyExceptionTracker.this.stackTracePanel.isVisible()) {
                    SpecifyExceptionTracker.this.stackTracePanel.setVisible(false);
                    moreBtn.setIcon(SpecifyExceptionTracker.this.forwardImgIcon);
                } else {
                    SpecifyExceptionTracker.this.stackTracePanel.setVisible(true);
                    moreBtn.setIcon(SpecifyExceptionTracker.this.downImgIcon);
                }
                if (SpecifyExceptionTracker.this.dlg != null) {
                    SpecifyExceptionTracker.this.dlg.pack();
                }
            }
        });
        copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String taskName = SpecifyExceptionTracker.this.getTaskName();
                FeedBackSenderItem item = new FeedBackSenderItem(taskName, "", "", commentsTA.getText(), stackTraceTA.getText(), cls.getName());
                NameValuePair[] pairs = SpecifyExceptionTracker.this.createPostParameters(item);
                StringBuilder sb = new StringBuilder();
                NameValuePair[] nameValuePairArray = pairs;
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    NameValuePair pair = nameValuePairArray[n2];
                    if (!pair.getName().equals("bug")) {
                        sb.append(pair.getName());
                        sb.append(": ");
                        if (pair.getName().equals("comments") || pair.getName().equals("stack_trace")) {
                            sb.append("\n");
                        }
                        sb.append(pair.getValue());
                        sb.append("\n");
                    }
                    ++n2;
                }
                UIHelper.setTextToClipboard(sb.toString());
            }
        });
        pb.setDefaultDialogBorder();
        this.dlg = new CustomDialog(null, UIRegistry.getResourceString("UnhandledExceptionTitle"), true, 1, (Component)pb.getPanel());
        this.dlg.setOkLabel(UIRegistry.getResourceString("UNHDL_EXCP_SEND"));
        this.dlg.createUI();
        this.stackTracePanel.setVisible(false);
        UIHelper.centerAndShow(this.dlg);
        String taskName = this.getTaskName();
        FeedBackSenderItem item = new FeedBackSenderItem(taskName, "", "", commentsTA.getText(), stackTraceTA.getText(), cls.getName());
        return item;
    }

    private String getTaskName() {
        String taskName = "";
        if (SubPaneMgr.getInstance().getCurrentSubPane() != null && SubPaneMgr.getInstance().getCurrentSubPane().getTask() != null) {
            Taskable tsk;
            Taskable currTask = SubPaneMgr.getInstance().getCurrentSubPane().getTask();
            Taskable taskable = tsk = currTask != null ? currTask : TaskMgr.getDefaultTaskable();
            if (tsk != null) {
                taskName = tsk.getName();
            }
        }
        return taskName;
    }

    @Override
    protected Vector<NameValuePair> collectionSecondaryInfo(FeedBackSenderItem item) {
        AppContextMgr mgr = AppContextMgr.getInstance();
        Vector<NameValuePair> stats = new Vector<NameValuePair>();
        if (mgr.hasContext()) {
            String email;
            Collection collection = mgr.getClassObject(Collection.class);
            Discipline discipline = mgr.getClassObject(Discipline.class);
            Division division = mgr.getClassObject(Division.class);
            Institution institution = mgr.getClassObject(Institution.class);
            stats.add(new NameValuePair("collection", collection != null ? collection.getCollectionName() : "No Collection"));
            stats.add(new NameValuePair("discipline", discipline != null ? discipline.getName() : "No Discipline"));
            stats.add(new NameValuePair("division", division != null ? division.getName() : "No Division"));
            stats.add(new NameValuePair("institution", institution != null ? institution.getName() : "No Institution"));
            stats.add(new NameValuePair("Collection_number", collection != null ? collection.getRegNumber() : "No Collection Number"));
            stats.add(new NameValuePair("Discipline_number", discipline != null ? discipline.getRegNumber() : "No Discipline Number"));
            stats.add(new NameValuePair("Division_number", division != null ? division.getRegNumber() : "No Division Number"));
            stats.add(new NameValuePair("Institution_number", institution != null ? institution.getRegNumber() : "No Institution Number"));
            if (collection != null && StringUtils.isNotEmpty((String)collection.getIsaNumber())) {
                stats.add(new NameValuePair("ISA_number", collection.getIsaNumber()));
            }
            if (item.isIncludeEmail() && StringUtils.isNotEmpty((String)(email = ((SpecifyAppContextMgr)mgr).getMailAddr(true)))) {
                stats.add(new NameValuePair("email", email));
            }
        }
        return stats;
    }
}

