/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.Taxon;
import java.sql.ResultSet;
import java.util.List;
import java.util.Vector;

public class SpecifyDBTableIdMgr
extends DBTableIdMgr
implements SQLExecutionListener {
    private Vector<String> names = null;

    public SpecifyDBTableIdMgr() {
        super(true);
    }

    @Override
    public List<String> getTreeFieldNames(DBTableInfo tableInfo) {
        Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        Institution institution = AppContextMgr.getInstance().getClassObject(Institution.class);
        Integer id = null;
        if (tableInfo.getClassObj() == Taxon.class) {
            id = discipline.getTaxonTreeDef().getId();
        } else if (tableInfo.getClassObj() == Geography.class) {
            id = discipline.getGeographyTreeDef().getId();
        } else if (tableInfo.getClassObj() == GeologicTimePeriod.class) {
            id = discipline.getGeologicTimePeriodTreeDef().getId();
        } else if (tableInfo.getClassObj() == LithoStrat.class) {
            id = discipline.getLithoStratTreeDef().getId();
        } else if (tableInfo.getClassObj() == Storage.class) {
            id = institution.getStorageTreeDef().getId();
        } else {
            return null;
        }
        String sql = String.format("select Name, RankId from TaxonTreeDefItem WHERE TaxonTreeDefID = %d ORDER BY RankID asc", id);
        SQLExecutionProcessor sqlProc = new SQLExecutionProcessor(this, sql);
        sqlProc.execute();
        return this.names;
    }

    @Override
    public void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
        this.names = new Vector();
        try {
            while (resultSet.next()) {
                if (resultSet.getInt(2) <= 0) continue;
                this.names.add(resultSet.getString(1));
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyDBTableIdMgr.class, ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void executionError(SQLExecutionProcessor process, Exception ex) {
    }
}

