/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.ViewSetMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSet;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.ChooseCollectionDlg;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.FixDBAfterLogin;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.config.init.RegisterSpecify;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Borrow;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.ExchangeIn;
import edu.ku.brc.specify.datamodel.ExchangeOut;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.Gift;
import edu.ku.brc.specify.datamodel.InfoRequest;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.Permit;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpViewSetObj;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.prefs.FormattingPrefsPanel;
import edu.ku.brc.specify.tasks.BaseTreeTask;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconEntry;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.UnhandledExceptionDialog;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.Triple;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.exception.SQLGrammarException;

public class SpecifyAppContextMgr
extends AppContextMgr {
    private static final Logger log = Logger.getLogger(SpecifyAppContextMgr.class);
    private static final String L10N = "SpecifyAppContextMgr.";
    public static final String PERSONALDIR = "Personal";
    public static final String USERTYPEDIR = "UserType";
    public static final String COLLECTIONDIR = "Collection";
    public static final String DISCPLINEDIR = "Discipline";
    public static final String COMMONDIR = "Common";
    public static final String BACKSTOPDIR = "BackStop";
    private static Boolean isNewJavaVersion = null;
    protected Vector<SpAppResourceDir> spAppResourceList = new Vector();
    protected Hashtable<String, SpAppResourceDir> spAppResourceHash = new Hashtable();
    protected Hashtable<String, List<ViewSetIFace>> viewSetHash = new Hashtable();
    protected Hashtable<String, Pair<String, File>> viewSetMgrHash = new Hashtable();
    protected String databaseName = null;
    protected String userName = null;
    protected SpecifyUser user = null;
    protected Agent currentUserAgent = null;
    protected boolean forceReloadViews = false;
    protected boolean debug = false;
    protected long lastLoadTime = 0L;
    protected long lastLoadTimeBS = 0L;
    protected UnhandledExceptionDialog uheDlg = null;
    protected DataProviderSessionIFace globalSession = null;
    protected int openSessionCount = 0;
    protected Boolean isSecurityOn = null;

    public static SpecifyAppContextMgr getInstance() {
        return (SpecifyAppContextMgr)AppContextMgr.getInstance();
    }

    public void setForceReloadViews(boolean forceReloadViews) {
        this.forceReloadViews = forceReloadViews;
    }

    public static String[] getVirtualDirNames() {
        String[] levels = new String[]{PERSONALDIR, USERTYPEDIR, COLLECTIONDIR, DISCPLINEDIR, COMMONDIR, BACKSTOPDIR};
        return levels;
    }

    public static String getVirtualDirName(int index) {
        String[] levels = SpecifyAppContextMgr.getVirtualDirNames();
        return levels[index];
    }

    public static int getVirtualDirIndex(String virtualDirName) {
        String[] levels = SpecifyAppContextMgr.getVirtualDirNames();
        int i = 0;
        while (i < levels.length) {
            if (virtualDirName.equals(levels[i])) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Virtual Directory name [" + virtualDirName + "] isn't found.");
    }

    @Override
    public Hashtable<String, List<ViewSetIFace>> getViewSetHash() {
        return this.viewSetHash;
    }

    @Override
    public Taskable getTaskFromTableId(int tableId) {
        String taskName = tableId == Accession.getClassTableId() || tableId == Permit.getClassTableId() || tableId == Loan.getClassTableId() || tableId == InfoRequest.getClassTableId() || tableId == Gift.getClassTableId() || tableId == ExchangeIn.getClassTableId() || tableId == ExchangeOut.getClassTableId() || tableId == Borrow.getClassTableId() ? "Interactions" : "Data_Entry";
        return TaskMgr.getTask(taskName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void replaceSpDirItem(int index, SpAppResourceDir newDir) {
        SpAppResourceDir oldDir = this.spAppResourceList.get(index);
        this.spAppResourceList.remove(index);
        this.spAppResourceList.insertElementAt(newDir, index);
        String key = null;
        for (String hashKey : this.spAppResourceHash.keySet()) {
            if (this.spAppResourceHash.get(hashKey) != oldDir) continue;
            key = hashKey;
            break;
        }
        if (key != null) {
            this.spAppResourceHash.put(key, newDir);
        }
    }

    protected DataProviderSessionIFace openSession() {
        if (this.globalSession == null) {
            try {
                this.globalSession = DataProviderFactory.getInstance().createSession();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                return null;
            }
        }
        ++this.openSessionCount;
        return this.globalSession;
    }

    protected void closeSession() {
        if (this.globalSession != null) {
            --this.openSessionCount;
            if (this.openSessionCount == 0) {
                this.globalSession.close();
                this.globalSession = null;
            } else if (this.openSessionCount < 0) {
                log.error((Object)"Open Session Count just went negitive!");
            }
        } else {
            log.error((Object)"There is no existing open session.");
        }
    }

    public int getNumOfCollectionsForUser() {
        String sqlStr = "SELECT count(cs) From Collection as cs INNER JOIN cs.userGroups as princ INNER JOIN princ.specifyUsers as user where user.specifyUserId = " + this.user.getSpecifyUserId();
        DataProviderSessionIFace session = null;
        try {
            session = this.openSession();
            Object result = session.getData(sqlStr);
            int n = result != null ? (Integer)result : 0;
            return n;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
            ex.printStackTrace();
        }
        finally {
            this.closeSession();
        }
        return 0;
    }

    public List<Integer> getCollectionIdList(DataProviderSessionIFace sessionArg) {
        Vector<Integer> list = new Vector<Integer>();
        SpecifyUser spUser = this.getClassObject(SpecifyUser.class);
        if (spUser != null) {
            sessionArg.attach(spUser);
            for (Agent agent : spUser.getAgents()) {
                for (Discipline discipline : agent.getDivision().getDisciplines()) {
                    for (Collection collection : discipline.getCollections()) {
                        list.add((int)collection.getCollectionId());
                    }
                }
            }
        } else {
            log.error((Object)"SpecifyUser was null!");
        }
        return list;
    }

    protected Collection setupCurrentCollection(SpecifyUser userArg, boolean promptForCollection, String collectionName) {
        DataProviderSessionIFace session = null;
        try {
            AppPreferences remotePrefs = AppPreferences.getRemote();
            session = DataProviderFactory.getInstance().createSession();
            SpecifyUser spUser = session.getData(SpecifyUser.class, "id", userArg.getId(), DataProviderSessionIFace.CompareType.Equals);
            String alwaysAskPref = "ALWAYS.ASK.COLL";
            boolean askForColl = remotePrefs.getBoolean(alwaysAskPref, true);
            String prefName = this.mkUserDBPrefName("recent_collection_id");
            Hashtable<String, Pair<String, Integer>> collectionHash = new Hashtable<String, Pair<String, Integer>>();
            String sqlStr = String.format("SELECT DISTINCT cln.CollectionID, cln.CollectionName, cln.DisciplineID FROM collection AS cln Inner Join spprincipal AS p ON cln.UserGroupScopeId = p.userGroupScopeID Inner Join specifyuser_spprincipal AS su_pr ON p.SpPrincipalID = su_pr.SpPrincipalID WHERE su_pr.SpecifyUserID = %d AND GroupSubClass = '%s'", spUser.getSpecifyUserId(), UserPrincipal.class.getName());
            for (Object[] row : BasicSQLUtils.query(sqlStr)) {
                String collName = row[1].toString();
                Integer collId = (Integer)row[0];
                if (collectionHash.get(collName) != null) {
                    String dispName = (String)BasicSQLUtils.querySingleObj("SELECT Name FROM discipline WHERE DisciplineID = " + row[2]);
                    if (collectionHash.get(collName = String.valueOf(collName) + " - " + dispName) != null) {
                        String sql = "SELECT d.DivisionID FROM collection c INNER JOIN discipline d ON c.DisciplineID = d.UserGroupScopeId WHERE d.DisciplineID = " + row[2];
                        String divName = (String)BasicSQLUtils.querySingleObj(sql);
                        collName = String.valueOf(collName) + " - " + divName;
                    }
                }
                collectionHash.put(collName, new Pair<String, Integer>(collName, collId));
            }
            Pair<String, Integer> currColl = null;
            if (collectionName == null) {
                String recentIds;
                String string = recentIds = askForColl || promptForCollection ? null : remotePrefs.get(prefName, null);
                if (StringUtils.isNotEmpty(recentIds)) {
                    Vector<Object[]> rows = BasicSQLUtils.query("SELECT CollectionName, UserGroupScopeId FROM collection WHERE UserGroupScopeId = " + recentIds);
                    if (rows.size() == 1) {
                        String collName = rows.get(0)[0].toString();
                        Integer collId = (Integer)rows.get(0)[1];
                        currColl = new Pair<String, Integer>(collName, collId);
                    } else {
                        log.debug((Object)"could NOT find recent ids");
                    }
                }
                if (currColl != null && collectionHash.get(currColl.first) == null) {
                    currColl = null;
                }
            }
            if (currColl == null || askForColl && promptForCollection) {
                if (collectionHash.size() == 1) {
                    currColl = (Pair<String, Integer>)collectionHash.elements().nextElement();
                } else if (collectionHash.size() > 0) {
                    if (collectionName == null) {
                        Vector<Pair<String, Integer>> list = new Vector<Pair<String, Integer>>();
                        list.addAll(collectionHash.values());
                        Collections.sort(list, new Comparator<Pair<String, Integer>>(){

                            @Override
                            public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                                return ((String)o1.first).compareTo((String)o2.first);
                            }
                        });
                        int selectColInx = -1;
                        ChooseCollectionDlg colDlg = null;
                        do {
                            colDlg = new ChooseCollectionDlg(list);
                            colDlg.setSelectedIndex(selectColInx);
                            colDlg.createUI();
                            colDlg.pack();
                            Dimension size = colDlg.getSize();
                            size.width = Math.max(size.width, 300);
                            if (size.height < 150) {
                                size.height += 100;
                            }
                            colDlg.setSize(size);
                            UIHelper.centerWindow(colDlg);
                            colDlg.setVisible(true);
                        } while (colDlg.getSelectedObject() == null || colDlg.isCancelled());
                        currColl = colDlg.getSelectedObject();
                    } else {
                        Integer colId = BasicSQLUtils.getCount(String.format("SELECT CollectionID FROM collection WHERE CollectionName = '%s'", collectionName));
                        if (colId != null) {
                            currColl = new Pair<String, Integer>(collectionName, colId);
                        } else {
                            return null;
                        }
                    }
                }
            }
            Collection collection = null;
            if (currColl != null && (collection = (Collection)session.getData("FROM Collection WHERE id = " + currColl.second)) != null) {
                collection.forceLoad();
                remotePrefs.put(prefName, Long.toString(collection.getCollectionId().intValue()));
                remotePrefs.flush();
            }
            if (collection == null) {
                UIRegistry.showLocalizedError("SpecifyAppContextMgr.ERR_NO_COLL");
                return null;
            }
            this.setClassObject(Collection.class, collection);
            if (collectionName == null) {
                String colObjStr = "CollectionObject";
                String iconName = remotePrefs.get(FormattingPrefsPanel.getDisciplineImageName(), colObjStr);
                if (StringUtils.isEmpty((String)iconName) || iconName.equals(colObjStr)) {
                    iconName = "colobj_backstop";
                }
                IconManager.aliasImages(iconName, colObjStr);
                IconManager.aliasImages(iconName, colObjStr.toLowerCase());
            }
            Discipline discipline = collection.getDiscipline();
            session.attach(discipline);
            Institution institution = discipline.getDivision().getInstitution();
            session.attach(institution);
            this.setClassObject(Institution.class, institution);
            if (!Agent.setUserAgent(spUser, discipline.getDivision())) {
                return null;
            }
            AppContextMgr am = AppContextMgr.getInstance();
            discipline.getTaxonTreeDef().forceLoad();
            am.setClassObject(TaxonTreeDef.class, discipline.getTaxonTreeDef());
            discipline.getGeologicTimePeriodTreeDef().forceLoad();
            am.setClassObject(GeologicTimePeriodTreeDef.class, discipline.getGeologicTimePeriodTreeDef());
            institution.getStorageTreeDef().forceLoad();
            am.setClassObject(StorageTreeDef.class, institution.getStorageTreeDef());
            discipline.getLithoStratTreeDef().forceLoad();
            am.setClassObject(LithoStratTreeDef.class, discipline.getLithoStratTreeDef());
            discipline.getGeographyTreeDef().forceLoad();
            am.setClassObject(GeographyTreeDef.class, discipline.getGeographyTreeDef());
            Collection collection2 = collection;
            return collection2;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
            ex.printStackTrace();
            UIRegistry.showLocalizedError(ex.toString());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    protected String mkUserDBPrefName(String prefName) {
        return String.valueOf(prefName) + "." + this.userName + "." + this.databaseName;
    }

    protected SpAppResourceDir find(List<?> appResDefList, SpecifyUser userArg, Collection collection, Discipline discipline) {
        if (this.debug) {
            log.debug((Object)"finding AppResourceDefault");
        }
        for (Object obj : appResDefList) {
            SpAppResourceDir ard = (SpAppResourceDir)obj;
            SpecifyUser spUser = ard.getSpecifyUser();
            Collection cs = ard.getCollection();
            Discipline ct = ard.getDiscipline();
            if (spUser == null || spUser.getSpecifyUserId() != userArg.getSpecifyUserId() || cs == null || cs.getCollectionId() != collection.getCollectionId() || ct == null || ct.getDisciplineId() != discipline.getDisciplineId()) continue;
            return ard;
        }
        return null;
    }

    public SpAppResourceDir getAppResDir(DataProviderSessionIFace sessionArg, SpecifyUser specifyUser, Discipline discipline, Collection collection, String userType, boolean isPersonal, String localizedTitle, boolean createWhenNotFound) {
        return this.getAppResDir(sessionArg, specifyUser, discipline, collection, userType, isPersonal, localizedTitle, createWhenNotFound, false);
    }

    public SpAppResourceDir getAppResDir(DataProviderSessionIFace sessionArg, SpecifyUser specifyUser, Discipline discipline, Collection collection, String userType, boolean isPersonal, String localizedTitle, boolean createWhenNotFound, boolean checkForNullSpUser) {
        StringBuilder sb = new StringBuilder("FROM SpAppResourceDir WHERE");
        sb.append(" isPersonal = ");
        sb.append(isPersonal);
        if (checkForNullSpUser) {
            sb.append(" AND specifyUserId is null");
        } else if (isPersonal) {
            sb.append(" AND specifyUserId = ");
            sb.append(specifyUser.getSpecifyUserId());
        }
        if (discipline != null) {
            sb.append(" AND disciplineId = ");
            sb.append(discipline.getId());
        } else {
            sb.append(" AND disciplineId is null");
        }
        if (collection != null) {
            sb.append(" AND collectionId = ");
            sb.append(collection.getId());
        } else {
            sb.append(" AND collectionId is null");
        }
        if (userType != null) {
            sb.append(" AND userType = '");
            sb.append(userType);
            sb.append("'");
        } else {
            sb.append(" AND userType is null");
        }
        List<?> list = sessionArg.getDataList(sb.toString());
        if (list.size() == 1) {
            SpAppResourceDir appResDir = (SpAppResourceDir)list.get(0);
            appResDir.getSpPersistedAppResources().size();
            appResDir.getSpPersistedViewSets().size();
            for (SpAppResource appRes : appResDir.getSpPersistedAppResources()) {
                appRes.forceLoad();
            }
            for (SpViewSetObj vso : appResDir.getSpPersistedViewSets()) {
                vso.forceLoad();
            }
            appResDir.setTitle(localizedTitle);
            return appResDir;
        }
        if (createWhenNotFound) {
            SpAppResourceDir appResDir = new SpAppResourceDir();
            appResDir.initialize();
            appResDir.setCollection(collection);
            appResDir.setUserType(userType);
            appResDir.setSpecifyUser(specifyUser);
            appResDir.setDiscipline(discipline);
            appResDir.setIsPersonal(isPersonal);
            appResDir.setTitle(localizedTitle);
            appResDir.setDisciplineType(discipline != null ? discipline.getName() : null);
            return appResDir;
        }
        return null;
    }

    public void addDiskResourceToAppDir(String resDirName, String resourceName) {
        Discipline discipline;
        DisciplineType disciplineType;
        String folderName;
        File dir;
        SpAppResourceDir appResDir = this.spAppResourceHash.get(resDirName);
        if (appResDir != null && appResDir.getId() != null && (dir = XMLHelper.getConfigDir(folderName = (disciplineType = DisciplineType.getDiscipline((discipline = this.getClassObject(Discipline.class)).getType())).getFolder())).exists()) {
            AppResourceMgr appResMgr = new AppResourceMgr(dir);
            for (SpAppResource appRes : appResMgr.getSpAppResources()) {
                String fileAppResName = appRes.getName();
                if (!fileAppResName.equals(resourceName)) continue;
                appRes.setSpAppResourceDir(appResDir);
                appResDir.getSpAppResources().add(appRes);
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.attach(appResDir);
                        session.save(appResDir);
                        session.commit();
                        session.flush();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (session != null) {
                            session.rollback();
                        }
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        if (session == null) continue;
                        session.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session == null) continue;
                session.close();
            }
        }
    }

    public AppResourceIFace revertResource(String virtualDirName, AppResourceIFace appResource) {
        int virtualNameIndex = SpecifyAppContextMgr.getVirtualDirIndex(virtualDirName);
        String[] levels = SpecifyAppContextMgr.getVirtualDirNames();
        SpAppResource fndAppRes = null;
        int i = virtualNameIndex;
        while (i < levels.length && fndAppRes == null) {
            SpAppResourceDir fndAppDir = this.spAppResourceList.get(i);
            for (SpAppResource appRes : new ArrayList<SpAppResource>(fndAppDir.getSpAppResources())) {
                if (appRes.getName() == null || !appRes.getName().equals(appResource.getName())) continue;
                fndAppRes = appRes;
                break;
            }
            ++i;
        }
        if (fndAppRes == null) {
            return null;
        }
        this.removeAppResource(virtualDirName, fndAppRes);
        return null;
    }

    public SpViewSetObj revertViewSet(String virtualDirName, String vsoName) {
        SpAppResourceDir spAppResourceDir;
        Pair<String, File> pair = this.viewSetMgrHash.get(virtualDirName);
        if (pair != null && (spAppResourceDir = this.spAppResourceHash.get(virtualDirName)) != null) {
            SpViewSetObj fndVSO = null;
            for (SpViewSetObj vso : spAppResourceDir.getSpPersistedViewSets()) {
                if (!vso.getName().equals(vsoName)) continue;
                fndVSO = vso;
                break;
            }
            if (fndVSO != null) {
                DataProviderSessionIFace session = null;
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.attach(spAppResourceDir);
                    spAppResourceDir.getSpPersistedViewSets().remove(fndVSO);
                    spAppResourceDir.getSpViewSets().remove(fndVSO);
                    boolean shouldDelDir = spAppResourceDir.getSpPersistedViewSets().size() == 0 && spAppResourceDir.getSpViewSets().size() == 0 && spAppResourceDir.getSpAppResources().size() == 0 && spAppResourceDir.getSpPersistedViewSets().size() == 0;
                    session.beginTransaction();
                    if (!shouldDelDir) {
                        session.save(spAppResourceDir);
                    }
                    session.delete(fndVSO);
                    if (shouldDelDir) {
                        session.delete(spAppResourceDir);
                    }
                    session.commit();
                    session.flush();
                    String viewSetMgrName = (String)pair.first;
                    File loadFromDir = (File)pair.second;
                    if (viewSetMgrName != null && loadFromDir != null) {
                        SpViewSetObj vso;
                        SpViewSetObj spViewSetObj = vso = this.loadViewSetMgrFromDir(spAppResourceDir, viewSetMgrName, loadFromDir);
                        return spViewSetObj;
                    }
                }
                catch (Exception ex) {
                    if (session != null) {
                        session.rollback();
                    }
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
        return null;
    }

    protected SpViewSetObj loadViewSetMgrFromDir(SpAppResourceDir spAppResourceDir, String viewSetMgrName, File dir) {
        if (this.debug) {
            log.debug((Object)("loadViewSetMgrFromDir [" + spAppResourceDir.getIdentityTitle() + "]"));
        }
        SpViewSetObj vso = null;
        ViewSetMgr viewSetMgr = new ViewSetMgr(viewSetMgrName, dir);
        for (ViewSetIFace vs : viewSetMgr.getViewSets()) {
            vso = new SpViewSetObj();
            vso.initialize();
            vso.setFileName(dir.getAbsoluteFile() + File.separator + vs.getFileName());
            vso.setLevel((short)0);
            vso.setName(vs.getName());
            vso.setSpAppResourceDir(spAppResourceDir);
            spAppResourceDir.getSpViewSets().add(vso);
        }
        return vso;
    }

    protected SpAppResourceDir mergeAppResourceDirFromDiskDir(String virtualDirName, SpAppResourceDir spAppResourceDir, String viewSetMgrName, File dir) {
        String fName;
        if (this.debug) {
            log.debug((Object)("Creating AppResourceDef from Dir [" + virtualDirName + "]"));
            log.debug((Object)("mergeAppResourceDirFromDiskDir AppResourceDef from Dir [" + dir.getAbsolutePath() + "]"));
        }
        this.viewSetMgrHash.put(virtualDirName, new Pair<String, File>(viewSetMgrName, dir));
        if (spAppResourceDir.getSpViewSets().size() == 0) {
            if (this.debug) {
                log.debug((Object)("Loading ViewSets from Dir [" + dir.getAbsolutePath() + "]"));
            }
            this.loadViewSetMgrFromDir(spAppResourceDir, viewSetMgrName, dir);
        } else if (this.debug) {
            log.debug((Object)("ViewSets came from the database [" + dir.getAbsolutePath() + "]"));
        }
        AppResourceMgr appResMgr = new AppResourceMgr(dir);
        Hashtable<String, SpAppResource> hash = new Hashtable<String, SpAppResource>();
        for (SpAppResource appRes : spAppResourceDir.getSpPersistedAppResources()) {
            fName = appRes.getName();
            hash.put(fName, appRes);
            if (!this.debug) continue;
            log.debug((Object)("Persisted AppRes [" + fName + "]"));
        }
        for (SpAppResource appRes : appResMgr.getSpAppResources()) {
            fName = appRes.getName();
            SpAppResource permAppRes = (SpAppResource)hash.get(fName);
            if (permAppRes == null) {
                appRes.setSpAppResourceDir(spAppResourceDir);
                spAppResourceDir.getSpAppResources().add(appRes);
                if (!this.debug) continue;
                log.debug((Object)("Add File AppRes [" + fName + "]"));
                continue;
            }
            spAppResourceDir.getSpAppResources().add(permAppRes);
            if (!this.debug) continue;
            log.debug((Object)("Add DB AppRes [" + fName + "]"));
        }
        for (SpAppResource appRes : spAppResourceDir.getSpAppResources()) {
            if (!this.debug) continue;
            log.debug((Object)("In AppResDir [" + appRes.getName() + "]"));
        }
        if (this.debug) {
            log.debug((Object)("-------------[" + spAppResourceDir.getTitle() + "]"));
            for (SpViewSetObj vso : spAppResourceDir.getSpViewSets()) {
                log.debug((Object)("    VSO[" + vso.getName() + "]"));
            }
        }
        return spAppResourceDir;
    }

    protected SpAppResourceDir createAppResourceDefFromDir(String viewSetMgrName, File dir) {
        if (this.debug) {
            log.debug((Object)("Creating AppResourceDef from Dir [" + dir.getAbsolutePath() + "]"));
        }
        SpAppResourceDir spAppResourceDir = new SpAppResourceDir();
        spAppResourceDir.initialize();
        this.loadViewSetMgrFromDir(spAppResourceDir, viewSetMgrName, dir);
        AppResourceMgr appResMgr = new AppResourceMgr(dir);
        for (SpAppResource appRes : appResMgr.getSpAppResources()) {
            appRes.setSpAppResourceDir(spAppResourceDir);
            spAppResourceDir.getSpAppResources().add(appRes);
        }
        return spAppResourceDir;
    }

    protected String getSpAppResDefAsString(SpAppResourceDir appResDef) {
        SpecifyUser spUser = appResDef.getSpecifyUser();
        Collection collection = appResDef.getCollection();
        Discipline discipline = appResDef.getDiscipline();
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("CS[" + (collection != null ? collection.getCollectionName() : "null") + "]");
        strBuf.append(" SU[" + (spUser != null ? spUser.getName() : "null") + "]");
        strBuf.append(" COD[" + (discipline != null ? discipline.getType() : "null") + "]");
        strBuf.append(" DSP[" + appResDef.getDisciplineType() + "]");
        strBuf.append(" UTYP[" + appResDef.getUserType() + "]");
        if (this.debug) {
            log.debug((Object)("AppResDefAsString - " + strBuf.toString()));
        }
        return strBuf.toString();
    }

    @Override
    public AppContextMgr.CONTEXT_STATUS setContext(String databaseName, String userName, boolean startingOver, boolean isFirstTime, boolean doPrompt) {
        return this.setContext(databaseName, userName, startingOver, doPrompt, isFirstTime, null);
    }

    public AppContextMgr.CONTEXT_STATUS setContext(String databaseName, String userName, boolean startingOver, boolean doPrompt, boolean isFirstTime, String collectionName) {
        if (this.debug) {
            log.debug((Object)("setting context - databaseName: [" + databaseName + "] userName: [" + userName + "]"));
        }
        this.databaseName = databaseName;
        this.userName = userName;
        this.hasContext = true;
        if (isFirstTime) {
            DBTableIdMgr.getInstance().clearPermissions();
        }
        DataProviderSessionIFace session = null;
        try {
            session = this.openSession();
        }
        catch (SQLGrammarException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, (Exception)((Object)ex));
            UIRegistry.showLocalizedError("SpecifyAppContextMgr.SCHEMA_OUTOF_SYNC");
            System.exit(0);
        }
        if (session == null) {
            return AppContextMgr.CONTEXT_STATUS.Error;
        }
        try {
            Institution institution;
            UIFieldFormatterIFace catNumFmtr;
            boolean isEmbedded;
            IconEntry ciEntry;
            Collection curColl;
            List<SpecifyUser> list = session.getDataList(SpecifyUser.class, "name", userName);
            if (list.size() == 1) {
                this.user = list.get(0);
                this.user.getAgents().size();
                session.evict(this.user.getAgents());
                this.setClassObject(SpecifyUser.class, this.user);
                if (!startingOver) {
                    if (this.user.getIsLoggedIn().booleanValue()) {
                        Object[] options = new Object[]{UIRegistry.getResourceString("SpecifyAppContextMgr.OVERRIDE"), UIRegistry.getResourceString("SpecifyAppContextMgr.EXIT")};
                        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("SpecifyAppContextMgr.LOGGED_IN"), UIRegistry.getResourceString("SpecifyAppContextMgr.LOGGED_IN_TITLE"), 0, 3, null, options, options[0]);
                        if (userChoice == 1) {
                            System.exit(0);
                        }
                    }
                    this.user.setIsLoggedIn(true);
                    this.user.setLoginOutTime(new Timestamp(System.currentTimeMillis()));
                    try {
                        session.beginTransaction();
                        session.saveOrUpdate(this.user);
                        session.commit();
                    }
                    catch (Exception ex) {
                        session.rollback();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        log.error((Object)ex);
                    }
                }
            } else {
                AppContextMgr.CONTEXT_STATUS cONTEXT_STATUS = AppContextMgr.CONTEXT_STATUS.Error;
                return cONTEXT_STATUS;
            }
            if (isFirstTime) {
                FixDBAfterLogin.fixUserPermissions(false);
            }
            if (!AppPreferences.getGlobalPrefs().getBoolean("ExsiccataUpdateFor1_7", false).booleanValue()) {
                FixDBAfterLogin.fixExsiccata();
            }
            int prevCollectionId = (curColl = this.getClassObject(Collection.class)) != null ? curColl.getCollectionId() : -1;
            Discipline curDis = this.getClassObject(Discipline.class);
            int prevDisciplineId = curDis != null ? curDis.getDisciplineId() : -1;
            this.classObjHash.clear();
            this.setClassObject(SpecifyUser.class, this.user);
            Collection collection = this.setupCurrentCollection(this.user, doPrompt, collectionName);
            if (collection == null) {
                AppContextMgr.CONTEXT_STATUS cONTEXT_STATUS = this.currentStatus = this.currentStatus == AppContextMgr.CONTEXT_STATUS.Initial ? AppContextMgr.CONTEXT_STATUS.Error : AppContextMgr.CONTEXT_STATUS.Ignore;
                return cONTEXT_STATUS;
            }
            collection = session.merge(collection);
            String userType = this.user.getUserType();
            if (this.debug) {
                log.debug((Object)("User[" + this.user.getName() + "] Type[" + userType + "]"));
            }
            userType = StringUtils.replace((String)userType, (String)" ", (String)"").toLowerCase();
            if (this.debug) {
                log.debug((Object)("Def Type[" + userType + "]"));
            }
            this.spAppResourceList.clear();
            this.viewSetHash.clear();
            Discipline discipline = session.getData(Discipline.class, "disciplineId", collection.getDiscipline().getId(), DataProviderSessionIFace.CompareType.Equals);
            discipline.forceLoad();
            this.setClassObject(Discipline.class, discipline);
            String disciplineStr = discipline.getType().toLowerCase();
            Division division = discipline.getDivision();
            division.forceLoad();
            this.setClassObject(Division.class, division);
            DataType dataType = discipline.getDataType();
            dataType.forceLoad();
            this.setClassObject(DataType.class, dataType);
            Agent userAgent = null;
            for (Agent agt : this.user.getAgents()) {
                if (!agt.getDivision().getId().equals(division.getId())) continue;
                userAgent = agt;
                userAgent.getAddresses().size();
                userAgent.getVariants().size();
                break;
            }
            this.setClassObject(Agent.class, userAgent);
            IconEntry ceEntry = IconManager.getIconEntryByName("CollectingEvent");
            if (ceEntry != null && (ciEntry = IconManager.getIconEntryByName((isEmbedded = collection.getIsEmbeddedCollectingEvent().booleanValue()) ? "collectinginformation" : "ce_restore")) != null) {
                ceEntry.setIcon(ciEntry.getIcon());
                ceEntry.getIcons().clear();
            }
            if (isFirstTime) {
                AppPreferences.startup();
                int uploadLockCheckResult = Uploader.checkUploadLock(null);
                boolean noLocks = uploadLockCheckResult != 3;
                boolean goodTrees = true;
                if (uploadLockCheckResult != 2) {
                    if (noLocks && !discipline.getTaxonTreeDef().checkNodeRenumberingLock()) {
                        noLocks = false;
                        UIRegistry.showLocalizedError("Specify.TreeUpdateLock", discipline.getTaxonTreeDef().getName());
                    }
                    if (noLocks && !discipline.getGeographyTreeDef().checkNodeRenumberingLock()) {
                        noLocks = false;
                        UIRegistry.showLocalizedError("Specify.TreeUpdateLock", discipline.getGeographyTreeDef().getName());
                    }
                    if (noLocks && !division.getInstitution().getStorageTreeDef().checkNodeRenumberingLock()) {
                        noLocks = false;
                        UIRegistry.showLocalizedError("Specify.TreeUpdateLock", division.getInstitution().getStorageTreeDef().getName());
                    }
                    if (noLocks && discipline.getGeologicTimePeriodTreeDef() != null && !discipline.getGeologicTimePeriodTreeDef().checkNodeRenumberingLock()) {
                        noLocks = false;
                        UIRegistry.showLocalizedError("Specify.TreeUpdateLock", discipline.getGeologicTimePeriodTreeDef().getName());
                    }
                    if (noLocks && discipline.getLithoStratTreeDef() != null && !discipline.getLithoStratTreeDef().checkNodeRenumberingLock()) {
                        noLocks = false;
                        UIRegistry.showLocalizedError("Specify.TreeUpdateLock", discipline.getLithoStratTreeDef().getName());
                    }
                    if (noLocks) {
                        goodTrees = discipline.getTaxonTreeDef().checkNodeNumbersUpToDate(true);
                        if (goodTrees) {
                            goodTrees = discipline.getGeographyTreeDef().checkNodeNumbersUpToDate(true);
                        }
                        if (goodTrees) {
                            goodTrees = division.getInstitution().getStorageTreeDef().checkNodeNumbersUpToDate(true);
                        }
                        if (goodTrees && discipline.getGeologicTimePeriodTreeDef() != null) {
                            goodTrees = discipline.getGeologicTimePeriodTreeDef().checkNodeNumbersUpToDate(true);
                        }
                        if (goodTrees && discipline.getLithoStratTreeDef() != null) {
                            goodTrees = discipline.getLithoStratTreeDef().checkNodeNumbersUpToDate(true);
                        }
                    }
                }
                if (!noLocks || !goodTrees) {
                    this.user.setIsLoggedIn(false);
                    this.user.setLoginOutTime(new Timestamp(System.currentTimeMillis()));
                    try {
                        session.beginTransaction();
                        session.saveOrUpdate(this.user);
                        session.commit();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        log.error((Object)ex);
                    }
                    System.exit(0);
                } else {
                    this.user.setLoginCollectionName(collection.getCollectionName());
                    this.user.setLoginDisciplineName(discipline.getName());
                    try {
                        session.beginTransaction();
                        session.saveOrUpdate(this.user);
                        session.commit();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        log.error((Object)ex);
                    }
                }
            }
            DisciplineType disciplineType = DisciplineType.getDiscipline(discipline.getType());
            String folderName = disciplineType.getFolder();
            String title = UIRegistry.getResourceString("SpecifyAppContextMgr.Personal");
            SpAppResourceDir appResDir = this.getAppResDir(session, this.user, discipline, collection, userType, true, title, true);
            this.spAppResourceList.add(appResDir);
            this.spAppResourceHash.put(PERSONALDIR, appResDir);
            this.viewSetMgrHash.put(PERSONALDIR, new Pair<Object, Object>(null, null));
            title = UIRegistry.getResourceString("SpecifyAppContextMgr.UserType");
            appResDir = this.getAppResDir(session, this.user, discipline, collection, userType, false, title, true);
            File dir = XMLHelper.getConfigDir(String.valueOf(folderName) + File.separator + userType);
            if (dir.exists()) {
                this.mergeAppResourceDirFromDiskDir(USERTYPEDIR, appResDir, String.valueOf(disciplineStr) + " " + userType, dir);
            }
            this.spAppResourceList.add(appResDir);
            this.spAppResourceHash.put(USERTYPEDIR, appResDir);
            title = UIRegistry.getResourceString("SpecifyAppContextMgr.Collection");
            appResDir = this.getAppResDir(session, this.user, discipline, collection, null, false, title, true);
            this.spAppResourceList.add(appResDir);
            this.spAppResourceHash.put(COLLECTIONDIR, appResDir);
            this.viewSetMgrHash.put(COLLECTIONDIR, new Pair<Object, Object>(null, null));
            title = UIRegistry.getResourceString("SpecifyAppContextMgr.Discipline");
            appResDir = this.getAppResDir(session, this.user, discipline, null, null, false, title, true);
            dir = XMLHelper.getConfigDir(folderName);
            if (dir.exists()) {
                this.mergeAppResourceDirFromDiskDir(DISCPLINEDIR, appResDir, disciplineStr, dir);
            }
            this.spAppResourceList.add(appResDir);
            this.spAppResourceHash.put(DISCPLINEDIR, appResDir);
            title = UIRegistry.getResourceString("SpecifyAppContextMgr.Common");
            appResDir = this.getAppResDir(session, this.user, null, null, COMMONDIR, false, title, true);
            dir = XMLHelper.getConfigDir("common");
            if (dir.exists()) {
                this.mergeAppResourceDirFromDiskDir(COMMONDIR, appResDir, COMMONDIR, dir);
                appResDir.setUserType(COMMONDIR);
            }
            this.spAppResourceList.add(appResDir);
            this.spAppResourceHash.put(COMMONDIR, appResDir);
            String backStopStr = "backstop";
            dir = XMLHelper.getConfigDir(backStopStr);
            if (dir.exists()) {
                appResDir = this.createAppResourceDefFromDir(BACKSTOPDIR, dir);
                appResDir.setUserType(BACKSTOPDIR);
                appResDir.setTitle(UIRegistry.getResourceString("SpecifyAppContextMgr.BackStop"));
                this.spAppResourceList.add(appResDir);
                this.spAppResourceHash.put(BACKSTOPDIR, appResDir);
            }
            if (isFirstTime) {
                SpecifyAppPrefs.initialPrefs();
            }
            this.closeSession();
            session = null;
            if (isFirstTime) {
                FixDBAfterLogin.fixDefaultDates();
                FormDevHelper.clearErrors();
                this.viewSetHash.clear();
                this.lastLoadTime = 0L;
                if (prevDisciplineId != -1) {
                    CommandDispatcher.dispatch(new CommandAction(DISCPLINEDIR, "Changed"));
                }
                if (prevCollectionId != -1) {
                    CommandDispatcher.dispatch(new CommandAction(COLLECTIONDIR, "Changed"));
                }
            }
            this.checkForInitialFormats();
            session = this.openSession();
            int disciplineId = this.getClassObject(Discipline.class).getDisciplineId();
            if (disciplineId != prevDisciplineId) {
                Locale engLocale = null;
                Locale fndLocale = null;
                Locale currLocale = SchemaI18NService.getCurrentLocale();
                List<Locale> locales = SchemaI18NService.getInstance().getLocalesFromData(SpLocaleContainer.CORE_SCHEMA, disciplineId);
                for (Locale locale : locales) {
                    if (locale.equals(currLocale)) {
                        fndLocale = currLocale;
                    }
                    if (!locale.getLanguage().equals("en")) continue;
                    engLocale = currLocale;
                }
                if (fndLocale == null) {
                    if (engLocale != null) {
                        fndLocale = engLocale;
                    } else if (locales.size() > 0) {
                        fndLocale = locales.get(0);
                    } else {
                        this.currentStatus = AppContextMgr.CONTEXT_STATUS.Error;
                        String msg = "Specify was unable to a Locale in the Schema Config for this discipline.\nPlease contact Specify support immediately.";
                        UIRegistry.showError(msg);
                        AppPreferences.shutdownAllPrefs();
                        DataProviderFactory.getInstance().shutdown();
                        DBConnection.shutdown();
                        System.exit(0);
                        AppContextMgr.CONTEXT_STATUS cONTEXT_STATUS = this.currentStatus;
                        return cONTEXT_STATUS;
                    }
                    fndLocale = engLocale != null ? engLocale : locales.get(0);
                    SchemaI18NService.setCurrentLocale(fndLocale);
                    Locale.setDefault(fndLocale);
                    UIRegistry.displayErrorDlgLocalized("SpecifyAppContextMgr.NO_LOCALE", discipline.getName(), currLocale.getDisplayName(), fndLocale.getDisplayName());
                }
                SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, disciplineId, DBTableIdMgr.getInstance(), Locale.getDefault());
            }
            if ((catNumFmtr = UIFieldFormatterMgr.getInstance().getFormatter(collection.getCatalogNumFormatName())) != null) {
                DBFieldInfo field = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()).getFieldByName("catalogNumber");
                field.setFormatter(catNumFmtr);
            }
            if (!(institution = this.getClassObject(Institution.class)).getIsAccessionsGlobal().booleanValue()) {
                for (AutoNumberingScheme ans : collection.getNumberingSchemes()) {
                    UIFieldFormatterIFace accNumFmtr;
                    if (ans.getTableNumber() == null || !ans.getTableNumber().equals(Accession.getClassTableId())) continue;
                    DBFieldInfo field = DBTableIdMgr.getInstance().getInfoById(Accession.getClassTableId()).getFieldByName("accessionNumber");
                    if (field == null || (accNumFmtr = UIFieldFormatterMgr.getInstance().getFormatter(ans.getFormatName())) == null) break;
                    field.setFormatter(accNumFmtr);
                    break;
                }
            }
            this.closeSession();
            session = null;
            if (isFirstTime) {
                for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                    ti.setPermissions(SecurityMgr.getInstance().getPermission("DO." + ti.getName().toLowerCase()));
                }
                RegisterSpecify.register(false, 0);
            }
            AppContextMgr.CONTEXT_STATUS cONTEXT_STATUS = this.currentStatus = AppContextMgr.CONTEXT_STATUS.OK;
            return cONTEXT_STATUS;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                this.closeSession();
            }
        }
        UIRegistry.showLocalizedError("SpecifyAppContextMgr.CRITICAL_LOGIN_ERR");
        System.exit(0);
        return null;
    }

    protected boolean addFormatFromFile(String fmtFileName, boolean isCatNum) {
        Collection coll = this.getClassObject(Collection.class);
        Institution inst = this.getClassObject(Institution.class);
        boolean isAccGlobal = inst != null && inst.getIsAccessionsGlobal() != false;
        String prefix = isCatNum || !isAccGlobal ? coll.getCollectionName() : null;
        String path = String.valueOf(UIRegistry.getAppDataDir()) + File.separator + (prefix != null ? String.valueOf(prefix) + "_" : "") + fmtFileName;
        File uifFile = new File(path);
        boolean loadedOK = false;
        if (uifFile.exists()) {
            try {
                loadedOK = UIFieldFormatterMgr.getInstance().addFormatter(uifFile);
                if (loadedOK) {
                    try {
                        uifFile.delete();
                    }
                    catch (SecurityException securityException) {}
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return loadedOK;
    }

    public void checkForInitialFormats() {
        if (this.addFormatFromFile("catnumfmt.xml", true) || this.addFormatFromFile("accnumfmt.xml", false)) {
            UIFieldFormatterMgr.getInstance().save();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ViewSetIFace> getViewSetList(SpAppResourceDir dirArg) {
        List<ViewSetIFace> viewSetList;
        Boolean reloadViews;
        SpAppResourceDir dir = dirArg;
        if (this.debug) {
            log.debug((Object)("Looking up [" + dir.toString() + "] [" + dir.getUniqueIdentifer() + "][" + dir.getVerboseUniqueIdentifer() + "]"));
        }
        if ((reloadViews = AppPreferences.getLocalPrefs().getBoolean("reload_views", false)).booleanValue() || this.forceReloadViews) {
            long rightNow = Calendar.getInstance().getTimeInMillis() / 1000L;
            if (rightNow - this.lastLoadTime > 10L) {
                FormDevHelper.clearErrors();
                this.viewSetHash.clear();
                this.lastLoadTime = rightNow;
            }
            this.forceReloadViews = false;
        }
        if ((viewSetList = this.viewSetHash.get(dir.getUniqueIdentifer())) == null) {
            block15: {
                DataProviderSessionIFace session = null;
                try {
                    session = this.openSession();
                    if (dir.getSpAppResourceDirId() != null) {
                        try {
                            session.attach(dir);
                        }
                        catch (HibernateException ex) {
                            dir = session.merge(dir);
                        }
                    }
                    viewSetList = new Vector<ViewSetIFace>();
                    for (SpViewSetObj vso : dir.getSpViewSets()) {
                        Element root = null;
                        try {
                            root = XMLHelper.readStrToDOM4J(vso.getDataAsString());
                        }
                        catch (Exception ex) {
                            String msg = "Error error parsing XML: `" + vso.getName() + "`\n" + StringUtils.replace((String)ex.getMessage(), (String)"Nested", (String)"\nNested");
                            FormDevHelper.appendFormDevError(msg);
                            List<ViewSetIFace> list = viewSetList;
                            this.closeSession();
                            return list;
                        }
                        ViewSet vs = new ViewSet(root, true);
                        vs.setDiskBased(vso.getId() == null);
                        vs.setFileName(vso.getFileName());
                        viewSetList.add(vs);
                    }
                }
                catch (Throwable throwable) {
                    this.closeSession();
                    throw throwable;
                }
                {
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        this.closeSession();
                        break block15;
                        break;
                    }
                }
                this.closeSession();
            }
            this.viewSetHash.put(dir.getUniqueIdentifer(), viewSetList);
        }
        return viewSetList;
    }

    public List<SpAppResourceDir> getSpAppResourceList() {
        return this.spAppResourceList;
    }

    public List<ViewIFace> getAllViews() {
        Hashtable<String, ViewIFace> viewHash = new Hashtable<String, ViewIFace>();
        for (SpAppResourceDir appResDir : this.spAppResourceList) {
            for (ViewSetIFace vs : this.getViewSetList(appResDir)) {
                Hashtable<String, ViewIFace> vsHash = vs.getViews();
                for (ViewIFace view : vsHash.values()) {
                    if (view.isInternal() || viewHash.get(view.getName()) != null) continue;
                    viewHash.put(view.getName(), view);
                }
            }
        }
        return new Vector<ViewIFace>(viewHash.values());
    }

    public List<ViewIFace> getEntirelyAllViews() {
        Vector<ViewIFace> list = new Vector<ViewIFace>();
        HashSet<String> viewHashSet = new HashSet<String>();
        for (SpAppResourceDir appResDir : this.spAppResourceList) {
            for (ViewSetIFace vs : this.getViewSetList(appResDir)) {
                Hashtable<String, ViewIFace> vsHash = vs.getViews();
                for (ViewIFace view : vsHash.values()) {
                    if (viewHashSet.contains(view.getName())) continue;
                    viewHashSet.add(view.getName());
                    list.add(view);
                }
            }
        }
        return list;
    }

    @Override
    public ViewIFace getView(String viewName) {
        return this.getView(null, viewName);
    }

    @Override
    public UIFieldFormatterIFace getFormatter(String shortClassName, String fieldName) {
        DBFieldInfo fi;
        DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(shortClassName);
        if (ti != null && (fi = ti.getFieldByName(fieldName)) != null) {
            return fi.getFormatter();
        }
        return null;
    }

    @Override
    public ViewIFace getView(String viewSetName, String viewName) {
        Triple<ViewIFace, Boolean, Integer> viewInfo;
        ViewIFace view = null;
        Triple<ViewIFace, Boolean, Integer> viewInfoDB = this.getViewInternal(viewSetName, viewName, true);
        if (viewInfoDB != null) {
            view = (ViewIFace)viewInfoDB.first;
        }
        if ((viewInfoDB == null || ((Boolean)viewInfoDB.second).booleanValue()) && (viewInfo = this.getViewInternal(viewSetName, viewName, false)) != null && viewInfo.first != null) {
            view = viewInfoDB != null ? ((Integer)viewInfoDB.third < (Integer)viewInfo.third ? (ViewIFace)viewInfoDB.first : (ViewIFace)viewInfo.first) : (ViewIFace)viewInfo.first;
        }
        return view;
    }

    private Triple<ViewIFace, Boolean, Integer> getViewInternal(String viewSetName, String viewName, boolean doCheckDB) {
        if (this.debug) {
            log.debug((Object)("getView - viewSetName[" + viewSetName + "][" + viewName + "]"));
        }
        if (StringUtils.isEmpty((String)viewName)) {
            throw new RuntimeException("Sorry the View Name cannot be empty.");
        }
        int level = 0;
        for (SpAppResourceDir dir : this.spAppResourceList) {
            if (this.debug) {
                log.debug((Object)("getView - " + dir.getIdentityTitle()));
            }
            if (dir.getId() == null && !doCheckDB || dir.getId() != null && doCheckDB) {
                if (this.debug) {
                    log.debug((Object)("  getView - " + dir.getIdentityTitle()));
                }
                for (ViewSetIFace vs : this.getViewSetList(dir)) {
                    ViewIFace view;
                    if (this.debug) {
                        log.debug((Object)("VS  [" + vs.getName() + "][" + viewSetName + "]"));
                    }
                    if (!StringUtils.isEmpty((String)viewSetName) && !vs.getName().equals(viewSetName) || (view = vs.getView(viewName)) == null) continue;
                    return new Triple<ViewIFace, Boolean, Integer>(view, vs.isDiskBased(), level);
                }
            }
            ++level;
        }
        return null;
    }

    @Override
    public boolean saveResource(AppResourceIFace appRes) {
        if (appRes instanceof SpAppResource) {
            SpAppResource spAppResource = (SpAppResource)appRes;
            SpAppResourceDir appResDir = spAppResource.getSpAppResourceDir();
            boolean dirContainsResource = false;
            if (spAppResource.getId() != null) {
                for (SpAppResource persisted : appResDir.getSpPersistedAppResources()) {
                    if (!spAppResource.getId().equals(persisted.getId())) continue;
                    dirContainsResource = true;
                    break;
                }
            }
            if (!dirContainsResource) {
                appResDir.getSpPersistedAppResources().add(spAppResource);
            }
            log.debug((Object)appResDir.getIdentityTitle());
            DataProviderSessionIFace session = null;
            try {
                session = DataProviderFactory.getInstance().createSession();
                appRes.setTimestampModified(new Timestamp(System.currentTimeMillis()));
                appRes.setModifiedByAgent(Agent.getUserAgent());
                appRes.setLevel((short)0);
                session.beginTransaction();
                if (!dirContainsResource) {
                    session.saveOrUpdate(appResDir);
                } else {
                    session.saveOrUpdate(spAppResource);
                }
                session.commit();
                session.flush();
                return true;
            }
            catch (Exception ex) {
                if (session != null) {
                    session.rollback();
                }
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        } else {
            log.error((Object)"AppResource was not of class SpAppResource!");
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public AppResourceIFace getResource(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public AppResourceIFace getResourceFromDir(String appResDirName, String appResName) {
        SpAppResourceDir appResDir = this.spAppResourceHash.get(appResDirName);
        if (appResDir != null) {
            return appResDir.getResourceByName(appResName);
        }
        log.error((Object)("Couldn't find AppResDir with name[" + appResDirName + "]"));
        return null;
    }

    public SpAppResourceDir getSpAppResourceDirByName(String appResDirName) {
        return this.spAppResourceHash.get(appResDirName);
    }

    public String getDirName(SpAppResourceDir appResDir) {
        for (Map.Entry<String, SpAppResourceDir> dir : this.spAppResourceHash.entrySet()) {
            if (!appResDir.getSpAppResourceDirId().equals(dir.getValue().getSpAppResourceDirId())) continue;
            return dir.getKey();
        }
        return null;
    }

    @Override
    public Element getResourceAsDOM(String appResName) {
        try {
            String xmlStr = this.getResourceAsXML(appResName);
            if (StringUtils.isNotEmpty((String)xmlStr)) {
                return XMLHelper.readStrToDOM4J(xmlStr);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return null;
    }

    @Override
    public Element getResourceAsDOM(AppResourceIFace appRes) {
        try {
            String xmlStr = this.getResourceAsXML(appRes);
            if (StringUtils.isNotEmpty((String)xmlStr)) {
                return XMLHelper.readStrToDOM4J(xmlStr);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getResourceAsXML(AppResourceIFace appResource) {
        if (appResource != null && appResource instanceof SpAppResource) {
            DataProviderSessionIFace session = null;
            SpAppResource appRes = (SpAppResource)appResource;
            try {
                session = this.openSession();
                if (appRes.getSpAppResourceId() != null) {
                    try {
                        session.attach(appRes);
                    }
                    catch (NonUniqueObjectException nonUniqueObjectException) {
                        // empty catch block
                    }
                }
                if (appRes.getMimeType() == null || !appRes.getMimeType().equals("text/xml")) throw new RuntimeException("MimeType was not 'text/xml'");
                try {
                    String string = appRes.getDataAsString(session);
                    return string;
                }
                catch (Exception ex) {
                    try {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        log.error((Object)ex);
                        throw new RuntimeException(ex);
                    }
                    catch (Exception ex2) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex2);
                        log.error((Object)ex2);
                        return null;
                    }
                }
            }
            finally {
                this.closeSession();
            }
        }
        log.debug((Object)"AppResourceIFace was null");
        return null;
    }

    @Override
    public String getResourceAsXML(String appResName) {
        return this.getResourceAsXML(this.getResource(appResName));
    }

    @Override
    public void putResourceAsXML(AppResourceIFace appResArg, String xmlStr) {
        block10: {
            if (appResArg == null || !(appResArg instanceof SpAppResource)) {
                return;
            }
            SpAppResourceDir appResDir = null;
            SpAppResource appRes = (SpAppResource)appResArg;
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = this.openSession();
                    appResDir = appRes.getSpAppResourceDir();
                    if (appRes.getSpAppResourceId() != null) {
                        session.attach(appRes);
                    }
                    if (appRes.getMimeType() == null || !appRes.getMimeType().equals("text/xml")) break block10;
                    try {
                        session.beginTransaction();
                        if (appResDir != null) {
                            appResDir.setTimestampModified(new Timestamp(System.currentTimeMillis()));
                            appResDir.setModifiedByAgent(Agent.getUserAgent());
                            session.saveOrUpdate(appResDir);
                        }
                        appRes.setTimestampModified(new Timestamp(System.currentTimeMillis()));
                        appRes.setModifiedByAgent(Agent.getUserAgent());
                        appRes.setDataStr(xmlStr);
                        session.saveOrUpdate(appRes);
                        session.commit();
                        session.flush();
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        session.rollback();
                        log.error((Object)ex);
                        throw new RuntimeException(ex);
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                    log.error((Object)ex);
                    this.closeSession();
                }
            }
            finally {
                this.closeSession();
            }
        }
    }

    @Override
    public void putResourceAsXML(String appResName, String xmlStr) {
        AppResourceIFace appRes = this.getResource(appResName);
        if (appRes != null) {
            this.putResourceAsXML(appRes, xmlStr);
        } else {
            log.error((Object)("Couldn't find respource [" + appRes + "]"));
        }
    }

    @Override
    public List<AppResourceIFace> getResourceByMimeType(String mimeType) {
        ArrayList<AppResourceIFace> list = new ArrayList<AppResourceIFace>();
        for (SpAppResourceDir appResDef : this.spAppResourceList) {
            for (AppResourceIFace appResourceIFace : appResDef.getSpAppResources()) {
                if (appResourceIFace.getMimeType() == null || !appResourceIFace.getMimeType().equals(mimeType)) continue;
                list.add(appResourceIFace);
            }
        }
        return list;
    }

    @Override
    public AppResourceIFace createAppResourceForDir(String appResDirName) {
        SpAppResourceDir appResDir = this.spAppResourceHash.get(appResDirName);
        if (appResDir != null) {
            return this.createAppResourceForDir(appResDir);
        }
        log.error((Object)("Couldn't find AppResDir with name[" + appResDirName + "]"));
        return null;
    }

    public AppResourceIFace createAppResourceForDir(SpAppResourceDir appResDir) {
        SpAppResource appRes = new SpAppResource();
        appRes.initialize();
        appRes.setSpecifyUser(this.getClassObject(SpecifyUser.class));
        appResDir.getSpAppResources().add(appRes);
        appRes.setSpAppResourceDir(appResDir);
        return appRes;
    }

    @Override
    public boolean removeAppResource(String appResDirName, AppResourceIFace appResource) {
        if (!(appResource instanceof SpAppResource)) {
            return false;
        }
        SpAppResource appRes = (SpAppResource)appResource;
        SpAppResourceDir appResDir = this.spAppResourceHash.get(appResDirName);
        if (appResDir != null) {
            if (!appResDir.containsResource(appRes, true)) {
                return false;
            }
            DataProviderSessionIFace session = null;
            try {
                if (!appResDir.removeResource(appRes)) {
                    log.error((Object)("Unable to remove AppResource '" + appResource + "' from directory '" + appResDirName + "'"));
                    return false;
                }
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                session.saveOrUpdate(appResDir);
                session.commit();
                session.flush();
                return true;
            }
            catch (Exception ex) {
                if (session != null) {
                    session.rollback();
                }
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                log.error((Object)ex);
                return false;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        log.error((Object)("Couldn't find AppResDir with name[" + appResDirName + "]"));
        return false;
    }

    public boolean removeAppResourceSp(SpAppResourceDir appResDir, AppResourceIFace appResource) {
        for (Map.Entry<String, SpAppResourceDir> entry : this.spAppResourceHash.entrySet()) {
            if (!appResDir.getId().equals(entry.getValue().getId())) continue;
            return this.removeAppResource(entry.getKey(), appResource);
        }
        return false;
    }

    public PickListItemIFace getDefaultPickListItem(String pickListName, String title) {
        DataProviderSessionIFace session;
        PickListItemIFace dObj = null;
        Collection collection = this.getClassObject(Collection.class);
        String prefName = String.valueOf(collection != null ? collection.getIdentityTitle() : "") + pickListName + "_DefaultId";
        AppPreferences appPrefs = AppPreferences.getRemote();
        String idStr = appPrefs.get(prefName, null);
        if (StringUtils.isNotEmpty((String)idStr)) {
            block19: {
                session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        dObj = session.get(PickListItem.class, Integer.valueOf(idStr));
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        log.error((Object)ex);
                        if (session != null) {
                            session.close();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            if (dObj != null) {
                return dObj;
            }
        }
        session = DataProviderFactory.getInstance().createSession();
        try {
            PickList pickList = session.getData(PickList.class, "name", pickListName, DataProviderSessionIFace.CompareType.Equals);
            if (pickList != null) {
                Vector<PickListItemIFace> list = new Vector<PickListItemIFace>();
                for (PickListItem itm : pickList.getPickListItems()) {
                    itm.getTitle();
                }
                list.addAll(pickList.getItems());
                ChooseFromListDlg plDlg = new ChooseFromListDlg(null, UIRegistry.getLocalizedMessage("SpecifyAppContextMgr.CHS_DEF_OBJ", title), list);
                plDlg.setModal(true);
                plDlg.setVisible(true);
                if (!plDlg.isCancelled()) {
                    appPrefs.put(prefName, ((PickListItemIFace)plDlg.getSelectedObject()).getId().toString());
                    PickListItemIFace pickListItemIFace = (PickListItemIFace)plDlg.getSelectedObject();
                    return pickListItemIFace;
                }
                return null;
            }
            try {
                throw new RuntimeException("PickList name[" + pickListName + "] doesn't exist.");
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                log.error((Object)ex);
            }
        }
        finally {
            session.close();
        }
        return dObj;
    }

    public FormDataObjIFace getDefaultObject(Class<?> classObj, String prefPrefix, String title, boolean ask, boolean useAllItems) {
        Collection collection = this.getClassObject(Collection.class);
        FormDataObjIFace dObj = null;
        String prefName = String.valueOf(collection != null ? collection.getIdentityTitle() : "") + prefPrefix + "_DefaultId";
        AppPreferences appPrefs = AppPreferences.getRemote();
        String idStr = appPrefs.get(prefName, null);
        if (StringUtils.isEmpty((String)idStr) && ask) {
            if (useAllItems) {
                class Item {
                    public FormDataObjIFace data;

                    public Item(FormDataObjIFace d) {
                        this.data = d;
                    }

                    public String toString() {
                        return this.data.getIdentityTitle();
                    }
                }
                Vector<Item> items;
                block26: {
                    items = null;
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            items = new Vector<Item>();
                            for (Object o : session.getDataList(classObj)) {
                                FormDataObjIFace dataObj = (FormDataObjIFace)o;
                                dataObj.getId();
                                items.add(new Item(dataObj));
                            }
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        session.close();
                    }
                }
                if (items != null) {
                    ChooseFromListDlg colDlg = new ChooseFromListDlg(null, title, items);
                    colDlg.setModal(true);
                    colDlg.setVisible(true);
                    if (!colDlg.isCancelled()) {
                        dObj = ((Item)colDlg.getSelectedObject()).data;
                        appPrefs.put(prefName, dObj.getId().toString());
                        return dObj;
                    }
                }
            } else {
                try {
                    ViewBasedSearchDialogIFace srchDlg = UIRegistry.getViewbasedFactory().createSearchDialog(null, String.valueOf(classObj.getSimpleName()) + "Search");
                    if (srchDlg != null) {
                        srchDlg.setTitle(title);
                        srchDlg.getDialog().setVisible(true);
                        if (!srchDlg.isCancelled()) {
                            dObj = (FormDataObjIFace)srchDlg.getSelectedObject();
                            appPrefs.put(prefName, dObj.getId().toString());
                            return dObj;
                        }
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                }
            }
        } else {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    dObj = (FormDataObjIFace)session.get(classObj, Integer.valueOf(idStr));
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                    log.error((Object)ex);
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return dObj;
    }

    @Override
    public String getCurrentContextDescription() {
        Collection collection;
        Agent uAgent;
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy hh:mm:ss zzz");
        sb.append(String.valueOf(sdf.format(Calendar.getInstance().getTime())) + "\n");
        sb.append(String.valueOf(Specify.getSpecify().getAppBuildVersion()) + "\n");
        SpecifyUser spUser = this.getClassObject(SpecifyUser.class);
        if (spUser != null) {
            sb.append(String.valueOf(spUser.toString()) + "\n");
        }
        if ((uAgent = Agent.getUserAgent()) != null) {
            Division div;
            sb.append(String.valueOf(uAgent.toString()) + "\n");
            if (StringUtils.isNotEmpty((String)uAgent.getEmail())) {
                sb.append(String.valueOf(uAgent.getEmail()) + "\n");
            }
            if ((div = uAgent.getDivision()) != null) {
                Institution inst = div.getInstitution();
                if (inst != null) {
                    sb.append(String.valueOf(inst.toString()) + "\n");
                }
                sb.append(String.valueOf(div.toString()) + "\n");
                sb.append(String.valueOf(uAgent.toString()) + "\n");
            }
        }
        if ((collection = this.getClassObject(Collection.class)) != null) {
            sb.append(String.valueOf(collection.toString()) + "\n");
        }
        return sb.toString();
    }

    public static boolean isNewJavaVersion() {
        boolean isNewVersion;
        String javaVersionPropName = "java.version";
        String prefsJavaVersion = AppPreferences.getLocalPrefs().get(javaVersionPropName, null);
        String systemJavaVersion = System.getProperty("java.version");
        boolean bl = isNewVersion = StringUtils.isEmpty((String)prefsJavaVersion) || StringUtils.isEmpty((String)systemJavaVersion) || !prefsJavaVersion.equals(systemJavaVersion);
        if (isNewVersion) {
            AppPreferences.getLocalPrefs().put(javaVersionPropName, System.getProperty("java.version"));
        }
        if (isNewJavaVersion == null) {
            isNewJavaVersion = isNewVersion;
        }
        return isNewVersion;
    }

    public static boolean isNewJavaVersionAtAppStart() {
        if (isNewJavaVersion == null) {
            return SpecifyAppContextMgr.isNewJavaVersion();
        }
        return isNewJavaVersion;
    }

    public TreeDefIface<?, ?, ?> getTreeDefForClass(Class<? extends Treeable<?, ?, ?>> treeableClass) {
        Enumeration objects = this.classObjHash.elements();
        while (objects.hasMoreElements()) {
            TreeDefIface td;
            Object object = objects.nextElement();
            if (!(object instanceof TreeDefIface) || !(td = (TreeDefIface)object).getNodeClass().equals(treeableClass)) continue;
            return td;
        }
        return null;
    }

    public Class<?> getTreeDefClass(ViewIFace view) {
        DBTableInfo tableInfo;
        if (view != null && (tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName())) != null && Treeable.class.isAssignableFrom(tableInfo.getClassObj())) {
            for (Taskable tsk : TaskMgr.getInstance().getAllTasks()) {
                if (!tsk.getName().equals(String.valueOf(tableInfo.getClassObj().getSimpleName()) + "Tree")) continue;
                return ((BaseTreeTask)tsk).getTreeDefClass();
            }
        }
        return null;
    }

    protected boolean isViewOKToOpen(ViewIFace view) {
        Class<?> treeDefClass = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefClass(view);
        return true;
    }

    public List<String> getAgentListLoggedIn(Discipline discipline) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT specifyuser.SpecifyUserID from specifyuser ");
        sb.append(" WHERE specifyuser.IsLoggedIn <> 0 and loginDisciplineName = '" + discipline.getName() + "'");
        SpecifyUser spUser = this.getClassObject(SpecifyUser.class);
        sb.append(" AND specifyuser.SpecifyUserID <> " + spUser.getId());
        Vector<Integer> ids = new Vector<Integer>();
        Vector<Object[]> idList = BasicSQLUtils.query(sb.toString());
        if (idList != null && idList.size() > 0) {
            for (Object[] row : idList) {
                ids.add((Integer)row[0]);
            }
        }
        Vector<String> names = new Vector<String>();
        if (ids.size() > 0) {
            sb.setLength(0);
            sb.append("SELECT ag FROM SpecifyUser spu INNER JOIN spu.agents ag ");
            sb.append("INNER JOIN ag.division dv INNER JOIN dv.disciplines dsp  WHERE dsp.id = ");
            sb.append(discipline.getId());
            sb.append(" AND spu.id in (");
            int i = 0;
            while (i < ids.size()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(ids.get(i));
                ++i;
            }
            sb.append(")");
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    List<?> dataRows = session.getDataList(sb.toString());
                    for (Object obj : dataRows) {
                        String name = ((Agent)obj).getIdentityTitle();
                        names.add(name);
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                    return null;
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return names;
    }

    public boolean displayAgentsLoggedInDlg(String msgKey) {
        int rv = this.displayAgentsLoggedInDlg(null, msgKey, false);
        return rv == 0;
    }

    public int displayAgentsLoggedInDlg(String titleKey, String msgKey, boolean includeOverride) {
        List<String> logins = this.getAgentListLoggedIn(this.getClassObject(Discipline.class));
        return this.displayAgentsLoggedInDlg(titleKey, msgKey, logins, includeOverride);
    }

    public int displayAgentsLoggedInDlg(String titleKey, String msgKey, List<String> logins, boolean includeOverride) {
        SpecifyUser currUser;
        String sql;
        Vector<Object[]> dataRows;
        if (logins.size() > 0 && (dataRows = BasicSQLUtils.query(sql = "SELECT Name, IsLoggedIn, IsLoggedInReport, LoginCollectionName, LoginDisciplineName FROM specifyuser WHERE IsLoggedIn <> 0 AND SpecifyUserID <> " + (currUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class)).getId())).size() > 0) {
            Object[][] rows = new Object[dataRows.size()][4];
            int i = 0;
            while (i < rows.length) {
                rows[i] = dataRows.get(i);
                ++i;
            }
            DefaultTableModel model = new DefaultTableModel(rows, new Object[]{"User", "Is Logged In", "Is Logged In to Report", "Login Collection", "Login Discipline"});
            JTable table = new JTable(model);
            UIHelper.calcColumnWidths(table, 5);
            UIHelper.makeTableHeadersCentered(table, true);
            JScrollPane scrollPane = UIHelper.createScrollPane(table);
            String rowDef = "f:p:g, 2dlu, f:p:g, 2dlu, f:p:g";
            int btns = includeOverride ? 3 : 1;
            String titleStr = UIRegistry.getResourceString(titleKey != null ? titleKey : "SpecifyAppContextMgr.OU_TITLE");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", rowDef));
            pb.add((Component)UIHelper.createI18NLabel("SpecifyAppContextMgr.OTHER_USERS"), cc.xy(1, 1));
            pb.add((Component)scrollPane, cc.xy(1, 3));
            pb.add((Component)UIHelper.createI18NLabel(msgKey), cc.xy(1, 5));
            pb.setDefaultDialogBorder();
            CustomDialog infoDlg = new CustomDialog(null, titleStr, true, btns, (Component)pb.getPanel());
            if (includeOverride) {
                infoDlg.setOkLabel(UIRegistry.getResourceString("SpecifyAppContextMgr.LOGIN_OVRDE"));
            }
            infoDlg.createUI();
            infoDlg.setDefaultCloseOperation(0);
            UIHelper.centerAndShow(infoDlg);
            return infoDlg.getBtnPressed();
        }
        return 0;
    }

    public boolean checkToOverrideLogins(String currentUserName) {
        SpecifyUser spUser = this.getClassObject(SpecifyUser.class);
        Integer userId = spUser != null ? spUser.getId() : null;
        Discipline disp = this.getClassObject(Discipline.class);
        List<String> logins = null;
        if (currentUserName == null && disp != null) {
            logins = this.getAgentListLoggedIn(this.getClassObject(Discipline.class));
        } else {
            userId = BasicSQLUtils.getCountAsInt(String.format("SELECT SpecifyUserID FROM specifyuser WHERE Name = '%s'", currentUserName));
            if (userId != null) {
                ArrayList<String> userNames = new ArrayList<String>();
                String sql = String.format("SELECT name FROM specifyuser WHERE name <> '%s'", currentUserName);
                for (Object usr : BasicSQLUtils.querySingleCol(sql)) {
                    userNames.add((String)usr);
                }
                logins = userNames;
            }
        }
        int rv = 0;
        if (logins != null && spUser != null && (rv = this.displayAgentsLoggedInDlg(null, "SpecifyAppContextMgr.OVRDE_MSG", logins, true)) == 1 && BasicSQLUtils.update("UPDATE specifyuser SET IsLoggedIn=0 WHERE SpecifyUserID <> " + spUser.getId()) > 0) {
            return true;
        }
        return rv == 0;
    }

    @Override
    public boolean isSecurity() {
        if (this.isSecurityOn == null) {
            String sql = "SELECT COUNT(IsSecurityOn) FROM institution WHERE IsSecurityOn = 0";
            Integer count = BasicSQLUtils.getCount(sql);
            if (count == null) {
                count = BasicSQLUtils.getCount(sql);
            }
            this.isSecurityOn = count == null || count == 0;
        }
        return this.isSecurityOn;
    }

    @Override
    public boolean setSecurity(boolean secVal) {
        this.isSecurityOn = secVal;
        boolean status = true;
        DataProviderSessionIFace session = null;
        try {
            try {
                session = this.openSession();
                Institution inst = (Institution)session.getData("FROM edu.ku.brc.specify.datamodel.Institution");
                inst.setIsSecurityOn(secVal);
                session.beginTransaction();
                session.saveOrUpdate(inst);
                session.commit();
            }
            catch (Exception ex) {
                if (session != null) {
                    session.rollback();
                }
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                status = false;
                this.closeSession();
            }
        }
        finally {
            this.closeSession();
        }
        return status;
    }

    public String getMailAddr(boolean doAskForIt) {
        DataProviderSessionIFace session;
        UpdateEmailType updateType = UpdateEmailType.eNone;
        String email = null;
        SpecifyUser spUser = this.getClassObject(SpecifyUser.class);
        Agent userAgent = this.getClassObject(Agent.class);
        if (spUser != null && StringUtils.isNotEmpty((String)spUser.getEmail()) && StringUtils.isNotEmpty((String)(email = spUser.getEmail()))) {
            updateType = UpdateEmailType.eAgent;
        }
        if (StringUtils.isEmpty(email) && userAgent != null && StringUtils.isNotEmpty((String)userAgent.getEmail()) && StringUtils.isNotEmpty((String)(email = userAgent.getEmail()))) {
            updateType = UpdateEmailType.eSpUser;
        }
        if (!doAskForIt) {
            return StringUtils.isEmpty((String)email) ? "" : email;
        }
        if (StringUtils.isEmpty((String)email) || !UIHelper.isValidEmailAddress(email)) {
            boolean isValidEmailAddr = true;
            while (!(isValidEmailAddr = UIHelper.isValidEmailAddress(email = UIRegistry.askForString("SpecifyAppContextMgr.ENT_EMAIL_LABEL", "SpecifyAppContextMgr.ENT_EMAIL_TITLE", L10N + (isValidEmailAddr ? "ENT_EMAIL_WHY" : "ENT_EMAIL_ERR"), true)))) {
            }
            updateType = UpdateEmailType.eBoth;
        }
        if (updateType != UpdateEmailType.eNone && (session = this.openSession()) != null) {
            try {
                try {
                    spUser = session.get(SpecifyUser.class, spUser.getId());
                    spUser.setEmail(email);
                    session.beginTransaction();
                    if (updateType == UpdateEmailType.eBoth || updateType == UpdateEmailType.eAgent) {
                        for (Agent agt : spUser.getAgents()) {
                            agt.setEmail(email);
                            session.saveOrUpdate(agt);
                        }
                    }
                    if (updateType == UpdateEmailType.eBoth || updateType == UpdateEmailType.eSpUser) {
                        session.saveOrUpdate(spUser);
                    }
                    session.commit();
                    this.setClassObject(Agent.class, session.get(Agent.class, userAgent.getId()));
                    this.setClassObject(SpecifyUser.class, spUser);
                }
                catch (Exception ex) {
                    session.rollback();
                    ex.printStackTrace();
                    this.closeSession();
                }
            }
            finally {
                this.closeSession();
            }
        }
        return email;
    }

    @Override
    public void clear() {
        super.clear();
        this.spAppResourceList.clear();
        this.spAppResourceHash.clear();
        this.viewSetHash.clear();
        this.viewSetMgrHash.clear();
    }

    public static /* bridge */ /* synthetic */ AppContextMgr getInstance() {
        return SpecifyAppContextMgr.getInstance();
    }

    class AppResourceMgr {
        protected File locationDir;
        protected Hashtable<String, SpAppResource> appResources = null;

        public AppResourceMgr() {
            this.locationDir = null;
        }

        public AppResourceMgr(File locationDir) {
            this.locationDir = locationDir;
            this.appResources = new Hashtable();
            this.init(locationDir, null);
        }

        public SpAppResource getSpAppResource(String name) {
            return this.appResources.get(name);
        }

        public void addAppRes(SpAppResource appRes) {
            this.appResources.put(appRes.getName(), appRes);
        }

        public AppResourceIFace loadResourceByName(File locDir, String resName) {
            this.locationDir = locDir;
            this.appResources = new Hashtable();
            this.init(locDir, resName);
            if (this.appResources.size() == 1) {
                return this.appResources.values().iterator().next();
            }
            return null;
        }

        protected void init(File file, String resName) {
            block12: {
                if (file.exists()) {
                    try {
                        Element root = XMLHelper.readFileToDOM4J(new FileInputStream(new File(file.getAbsoluteFile() + File.separator + "app_resources.xml")));
                        if (root != null) {
                            Iterator i = root.elementIterator("file");
                            while (i.hasNext()) {
                                Element fileElement = (Element)i.next();
                                String name = XMLHelper.getAttr(fileElement, "name", null);
                                if (this.appResources.get(name) == null && (resName == null || name.equals(resName))) {
                                    Integer level = XMLHelper.getAttr(fileElement, "level", 0);
                                    String mimeType = XMLHelper.getAttr(fileElement, "mimetype", null);
                                    String desc = XMLHelper.getAttr(fileElement, "description", null);
                                    String fileName = XMLHelper.getAttr(fileElement, "file", null);
                                    String metaData = XMLHelper.getAttr(fileElement, "metadata", null);
                                    if (level == null) {
                                        throw new RuntimeException("AppResource level cannot be null!");
                                    }
                                    if (StringUtils.isEmpty((String)mimeType)) {
                                        throw new RuntimeException("AppResource mimeType cannot be null!");
                                    }
                                    if (StringUtils.isEmpty((String)fileName)) {
                                        throw new RuntimeException("AppResource file cannot be null!");
                                    }
                                    File resFile = new File(file.getAbsoluteFile() + File.separator + fileName);
                                    if (!resFile.exists()) {
                                        log.error((Object)("AppResource file cannot be found at[" + resFile.getAbsolutePath() + "]"));
                                    }
                                    SpAppResource appRes = new SpAppResource();
                                    appRes.initialize();
                                    appRes.setLevel(level.shortValue());
                                    appRes.setName(name);
                                    appRes.setMimeType(mimeType);
                                    appRes.setDescription(desc);
                                    appRes.setMetaData(metaData);
                                    appRes.setSpecifyUser(SpecifyAppContextMgr.this.user);
                                    appRes.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
                                    appRes.setFileName(resFile.getAbsolutePath());
                                    if (SpecifyAppContextMgr.this.debug) {
                                        log.debug((Object)("Adding [" + name + "] [" + resFile.getAbsolutePath() + "]"));
                                    }
                                    this.appResources.put(name, appRes);
                                    continue;
                                }
                                if (name != null) continue;
                                log.error((Object)("AppResource Name[" + name + "] is in use."));
                            }
                            break block12;
                        }
                        String msg = "The root element for the document was null!";
                        log.error((Object)msg);
                        throw new ConfigurationException(msg);
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        ex.printStackTrace();
                        log.error((Object)ex);
                    }
                } else {
                    log.error((Object)("Directory [" + file.getAbsolutePath() + "] doesn't exist!"));
                }
            }
        }

        public List<SpAppResource> getSpAppResources() {
            return Collections.list(this.appResources.elements());
        }
    }

    private static enum UpdateEmailType {
        eNone,
        eAgent,
        eSpUser,
        eBoth;

    }
}

