/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchJRDataSource;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.DateConverter;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.Triple;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Scriptlet
extends JRDefaultScriptlet {
    private static final Logger log = Logger.getLogger(Scriptlet.class);
    private static final String SCRPLT_N = "SCRPLT_N";
    private static final String SCRPLT_S = "SCRPLT_S";
    private static final String SCRPLT_E = "SCRPLT_E";
    private static final String SCRPLT_W = "SCRPLT_W";
    protected UIFieldFormatterIFace catalogFormatter = AppContextMgr.getInstance().getFormatter("CollectionObject", "CatalogNumber");
    DateConverter dateConverter = new DateConverter();
    protected static final String stdFormat = "yyyy-MM-dd";
    protected HashMap<String, SimpleDateFormat> dateFormatHash = new HashMap();
    protected static final int Genus = 1;
    protected static final int SpeciesQualifier = 2;
    protected static final int Species = 4;
    protected static final int SpeciesAuthorFirstName = 8;
    protected static final int SpeciesAuthorLastName = 16;
    protected static final int SubspeciesQualifier = 32;
    protected static final int Subspecies = 64;
    protected static final int InfraAuthorFirstName = 128;
    protected static final int InfraAuthorLastName = 256;
    protected static final int VarietyQualifier = 512;
    protected static final int Variety = 1024;
    protected int mask;
    protected TaxonInfo info = new TaxonInfo();
    protected Triple<String, String, String> cit = new Triple();
    protected Statement stmt = null;

    public void beforeReportInit() throws JRScriptletException {
    }

    public void afterReportInit() throws JRScriptletException {
    }

    public void beforePageInit() throws JRScriptletException {
    }

    public void afterPageInit() throws JRScriptletException {
    }

    public void beforeColumnInit() throws JRScriptletException {
    }

    public void afterColumnInit() throws JRScriptletException {
    }

    public void beforeGroupInit(String groupName) throws JRScriptletException {
    }

    public void afterGroupInit(String groupName) throws JRScriptletException {
    }

    public void beforeDetailEval() throws JRScriptletException {
    }

    public void afterDetailEval() throws JRScriptletException {
    }

    public String formatCatNo(String catalogNumber) {
        if (this.catalogFormatter != null && this.catalogFormatter.isInBoundFormatter()) {
            return this.catalogFormatter.formatToUI(catalogNumber).toString();
        }
        return catalogNumber;
    }

    public String format(Float floatVar) throws JRScriptletException {
        if (floatVar == null) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("#.####");
        return df.format(floatVar.floatValue());
    }

    public String getDirChar(Float floatVal, boolean isLat) {
        if (floatVal == null) {
            return "";
        }
        String key = isLat ? ((double)floatVal.floatValue() > 0.0 ? SCRPLT_N : SCRPLT_S) : ((double)floatVal.floatValue() > 0.0 ? SCRPLT_E : SCRPLT_W);
        return UIRegistry.getResourceString(key);
    }

    public String getDirChar(BigDecimal bdValue, boolean isLat) {
        if (bdValue == null) {
            return "";
        }
        String key = isLat ? ((double)bdValue.floatValue() > 0.0 ? SCRPLT_N : SCRPLT_S) : ((double)bdValue.floatValue() > 0.0 ? SCRPLT_E : SCRPLT_W);
        return UIRegistry.getResourceString(key);
    }

    public String getDirChar(String strVal, boolean isLat) {
        if (strVal == null) {
            return "";
        }
        return this.getDirChar(new Float(Float.parseFloat(strVal)), isLat);
    }

    public String formatLatLon(BigDecimal value, Integer originalLatLongUnit, boolean isLat) throws JRScriptletException {
        if (value != null) {
            return LatLonConverter.format(value, isLat ? LatLonConverter.LATLON.Latitude : LatLonConverter.LATLON.Longitude, LatLonConverter.convertIntToFORMAT(originalLatLongUnit), LatLonConverter.DEGREES_FORMAT.Symbol, LatLonConverter.DECIMAL_SIZES[originalLatLongUnit]);
        }
        return null;
    }

    public String degrees(String floatStr, boolean isLat) throws JRScriptletException {
        return "Not Implemented!";
    }

    public String locality(Object desc, Float lat, Float lon, int originalLatLongUnit) throws JRScriptletException {
        return this.localityBD(desc, new BigDecimal(lat.floatValue()), new BigDecimal(lon.floatValue()), originalLatLongUnit);
    }

    public String localityBD(Object desc, BigDecimal lat, BigDecimal lon, Integer originalLatLongUnit) throws JRScriptletException {
        StringBuffer strBuf = new StringBuffer();
        if (desc instanceof String) {
            strBuf.append((String)desc);
        } else if (desc instanceof byte[]) {
            strBuf.append(new String((byte[])desc));
        }
        strBuf.append(" ");
        strBuf.append(this.formatLatLon(lat, originalLatLongUnit, true));
        strBuf.append(", ");
        strBuf.append(this.formatLatLon(lon, originalLatLongUnit, false));
        return strBuf.toString();
    }

    public String formatFieldNo(String fieldNumber) {
        return fieldNumber == null ? "" : fieldNumber;
    }

    public String getCurrentDate(String format) {
        return this.formatDate(new java.util.Date(System.currentTimeMillis()), format);
    }

    public String loanCategory(Boolean isGift) {
        if (isGift.booleanValue()) {
            return "GIFT";
        }
        return "LOAN";
    }

    public String getByLoanAgentRole(String loanNumber, String role, String fld) throws Exception {
        return this.getByRole("loan", "LoanNumber", loanNumber, "loanagent", role, fld);
    }

    public String getByRole(String transTbl, String transNumberFld, String transNumber, String roleTbl, String role, String fld) throws Exception {
        Vector<Object> match;
        String fldTbl = roleTbl;
        String fldName = fld;
        String[] chunks = fld.split("\\.");
        if (chunks.length > 1) {
            fldTbl = chunks[0];
            fldName = chunks[1];
        }
        if (!(fldTbl.equals("address") || fldTbl.equals("agent") || fldTbl.equals(roleTbl))) {
            throw new Exception("unsupported table: " + fldTbl);
        }
        DBTableInfo transInfo = DBTableIdMgr.getInstance().getInfoByTableName(transTbl);
        if (transInfo == null) {
            throw new Exception("unrecognized table: " + transTbl);
        }
        if (transInfo.getFieldByColumnName(transNumberFld, true) == null) {
            throw new Exception("unrecognized field: " + transTbl + "." + transNumberFld);
        }
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoByTableName(fldTbl);
        if (tblInfo == null) {
            throw new Exception("unrecognized table: " + roleTbl);
        }
        if (tblInfo.getFieldByColumnName(fldName, true) == null) {
            throw new Exception("unrecognized field: " + fldTbl + "." + fldName);
        }
        String sql = "select " + fldTbl + "." + fldName + " from " + transTbl + " inner join " + roleTbl + " on " + roleTbl + "." + transInfo.getPrimaryKeyName() + " = " + transTbl + "." + transInfo.getPrimaryKeyName();
        if (!fldTbl.equals(roleTbl)) {
            sql = String.valueOf(sql) + " inner join agent on agent.AgentID = " + roleTbl + ".AgentID";
            if (!fldTbl.equals("agent")) {
                sql = String.valueOf(sql) + " inner join address on address.AgentID = agent.AgentID";
            }
        }
        if ((match = BasicSQLUtils.querySingleCol(sql = String.valueOf(sql) + " where " + transTbl + "." + transNumberFld + " = '" + transNumber + "' and " + roleTbl + ".Role = '" + role + "'")) == null || match.size() == 0) {
            return "";
        }
        return match.get(0) == null ? "" : match.get(0).toString();
    }

    public String escapeForHtml(String text) {
        String[] subs = new String[]{"&", "&amp;"};
        String result = text;
        int s = 0;
        while (s < subs.length) {
            result = result.replaceAll(subs[s], subs[s + 1]);
            s += 2;
        }
        return result;
    }

    public String getFirstCollector(Object catalogNumber) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            String result = "";
            UIFieldFormatterIFace formatter = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()).getFieldByName("catalogNumber").getFormatter();
            Object dbCatNum = formatter.formatFromUI(catalogNumber);
            List<CollectionObject> list = session.getDataList(CollectionObject.class, "catalogNumber", dbCatNum);
            if (list.size() > 0) {
                CollectingEvent ce = list.get(0).getCollectingEvent();
                Set<Collector> collectors = ce.getCollectors();
                if (collectors.size() > 0) {
                    Collector firstCollector = null;
                    for (Collector collector : collectors) {
                        if (firstCollector != null && collector.getOrderNumber() >= firstCollector.getOrderNumber()) continue;
                        firstCollector = collector;
                    }
                    if (firstCollector != null) {
                        result = DataObjFieldFormatMgr.getInstance().format(firstCollector, Collector.class);
                    }
                } else {
                    result = "";
                }
            } else {
                log.error((Object)("Couldn't locate CatalogNumber [" + catalogNumber + "]"));
            }
            String string = result;
            return string;
        }
        finally {
            session.close();
        }
    }

    public String getCurrentDeterminationFullName(Object catalogNumber) {
        UIFieldFormatterIFace formatter = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()).getFieldByName("catalogNumber").getFormatter();
        Object dbCatNum = formatter.formatFromUI(catalogNumber);
        String sql = "select t.FullName from taxon t inner join determination d on d.PreferredTaxonID = t.TaxonID inner join collectionobject co on co.CollectionObjectID = d.CollectionObjectID where d.IsCurrent and co.CatalogNumber = '" + dbCatNum + "'";
        return (String)BasicSQLUtils.querySingleObj(sql);
    }

    public String getSecondaryCollectors(Object catalogNumber) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            String result = "";
            UIFieldFormatterIFace formatter = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()).getFieldByName("catalogNumber").getFormatter();
            Object dbCatNum = formatter.formatFromUI(catalogNumber);
            List<CollectionObject> list = session.getDataList(CollectionObject.class, "catalogNumber", dbCatNum);
            if (list.size() > 0) {
                CollectingEvent ce = list.get(0).getCollectingEvent();
                Set<Collector> collectors = ce.getCollectors();
                if (collectors.size() > 1) {
                    Collector firstCollector = null;
                    for (Collector collector : collectors) {
                        if (firstCollector != null && collector.getOrderNumber() >= firstCollector.getOrderNumber()) continue;
                        firstCollector = collector;
                    }
                    if (firstCollector != null) {
                        collectors.remove(firstCollector);
                        Vector<Collector> sortedCollectors = new Vector<Collector>(collectors);
                        Collections.sort(sortedCollectors, new Comparator<Collector>(){

                            @Override
                            public int compare(Collector arg0, Collector arg1) {
                                Integer order0 = arg0.getOrderNumber() != null ? arg0.getOrderNumber() : -1;
                                Integer order1 = arg1.getOrderNumber() != null ? arg1.getOrderNumber() : -1;
                                return order0.compareTo(order1);
                            }
                        });
                        result = DataObjFieldFormatMgr.getInstance().aggregate(collectors, Collector.class);
                    }
                } else {
                    result = "";
                }
            } else {
                log.error((Object)("Couldn't locate CatalogNumber [" + catalogNumber + "]"));
            }
            String string = result;
            return string;
        }
        finally {
            session.close();
        }
    }

    public String buildNameString(String firstName, String lastName, String middleInitial) {
        String name;
        String string = name = StringUtils.isNotEmpty((String)lastName) ? lastName : "";
        if (StringUtils.isNotEmpty((String)firstName)) {
            name = String.valueOf(name) + (name.length() > 0 ? ", " : "") + firstName;
        }
        if (StringUtils.isNotEmpty((String)middleInitial)) {
            name = String.valueOf(name) + (name.length() > 0 ? " " : "") + middleInitial;
        }
        return name;
    }

    public String getTypeStatus(Integer collectionObjectId) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        String result = "";
        try {
            if (collectionObjectId != null) {
                List<Determination> list = session.getDataList(Determination.class, "collectionObject", session.get(CollectionObject.class, collectionObjectId));
                for (Determination d : list) {
                    if (d.getTypeStatusName() == null) continue;
                    if (!result.equals("")) {
                        result = String.valueOf(result) + ", ";
                    }
                    result = String.valueOf(result) + d.getTypeStatusName();
                }
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    public String getTypeTaxon(Integer collectionObjectId) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        String result = "";
        try {
            if (collectionObjectId != null) {
                List<Determination> list = session.getDataList(Determination.class, "collectionObject", session.get(CollectionObject.class, collectionObjectId));
                for (Determination d : list) {
                    if (d.getTypeStatusName() == null) continue;
                    Taxon t = null;
                    if (d.getTaxon() != null) {
                        t = session.getData(Taxon.class, "taxonId", d.getTaxon().getId(), DataProviderSessionIFace.CompareType.Equals);
                    }
                    if (t != null) {
                        if (!result.equals("")) {
                            result = String.valueOf(result) + ", ";
                        }
                        result = String.valueOf(result) + t.getFullName();
                        if (t.getAuthor() == null) continue;
                        result = String.valueOf(result) + " " + t.getAuthor();
                        continue;
                    }
                    log.error((Object)("Couldn't locate taxon [" + d.getTaxon() + "]"));
                }
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    public String buildLocalityString(String geoName, String localityName, String latitude, String longitude) {
        String locality = "";
        if (geoName != null && geoName.length() >= 1) {
            locality = String.valueOf(locality) + geoName;
        }
        if (localityName != null && localityName.length() >= 1) {
            locality = String.valueOf(locality) + ", " + localityName;
        }
        if (latitude != null && latitude.length() >= 1) {
            String[] temp1 = latitude.split("deg");
            locality = String.valueOf(locality) + ", " + temp1[0] + (temp1.length > 1 ? temp1[1] : "");
        }
        if (longitude != null && longitude.length() >= 1) {
            String[] temp2 = longitude.split("deg");
            locality = String.valueOf(locality) + ", " + temp2[0] + (temp2.length > 1 ? temp2[1] : "");
        }
        return locality;
    }

    public String dateDifference(Date startDate, Date endDate) {
        String loanLength = UIRegistry.getResourceString("NA");
        if (startDate != null && endDate != null) {
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(startDate);
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(endDate);
            int monthCount = 0;
            while (startCal.before(endCal)) {
                startCal.add(2, 1);
                ++monthCount;
            }
            loanLength = String.format(UIRegistry.getResourceString("SCRPLT_MON_LEN"), monthCount);
        }
        return loanLength;
    }

    public String dateStringDifference(String startDate, String endDate) {
        try {
            return this.dateDifference(new Date(this.dateConverter.convert(startDate).getTimeInMillis()), new Date(this.dateConverter.convert(endDate).getTimeInMillis()));
        }
        catch (ParseException pex) {
            return UIRegistry.getResourceString("NA");
        }
    }

    public String formatDate(java.util.Date date, String format) {
        String fmtStr = StringUtils.isNotEmpty((String)format) ? format : stdFormat;
        SimpleDateFormat sdf = this.dateFormatHash.get(fmtStr);
        if (sdf == null) {
            sdf = new SimpleDateFormat(fmtStr);
            this.dateFormatHash.put(format, sdf);
        }
        return sdf.format(date);
    }

    public String formatDate(Date sqlDate, String format) {
        return this.formatDate((java.util.Date)sqlDate, format);
    }

    public String getAggregated(String parentTable, String childTable, String getter, String aggregator, Integer parentID) throws Exception {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByShortClassName(parentTable);
            String parentKeyFld = tblInfo.getPrimaryKeyName();
            Class<?> parentClass = tblInfo.getClassObj();
            Method getMethod = parentClass.getMethod(getter, null);
            tblInfo = DBTableIdMgr.getInstance().getByShortClassName(childTable);
            Class<?> childClass = tblInfo.getClassObj();
            List<?> list = session.getDataList(parentClass, parentKeyFld, parentID);
            if (list.size() > 0) {
                Object parent = list.get(0);
                Set children = (Set)getMethod.invoke(parentClass.cast(parent), null);
                if (children.size() > 0) {
                    if (StringUtils.isNotBlank((String)aggregator)) {
                        DataObjAggregator agg = DataObjFieldFormatMgr.getInstance().getAggregator(aggregator);
                        if (agg != null && agg.getDataClass().equals(childClass)) {
                            String string = DataObjFieldFormatMgr.getInstance().aggregate(children, aggregator);
                            return string;
                        }
                        log.error((Object)("Unable to find aggregator for " + childTable + " named " + aggregator + ". Using default aggregator."));
                    }
                    String string = DataObjFieldFormatMgr.getInstance().aggregate(children, childClass);
                    return string;
                }
            } else {
                log.error((Object)("Couldn't locate " + parentTable + " [" + parentID + "]"));
            }
        }
        finally {
            session.close();
        }
        return "";
    }

    public String getCollectorsWithAggregator(Integer colEvId, String aggregator) throws Exception {
        return this.getAggregated("CollectingEvent", "Collector", "getCollectors", aggregator, colEvId);
    }

    public String getCollectorsByCOIdNumWithAggregator(Integer coId, String aggregator) throws Exception {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        if (session != null) {
            try {
                CollectingEvent ce;
                CollectionObject co = session.get(CollectionObject.class, coId);
                if (co != null && (ce = co.getCollectingEvent()) != null) {
                    String string = this.getCollectorsWithAggregator(ce.getId(), aggregator);
                    return string;
                }
            }
            finally {
                session.close();
            }
        }
        return "";
    }

    public String getCollectors(Integer colEvId) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        String collectorsStr = UIRegistry.getResourceString("NA");
        List<CollectingEvent> list = session.getDataList(CollectingEvent.class, "collectingEventId", colEvId);
        if (list.size() > 0) {
            CollectingEvent ce = list.get(0);
            Set<Collector> collectors = ce.getCollectors();
            collectorsStr = collectors.size() > 0 ? DataObjFieldFormatMgr.getInstance().aggregate(collectors, Collector.class) : UIRegistry.getResourceString("SCRPLT_NO_COLTRS");
        } else {
            log.error((Object)("Couldn't locate CollecingEventID [" + colEvId + "]"));
        }
        session.close();
        return collectorsStr;
    }

    protected int convertInt(Integer val) {
        return val == null ? 0 : val;
    }

    public Integer calcLoanQuantity(Integer countArg, Integer QuantityReturnedArg, Integer QuantityResolvedArg) {
        int count = this.convertInt(countArg);
        int quantityReturned = this.convertInt(QuantityReturnedArg);
        int quantityResolved = this.convertInt(QuantityResolvedArg);
        return count - quantityReturned - quantityResolved;
    }

    public String formatDetermination(Object dataSource) {
        String label;
        block8: {
            String isCurrent2;
            WorkbenchJRDataSource rowDataSource;
            String styleInfo;
            String data;
            block9: {
                label = new String();
                data = new String();
                styleInfo = new String();
                if (!(dataSource instanceof WorkbenchJRDataSource)) break block8;
                rowDataSource = (WorkbenchJRDataSource)dataSource;
                String isCurrent1 = rowDataSource.getFieldValue("isCurrent1").toString();
                isCurrent2 = rowDataSource.getFieldValue("isCurrent2").toString();
                if (!isCurrent1.equals("true") && (!isCurrent1.equals("") || !isCurrent2.equals(""))) break block9;
                Vector<String> labelNames = this.isCurrent1Labels();
                Enumeration<String> e = labelNames.elements();
                while (e.hasMoreElements()) {
                    data = rowDataSource.getFieldValue(e.nextElement()).toString();
                    try {
                        if (!StringUtils.isNotEmpty((String)data)) continue;
                        styleInfo = e.nextElement();
                        if (styleInfo.startsWith("<style")) {
                            label = label.concat(String.valueOf(styleInfo) + StringEscapeUtils.escapeHtml((String)data) + " </style>");
                            continue;
                        }
                        label = label.concat(String.valueOf(styleInfo) + data + " ");
                    }
                    catch (NoSuchElementException ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(Scriptlet.class, ex);
                        log.error((Object)ex);
                        return label;
                    }
                }
                break block8;
            }
            if (!isCurrent2.equals("true")) break block8;
            Vector<String> labelNames = this.isCurrent2Labels();
            Enumeration<String> e = labelNames.elements();
            while (e.hasMoreElements()) {
                data = rowDataSource.getFieldValue(e.nextElement()).toString();
                try {
                    if (!StringUtils.isNotEmpty((String)data)) continue;
                    styleInfo = e.nextElement();
                    if (styleInfo.startsWith("<style")) {
                        label = label.concat(String.valueOf(styleInfo) + data + " </style>");
                        continue;
                    }
                    label = label.concat(String.valueOf(styleInfo) + data + " ");
                }
                catch (NoSuchElementException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(Scriptlet.class, ex);
                    log.error((Object)ex);
                    return label;
                }
            }
        }
        return label;
    }

    public Vector<String> isCurrent1Labels() {
        Vector<String> labelNames = new Vector<String>();
        labelNames.add("genus1");
        labelNames.add("<style isItalic=\"true\">");
        labelNames.add("speciesQualifier1");
        labelNames.add("");
        labelNames.add("species1");
        labelNames.add("<style isItalic=\"true\">");
        labelNames.add("speciesAuthorFirstName1");
        labelNames.add("");
        labelNames.add("speciesAuthorLastName1");
        labelNames.add("");
        labelNames.add("subspeciesQualifier1");
        labelNames.add("");
        labelNames.add("subspecies1");
        labelNames.add("<style isItalic=\"true\">");
        labelNames.add("infraAuthorFirstName1");
        labelNames.add("");
        labelNames.add("infraAuthorLastName1");
        labelNames.add("");
        labelNames.add("varietyQualifier1");
        labelNames.add("var.");
        labelNames.add("variety1");
        labelNames.add("<style isItalic=\"true\">");
        return labelNames;
    }

    public Vector<String> isCurrent2Labels() {
        Vector<String> labelNames = new Vector<String>();
        labelNames.add("genus2");
        labelNames.add("<style isItalic=\"true\">");
        labelNames.add("speciesQualifier2");
        labelNames.add("");
        labelNames.add("species2");
        labelNames.add("<style isItalic=\"true\">");
        labelNames.add("speciesAuthorFirstName2");
        labelNames.add("");
        labelNames.add("speciesAuthorLastName2");
        labelNames.add("");
        labelNames.add("subspeciesQualifier2");
        labelNames.add("");
        labelNames.add("subspecies2");
        labelNames.add("<style isItalic=\"true\">");
        labelNames.add("infraAuthorFirstName2");
        labelNames.add("");
        labelNames.add("infraAuthorLastName2");
        labelNames.add("");
        labelNames.add("varietyQualifier2");
        labelNames.add("var.");
        labelNames.add("variety2");
        labelNames.add("<style isItalic=\"true\">");
        return labelNames;
    }

    protected boolean isOn(int opt) {
        return (this.mask & opt) == opt;
    }

    protected void setOn(int opt) {
        this.mask |= opt;
    }

    public String formatTaxonWithAuthors(String genus, String speciesQualifier, String species, String speciesAuthorFirstName, String speciesAuthorLastName, String subspeciesQualifier, String subspecies, String infraAuthorFirstName, String infraAuthorLastName, String varietyQualifier, String variety) {
        StringBuilder sb = new StringBuilder();
        sb.append(genus);
        sb.append(" ");
        if (this.isOn(2)) {
            sb.append("<style isItalic=\"true\">");
            sb.append(speciesQualifier);
            sb.append("</style>");
            sb.append(" ");
        }
        sb.append(species);
        if (this.isOn(8) || this.isOn(16)) {
            sb.append(" ");
            sb.append("<style isItalic=\"true\">(");
            if (this.isOn(8)) {
                sb.append(speciesAuthorFirstName);
                if (this.isOn(16)) {
                    sb.append(" ");
                }
            }
            if (this.isOn(16)) {
                sb.append(speciesAuthorLastName);
            }
            sb.append(")</style>");
        }
        if (this.isOn(32)) {
            sb.append(" ");
            sb.append(subspeciesQualifier);
        }
        if (this.isOn(64)) {
            sb.append(" subsp. ");
            sb.append(subspecies);
        }
        if (this.isOn(128) || this.isOn(256)) {
            sb.append(" ");
            sb.append("<style isItalic=\"true\">(");
            if (this.isOn(128)) {
                sb.append(infraAuthorFirstName);
                if (this.isOn(256)) {
                    sb.append(" ");
                }
            }
            if (this.isOn(256)) {
                sb.append(infraAuthorLastName);
            }
            sb.append(")</style>");
        }
        if (this.isOn(512)) {
            sb.append(" ");
            sb.append(varietyQualifier);
        }
        if (this.isOn(1024)) {
            sb.append(" var. ");
            sb.append(variety);
        }
        return sb.toString();
    }

    protected TaxonInfo getTaxonInfo(int taxonId) {
        block16: {
            if (this.stmt == null) {
                try {
                    this.stmt = DBConnection.getInstance().getConnection().createStatement();
                }
                catch (SQLException ex) {
                    log.debug((Object)ex);
                }
            }
            ResultSet rs = null;
            try {
                try {
                    rs = this.stmt.executeQuery("SELECT Name, RankID, ParentID, Author FROM taxon WHERE TaxonID = " + taxonId);
                    if (rs.next()) {
                        this.info.set(rs.getString(1), rs.getInt(2), rs.getInt(3), rs.getString(4));
                    }
                }
                catch (SQLException ex) {
                    log.debug((Object)ex);
                    ex.printStackTrace();
                    if (rs == null) break block16;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return this.info;
    }

    protected Triple<String, String, String> getAuthor(int taxonId) {
        block17: {
            if (this.stmt == null) {
                try {
                    this.stmt = DBConnection.getInstance().getConnection().createStatement();
                }
                catch (SQLException ex) {
                    log.debug((Object)ex);
                }
            }
            ResultSet rs = null;
            try {
                try {
                    String sql = "SELECT r.Title, r.WorkDate, a.FirstName, a.MiddleInitial, a.LastName FROM taxoncitation ct INNER JOIN referencework r ON ct.ReferenceWorkID = r.ReferenceWorkID LEFT JOIN author au ON r.ReferenceWorkID = au.ReferenceWorkID INNER JOIN agent a ON au.AgentID = a.AgentID WHERE ct.TaxonID = " + taxonId + " ORDER BY au.OrderNumber ASC";
                    rs = this.stmt.executeQuery(sql);
                    this.cit.third = "";
                    while (rs.next()) {
                        this.cit.first = rs.getString(1);
                        this.cit.second = rs.getString(2);
                        String last = rs.getString(5);
                        if (StringUtils.isNotEmpty((String)((String)this.cit.third))) {
                            this.cit.third = String.valueOf(this.cit.third) + ", ";
                        }
                        this.cit.third = String.valueOf(this.cit.third) + last;
                    }
                }
                catch (SQLException ex) {
                    log.debug((Object)ex);
                    ex.printStackTrace();
                    if (rs == null) break block17;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return this.cit;
    }

    protected Triple<String, String, String> getDeterminationQualifiers(int detId) {
        block16: {
            if (this.stmt == null) {
                try {
                    this.stmt = DBConnection.getInstance().getConnection().createStatement();
                }
                catch (SQLException ex) {
                    log.debug((Object)ex);
                }
            }
            ResultSet rs = null;
            try {
                try {
                    String sql = "SELECT Qualifier, SubSpQualifier, VarQualifier FROM determination WHERE DeterminationID = " + detId;
                    rs = this.stmt.executeQuery(sql);
                    this.cit.third = "";
                    while (rs.next()) {
                        this.info.spQualifer = rs.getString(1);
                        this.info.subSpQualifer = rs.getString(2);
                        this.info.varQualifer = rs.getString(3);
                    }
                }
                catch (SQLException ex) {
                    log.debug((Object)ex);
                    ex.printStackTrace();
                    if (rs == null) break block16;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return this.cit;
    }

    public String getTaxonNameWithAuthors(Integer taxonIdArg, Integer detIdArg) {
        int taxonId = taxonIdArg;
        String genus = null;
        String speciesQualifier = null;
        String species = null;
        String speciesAuthorFirstName = null;
        String speciesAuthorLastName = null;
        String subspeciesQualifier = null;
        String subspecies = null;
        String infraAuthorFirstName = null;
        String infraAuthorLastName = null;
        String varietyQualifier = null;
        String variety = null;
        this.mask = 0;
        this.info.clear();
        if (detIdArg != null) {
            this.getDeterminationQualifiers(detIdArg);
            if (StringUtils.isNotEmpty((String)this.info.spQualifer)) {
                speciesQualifier = this.info.spQualifer;
                this.setOn(2);
            }
            if (StringUtils.isNotEmpty((String)this.info.subSpQualifer)) {
                subspeciesQualifier = this.info.subSpQualifer;
                this.setOn(32);
            }
            if (StringUtils.isNotEmpty((String)this.info.varQualifer)) {
                varietyQualifier = this.info.varQualifer;
                this.setOn(512);
            }
        }
        this.getTaxonInfo(taxonId);
        if (this.info.rankId == 240) {
            variety = this.info.name;
            taxonId = this.info.parentId;
            this.info.rankId = 230;
            this.setOn(1024);
        }
        if (this.info.rankId == 230) {
            this.getTaxonInfo(taxonId);
            if (StringUtils.isNotEmpty((String)this.info.author)) {
                this.cit.third = this.info.author;
            } else {
                this.getAuthor(taxonId);
            }
            if (this.cit.third != null) {
                infraAuthorLastName = (String)this.cit.third;
                this.setOn(256);
            }
            subspecies = this.info.name;
            taxonId = this.info.parentId;
            this.info.rankId = 220;
            this.setOn(64);
        }
        if (this.info.rankId == 220) {
            this.getTaxonInfo(taxonId);
            if (StringUtils.isNotEmpty((String)this.info.author)) {
                this.cit.third = this.info.author;
            } else {
                this.getAuthor(taxonId);
            }
            if (this.cit.third != null) {
                speciesAuthorLastName = (String)this.cit.third;
                this.setOn(16);
            }
            species = this.info.name;
            taxonId = this.info.parentId;
            this.info.rankId = 180;
            this.setOn(4);
        }
        if (this.info.rankId == 180) {
            this.getTaxonInfo(taxonId);
            genus = this.info.name;
            taxonId = this.info.parentId;
            this.info.rankId = 230;
            this.setOn(1);
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.formatTaxonWithAuthors(genus, speciesQualifier, species, speciesAuthorFirstName, speciesAuthorLastName, subspeciesQualifier, subspecies, infraAuthorFirstName, infraAuthorLastName, varietyQualifier, variety);
    }

    class TaxonInfo {
        String name;
        Integer rankId;
        Integer parentId;
        String author;
        String spQualifer;
        String subSpQualifer;
        String varQualifer;

        public TaxonInfo() {
        }

        public TaxonInfo(String name, Integer rankId, Integer parentId, String author) {
            this.name = name;
            this.rankId = rankId;
            this.parentId = parentId;
            this.author = author;
        }

        public void set(String name, Integer rankId, Integer parentId, String author) {
            this.name = name;
            this.rankId = rankId;
            this.parentId = parentId;
            this.author = author;
        }

        public void clear() {
            this.name = null;
            this.rankId = null;
            this.parentId = null;
            this.author = null;
            this.spQualifer = null;
            this.subSpQualifer = null;
            this.varQualifer = null;
        }
    }
}

