/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.ResImpExpMetaInfoDlg;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceData;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpViewSetObj;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tasks.ReportsBaseTask;
import edu.ku.brc.specify.tools.ireportspecify.MainFrameSpecify;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.PromptDlg;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class ResourceImportExportDlg
extends CustomDialog {
    protected static final Logger log = Logger.getLogger(ResourceImportExportDlg.class);
    private SpecifyAppContextMgr contextMgr;
    private String userName;
    protected JComboBox levelCBX;
    protected JList viewSetsList;
    protected DefaultListModel viewSetsModel = new DefaultListModel();
    protected JList viewsList;
    protected DefaultListModel viewsModel = new DefaultListModel();
    protected JPanel viewsPanel = null;
    protected JList resList;
    protected DefaultListModel resModel = new DefaultListModel();
    protected JPanel resPanel = null;
    protected JList repList;
    protected DefaultListModel repModel = new DefaultListModel();
    protected JPanel repPanel = null;
    protected JTabbedPane tabbedPane;
    protected JButton exportBtn;
    protected JButton importBtn;
    protected JButton revertBtn;
    protected List<SpAppResource> resources = new Vector<SpAppResource>();
    protected List<SpAppResourceDir> dirs = new Vector<SpAppResourceDir>();
    protected boolean hasChanged = false;

    public ResourceImportExportDlg(SpecifyAppContextMgr contextMgr, String userName) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("RIE_TITLE"), true, 5, null);
        this.okLabel = UIRegistry.getResourceString("CLOSE");
        this.contextMgr = contextMgr == null ? (SpecifyAppContextMgr)AppContextMgr.getInstance() : contextMgr;
        this.userName = userName;
    }

    protected String getHierarchicalTitle(SpAppResourceDir dir) {
        DBTableInfo collectionTI = DBTableIdMgr.getInstance().getByClassName(Collection.class.getName());
        DBTableInfo disciplineTI = DBTableIdMgr.getInstance().getByClassName(Discipline.class.getName());
        String hierTitle = "XXX";
        hierTitle = dir.getIsPersonal().booleanValue() ? dir.getTitle() : (dir.getUserType() != null ? (dir.getUserType().equals("Common") || dir.getUserType().equals("BackStop") ? dir.getTitle() : UIRegistry.getResourceString("RIE_GROUP")) : (dir.getCollection() != null ? String.valueOf(dir.getCollection().getCollectionName()) + " (" + collectionTI.getTitle() + ")" : (dir.getDiscipline() != null ? String.valueOf(dir.getDiscipline().getType()) + " (" + disciplineTI.getTitle() + ")" : dir.getIdentityTitle())));
        return hierTitle;
    }

    @Override
    public void createUI() {
        CellConstraints cc;
        block14: {
            super.createUI();
            this.setHelpContext("Import");
            cc = new CellConstraints();
            this.levelCBX = UIHelper.createComboBox();
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    for (SpAppResourceDir curDir : this.contextMgr.getSpAppResourceList()) {
                        SpAppResourceDir dir;
                        if (curDir.getId() != null) {
                            dir = session.get(SpAppResourceDir.class, curDir.getId());
                            dir.setTitle(curDir.getTitle());
                            dir.getSpAppResources().size();
                            dir.getSpPersistedAppResources().size();
                            dir.getSpPersistedViewSets().size();
                            for (SpAppResource appRes : curDir.getSpAppResources()) {
                                if (appRes.getId() != null) continue;
                                dir.getSpAppResources().add(appRes);
                            }
                            for (SpViewSetObj vso : curDir.getSpViewSets()) {
                                if (vso.getId() != null) continue;
                                dir.getSpViewSets().add(vso);
                            }
                        } else {
                            dir = (SpAppResourceDir)curDir.clone();
                        }
                        this.dirs.add(dir);
                        this.levelCBX.addItem(dir);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex);
                    if (session != null) {
                        session.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        PanelBuilder centerPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "p,10px,p"));
        centerPB.add((Component)UIHelper.createLabel(UIRegistry.getLocalizedMessage("RIE_USR_LBL", this.userName)), cc.xy(2, 1));
        centerPB.add((Component)this.levelCBX, cc.xy(2, 3));
        this.tabbedPane = new JTabbedPane();
        PanelBuilder viewPanel = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "p,2px,f:p:g"));
        viewPanel.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("RIE_VIEWSETS"), 0), cc.xy(1, 1));
        this.viewSetsList = new JList(this.viewSetsModel);
        this.viewSetsList.setCellRenderer(new ARListRenderer());
        JScrollPane sp = new JScrollPane(this.viewSetsList, 20, 31);
        viewPanel.add((Component)sp, cc.xy(1, 3));
        viewPanel.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("RIE_VIEWS"), 0), cc.xy(3, 1));
        this.viewsList = new JList(this.viewsModel);
        this.viewsList.setCellRenderer(new ViewRenderer());
        sp = new JScrollPane(this.viewsList, 20, 31);
        viewPanel.add((Component)sp, cc.xy(3, 3));
        this.viewsList.setEnabled(false);
        PanelBuilder resPane = new PanelBuilder(new FormLayout("f:p:g", "p,2px,p"));
        resPane.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("RIE_OTHER_RES"), 0), cc.xy(1, 1));
        this.resList = new JList(this.resModel);
        this.resList.setSelectionMode(0);
        this.resList.setCellRenderer(new ARListRenderer());
        sp = new JScrollPane(this.resList, 20, 31);
        resPane.add((Component)sp, cc.xy(1, 3));
        PanelBuilder repPane = new PanelBuilder(new FormLayout("f:p:g", "p,2px,f:p:g"));
        repPane.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("RIE_REPORT_RES"), 0), cc.xy(1, 1));
        this.repList = new JList(this.repModel);
        this.repList.setSelectionMode(0);
        this.repList.setCellRenderer(new ARListRenderer());
        sp = new JScrollPane(this.repList, 20, 31);
        repPane.add((Component)sp, cc.xy(1, 3));
        boolean addResourcesPanel = AppPreferences.getLocalPrefs().getBoolean("ADD_IMP_RES", false);
        this.viewsPanel = viewPanel.getPanel();
        this.tabbedPane.addTab(UIRegistry.getResourceString("RIE_VIEWSETS"), this.viewsPanel);
        if (addResourcesPanel) {
            this.resPanel = resPane.getPanel();
            this.tabbedPane.addTab(UIRegistry.getResourceString("RIE_OTHER_RES"), this.resPanel);
        }
        this.repPanel = repPane.getPanel();
        this.tabbedPane.addTab(UIRegistry.getResourceString("RIE_REPORT_RES"), this.repPanel);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,f:p:g,2px,p"));
        pb.add((Component)centerPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)this.tabbedPane, cc.xy(1, 3));
        this.exportBtn = UIHelper.createButton(UIRegistry.getResourceString("RIE_EXPORT"));
        this.importBtn = UIHelper.createButton(UIRegistry.getResourceString("RIE_IMPORT"));
        this.revertBtn = UIHelper.createButton(UIRegistry.getResourceString("RIE_REVERT"));
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,f:p:g,p,f:p:g", "p,10px"));
        btnPB.add((Component)this.exportBtn, cc.xy(2, 1));
        btnPB.add((Component)this.importBtn, cc.xy(4, 1));
        btnPB.add((Component)this.revertBtn, cc.xy(6, 1));
        pb.add((Component)btnPB.getPanel(), cc.xy(1, 5));
        pb.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComp = ResourceImportExportDlg.this.tabbedPane.getSelectedComponent();
                if (selectedComp != null) {
                    if (selectedComp == ResourceImportExportDlg.this.viewsPanel) {
                        ResourceImportExportDlg.this.viewSetsList.setSelectedIndex(-1);
                    } else if (selectedComp == ResourceImportExportDlg.this.resPanel) {
                        ResourceImportExportDlg.this.resList.setSelectedIndex(-1);
                    } else {
                        ResourceImportExportDlg.this.repList.setSelectedIndex(-1);
                    }
                }
                ResourceImportExportDlg.this.enableUI();
                Dimension size = ResourceImportExportDlg.this.getSize();
                Dimension newSize = ResourceImportExportDlg.this.getPreferredSize();
                size.height = newSize.height;
                ResourceImportExportDlg.this.setSize(size);
            }
        });
        this.levelCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ResourceImportExportDlg.this.levelSelected();
                    }
                });
            }
        });
        this.levelCBX.setSelectedIndex(0);
        this.pack();
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceImportExportDlg.this.exportResource();
            }
        });
        this.importBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceImportExportDlg.this.importResource();
            }
        });
        this.revertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceImportExportDlg.this.revertResource();
            }
        });
        this.viewSetsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (ResourceImportExportDlg.this.viewSetsList.getSelectedIndex() > -1) {
                        ResourceImportExportDlg.this.resList.clearSelection();
                        ResourceImportExportDlg.this.repList.clearSelection();
                    }
                    ResourceImportExportDlg.this.fillViewsList();
                    ResourceImportExportDlg.this.enableUI();
                }
            }
        });
        this.resList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (ResourceImportExportDlg.this.resList.getSelectedIndex() > -1) {
                        ResourceImportExportDlg.this.viewSetsList.clearSelection();
                        ResourceImportExportDlg.this.repList.clearSelection();
                    }
                    ResourceImportExportDlg.this.enableUI();
                }
            }
        });
        this.repList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (ResourceImportExportDlg.this.resList.getSelectedIndex() > -1) {
                        ResourceImportExportDlg.this.viewSetsList.clearSelection();
                        ResourceImportExportDlg.this.resList.clearSelection();
                    }
                    ResourceImportExportDlg.this.enableUI();
                }
            }
        });
        this.pack();
    }

    protected void fillViewsList() {
        int levelIndex = this.levelCBX.getSelectedIndex();
        if (levelIndex > -1) {
            List<ViewSetIFace> vsList;
            SpAppResourceDir dir = this.dirs.get(levelIndex);
            this.viewsModel.clear();
            levelIndex = this.viewSetsList.getSelectedIndex();
            if (levelIndex > -1 && (vsList = this.contextMgr.getViewSetList(dir)) != null && levelIndex < vsList.size()) {
                ViewSetIFace vs = vsList.get(levelIndex);
                Vector<ViewIFace> views = new Vector<ViewIFace>(vs.getViews().values());
                Collections.sort(views);
                for (ViewIFace view : views) {
                    this.viewsModel.addElement(view);
                }
            }
        }
    }

    protected void enableUI() {
        int currentTabIndex = this.tabbedPane.getModel().getSelectedIndex();
        if (currentTabIndex == 0) {
            boolean enable = !this.viewSetsList.isSelectionEmpty();
            this.importBtn.setEnabled(enable && this.levelCBX.getSelectedIndex() < 5);
            this.exportBtn.setEnabled(enable && this.viewSetsModel.size() > 0);
            if (this.viewSetsList.getSelectedValue() instanceof SpViewSetObj) {
                SpViewSetObj vso = (SpViewSetObj)this.viewSetsList.getSelectedValue();
                this.revertBtn.setEnabled(vso != null && vso.getId() != null);
            } else {
                this.revertBtn.setEnabled(false);
            }
        } else if (currentTabIndex != -1) {
            JList activeList;
            JList jList = activeList = this.tabbedPane.getSelectedComponent() == this.resPanel ? this.resList : this.repList;
            if (activeList.getSelectedValue() instanceof String) {
                this.importBtn.setEnabled(true);
                this.exportBtn.setEnabled(false);
                this.revertBtn.setEnabled(false);
            } else {
                boolean hasOthersTab = this.tabbedPane.getTabCount() > 2;
                boolean enable = !activeList.isSelectionEmpty();
                int numItems = ((DefaultListModel)activeList.getModel()).size();
                this.importBtn.setEnabled(enable && (this.levelCBX.getSelectedIndex() < 2 || numItems > 1 && hasOthersTab));
                this.exportBtn.setEnabled(enable && numItems > 1);
                SpAppResource appRes = (SpAppResource)activeList.getSelectedValue();
                enable = false;
                if (appRes != null && appRes.getId() != null) {
                    enable = appRes.getMimeType() != null && (appRes.getMimeType().equals("jrxml/report") || appRes.getMimeType().equals("jrxml/label")) ? true : true;
                }
                this.revertBtn.setEnabled(enable);
            }
        }
    }

    protected void revertResource() {
        int index = this.levelCBX.getSelectedIndex();
        if (index > -1) {
            String exportedName = null;
            String virtualDirName = SpecifyAppContextMgr.getVirtualDirName(index);
            if (this.tabbedPane.getSelectedComponent() == this.viewsPanel) {
                SpViewSetObj vso = (SpViewSetObj)this.viewSetsList.getSelectedValue();
                if (vso != null) {
                    exportedName = vso.getName();
                    index = this.viewSetsList.getSelectedIndex();
                    if (index > -1) {
                        this.viewSetsModel.remove(index);
                        this.contextMgr.revertViewSet(virtualDirName, vso.getName());
                        this.setHasChanged(true);
                    }
                }
            } else {
                JList theList = this.tabbedPane.getSelectedComponent() == this.repPanel ? this.repList : this.resList;
                DefaultListModel theModel = theList == this.repList ? this.repModel : this.resModel;
                index = theList.getSelectedIndex();
                if (index > 0) {
                    AppResourceIFace appRes = (AppResourceIFace)theList.getSelectedValue();
                    AppResourceIFace revertedNewAR = this.contextMgr.revertResource(virtualDirName, appRes);
                    this.setHasChanged(true);
                    if (revertedNewAR != null) {
                        theModel.insertElementAt(revertedNewAR, index);
                        theList.setSelectedIndex(index);
                    } else {
                        theModel.removeElementAt(index);
                        theList.clearSelection();
                    }
                    this.levelSelected();
                }
            }
            if (exportedName != null) {
                UIRegistry.getStatusBar().setText(UIRegistry.getLocalizedMessage("RIE_RES_REVERTED", exportedName));
            }
            this.enableUI();
        }
    }

    private void setHasChanged(boolean changed) {
        this.hasChanged = changed;
        this.okBtn.setText(UIRegistry.getResourceString(changed ? "EXIT" : "CLOSE"));
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    protected void exportResource() {
        int index = this.levelCBX.getSelectedIndex();
        if (index > -1) {
            String exportedName = null;
            String data = null;
            String fileName = null;
            AppResourceIFace appRes = null;
            if (this.tabbedPane.getSelectedComponent() == this.viewsPanel) {
                if (this.viewSetsList.getSelectedIndex() > -1) {
                    SpViewSetObj vso = (SpViewSetObj)this.viewSetsList.getSelectedValue();
                    exportedName = vso.getName();
                    fileName = FilenameUtils.getName((String)vso.getFileName());
                    data = vso.getDataAsString(true);
                }
            } else {
                JList theList;
                JList jList = theList = this.tabbedPane.getSelectedComponent() == this.repPanel ? this.repList : this.resList;
                if (theList.getSelectedIndex() > 0) {
                    appRes = (AppResourceIFace)theList.getSelectedValue();
                    exportedName = appRes.getName();
                    fileName = FilenameUtils.getName((String)exportedName);
                    data = appRes.getDataAsString();
                }
            }
            if (StringUtils.isNotEmpty(data)) {
                String EXP_DIR_PREF = "RES_LAST_EXPORT_DIR";
                String initalExportDir = AppPreferences.getLocalPrefs().get("RES_LAST_EXPORT_DIR", UIRegistry.getUserHomeDir());
                FileDialog fileDlg = new FileDialog((Dialog)this, UIRegistry.getResourceString("RIE_ExportResource"), 1);
                File expDir = new File(initalExportDir);
                if (StringUtils.isNotEmpty((String)initalExportDir) && expDir.exists()) {
                    fileDlg.setDirectory(initalExportDir);
                }
                fileDlg.setFile(fileName);
                UIHelper.centerAndShow(fileDlg);
                String dirStr = fileDlg.getDirectory();
                fileName = fileDlg.getFile();
                if (StringUtils.isNotEmpty((String)dirStr) && StringUtils.isNotEmpty((String)fileName)) {
                    AppPreferences.getLocalPrefs().put("RES_LAST_EXPORT_DIR", dirStr);
                    File expFile = new File(String.valueOf(dirStr) + File.separator + fileName);
                    try {
                        if (this.isReportResource((SpAppResource)appRes) && this.isSpReportResource((SpAppResource)appRes)) {
                            this.writeSpReportResToZipFile(expFile, data, appRes);
                        } else {
                            FileUtils.writeStringToFile((File)expFile, (String)data);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        UIRegistry.showLocalizedMsg("RIE_NOFILEPERM");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex);
                    }
                }
            }
            if (exportedName != null) {
                UIRegistry.getStatusBar().setText(UIRegistry.getLocalizedMessage("RIE_RES_EXPORTED", exportedName));
            }
        }
    }

    protected boolean isSpReportResource(String data) {
        return data.indexOf("<reportresource name=") == 0;
    }

    protected boolean isSpReportResource(SpAppResource res) {
        if (res.getId() == null) {
            return false;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            boolean bl = session.getData("from SpReport where appResourceId = " + res.getId()) != null;
            return bl;
        }
        finally {
            session.close();
        }
    }

    protected boolean isJasperReport(String data) {
        try {
            Element element = XMLHelper.readStrToDOM4J(data);
            return element.getDocument().getDocType().getName().equals("jasperReport");
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected String getSpReportResourceName(File file) {
        ZipEntry app;
        ZipInputStream zin;
        block7: {
            block6: {
                zin = new ZipInputStream(new FileInputStream(file));
                app = zin.getNextEntry();
                if (app != null) break block6;
                return null;
            }
            if (zin.available() != 0) break block7;
            return null;
        }
        try {
            String appStr = this.readZipEntryToString(zin, app);
            if (this.isSpReportResource(appStr)) {
                Element appElement = XMLHelper.readStrToDOM4J(appStr);
                return XMLHelper.getAttr(appElement, "name", null);
            }
            return null;
        }
        catch (ZipException ex) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex);
            return null;
        }
    }

    protected String readZipEntryToString(ZipInputStream zin, ZipEntry entry) throws IOException {
        StringBuilder result = new StringBuilder();
        byte[] bytes = new byte[100];
        int bytesRead = zin.read(bytes, 0, 100);
        while (bytesRead > 0) {
            result.append(new String(bytes, 0, bytesRead));
            bytesRead = zin.read(bytes, 0, 100);
        }
        return result.toString();
    }

    protected void writeReportResToFile(File expFile, String data, AppResourceIFace appRes) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<reportresource name=\"" + appRes.getName() + "\">\r\n");
        sb.append("<resourcedata>\r\n");
        sb.append("<header>\r\n");
        int reportTag = data.indexOf("<jasperReport");
        String header = data.substring(0, reportTag);
        sb.append("<![CDATA[\r\n");
        sb.append(header);
        sb.append("]]>\r\n");
        sb.append("</header>\r\n");
        sb.append(data.substring(reportTag));
        sb.append("\r\n</resourcedata>\r\n");
        sb.append("<metadata > <![CDATA[");
        sb.append(appRes.getMetaData());
        sb.append("]]>");
        sb.append("</metadata>\r\n");
        sb.append("<mimetype><![CDATA[");
        sb.append(appRes.getMimeType());
        sb.append("]]>");
        sb.append("</mimetype>\r\n");
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            SpReport spRep = (SpReport)session.getData("from SpReport where appResourceId = " + ((SpAppResource)appRes).getId());
            if (spRep != null) {
                spRep.forceLoad();
                spRep.toXML(sb);
            }
        }
        finally {
            session.close();
        }
        sb.append("\r\n</reportresource>\r\n");
        FileUtils.writeStringToFile((File)expFile, (String)sb.toString());
    }

    protected void writeSpReportResToZipFile(File expFile, String data, AppResourceIFace appRes) throws IOException {
        StringBuilder sb = new StringBuilder();
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(expFile));
        sb.append("<reportresource name=\"" + appRes.getName() + "\">\r\n");
        sb.append("<metadata > <![CDATA[");
        sb.append(appRes.getMetaData());
        sb.append("]]>");
        sb.append("</metadata>\r\n");
        sb.append("<mimetype > <![CDATA[");
        sb.append(appRes.getMimeType());
        sb.append("]]>");
        sb.append("</mimetype>\r\n");
        sb.append("\r\n</reportresource>\r\n");
        zout.putNextEntry(new ZipEntry("app.xml"));
        byte[] bytes = sb.toString().getBytes();
        zout.write(bytes, 0, bytes.length);
        zout.closeEntry();
        zout.putNextEntry(new ZipEntry("data.xml"));
        bytes = data.getBytes();
        zout.write(bytes, 0, bytes.length);
        zout.closeEntry();
        sb.setLength(0);
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            SpReport spRep = (SpReport)session.getData("from SpReport where appResourceId = " + ((SpAppResource)appRes).getId());
            if (spRep != null) {
                spRep.forceLoad();
                spRep.toXML(sb);
                bytes = sb.toString().getBytes();
                zout.putNextEntry(new ZipEntry("SpReport.xml"));
                zout.write(bytes, 0, bytes.length);
                zout.closeEntry();
            }
        }
        finally {
            session.close();
        }
        zout.close();
    }

    protected SpAppResource importSpReportZipResource(File file, SpAppResource appRes, SpAppResourceDir dirArg, String newResName) {
        block15: {
            SpAppResourceDir dir = dirArg;
            try {
                Node mimeTypeNode;
                ZipInputStream zin = new ZipInputStream(new FileInputStream(file));
                ZipEntry entry = zin.getNextEntry();
                if (entry == null) {
                    throw new Exception(UIRegistry.getResourceString("RIE_ReportImportFileError"));
                }
                String app = this.readZipEntryToString(zin, entry);
                zin.closeEntry();
                entry = zin.getNextEntry();
                if (entry == null) {
                    throw new Exception(UIRegistry.getResourceString("RIE_ReportImportFileError"));
                }
                String data = this.readZipEntryToString(zin, entry);
                zin.closeEntry();
                Element appRoot = XMLHelper.readStrToDOM4J(app);
                Node metadata = appRoot.selectSingleNode("metadata");
                String metadataStr = metadata.getStringValue();
                if (!metadataStr.endsWith(";")) {
                    metadataStr = String.valueOf(metadataStr) + ";";
                }
                String mimeTypeStr = (mimeTypeNode = appRoot.selectSingleNode("mimetype")) != null ? mimeTypeNode.getStringValue().trim() : null;
                entry = zin.getNextEntry();
                if (entry == null) break block15;
                appRes.setDataAsString(data);
                appRes.setMetaData(metadataStr.trim());
                String repType = appRes.getMetaDataMap().getProperty("reporttype");
                String mimeType = mimeTypeStr != null ? mimeTypeStr : (repType != null && repType.equalsIgnoreCase("label") ? "jrxml/label" : "jrxml/report");
                appRes.setMimeType(mimeType);
                appRes.setLevel((short)3);
                String spReport = this.readZipEntryToString(zin, entry);
                zin.closeEntry();
                zin.close();
                Element repElement = XMLHelper.readStrToDOM4J(spReport);
                SpReport report = new SpReport();
                report.initialize();
                report.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
                report.fromXML(repElement, newResName != null);
                if (newResName != null) {
                    report.setName(newResName);
                }
                appRes.setName(report.getName());
                appRes.setDescription(appRes.getName());
                if (newResName != null && report.getQuery() != null) {
                    UIRegistry.showLocalizedMsg("RIE_ReportNewQueryTitle", "RIE_ReportNewQueryMsg", report.getQuery().getName(), report.getName());
                }
                report.setAppResource(appRes);
                appRes.getSpReports().add(report);
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.beginTransaction();
                        if (dir.getId() != null) {
                            dir = session.get(SpAppResourceDir.class, dir.getId());
                        }
                        dir.getSpPersistedAppResources().add(appRes);
                        appRes.setSpAppResourceDir(dir);
                        if (report.getReportObject() != null && report.getReportObject().getId() == null) {
                            session.saveOrUpdate(report.getReportObject());
                        }
                        session.saveOrUpdate(dir);
                        session.saveOrUpdate(appRes);
                        session.saveOrUpdate(report);
                        session.commit();
                    }
                    catch (Exception ex) {
                        session.rollback();
                        throw ex;
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, e);
                return null;
            }
        }
        return appRes;
    }

    private Pair<SpAppResource, String> checkForOverwriteOrNewName(SpAppResourceDir dir, String currAppResName, boolean isSpReportRes) {
        SpAppResource fndAppRes;
        while ((fndAppRes = this.checkForOverrideAppRes(dir, currAppResName, !isSpReportRes ? FilenameUtils.getBaseName((String)currAppResName) : null)) != null) {
            SpAppResource appRes;
            String msg;
            block12: {
                msg = null;
                String ardTitle = null;
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        SpAppResourceDir dirTmp = session.get(SpAppResourceDir.class, dir.getId());
                        if (dir != null) {
                            dirTmp.getSpPersistedAppResources().size();
                            ardTitle = this.getHierarchicalTitle(dirTmp);
                        }
                        msg = String.format(UIRegistry.getResourceString("RIE_ConfirmResourceOverwriteMsg"), fndAppRes.getName(), StringUtils.isNotEmpty((String)ardTitle) ? ardTitle : this.levelCBX.getSelectedItem().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (session != null) {
                            session.close();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            String title = UIRegistry.getResourceString("RIE_ConfirmResourceOverwriteTitle");
            final PromptDlg dlg = new PromptDlg((Dialog)UIRegistry.getMostRecentWindow(), title, msg, true, 11);
            dlg.setOkLabel(UIRegistry.getResourceString("RIE_ConfirmResourceOverwrite"));
            dlg.setApplyLabel(UIRegistry.getResourceString("Rename"));
            dlg.createUI();
            dlg.getApplyBtn().setEnabled(false);
            dlg.pack();
            dlg.getTextField().getDocument().addDocumentListener(new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    boolean hasText;
                    boolean bl = hasText = !dlg.getTextField().getText().isEmpty();
                    if (dlg.getApplyBtn() != null) {
                        dlg.getApplyBtn().setEnabled(hasText);
                    }
                }
            });
            dlg.getApplyBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dlg.setVisible(false);
                }
            });
            UIHelper.centerAndShow(dlg);
            int option = dlg.getBtnPressed();
            if (option == 2) {
                return null;
            }
            if (option == 1) {
                return new Pair<SpAppResource, String>(fndAppRes, currAppResName);
            }
            if (option != 8 || (appRes = this.checkForOverrideAppRes(dir, dlg.getTextField().getText(), null)) != null) continue;
            return new Pair<Object, String>(null, dlg.getTextField().getText());
        }
        return null;
    }

    protected void importResource() {
        int levelIndex = this.levelCBX.getSelectedIndex();
        if (levelIndex > -1) {
            String importedName = null;
            String IMP_DIR_PREF = "RES_LAST_IMPORT_DIR";
            String initalImportDir = AppPreferences.getLocalPrefs().get("RES_LAST_IMPORT_DIR", UIRegistry.getUserHomeDir());
            FileDialog fileDlg = new FileDialog((Dialog)this, UIRegistry.getResourceString("RIE_IMPORT_RES"), 0);
            File impDir = new File(initalImportDir);
            if (StringUtils.isNotEmpty((String)initalImportDir) && impDir.exists()) {
                fileDlg.setDirectory(initalImportDir);
            }
            UIHelper.centerAndShow(fileDlg);
            String dirStr = fileDlg.getDirectory();
            String fileName = fileDlg.getFile();
            if (StringUtils.isNotEmpty((String)dirStr) && StringUtils.isNotEmpty((String)fileName)) {
                AppPreferences.getLocalPrefs().put("RES_LAST_IMPORT_DIR", dirStr);
                String data = null;
                String fullFileName = String.valueOf(dirStr) + File.separator + fileName;
                File importFile = new File(fullFileName);
                if (importFile.exists()) {
                    boolean isReportRes;
                    String repResourceName = this.getSpReportResourceName(importFile);
                    boolean isSpReportRes = repResourceName != null;
                    boolean isJRReportRes = false;
                    try {
                        data = FileUtils.readFileToString((File)importFile);
                        isJRReportRes = this.isJasperReport(data);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex);
                        return;
                    }
                    boolean bl = isReportRes = isJRReportRes || isSpReportRes;
                    if (this.tabbedPane.getSelectedComponent() == this.viewsPanel) {
                        int viewIndex = this.viewSetsList.getSelectedIndex();
                        if (viewIndex > -1) {
                            SpViewSetObj vso;
                            boolean isOK;
                            boolean isAddItemForImport;
                            block58: {
                                isAddItemForImport = this.viewSetsList.getSelectedValue() instanceof String;
                                isOK = false;
                                vso = null;
                                DataProviderSessionIFace session = null;
                                try {
                                    try {
                                        session = DataProviderFactory.getInstance().createSession();
                                        session.beginTransaction();
                                        if (!isAddItemForImport) {
                                            vso = (SpViewSetObj)this.viewSetsList.getSelectedValue();
                                            SpAppResourceDir spAppResourceDir = vso.getSpAppResourceDir();
                                            importedName = vso.getName();
                                            if (vso.getSpViewSetObjId() == null) {
                                                spAppResourceDir.getSpPersistedViewSets().add(vso);
                                                vso.setSpAppResourceDir(spAppResourceDir);
                                            }
                                            vso.setDataAsString(data, true);
                                            session.saveOrUpdate(spAppResourceDir);
                                        } else {
                                            SpAppResourceDir spAppResourceDir = this.dirs.get(levelIndex);
                                            vso = new SpViewSetObj();
                                            vso.initialize();
                                            vso.setLevel((short)levelIndex);
                                            vso.setName(FilenameUtils.getBaseName((String)importFile.getName()));
                                            spAppResourceDir.getSpPersistedViewSets().add(vso);
                                            vso.setSpAppResourceDir(spAppResourceDir);
                                            vso.setDataAsString(data);
                                            session.saveOrUpdate(spAppResourceDir);
                                        }
                                        session.saveOrUpdate(vso);
                                        for (SpAppResourceData spAppResourceData : vso.getSpAppResourceDatas()) {
                                            session.saveOrUpdate(spAppResourceData);
                                        }
                                        session.commit();
                                        session.flush();
                                        this.setHasChanged(true);
                                        isOK = true;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        UsageTracker.incrHandledUsageCount();
                                        ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, exception);
                                        session.rollback();
                                        try {
                                            session.close();
                                        }
                                        catch (Exception ex2) {
                                            ex2.printStackTrace();
                                            UsageTracker.incrHandledUsageCount();
                                            ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex2);
                                        }
                                        break block58;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        session.close();
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        UsageTracker.incrHandledUsageCount();
                                        ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex);
                                    }
                                    throw throwable;
                                }
                                try {
                                    session.close();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, ex);
                                }
                            }
                            if (isOK) {
                                if (isAddItemForImport) {
                                    this.viewSetsModel.clear();
                                    this.viewSetsModel.addElement(vso);
                                } else {
                                    this.viewSetsModel.remove(viewIndex);
                                    this.viewSetsModel.insertElementAt(vso, viewIndex);
                                }
                                this.viewSetsList.repaint();
                            }
                        }
                    } else {
                        boolean isResourcePanel = this.tabbedPane.getSelectedComponent() == this.repPanel;
                        JList theList = isResourcePanel ? this.repList : this.resList;
                        int resIndex = theList.getSelectedIndex();
                        Object selObj = theList.getSelectedValue();
                        if (resIndex > -1) {
                            if (resIndex == 0) {
                                try {
                                    String newResName;
                                    SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                                    Agent agent = AppContextMgr.getInstance().getClassObject(Agent.class);
                                    SpAppResourceDir dir = this.dirs.get(levelIndex);
                                    SpAppResource appRes = new SpAppResource();
                                    appRes.initialize();
                                    appRes.setName(fileName);
                                    appRes.setCreatedByAgent(agent);
                                    appRes.setSpecifyUser(user);
                                    if (dir.getId() == null) {
                                        dir.mergeTransientResourceAndViewSets();
                                    }
                                    Pair<SpAppResource, String> retValues = this.checkForOverwriteOrNewName(dir, isSpReportRes ? repResourceName : fileName, isSpReportRes);
                                    SpAppResource fndAppRes = retValues != null && retValues.first != null ? (SpAppResource)retValues.first : null;
                                    String string = newResName = retValues != null && retValues.second != null ? (String)retValues.second : null;
                                    if (isReportRes) {
                                        if (fndAppRes != null) {
                                            if (isSpReportRes) {
                                                ReportsBaseTask.deleteReportAndResource(null, fndAppRes);
                                            } else if (fndAppRes.getSpAppResourceId() != null) {
                                                this.contextMgr.removeAppResourceSp(fndAppRes.getSpAppResourceDir(), fndAppRes);
                                            }
                                        }
                                        if (isSpReportRes) {
                                            if ((appRes = this.importSpReportZipResource(importFile, appRes, dir, newResName)) != null) {
                                                importedName = appRes.getName();
                                            }
                                        } else if (MainFrameSpecify.importJasperReport(importFile, false, newResName)) {
                                            importedName = importFile.getName();
                                        } else {
                                            return;
                                        }
                                        if (importedName != null) {
                                            CommandDispatcher.dispatch(new CommandAction("Reports", "RPT.Refresh", null));
                                            CommandDispatcher.dispatch(new CommandAction("Query", "RefreshQueries", null));
                                            this.levelSelected();
                                        }
                                    } else if (fndAppRes != null) {
                                        appRes.setMetaData(fndAppRes.getMetaData());
                                        appRes.setDescription(fndAppRes.getDescription());
                                        appRes.setFileName(fileName);
                                        appRes.setMimeType(appRes.getMimeType());
                                        appRes.setName(fileName);
                                        appRes.setLevel(fndAppRes.getLevel());
                                    } else if (!this.getMetaInformation(appRes, fileName)) {
                                        return;
                                    }
                                    if (!isReportRes) {
                                        appRes.setSpAppResourceDir(dir);
                                        dir.getSpAppResources().add(appRes);
                                        appRes.setDataAsString(data);
                                        this.contextMgr.saveResource(appRes);
                                    }
                                    this.setHasChanged(true);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(ResourceImportExportDlg.class, e);
                                }
                            } else if (selObj instanceof AppResourceIFace) {
                                AppResourceIFace fndAppRes = null;
                                for (AppResourceIFace appResourceIFace : this.resources) {
                                    if (appResourceIFace != selObj) continue;
                                    fndAppRes = appResourceIFace;
                                    break;
                                }
                                if (fndAppRes != null) {
                                    String string = fndAppRes.getFileName();
                                    String fName = FilenameUtils.getName((String)string);
                                    String dbBaseName = FilenameUtils.getBaseName((String)fileName);
                                    boolean doOverwrite = true;
                                    if (!dbBaseName.equals(fName)) {
                                        String msg = UIRegistry.getLocalizedMessage("RIE_OVRDE_MSG", dbBaseName, fName);
                                        doOverwrite = UIRegistry.displayConfirm(UIRegistry.getResourceString("RIE_OVRDE_TITLE"), msg, UIRegistry.getResourceString("RIE_OVRDE"), UIRegistry.getResourceString("CANCEL"), 3);
                                    }
                                    if (doOverwrite) {
                                        fndAppRes.setDataAsString(data);
                                        this.contextMgr.saveResource(fndAppRes);
                                    }
                                } else {
                                    UIRegistry.showError("Strange error - Couldn't resource.");
                                }
                            }
                        }
                    }
                    if (importedName != null) {
                        UIRegistry.getStatusBar().setText(UIRegistry.getLocalizedMessage("RIE_RES_IMPORTED", importedName));
                    }
                    if (this.hasChanged()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ResourceImportExportDlg.this.okBtn.doClick();
                            }
                        });
                    }
                } else {
                    UIRegistry.showLocalizedError("FILE_NO_EXISTS", fullFileName);
                }
            }
            this.enableUI();
        }
    }

    protected boolean getMetaInformation(SpAppResource appRes, String fileName) {
        ResImpExpMetaInfoDlg dlg = new ResImpExpMetaInfoDlg(appRes, fileName);
        UIHelper.centerAndShow(dlg);
        return !dlg.isCancelled();
    }

    protected SpAppResource checkForOverrideAppRes(SpAppResourceDir dir, String filename, String secondName) {
        String name = filename;
        log.debug((Object)dir.getTitle());
        for (SpAppResource ar : dir.getSpAppResources()) {
            String title = ar.getName();
            log.debug((Object)("  " + title));
            if (title == null || !title.equals(name) && (!StringUtils.isNotEmpty((String)secondName) || !title.equals(secondName))) continue;
            return ar;
        }
        return null;
    }

    protected boolean isReportResource(SpAppResource appRes) {
        return appRes != null && appRes.getMimeType() != null && (appRes.getMimeType().equals("jrxml/report") || appRes.getMimeType().equals("jrxml/label") || appRes.getMimeType().equals("jrxml/subreport"));
    }

    protected void levelSelected() {
        int index = this.levelCBX.getSelectedIndex();
        if (index > -1) {
            SpAppResourceDir dir = this.dirs.get(index);
            this.viewSetsModel.clear();
            this.viewsModel.clear();
            this.resModel.clear();
            this.repModel.clear();
            this.resources.clear();
            this.resources.addAll(dir.getSpAppResources());
            Collections.sort(this.resources);
            log.debug((Object)"Level Selected - Filling Resources:");
            for (SpAppResource appRes : this.resources) {
                log.debug((Object)("> " + appRes.getName()));
            }
            this.resModel.addElement(UIRegistry.getResourceString("RIE_ADD_NEW_RESOURCE"));
            this.repModel.addElement(UIRegistry.getResourceString("RIE_ADD_NEW_RESOURCE"));
            for (SpAppResource appRes : this.resources) {
                if (this.isReportResource(appRes)) {
                    this.repModel.addElement(appRes);
                    continue;
                }
                this.resModel.addElement(appRes);
            }
            Vector<SpViewSetObj> viewSetList = new Vector<SpViewSetObj>(dir.getSpViewSets());
            Collections.sort(viewSetList);
            for (SpViewSetObj vso : viewSetList) {
                this.viewSetsModel.addElement(vso);
            }
            if (this.viewSetsModel.size() == 0) {
                this.viewSetsModel.addElement(UIRegistry.getResourceString("RIE_ADD_NEW_VIEWSETOBJ"));
            }
            this.viewSetsList.setSelectedIndex(0);
            this.enableUI();
        }
    }

    class ARListRenderer
    extends DefaultListCellRenderer {
        private String databaseStr = UIRegistry.getResourceString("RIE_FROM_DATABASE");

        ARListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Integer id;
            String title;
            if (value instanceof SpViewSetObj) {
                title = ((SpViewSetObj)value).getName();
                id = ((SpViewSetObj)value).getId();
            } else if (value instanceof SpAppResource) {
                title = ((SpAppResource)value).getName();
                id = ((SpAppResource)value).getId();
            } else {
                title = value.toString();
                id = null;
            }
            if (id != null) {
                title = String.valueOf(title) + " " + this.databaseStr;
            }
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setText(title);
            return label;
        }
    }

    class ViewRenderer
    extends DefaultListCellRenderer {
        ViewRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
        }
    }
}

