/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class ResImpExpMetaInfoDlg
extends CustomDialog {
    protected JTextField nameTxt;
    protected JComboBox mimeTypeCBX;
    protected JTextField descTxt;
    protected JComboBox tableIdCBX;
    protected JCheckBox reqsRecSetChk;
    protected JComboBox rptTypeCBX;
    protected JTextField subReportsTxt;
    protected JTextField actionsTxt;
    protected ArrayList<JLabel> labels = new ArrayList();
    protected SpAppResource appRes = null;
    protected String fileName;

    public ResImpExpMetaInfoDlg(SpAppResource appRes, String fileName) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ResImpExpMetaInfoDlg.DlgTitle"), true, 7, null);
        this.appRes = appRes;
        this.fileName = fileName;
    }

    @Override
    public void createUI() {
        super.createUI();
        DefaultComboBoxModel<String> mimeModel = new DefaultComboBoxModel<String>(new String[]{"XML", "Label", "Report", "Subreport"});
        DefaultComboBoxModel<String> typeModel = new DefaultComboBoxModel<String>(new String[]{"Report", "Invoice", "WorkBench", "CollectionObject"});
        DefaultComboBoxModel<DBTableInfo> tblModel = new DefaultComboBoxModel<DBTableInfo>(DBTableIdMgr.getInstance().getTablesForUserDisplay());
        this.mimeTypeCBX = UIHelper.createComboBox(mimeModel);
        this.nameTxt = UIHelper.createTextField();
        this.descTxt = UIHelper.createTextField();
        CellConstraints cc = new CellConstraints();
        this.tableIdCBX = UIHelper.createComboBox(tblModel);
        this.reqsRecSetChk = UIHelper.createCheckBox("Is Record Set Required?");
        this.rptTypeCBX = UIHelper.createComboBox(typeModel);
        this.subReportsTxt = UIHelper.createTextField();
        this.actionsTxt = UIHelper.createTextField();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,4px,p,4px,p,4px,p,4px,p,4px,p,4px,p,4px,p,4px"));
        int y = 1;
        JLabel lbl = UIHelper.createI18NFormLabel("Mime Type");
        pb.add((Component)lbl, cc.xy(1, y));
        pb.add((Component)this.mimeTypeCBX, cc.xy(3, y));
        lbl = UIHelper.createI18NFormLabel("Name");
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.nameTxt, cc.xy(3, y));
        lbl = UIHelper.createI18NFormLabel("Description");
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.descTxt, cc.xyw(3, y, 2));
        lbl = UIHelper.createI18NFormLabel("Table");
        this.labels.add(lbl);
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.tableIdCBX, cc.xy(3, y));
        pb.add((Component)this.reqsRecSetChk, cc.xy(3, y += 2));
        lbl = UIHelper.createI18NFormLabel("Report Type");
        this.labels.add(lbl);
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.rptTypeCBX, cc.xy(3, y));
        lbl = UIHelper.createI18NFormLabel("Sub-Reports");
        this.labels.add(lbl);
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.subReportsTxt, cc.xyw(3, y, 2));
        lbl = UIHelper.createI18NFormLabel("Action");
        this.labels.add(lbl);
        pb.add((Component)lbl, cc.xy(1, y += 2));
        pb.add((Component)this.actionsTxt, cc.xyw(3, y, 2));
        y += 2;
        pb.setDefaultDialogBorder();
        this.nameTxt.setText(FilenameUtils.getBaseName((String)this.fileName));
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.updateUI();
        this.mimeTypeCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResImpExpMetaInfoDlg.this.updateUI();
            }
        });
    }

    private void updateUI() {
        boolean isRep = this.mimeTypeCBX.getSelectedIndex() > 0;
        this.tableIdCBX.setEnabled(isRep);
        this.reqsRecSetChk.setEnabled(isRep);
        this.rptTypeCBX.setEnabled(isRep);
        this.subReportsTxt.setEnabled(isRep);
        this.actionsTxt.setEnabled(isRep);
        for (JLabel lbl : this.labels) {
            lbl.setEnabled(isRep);
        }
    }

    @Override
    protected void okButtonPressed() {
        String mimeType = (String)this.mimeTypeCBX.getSelectedItem();
        this.appRes.setMimeType(String.valueOf(this.mimeTypeCBX.getSelectedIndex() == 0 ? "text/" : "jrxml/") + mimeType.toLowerCase());
        this.appRes.setName(this.nameTxt.getText());
        this.appRes.setDescription(this.descTxt.getText());
        if (this.mimeTypeCBX.getSelectedIndex() > 0 && this.mimeTypeCBX.getSelectedIndex() < 3) {
            String subRpt;
            StringBuilder metaData = new StringBuilder();
            if (this.tableIdCBX.getSelectedItem() != null) {
                DBTableInfo ti = (DBTableInfo)this.tableIdCBX.getSelectedItem();
                metaData.append("tableid=");
                metaData.append(ti.getTableId());
            }
            metaData.append("reqrs=");
            metaData.append(this.reqsRecSetChk.isSelected());
            String type = null;
            String rptTyp = (String)this.rptTypeCBX.getSelectedItem();
            if (rptTyp != null) {
                metaData.append("reporttype=");
                metaData.append(rptTyp);
                type = rptTyp.equals("Label") ? "Labels" : "Report";
            }
            metaData.append("type=");
            metaData.append(type);
            String actionStr = this.actionsTxt.getText();
            if (StringUtils.isNotEmpty((String)actionStr)) {
                metaData.append("action=");
                metaData.append(type);
            }
            if (StringUtils.isNotEmpty((String)(subRpt = this.subReportsTxt.getText()))) {
                metaData.append("subreports=");
                metaData.append(subRpt);
            }
            this.appRes.setMetaData(metaData.toString());
        }
        super.okButtonPressed();
    }
}

