/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LoggerDialog
extends JDialog
implements ActionListener {
    protected final Level[] levelsList = new Level[]{Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL};
    protected JButton cancelBtn;
    protected JButton okBtn;
    protected JComboBox setAllCBX;
    protected List<LoggerInfo> loggers = new Vector<LoggerInfo>();

    public LoggerDialog(Frame frame) {
        super(frame);
        this.createUI();
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    protected void createUI() {
        int cnt = 0;
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger logger = (Logger)e.nextElement();
            JComboBox cbx = this.createCBX(logger.getLevel());
            this.loggers.add(new LoggerInfo(logger, cbx));
        }
        Collections.sort(this.loggers);
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p", UIHelper.createDuplicateJGoodiesDef("p", "4px", this.loggers.size())));
        CellConstraints cc = new CellConstraints();
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("OK"));
        cnt = 1;
        for (LoggerInfo logInfo : this.loggers) {
            builder.add((Component)UIHelper.createLabel(logInfo.getLogger().getName()), cc.xy(1, cnt));
            builder.add((Component)logInfo.getCbx(), cc.xy(3, cnt));
            cnt += 2;
        }
        this.okBtn.addActionListener(this);
        this.okBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okBtn);
        ButtonBarBuilder btnBuilder = new ButtonBarBuilder();
        btnBuilder.addGlue();
        btnBuilder.addGriddedButtons(new JButton[]{this.cancelBtn, this.okBtn});
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoggerDialog.this.save();
                LoggerDialog.this.setVisible(false);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoggerDialog.this.setVisible(false);
            }
        });
        this.setAllCBX = UIHelper.createComboBox(this.levelsList);
        this.setAllCBX.setSelectedIndex(-1);
        this.setAllCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Level level = (Level)((JComboBox)e.getSource()).getSelectedItem();
                for (LoggerInfo logInfo : LoggerDialog.this.loggers) {
                    logInfo.getCbx().setSelectedItem(level);
                }
            }
        });
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Dimension size = builder.getPanel().getPreferredSize();
        size.width += 15;
        builder.getPanel().setPreferredSize(size);
        JScrollPane scroller = new JScrollPane(builder.getPanel(), 20, 31);
        PanelBuilder outerPanel = new PanelBuilder(new FormLayout("p,2px,p,p:g", "min(400px;p):g,5px,p,10px,p"));
        outerPanel.add((Component)scroller, cc.xywh(1, 1, 4, 1));
        outerPanel.add((Component)UIHelper.createLabel("Set All To:"), cc.xy(1, 3));
        outerPanel.add((Component)this.setAllCBX, cc.xy(3, 3));
        outerPanel.add((Component)btnBuilder.getPanel(), cc.xywh(1, 5, 4, 1));
        outerPanel.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(outerPanel.getPanel());
        this.setTitle("Configure Log Levels");
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    protected void updateUI() {
        boolean enable = false;
        for (LoggerInfo logInfo : this.loggers) {
            Level cbxLevel = (Level)logInfo.getCbx().getSelectedItem();
            if (cbxLevel == logInfo.getLogger().getLevel()) continue;
            enable = true;
            break;
        }
        this.okBtn.setEnabled(enable);
    }

    protected void save() {
        for (LoggerInfo logInfo : this.loggers) {
            Level cbxLevel = (Level)logInfo.getCbx().getSelectedItem();
            if (cbxLevel == logInfo.getLogger().getLevel()) continue;
            logInfo.getLogger().setLevel(cbxLevel);
        }
    }

    protected JComboBox createCBX(Level levelArg) {
        Level level = levelArg;
        JComboBox cbx = UIHelper.createComboBox(this.levelsList);
        if (level == null) {
            level = Level.ERROR;
        }
        int inx = 0;
        Level[] levelArray = this.levelsList;
        int n = this.levelsList.length;
        int n2 = 0;
        while (n2 < n) {
            Level lvl = levelArray[n2];
            if (level.toInt() == lvl.toInt()) {
                cbx.setSelectedIndex(inx);
            }
            ++inx;
            ++n2;
        }
        cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerDialog.this.updateUI();
            }
        });
        return cbx;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class LoggerInfo
    implements Comparable<LoggerInfo> {
        protected Logger logger;
        protected JComboBox cbx;

        public LoggerInfo(Logger logger, JComboBox cbx) {
            this.logger = logger;
            this.cbx = cbx;
        }

        public JComboBox getCbx() {
            return this.cbx;
        }

        public Logger getLogger() {
            return this.logger;
        }

        @Override
        public int compareTo(LoggerInfo obj) {
            return this.logger.getName().compareTo(obj.getLogger().getName());
        }
    }
}

