/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.FormViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JEditorPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FixDBAfterLogin {
    private static final Logger log = Logger.getLogger(FixDBAfterLogin.class);
    private static final String FIX_DEFDATES_PREF = "FIX_DEFDATES_PREF";
    public static final String DEGREES_SYMBOL = "\u00b0";
    public static final String SEPS = "\u00b0:'\" ";
    private static String updateSQL = "UPDATE %s SET %s = DATE(TimestampCreated) WHERE %s IS NULL AND TimestampCreated IS NOT NULL AND TimestampCreated > TIMESTAMP('2008-06-01 00:00:00')";
    private static String updatePrecSQL = "UPDATE %s SET %s = 1 WHERE %s IS NULL AND %s IS NULL AND TimestampCreated IS NOT NULL AND TimestampCreated > TIMESTAMP('2008-06-01 00:00:00')";

    public void checkMultipleLocalities() {
        String str;
        int cnt = BasicSQLUtils.getCountAsInt("select count(localitydetailid) - count(distinct localityid) from localitydetail");
        if (cnt > 0) {
            cnt = BasicSQLUtils.getCountAsInt("select count(collectionobjectid) from collectionobject co inner join collectingevent ce on ce.collectingeventid = co.collectingeventid inner join  (select localityid from localitydetail group by localityid having count(localitydetailid) > 1) badlocs on badlocs.localityid = ce.localityid");
            str = String.format("Multiple Locality Detail Records - Count: %d", cnt);
            ExceptionTracker.getInstance().sendMsg(FixDBAfterLogin.class, str, new Exception(str));
        }
        if ((cnt = BasicSQLUtils.getCountAsInt("select count(geocoorddetailid) - count(distinct localityid) from geocoorddetail")) > 0) {
            cnt = BasicSQLUtils.getCountAsInt("select count(collectionobjectid) from collectionobject co inner join collectingevent ce on ce.collectingeventid = co.collectingeventid inner join (select localityid from geocoorddetail group by localityid having count(geocoorddetailid) > 1) badlocs on badlocs.localityid = ce.localityid");
            str = String.format("Multiple GeoCoord Detail Records - Count: %d", cnt);
            ExceptionTracker.getInstance().sendMsg(FixDBAfterLogin.class, str, new Exception(str));
        }
    }

    public void fixUploaderRecordsets() {
        BasicSQLUtils.update("update recordset set TimestampCreated = now(), Version = 0 where Type = 1 and Version is null");
        AppPreferences.getGlobalPrefs().putBoolean("FixUploaderRecordsets", true);
    }

    public static void fixUnMatchedWBSpecifyUserIDs() {
        BasicSQLUtils.update("update workbenchtemplate t inner join workbench w on w.workbenchtemplateid = t.workbenchtemplateid set t.SpecifyUserID = w.SpecifyUserID");
        AppPreferences.getGlobalPrefs().putBoolean("FixedUnMatchedWBSpecifyUserIDs", true);
    }

    private boolean fixLatLong(PreparedStatement pStmt, int locId, int origUnit, int srcUnit, String lat1Text, String long1Text, boolean isNew) throws SQLException {
        pStmt.setInt(3, locId);
        boolean doUpdate = false;
        if (isNew) {
            int numColonsLon;
            int numColonsLat = lat1Text != null ? StringUtils.countMatches((String)lat1Text, (String)":") : 0;
            int n = numColonsLon = long1Text != null ? StringUtils.countMatches((String)long1Text, (String)":") : 0;
            if (numColonsLat == 2 || numColonsLon == 2) {
                if (srcUnit != 1) {
                    pStmt.setInt(1, origUnit);
                    pStmt.setInt(2, 1);
                    return true;
                }
                return false;
            }
            String[] latTokens = StringUtils.split((String)lat1Text, (String)SEPS);
            String[] lonTokens = StringUtils.split((String)long1Text, (String)SEPS);
            int latLen = latTokens.length;
            int lonLen = lonTokens.length;
            if (latLen == 4 || lonLen == 4) {
                if (srcUnit != 1) {
                    pStmt.setInt(1, origUnit);
                    pStmt.setInt(2, 1);
                    return true;
                }
            } else if (latLen == 3 || lonLen == 3) {
                if (srcUnit != 2) {
                    pStmt.setInt(1, origUnit);
                    pStmt.setInt(2, 2);
                    return true;
                }
            } else if (latLen == 2 || lonLen == 2) {
                if (srcUnit != 0) {
                    pStmt.setInt(1, origUnit);
                    pStmt.setInt(2, 1);
                    return true;
                }
            } else {
                log.debug((Object)String.format("*** Couldn't parse Lat[%s]  Lon[%s]  origUnit %d  srcUnit %d", lat1Text, long1Text, origUnit, srcUnit));
            }
        } else if (srcUnit == 0 && origUnit != 0) {
            pStmt.setInt(1, origUnit);
            pStmt.setInt(2, origUnit);
            doUpdate = true;
        }
        return doUpdate;
    }

    public void fixLatLongUnit() {
        int fixed = 0;
        String postStr = " WHERE OriginalLatLongUnit > 0 AND (Lat1Text IS NOT NULL OR Long1Text IS NOT NULL)";
        Connection conn = DBConnection.getInstance().getConnection();
        Statement pStmt = null;
        Statement stmt = null;
        try {
            try {
                int totalCnt = BasicSQLUtils.getCount(conn, "SELECT COUNT(*) FROM locality" + postStr);
                if (totalCnt > 0) {
                    pStmt = conn.prepareStatement(updateSQL);
                    stmt = conn.createStatement();
                    int cnt = 0;
                    ResultSet rs = stmt.executeQuery("SELECT LocalityID, OriginalLatLongUnit, SrcLatLongUnit, Lat1Text, Long1Text, (TimestampCreated > '2008-06-01 00:00:00') AS IsNew FROM locality" + postStr);
                    while (rs.next()) {
                        boolean isNew;
                        int id = rs.getInt(1);
                        int origUnit = rs.getInt(2);
                        int srcUnit = rs.getInt(3);
                        String lat1Text = rs.getString(4);
                        String long1Text = rs.getString(5);
                        boolean bl = isNew = rs.getInt(6) == 1;
                        if (this.fixLatLong((PreparedStatement)pStmt, id, origUnit, srcUnit, lat1Text, long1Text, isNew)) {
                            if (pStmt.executeUpdate() != 1) {
                                log.error((Object)("Error updating " + id));
                            } else {
                                ++fixed;
                            }
                        }
                        if (++cnt % 100 != 0) continue;
                        log.debug((Object)String.format("Processing %d/%d", cnt, totalCnt));
                    }
                    rs.close();
                    log.debug((Object)String.format("Fixed %d/%d", fixed, totalCnt));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void fixNullEmbeddedCollectingEvents() {
        try {
            String checkSQL = "select count(co.CollectionObjectID) from collectionobject co inner join collection cln on cln.UserGroupScopeID = co.CollectionMemberID where co.CollectingEventID is null and cln.IsEmbeddedCollectingEvent";
            int cesToAdd = BasicSQLUtils.getCount(checkSQL);
            if (cesToAdd > 0) {
                String ceInsertSql = "insert into collectingevent (TimestampCreated, TimestampModified, Version, Visibility, CreatedByAgentID, VisibilitySetByID, ModifiedByAgentID, DisciplineID) select co.TimestampCreated, co.TimestampModified, co.CollectionObjectID, co.Visibility, co.CreatedByAgentID, co.VisibilitySetByID, co.ModifiedByAgentID, (select DisciplineID from collection cln2 where cln2.UserGroupScopeID = co.CollectionMemberID) from collectionobject co inner join collection cln on cln.UserGroupScopeID = co.CollectionMemberID where co.CollectingEventID is null and cln.IsEmbeddedCollectingEvent";
                int insertedCnt = BasicSQLUtils.update(ceInsertSql);
                if (insertedCnt != cesToAdd) {
                    throw new Exception("fixNullEmbeddedCollectingEvents: error inserting colllectingevent records");
                }
                String ceIDUpdateSql = "update collectionobject co inner join collectingevent ce on ce.Version = co.CollectionObjectID inner join collection cln on cln.UserGroupScopeID = co.CollectionMemberID set co.CollectingEventID = ce.CollectingEventID, ce.Version = 0 where co.collectingeventid is null and cln.IsEmbeddedCollectingEvent";
                int updatedCnt = BasicSQLUtils.update(ceIDUpdateSql);
                if (updatedCnt != 2 * insertedCnt) {
                    throw new Exception("fixNullEmbeddedCollectingEvents: error updating colllectingevent IDs");
                }
                log.info((Object)("added " + insertedCnt + " collectingevent records"));
                AppPreferences.getGlobalPrefs().putBoolean("FixNullEmbeddedCollectingEvents", true);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
            ex.printStackTrace();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void fixUserPermissions(boolean doSilently) {
        block37: {
            FIXED_USER_PERMS = "FIXED_USER_PERMS";
            isAlreadyFixed = AppPreferences.getRemote().getBoolean("FIXED_USER_PERMS", false);
            if (isAlreadyFixed) {
                return;
            }
            whereStr = " WHERE p.GroupSubClass = 'edu.ku.brc.af.auth.specify.principal.UserPrincipal' ";
            whereStr2 = "AND p.userGroupScopeID IS NULL";
            postSQL = " FROM specifyuser su INNER JOIN specifyuser_spprincipal ss ON su.SpecifyUserID = ss.SpecifyUserID INNER JOIN spprincipal p ON ss.SpPrincipalID = p.SpPrincipalID LEFT JOIN spprincipal_sppermission pp ON p.SpPrincipalID = pp.SpPrincipalID LEFT OUTER JOIN sppermission pm ON pp.SpPermissionID = pm.SpPermissionID " + whereStr;
            sql = "SELECT COUNT(*)" + postSQL + whereStr2;
            FixDBAfterLogin.log.debug((Object)sql);
            if (BasicSQLUtils.getCountAsInt(sql) < 1) {
                sql = "SELECT COUNT(*)" + postSQL;
                FixDBAfterLogin.log.debug((Object)sql);
                if (BasicSQLUtils.getCountAsInt(sql) > 0) {
                    return;
                }
            }
            updatePermSQL = "DELETE FROM %s WHERE SpPermissionID = %d";
            updatePrinSQL = "DELETE FROM %s WHERE SpPrincipalID = %d";
            sql = "SELECT p.SpPrincipalID, pp.SpPermissionID" + postSQL;
            FixDBAfterLogin.log.debug((Object)sql);
            prinIds = new HashSet<Object>();
            for (Object[] row : BasicSQLUtils.query(sql)) {
                prinId = (Integer)row[0];
                if (prinId != null) {
                    prinIds.add(prinId);
                }
                if ((permId = (Integer)row[1]) == null) continue;
                BasicSQLUtils.update(String.format("DELETE FROM %s WHERE SpPermissionID = %d", new Object[]{"spprincipal_sppermission", permId}));
                BasicSQLUtils.update(String.format("DELETE FROM %s WHERE SpPermissionID = %d", new Object[]{"sppermission", permId}));
                FixDBAfterLogin.log.debug((Object)("Removing PermId: " + permId));
            }
            sb1 = new StringBuilder();
            for (Integer prinId : prinIds) {
                BasicSQLUtils.update(String.format("DELETE FROM %s WHERE SpPrincipalID = %d", new Object[]{"specifyuser_spprincipal", prinId}));
                BasicSQLUtils.update(String.format("DELETE FROM %s WHERE SpPrincipalID = %d", new Object[]{"spprincipal", prinId}));
                FixDBAfterLogin.log.debug((Object)("Removing PrinId: " + prinId));
                if (sb1.length() > 0) {
                    sb1.append(",");
                }
                sb1.append(prinId.toString());
            }
            FixDBAfterLogin.log.debug((Object)("(" + sb1.toString() + ")"));
            nameSet = new TreeSet<String>();
            sql = "SELECT su.Name, su.SpecifyUserID, p.userGroupScopeID, p.SpPrincipalID FROM specifyuser su INNER JOIN specifyuser_spprincipal sp ON su.SpecifyUserID = sp.SpecifyUserID INNER JOIN spprincipal p ON sp.SpPrincipalID = p.SpPrincipalID WHERE p.GroupSubClass = 'edu.ku.brc.af.auth.specify.principal.GroupPrincipal'";
            fields = "TimestampCreated, TimestampModified, Version, GroupSubClass, groupType, Name, Priority, Remarks, userGroupScopeID, CreatedByAgentID, ModifiedByAgentID";
            insertSQL = "INSERT INTO spprincipal (" + fields + ") VALUES(?,?,?,?,?,?,?,?,?,?,?)";
            insertSQL2 = "INSERT INTO specifyuser_spprincipal (SpecifyUserID, SpPrincipalID) VALUES(?,?)";
            searchSql = "SELECT " + fields + " FROM spprincipal WHERE SpPrincipalID = ?";
            sb1 = new StringBuilder();
            selStmt = null;
            pStmt = null;
            pStmt2 = null;
            conn = DBConnection.getInstance().getConnection();
            pStmt = conn.prepareStatement(insertSQL);
            pStmt2 = conn.prepareStatement(insertSQL2);
            selStmt = conn.prepareStatement(searchSql);
            adtSQL = "SELECT DISTINCT ca.AgentID FROM specifyuser AS su INNER Join agent AS ca ON su.CreatedByAgentID = ca.AgentID";
            createdById = BasicSQLUtils.getCount(conn, adtSQL);
            if (createdById != null || (createdById = BasicSQLUtils.getCount(conn, "SELECT AgentID FROM agent ORDER BY AgentID ASC LIMIT 0,1")) != null) break block37;
            UIRegistry.showError("The permissions could not be fixed because there were no agents.");
            AppPreferences.shutdownAllPrefs();
            DBConnection.shutdownFinalConnection(true, true);
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (pStmt2 != null) {
                    pStmt2.close();
                }
                if (selStmt != null) {
                    selStmt.close();
                }
            }
            catch (Exception var33_23) {
                // empty catch block
            }
            return;
        }
        try {
            try {
                for (Object[] row : BasicSQLUtils.query(sql)) {
                    usrName = (String)row[0];
                    userId = (Integer)row[1];
                    collId = (Integer)row[2];
                    prinId = (Integer)row[3];
                    nameSet.add(usrName);
                    FixDBAfterLogin.log.debug((Object)("usrName: " + usrName + "  prinId: " + prinId));
                    if (sb1.length() > 0) {
                        sb1.append(",");
                    }
                    sb1.append(prinId.toString());
                    selStmt.setInt(1, prinId);
                    rs = selStmt.executeQuery();
                    if (rs.next()) {
                        FixDBAfterLogin.log.debug((Object)String.format("%s - adding UserPrincipal for Collection  %d / %d", new Object[]{usrName, rs.getInt(9), collId}));
                        createdByAgentID = (Integer)rs.getObject(10);
                        modifiedByAgentID = (Integer)rs.getObject(11);
                        pStmt.setTimestamp(1, rs.getTimestamp(1));
                        pStmt.setTimestamp(2, rs.getTimestamp(2));
                        pStmt.setInt(3, 1);
                        pStmt.setString(4, "edu.ku.brc.af.auth.specify.principal.UserPrincipal");
                        pStmt.setString(5, null);
                        pStmt.setString(6, rs.getString(6));
                        pStmt.setInt(7, 80);
                        pStmt.setString(8, rs.getString(8));
                        pStmt.setInt(9, rs.getInt(9));
                        pStmt.setInt(10, (createdByAgentID != null ? createdByAgentID : createdById).intValue());
                        pStmt.setInt(11, (modifiedByAgentID != null ? modifiedByAgentID : createdById).intValue());
                        pStmt.executeUpdate();
                        newPrinId = BasicSQLUtils.getInsertedId(pStmt);
                        pStmt2.setInt(1, userId);
                        pStmt2.setInt(2, newPrinId);
                        pStmt2.executeUpdate();
                    }
                    rs.close();
                }
                FixDBAfterLogin.log.debug((Object)("(" + sb1.toString() + ")"));
                AppPreferences.getRemote().putBoolean("FIXED_USER_PERMS", true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (pStmt2 != null) {
                        pStmt2.close();
                    }
                    if (selStmt == null) ** GOTO lbl158
                    selStmt.close();
                }
                catch (Exception var33_24) {}
            }
        }
        catch (Throwable var32_38) {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (pStmt2 != null) {
                    pStmt2.close();
                }
                if (selStmt != null) {
                    selStmt.close();
                }
            }
            catch (Exception var33_25) {
                // empty catch block
            }
            throw var32_38;
        }
        try {
            if (pStmt != null) {
                pStmt.close();
            }
            if (pStmt2 != null) {
                pStmt2.close();
            }
            if (selStmt != null) {
                selStmt.close();
            }
        }
        catch (Exception var33_26) {
            // empty catch block
        }
lbl158:
        // 5 sources

        sb = new StringBuilder();
        for (String nm : nameSet) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(nm);
        }
        if (!doSilently) {
            ta = UIHelper.createTextArea(15, 30);
            ta.setText(sb.toString());
            ta.setEditable(false);
            htmlPane = new JEditorPane("text/html", UIRegistry.getResourceString("FDBAL_PERMFIXEDDESC"));
            htmlPane.setEditable(false);
            htmlPane.setOpaque(false);
            cc = new CellConstraints();
            pb = new PanelBuilder(new FormLayout("f:p:g", "p:g,8px,f:p:g"));
            pb.add((Component)htmlPane, cc.xy(1, 1));
            pb.add((Component)UIHelper.createScrollPane(ta), cc.xy(1, 3));
            pb.setDefaultDialogBorder();
            dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("FDBAL_PERMFIXED"), true, 1, (Component)pb.getPanel());
            dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
            UIHelper.centerAndShow(dlg);
        }
    }

    public static void fixDefaultDates() {
        boolean doFix;
        boolean bl = doFix = AppPreferences.getGlobalPrefs().getBoolean(FIX_DEFDATES_PREF, false) == false;
        if (doFix) {
            HashMap<DBTableInfo, List<FormCellFieldIFace>> tblToFldHash = new HashMap<DBTableInfo, List<FormCellFieldIFace>>();
            HashSet<String> nameHash = new HashSet<String>();
            for (ViewIFace view : ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getEntirelyAllViews()) {
                String tableClassName = view.getClassName();
                DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(tableClassName);
                if (ti == null || nameHash.contains(tableClassName)) continue;
                nameHash.add(tableClassName);
                for (AltViewIFace avi : view.getAltViews()) {
                    ViewDefIFace vd;
                    if (avi.getMode() != AltViewIFace.CreationMode.EDIT || !((vd = avi.getViewDef()) instanceof FormViewDef)) continue;
                    FormViewDefIFace fvd = (FormViewDefIFace)vd;
                    for (FormRowIFace fri : fvd.getRows()) {
                        for (FormCellIFace fci : fri.getCells()) {
                            FormCellFieldIFace fcf;
                            String defValue;
                            if (!(fci instanceof FormCellFieldIFace) || !StringUtils.isNotEmpty((String)(defValue = (fcf = (FormCellFieldIFace)fci).getDefaultValue())) || defValue.equals("Today")) continue;
                            List<FormCellFieldIFace> fieldList = tblToFldHash.get(ti);
                            if (fieldList == null) {
                                fieldList = new ArrayList<FormCellFieldIFace>();
                                tblToFldHash.put(ti, fieldList);
                            }
                            fieldList.add(fcf);
                        }
                    }
                }
            }
            log.debug((Object)("Number of Tables Found[" + tblToFldHash.size() + "]"));
            FixDBAfterLogin.processTableDefaultDates(tblToFldHash, false);
            AppPreferences.getGlobalPrefs().putBoolean(FIX_DEFDATES_PREF, true);
        }
    }

    private static int processTableDefaultDates(HashMap<DBTableInfo, List<FormCellFieldIFace>> tblToFldHash, boolean doingCount) {
        int totalCount = 0;
        for (DBTableInfo ti : tblToFldHash.keySet()) {
            for (FormCellFieldIFace fci : tblToFldHash.get(ti)) {
                String sql;
                int cnt;
                DBFieldInfo fi;
                String[] names = fci.getFieldNames();
                if (names == null || names.length <= 0 || names.length >= 3) continue;
                Class<Object> dataClass = null;
                String fldName = null;
                if (fci.getUiType() == FormCellFieldIFace.FieldType.plugin) {
                    String dataField;
                    String pluginName = fci.getProperty("name");
                    if (StringUtils.isNotEmpty((String)pluginName) && pluginName.equals("PartialDateUI") && StringUtils.isNotEmpty((String)(dataField = fci.getProperty("df")))) {
                        fldName = dataField;
                        dataClass = Calendar.class;
                    }
                } else {
                    fldName = names[0];
                }
                if ((fi = ti.getFieldByName(fldName)) == null) continue;
                if (dataClass == null) {
                    dataClass = fi.getDataClass();
                }
                if (dataClass != Calendar.class || (cnt = BasicSQLUtils.getCountAsInt(sql = String.format("SELECT COUNT(*) FROM %s WHERE %s IS NULL AND TimestampCreated IS NOT NULL AND TimestampCreated > TIMESTAMP('2008-06-01 00:00:00')", ti.getName(), fi.getColumn()))) <= 0) continue;
                if (doingCount) {
                    totalCount += cnt;
                    continue;
                }
                totalCount += FixDBAfterLogin.fixTableDefaultDates(ti, fi);
            }
        }
        log.debug((Object)("processTableDefaultDates - Fixed " + totalCount + " Records."));
        return 0;
    }

    private static int fixTableDefaultDates(DBTableInfo ti, DBFieldInfo fi) {
        String precName;
        String colName = fi.getColumn();
        if (colName.length() > 4 && colName.endsWith("Date") && ti.getFieldByColumnName(precName = String.valueOf(colName) + "Precision") != null) {
            String sql = String.format(updatePrecSQL, ti.getName(), precName, precName, fi.getColumn());
            BasicSQLUtils.update(sql);
        }
        String sql = String.format(updateSQL, ti.getName(), fi.getColumn(), fi.getColumn());
        int rv = BasicSQLUtils.update(sql);
        return rv;
    }

    public static void fixExsiccata() {
        String typeSearchTag = "<typesearches>";
        String sql = "SELECT d.SpAppResourceDataID, Data FROM spappresource AS r Inner Join spappresourcedata AS d ON r.SpAppResourceID = d.SpAppResourceID WHERE LOWER(r.Name) LIKE 'typesearch%'";
        Object[] row = BasicSQLUtils.queryForRow(sql);
        if (row != null && row.length > 0) {
            String contents;
            Integer id = (Integer)row[0];
            byte[] bytes = (byte[])row[1];
            if (bytes != null && bytes.length > 0 && StringUtils.isNotEmpty((String)(contents = new String(bytes)))) {
                String extStr = "\n    <typesearch tableid=\"89\" name=\"Exsiccata\" searchfield=\"title\" displaycols=\"title\" format=\"%s\" dataobjformatter=\"\"/>";
                int inx = contents.indexOf("<typesearches>") + "<typesearches>".length();
                if (inx > -1 && inx < contents.length()) {
                    String newContents = String.valueOf(contents.substring(0, inx)) + extStr + contents.substring(inx);
                    Connection conn = DBConnection.getInstance().getConnection();
                    if (conn != null) {
                        try {
                            PreparedStatement ps = conn.prepareStatement("UPDATE spappresourcedata SET Data=? WHERE SpAppResourceDataID=?");
                            if (ps != null) {
                                ps.setString(1, newContents);
                                ps.setInt(2, id);
                                int rv = ps.executeUpdate();
                                if (rv == 1) {
                                    AppPreferences.getGlobalPrefs().putBoolean("ExsiccataUpdateFor1_7", true);
                                }
                                ps.close();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

