/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.AccessionAttachment;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AgentAttachment;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.CollectingEventAttachment;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.ConservDescriptionAttachment;
import edu.ku.brc.specify.datamodel.ConservEventAttachment;
import edu.ku.brc.specify.datamodel.DNASequencingRunAttachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.FieldNotebookAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSetAttachment;
import edu.ku.brc.specify.datamodel.LoanAttachment;
import edu.ku.brc.specify.datamodel.LocalityAttachment;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.PermitAttachment;
import edu.ku.brc.specify.datamodel.PreparationAttachment;
import edu.ku.brc.specify.datamodel.RepositoryAgreementAttachment;
import edu.ku.brc.specify.datamodel.TaxonAttachment;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.AttachmentUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class FixAttachments {
    private void reattachFiles(final HashMap<Integer, Vector<Object[]>> resultsHashMap, final HashMap<Integer, AttchTableModel> tableHash, final int totalFiles) {
        String CNT = "CNT";
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            int filesCnt = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                if (session != null) {
                    try {
                        try {
                            Iterator iterator = resultsHashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                int tblId = (Integer)iterator.next();
                                AttchTableModel model = (AttchTableModel)tableHash.get(tblId);
                                int cnt = 0;
                                int r = 0;
                                while (r < model.getRowCount()) {
                                    if (model.isRecoverable(r)) {
                                        Thread.sleep(100L);
                                        session.beginTransaction();
                                        Integer attachID = model.getAttachmentId(r);
                                        Attachment attachment = session.get(Attachment.class, attachID);
                                        AttachmentUtils.getAttachmentManager().setStorageLocationIntoAttachment(attachment, false);
                                        try {
                                            attachment.storeFile(true);
                                            session.saveOrUpdate(attachment);
                                            session.commit();
                                            model.setRecovered(r, true);
                                            ++this.filesCnt;
                                        }
                                        catch (IOException ex) {
                                            session.rollback();
                                        }
                                    }
                                    this.firePropertyChange("CNT", 0, (int)((double)(++cnt) / (double)totalFiles * 100.0));
                                    ++r;
                                }
                            }
                        }
                        catch (Exception ex) {
                            session.rollback();
                            session.close();
                        }
                    }
                    finally {
                        session.close();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                UIRegistry.clearSimpleGlassPaneMsg();
                UIRegistry.displayInfoMsgDlg(String.format("Files recovered: %d / %d", this.filesCnt, totalFiles));
                File file = FixAttachments.this.produceSummaryReport(resultsHashMap, tableHash, totalFiles);
                if (file != null) {
                    try {
                        AttachmentUtils.openFile(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (FixAttachments.this.getNumberofBadAttachments() == 0) {
                    AppPreferences.getGlobalPrefs().putBoolean("CHECK_ATTCH_ERR", true);
                }
                super.done();
            }
        };
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(String.format("Recovering %d files.", totalFiles), 24);
        glassPane.setProgress(0);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("CNT".equals(evt.getPropertyName())) {
                    glassPane.setProgress((Integer)evt.getNewValue());
                }
            }
        });
        worker.execute();
    }

    private String getVal(Object data) {
        String str = "&nbsp;";
        if (data != null) {
            if (data instanceof Boolean) {
                if (((Boolean)data).booleanValue()) {
                    str = "<CENTER>Y</CENTER>";
                }
            } else {
                str = data.toString();
            }
        }
        return str;
    }

    private void doAttachmentRefCleanup(final HashMap<Integer, Vector<Object[]>> resultsHashMap, final HashMap<Integer, AttchTableModel> tableHash, final int totalFiles) {
        final int numAttachs = this.getNumberofBadAttachments();
        String CNT = "CNT";
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            int filesCnt = 0;
            int errs = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                try {
                    Iterator iterator = resultsHashMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int tblId = (Integer)iterator.next();
                        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tblId);
                        AttchTableModel model = (AttchTableModel)tableHash.get(tblId);
                        int r = 0;
                        while (r < model.getRowCount()) {
                            int attachId = model.getAttachmentId(r);
                            int attachJoinId = model.getAttachmentJoinId(r);
                            String sql = String.format("DELETE FROM %s WHERE %s = %d", ti.getName(), ti.getIdColumnName(), attachJoinId);
                            int rv = BasicSQLUtils.update(sql);
                            if (rv == 1) {
                                rv = BasicSQLUtils.update("DELETE FROM attachment WHERE AttachmentID = " + attachId);
                                if (rv == 1) {
                                    ++this.filesCnt;
                                } else {
                                    ++this.errs;
                                }
                            } else {
                                ++this.errs;
                            }
                            this.firePropertyChange("CNT", 0, (int)((double)this.filesCnt / (double)totalFiles * 100.0));
                            ++r;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            protected void done() {
                UIRegistry.clearSimpleGlassPaneMsg();
                UIRegistry.displayInfoMsgDlg(String.format("Attachments removed: %d / %d", this.filesCnt, numAttachs));
                if (this.errs > 0) {
                    UIRegistry.displayErrorDlg(String.format("There were %d errors when deleting the attachments.", this.errs));
                } else if (FixAttachments.this.getNumberofBadAttachments() == 0) {
                    AppPreferences.getGlobalPrefs().putBoolean("CHECK_ATTCH_ERR", false);
                }
                super.done();
            }
        };
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(String.format("Removing %d attachments.", numAttachs), 24);
        glassPane.setProgress(0);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("CNT".equals(evt.getPropertyName())) {
                    glassPane.setProgress((Integer)evt.getNewValue());
                }
            }
        });
        worker.execute();
    }

    private File produceSummaryReport(HashMap<Integer, Vector<Object[]>> resultsHashMap, HashMap<Integer, AttchTableModel> tableHash, int totalFiles) {
        String path = String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "att_rec_summary.html";
        try {
            TableWriter tw = new TableWriter(path, "Attachment Recovery Summary", true);
            boolean first = true;
            for (int tblId : resultsHashMap.keySet()) {
                DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tblId);
                AttchTableModel model = tableHash.get(tblId);
                if (!first) {
                    tw.endTable();
                    tw.log("<BR/>");
                }
                first = false;
                tw.startTable();
                tw.log("<TR><TD COLSPAN=\"6\">" + ti.getTitle() + "</TD></TR>");
                tw.logHdr(model.getHeaders());
                int r = 0;
                while (r < model.getRowCount()) {
                    tw.print("<TR>");
                    int i = 0;
                    while (i < 5) {
                        tw.logTDCls(null, this.getVal(model.getValueAt(r, i)));
                        ++i;
                    }
                    tw.logTDCls(null, this.getVal(model.getValueAt(r, 5)));
                    tw.print("</TR>");
                    ++r;
                }
            }
            tw.endTable();
            tw.close();
            return new File(path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UIRegistry.displayErrorDlg("Unable to create Summary report.");
            return null;
        }
    }

    private String getIdentityTitle(DataProviderSessionIFace session, DBTableInfo ti, int id) {
        try {
            ObjectAttachmentIFace dataObj = (ObjectAttachmentIFace)session.get(ti.getClassObj(), id);
            if (dataObj != null) {
                return ((DataModelObjBase)dataObj.getObject()).getIdentityTitle();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "N/A";
    }

    private void hookupAction(JButton btn, final URI uri) {
        ActionListener[] actionListenerArray = btn.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener al = actionListenerArray[n2];
            btn.removeActionListener(al);
            ++n2;
        }
        if (uri != null) {
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        AttachmentUtils.openURI(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private Vector<Object[]> getImageData(int agentId, int tableId, HashMap<Integer, String> tblTypeHash) throws Exception {
        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tableId);
        String sql = String.format("SELECT a.AttachmentID, a.AttachmentLocation, a.OrigFilename, ag.AgentID, %s FROM attachment a INNER JOIN %s x ON a.AttachmentID = x.AttachmentID INNER JOIN agent ag ON a.CreatedByAgentID = ag.AgentID WHERE (a.AttachmentLocation IS NULL OR a.AttachmentLocation LIKE 'xxx.att.%c')", ti.getIdColumnName(), ti.getName(), Character.valueOf('%'), agentId);
        String title = ti.getTitle();
        if (ti.getRelationshipByName("division") != null) {
            Division div = AppContextMgr.getInstance().getClassObject(Division.class);
            sql = String.valueOf(sql) + " AND x.DivisionID = " + div.getId();
            title = String.valueOf(title) + " (Division Level)";
        } else if (ti.getFieldByColumnName("CollectionMemberID") != null) {
            Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
            sql = String.valueOf(sql) + " AND x.CollectionMemberID = " + collection.getId();
            title = String.valueOf(title) + " (Collection Level)";
        } else if (ti.getRelationshipByName("discipline") != null) {
            Discipline dsp = AppContextMgr.getInstance().getClassObject(Discipline.class);
            sql = String.valueOf(sql) + " AND x.DisciplineID = " + dsp.getId();
            title = String.valueOf(title) + " (Discipline Level)";
        } else {
            title = String.valueOf(title) + " (Global Level)";
        }
        tblTypeHash.put(tableId, title);
        System.out.println(sql);
        return BasicSQLUtils.query(sql);
    }

    private int getNumberofBadAttachments() {
        String sql = "SELECT COUNT(*) FROM attachment WHERE AttachmentLocation LIKE 'xxx.att%'";
        return BasicSQLUtils.getCountAsInt(sql);
    }

    public void checkForBadAttachments() {
        JEditorPane htmlPane;
        int count = this.getNumberofBadAttachments();
        if (count == 0) {
            AppPreferences.getGlobalPrefs().putBoolean("CHECK_ATTCH_ERR", false);
            return;
        }
        URL url = null;
        try {
            url = new URL("http://files.specifysoftware.org/attachment_recovery.html");
            htmlPane = new JEditorPane(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            htmlPane = new JEditorPane("text/html", "<html><body><h1>Network Error - You must have a network conneciton to get the instructions.</H1></body>");
        }
        JScrollPane scrollPane = UIHelper.createScrollPane(htmlPane);
        htmlPane.setEditable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        CustomDialog infoDlg = new CustomDialog(null, "Recovery Information", true, 3, (Component)panel);
        infoDlg.setCancelLabel("Close");
        infoDlg.setOkLabel("Print in Browser");
        infoDlg.createUI();
        infoDlg.setSize(1024, 600);
        try {
            this.hookupAction(infoDlg.getOkBtn(), url != null ? url.toURI() : null);
            infoDlg.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String CNT = "CNT";
        SwingWorker<Integer, Integer> worker = new SwingWorker<Integer, Integer>(){
            int totalFiles = 0;
            HashMap<Integer, Vector<Object[]>> resultsHashMap = new HashMap();
            HashMap<Integer, String> tblTypeHash = new HashMap();
            HashMap<Integer, String> agentHash = new HashMap();
            HashMap<Integer, AttchTableModel> tableHash = new HashMap();
            ArrayList<JTable> tableList = new ArrayList();
            ArrayList<Integer> tableIdList = new ArrayList();

            @Override
            protected Integer doInBackground() throws Exception {
                DataProviderSessionIFace session = null;
                try {
                    int[] tableIds = new int[]{AccessionAttachment.getClassTableId(), AgentAttachment.getClassTableId(), CollectingEventAttachment.getClassTableId(), CollectionObjectAttachment.getClassTableId(), ConservDescriptionAttachment.getClassTableId(), ConservEventAttachment.getClassTableId(), DNASequencingRunAttachment.getClassTableId(), FieldNotebookAttachment.getClassTableId(), FieldNotebookPageAttachment.getClassTableId(), FieldNotebookPageSetAttachment.getClassTableId(), LoanAttachment.getClassTableId(), LocalityAttachment.getClassTableId(), PermitAttachment.getClassTableId(), PreparationAttachment.getClassTableId(), RepositoryAgreementAttachment.getClassTableId(), TaxonAttachment.getClassTableId()};
                    Agent userAgent = AppContextMgr.getInstance().getClassObject(Agent.class);
                    int totFiles = 0;
                    this.firePropertyChange("CNT", 0, 0);
                    int cnt = 0;
                    int[] nArray = tableIds;
                    int n = tableIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int tableId = nArray[n2];
                        Vector results = FixAttachments.this.getImageData(userAgent.getId(), tableId, this.tblTypeHash);
                        if (results != null && results.size() > 0) {
                            this.resultsHashMap.put(tableId, results);
                            totFiles += results.size();
                        }
                        this.firePropertyChange("CNT", 0, (int)((double)cnt / (double)tableIds.length * 100.0));
                        ++cnt;
                        ++n2;
                    }
                    if (this.resultsHashMap.size() == 0) {
                        return null;
                    }
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        this.firePropertyChange("CNT", 0, 0);
                        int i = 1;
                        for (int tblId : this.resultsHashMap.keySet()) {
                            DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tblId);
                            Vector<Object[]> dataRows = new Vector<Object[]>();
                            Vector<Object[]> results = this.resultsHashMap.get(tblId);
                            for (Object[] row : results) {
                                Integer agentId = (Integer)row[3];
                                String userName = this.agentHash.get(agentId);
                                if (userName == null) {
                                    userName = (String)BasicSQLUtils.querySingleObj("SELECT su.Name FROM agent a INNER JOIN specifyuser su ON a.SpecifyUserID = su.SpecifyUserID WHERE a.AgentID = " + row[3]);
                                    this.agentHash.put(agentId, userName);
                                }
                                int attachJoinID = (Integer)row[4];
                                String identTitle = FixAttachments.this.getIdentityTitle(session, ti, attachJoinID);
                                String fullPath = (String)row[2];
                                boolean doesExist = new File(fullPath).exists();
                                Object[] rowObjs = new Object[]{StringUtils.isEmpty((String)identTitle) ? "" : (identTitle.length() > 30 ? String.valueOf(identTitle.substring(0, 30)) + "..." : identTitle), FilenameUtils.getName((String)fullPath), fullPath, userName, doesExist, Boolean.FALSE, row[0], attachJoinID};
                                dataRows.add(rowObjs);
                                if (doesExist) {
                                    ++this.totalFiles;
                                }
                                this.firePropertyChange("CNT", 0, (int)((double)i / (double)totFiles * 100.0));
                                ++i;
                            }
                            AttchTableModel model = new AttchTableModel(dataRows);
                            JTable table = new JTable(model);
                            this.tableHash.put(tblId, model);
                            this.tableList.add(table);
                            this.tableIdList.add(tblId);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                finally {
                    session.close();
                }
                return null;
            }

            @Override
            protected void done() {
                UIRegistry.clearSimpleGlassPaneMsg();
                if (this.tableList.size() > 0) {
                    FixAttachments.this.displayBadAttachments(this.tableList, this.tableIdList, this.resultsHashMap, this.tblTypeHash, this.tableHash, this.totalFiles);
                }
                super.done();
            }
        };
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg("Verifying attachments in the repository...", 24);
        glassPane.setProgress(0);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("CNT".equals(evt.getPropertyName())) {
                    glassPane.setProgress((Integer)evt.getNewValue());
                }
            }
        });
        worker.execute();
    }

    private void displayBadAttachments(ArrayList<JTable> tableList, ArrayList<Integer> tableIdList, final HashMap<Integer, Vector<Object[]>> resultsHashMap, HashMap<Integer, String> tblTypeHash, final HashMap<Integer, AttchTableModel> tableHash, int totalFiles) {
        CellConstraints cc = new CellConstraints();
        int maxWidth = 200;
        int y = 1;
        String rowDef = tableList.size() == 1 ? "f:p:g" : UIHelper.createDuplicateJGoodiesDef("p", "10px", tableList.size());
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", rowDef));
        if (tableList.size() > 1) {
            int i = 0;
            for (JTable table : tableList) {
                Integer tblId = tableIdList.get(i++);
                int numRows = table.getModel().getRowCount();
                PanelBuilder pb2 = new PanelBuilder(new FormLayout("f:p:g", "p,2px,f:p:g"));
                if (resultsHashMap.size() > 1) {
                    UIHelper.calcColumnWidths(table, numRows < 15 ? numRows + 1 : 15, maxWidth);
                } else {
                    UIHelper.calcColumnWidths(table, 15, maxWidth);
                }
                pb2.addSeparator(tblTypeHash.get(tblId), cc.xy(1, 1));
                pb2.add((Component)UIHelper.createScrollPane(table), cc.xy(1, 3));
                pb.add((Component)pb2.getPanel(), cc.xy(1, y));
                y += 2;
            }
        } else {
            UIHelper.calcColumnWidths(tableList.get(0), 15, maxWidth);
            pb.add((Component)UIHelper.createScrollPane(tableList.get(0)), cc.xy(1, 1));
        }
        tableList.clear();
        pb.setDefaultDialogBorder();
        JScrollPane panelSB = UIHelper.createScrollPane(pb.getPanel());
        panelSB.setBorder(BorderFactory.createEmptyBorder());
        Dimension dim = panelSB.getPreferredSize();
        panelSB.setPreferredSize(new Dimension(dim.width + 10, 600));
        final int totFiles = totalFiles;
        String title = String.format("Attachment Information - %d files to recover.", totalFiles);
        CustomDialog dlg = new CustomDialog(null, title, true, 15, panelSB){

            @Override
            protected void helpButtonPressed() {
                File file = FixAttachments.this.produceSummaryReport(resultsHashMap, tableHash, totFiles);
                try {
                    AttachmentUtils.openURI(file.toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            protected void applyButtonPressed() {
                boolean isOK = UIRegistry.displayConfirm("Clean up", "Are you sure you want to remove all references to the missing attachments?", "Remove", "Cancel", 2);
                if (isOK) {
                    super.applyButtonPressed();
                }
            }
        };
        dlg.setCloseOnApplyClk(true);
        dlg.setCancelLabel("Skip");
        dlg.setOkLabel("Recover Files");
        dlg.setHelpLabel("Show Summary");
        dlg.setApplyLabel("Delete References");
        dlg.createUI();
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.getBtnPressed() == 1) {
            this.reattachFiles(resultsHashMap, tableHash, totalFiles);
        } else if (dlg.getBtnPressed() == 8) {
            this.doAttachmentRefCleanup(resultsHashMap, tableHash, totFiles);
        }
    }

    class AttchTableModel
    extends DefaultTableModel {
        protected String[] headers = new String[]{"Owner", "File Name", "Full Path", "User", "Is Recoverable", "Was Recovered"};
        protected Vector<Object[]> dataRows;

        public AttchTableModel(Vector<Object[]> dataRows) {
            this.dataRows = dataRows;
        }

        @Override
        public int getColumnCount() {
            return this.headers != null ? this.headers.length - 1 : 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return col == 4 ? Boolean.class : String.class;
        }

        @Override
        public int getRowCount() {
            return this.dataRows != null ? this.dataRows.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object[] r = this.dataRows.get(row);
            return r[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getAttachmentId(int row) {
            Object[] r = this.dataRows.get(row);
            return (Integer)r[r.length - 2];
        }

        public int getAttachmentJoinId(int row) {
            Object[] r = this.dataRows.get(row);
            return (Integer)r[r.length - 1];
        }

        public boolean isRecoverable(int row) {
            Object[] r = this.dataRows.get(row);
            return (Boolean)r[4];
        }

        public void setRecovered(int row, boolean val) {
            Object[] r = this.dataRows.get(row);
            r[5] = val;
        }

        public boolean isRecovered(int row) {
            Object[] r = this.dataRows.get(row);
            return (Boolean)r[5];
        }

        public String[] getHeaders() {
            return this.headers;
        }
    }
}

