/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.helpers.XMLHelper;
import java.io.FileInputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class DisciplineType
implements Comparable<DisciplineType> {
    private static final Logger log = Logger.getLogger(DisciplineType.class);
    protected static SoftReference<Vector<DisciplineType>> disciplineList = null;
    protected static SoftReference<Hashtable<String, DisciplineType>> disciplineHash = null;
    protected String name;
    protected String title;
    protected int type;
    protected String abbrev;
    protected String folder;
    protected boolean isEmbeddedCollecingEvent;
    protected STD_DISCIPLINES disciplineType;

    public DisciplineType(String name, String title, String abbrev, String folder, int type, boolean isEmbeddedCollecingEvent) {
        this.name = name;
        this.title = title;
        this.type = type;
        this.abbrev = abbrev;
        this.folder = folder;
        this.isEmbeddedCollecingEvent = isEmbeddedCollecingEvent;
        this.disciplineType = STD_DISCIPLINES.valueOf(name);
    }

    public boolean isPaleo() {
        return this.disciplineType == STD_DISCIPLINES.paleobotany || this.disciplineType == STD_DISCIPLINES.vertpaleo || this.disciplineType == STD_DISCIPLINES.invertpaleo;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public int getType() {
        return this.type;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public String getFolder() {
        return this.folder;
    }

    public STD_DISCIPLINES getDisciplineType() {
        return this.disciplineType;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public int compareTo(DisciplineType obj) {
        return this.title.compareTo(obj.title);
    }

    public boolean isEmbeddedCollecingEvent() {
        return this.isEmbeddedCollecingEvent;
    }

    public void setEmbeddedCollecingEvent(boolean isEmbeddedCollecingEvent) {
        this.isEmbeddedCollecingEvent = isEmbeddedCollecingEvent;
    }

    public static DisciplineType getDiscipline(String name) {
        DisciplineType disciplineType = DisciplineType.getDisciplineHash().get(name);
        if (disciplineType == null) {
            for (DisciplineType dt : DisciplineType.getDisciplineHash().values()) {
                if (!dt.getTitle().equalsIgnoreCase(name)) continue;
                return dt;
            }
            log.error((Object)("Couldn't locate disciplineType[" + name + "]"));
        }
        return disciplineType;
    }

    public static DisciplineType getDiscipline(STD_DISCIPLINES dType) {
        for (DisciplineType disciplineType : DisciplineType.getDisciplineList()) {
            if (dType != disciplineType.getDisciplineType()) continue;
            return disciplineType;
        }
        return null;
    }

    public static DisciplineType getByTitle(String title) {
        for (DisciplineType disciplineType : DisciplineType.getDisciplineList()) {
            if (!title.equals(disciplineType.getTitle())) continue;
            return disciplineType;
        }
        return null;
    }

    public static DisciplineType getByName(String nameStr) {
        return DisciplineType.getDisciplineHash().get(nameStr);
    }

    public static Vector<DisciplineType> getDisciplineList() {
        Vector<DisciplineType> list = null;
        if (disciplineList != null) {
            list = disciplineList.get();
        }
        if (list == null) {
            disciplineList = new SoftReference<Vector<DisciplineType>>(DisciplineType.loadDisciplineList());
        }
        return disciplineList.get();
    }

    protected static Vector<DisciplineType> loadDisciplineList() {
        Vector<DisciplineType> list;
        block4: {
            list = new Vector<DisciplineType>();
            try {
                Element root = XMLHelper.readFileToDOM4J(new FileInputStream(XMLHelper.getConfigDirPath("disciplines.xml")));
                if (root != null) {
                    Iterator i = root.elementIterator("discipline");
                    while (i.hasNext()) {
                        Element disciplineNode = (Element)i.next();
                        String name = XMLHelper.getAttr(disciplineNode, "name", null);
                        String title = XMLHelper.getAttr(disciplineNode, "title", null);
                        String abbrev = XMLHelper.getAttr(disciplineNode, "abbrev", "");
                        String folder = XMLHelper.getAttr(disciplineNode, "folder", name);
                        int type = XMLHelper.getAttr(disciplineNode, "type", 0);
                        boolean isEmbedCE = XMLHelper.getAttr(disciplineNode, "isembedce", true);
                        DisciplineType disciplineType = new DisciplineType(name, title, abbrev, folder, type, isEmbedCE);
                        list.add(disciplineType);
                    }
                    break block4;
                }
                String msg = "The root element for the document was null!";
                log.error((Object)msg);
                throw new ConfigurationException(msg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Collections.sort(list);
        return list;
    }

    public static Hashtable<String, DisciplineType> getDisciplineHash() {
        Hashtable<String, DisciplineType> hash = null;
        if (disciplineHash != null) {
            hash = disciplineHash.get();
        }
        if (hash == null) {
            disciplineHash = new SoftReference<Hashtable<String, DisciplineType>>(DisciplineType.loadDisciplineHash());
        }
        return disciplineHash.get();
    }

    protected static Hashtable<String, DisciplineType> loadDisciplineHash() {
        Hashtable<String, DisciplineType> dispHash = new Hashtable<String, DisciplineType>();
        for (DisciplineType disciplineType : DisciplineType.getDisciplineList()) {
            dispHash.put(disciplineType.getName(), disciplineType);
        }
        return dispHash;
    }

    public static enum STD_DISCIPLINES {
        fish,
        herpetology,
        paleobotany,
        invertpaleo,
        vertpaleo,
        bird,
        mammal,
        insect,
        botany,
        invertebrate,
        minerals,
        anthropology;

    }
}

