/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DebugLoggerDialog
extends CustomDialog {
    protected static File debugLogFile = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "debug_logger.init");
    protected Hashtable<String, Logger> loggers = new Hashtable();
    protected Vector<String> sortedNames;
    protected LoggerNode root;

    public DebugLoggerDialog(Frame frame) throws HeadlessException {
        super(frame, "Debug Logger Configurer", true, (Component)null);
        this.loadLoggers();
    }

    public void loadLoggers() {
        this.loggers.clear();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger logger = (Logger)e.nextElement();
            this.loggers.put(logger.getName(), logger);
        }
        this.sortedNames = new Vector<String>(this.loggers.keySet());
        Collections.sort(this.sortedNames);
    }

    @Override
    public void createUI() {
        super.createUI();
        this.configureLoggers();
        this.root = new LoggerNode(null, "Root");
        for (String loggerName : this.sortedNames) {
            this.buildTree(this.loggers.get(loggerName), this.root, StringUtils.split((String)loggerName, (char)'.'), 0);
        }
        JTree tree = new JTree(this.root);
        tree.setCellRenderer(new CheckRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.addMouseListener(new NodeSelectionListener(tree));
        this.contentPanel = new JScrollPane(tree);
        this.mainPanel.add(this.contentPanel, "Center");
        this.setSize(500, 500);
    }

    protected void buildTree(Logger logger, DefaultMutableTreeNode parent, String[] names, int level) {
        int i = 0;
        while (i < parent.getChildCount()) {
            LoggerNode node = (LoggerNode)parent.getChildAt(i);
            if (node.toString().equals(names[level])) {
                this.buildTree(logger, node, names, level + 1);
                return;
            }
            ++i;
        }
        LoggerNode newNode = new LoggerNode(logger, names[level]);
        newNode.setSelected(logger.getLevel() == Level.DEBUG);
        parent.add(newNode);
        newNode.setParent(parent);
        if (level < names.length - 1) {
            this.buildTree(logger, newNode, names, level + 1);
        }
    }

    @Override
    protected void okButtonPressed() {
        try {
            StringBuilder sb = new StringBuilder();
            this.save(sb, this.root);
            FileUtils.writeStringToFile((File)debugLogFile, (String)sb.toString());
            System.out.println("Saved to[" + debugLogFile.getAbsolutePath() + "]");
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DebugLoggerDialog.class, ex);
            ex.printStackTrace();
        }
        super.okButtonPressed();
    }

    protected void save(StringBuilder sb, LoggerNode parent) {
        if (parent.isLeaf()) {
            parent.getLogger().setLevel(parent.isSelected ? Level.DEBUG : Level.OFF);
            sb.append(parent.getLogger().getName());
            sb.append("=");
            sb.append(parent.isSelected);
            sb.append("\n");
            return;
        }
        int i = 0;
        while (i < parent.getChildCount()) {
            LoggerNode node = (LoggerNode)parent.getChildAt(i);
            this.save(sb, node);
            ++i;
        }
    }

    public void configureLoggers() {
        if (this.configureLoggersInternal()) {
            this.loadLoggers();
            this.configureLoggersInternal();
        }
    }

    public boolean configureLoggersInternal() {
        boolean loggersNotLoaded = false;
        if (debugLogFile.exists()) {
            try {
                for (String line : FileUtils.readLines((File)debugLogFile)) {
                    String[] toks = StringUtils.split((String)line, (String)"=");
                    Logger logger = this.loggers.get(toks[0]);
                    if (logger != null) {
                        logger.setLevel(Boolean.parseBoolean(toks[1]) ? Level.DEBUG : Level.OFF);
                        continue;
                    }
                    loggersNotLoaded = true;
                    try {
                        Class<?> cls = Class.forName(toks[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DebugLoggerDialog.class, ex);
            }
        } else {
            System.out.println("Nothing to Configure.");
        }
        return loggersNotLoaded;
    }

    public class CheckNode
    extends DefaultMutableTreeNode {
        public static final int SINGLE_SELECTION = 0;
        public static final int DIG_IN_SELECTION = 4;
        protected int selectionMode;
        protected boolean isSelected;

        public CheckNode() {
            this(null);
        }

        public CheckNode(Object userObject) {
            this(userObject, true, false);
        }

        public CheckNode(Object userObject, boolean allowsChildren, boolean isSelected) {
            super(userObject, allowsChildren);
            this.isSelected = isSelected;
            this.setSelectionMode(4);
        }

        public void setSelectionMode(int mode) {
            this.selectionMode = mode;
        }

        public int getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
            if (this.selectionMode == 4 && this.children != null) {
                Enumeration menum = this.children.elements();
                while (menum.hasMoreElements()) {
                    CheckNode node = (CheckNode)menum.nextElement();
                    node.setSelected(isSelected);
                }
            }
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    public class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected TreeLabel label;

        public CheckRenderer() {
            this.setLayout(null);
            this.check = UIHelper.createCheckBox("");
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.check.setSelected(((CheckNode)value).isSelected());
            this.label.setFont(tree.getFont());
            this.label.setText(stringValue);
            this.label.setSelected(isSelected);
            this.label.setFocus(hasFocus);
            if (leaf) {
                this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
        }

        @Override
        public void doLayout() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            int y_check = 0;
            int y_label = 0;
            if (d_check.height < d_label.height) {
                y_check = (d_label.height - d_check.height) / 2;
            } else {
                y_label = (d_check.height - d_label.height) / 2;
            }
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color instanceof ColorUIResource ? null : color);
        }

        public class TreeLabel
        extends JLabel {
            boolean isSelected;
            boolean hasFocus;

            @Override
            public void setBackground(Color color) {
                super.setBackground(color instanceof ColorUIResource ? null : color);
            }

            @Override
            public void paint(Graphics g) {
                String str = this.getText();
                if (str != null && str.length() > 0) {
                    if (this.isSelected) {
                        g.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        g.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension d = this.getPreferredSize();
                    int imageOffset = 0;
                    Icon currentI = this.getIcon();
                    if (currentI != null) {
                        imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                    if (this.hasFocus) {
                        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                    }
                }
                super.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension retDimension = super.getPreferredSize();
                if (retDimension != null) {
                    retDimension = new Dimension(retDimension.width + 3, retDimension.height);
                }
                return retDimension;
            }

            public void setSelected(boolean isSelected) {
                this.isSelected = isSelected;
            }

            public void setFocus(boolean hasFocus) {
                this.hasFocus = hasFocus;
            }
        }
    }

    class LoggerNode
    extends CheckNode {
        protected Logger logger;
        protected String shortName;

        public LoggerNode(Logger logger, String shortName) {
            this.logger = logger;
            this.shortName = shortName;
        }

        public Logger getLogger() {
            return this.logger;
        }

        @Override
        public String toString() {
            return this.shortName;
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                CheckNode node = (CheckNode)path.getLastPathComponent();
                boolean isSelected = !node.isSelected();
                node.setSelected(isSelected);
                if (node.getSelectionMode() == 4) {
                    if (isSelected) {
                        this.tree.expandPath(path);
                    } else {
                        this.tree.collapsePath(path);
                    }
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
                if (row == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

