/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttribute;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationAttribute;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectingEventsAndAttrsMaint {
    private static String CNT = "CNT";
    protected static final Logger log = Logger.getLogger(CollectingEventsAndAttrsMaint.class);
    protected Connection connection;
    protected DataProviderSessionIFace session;
    protected FixUpWorker fixUpWorker = null;

    public void shutdown() {
        if (!AppPreferences.getGlobalPrefs().getBoolean("CollectingEventsAndAttrsMaint1", false).booleanValue()) {
            AppPreferences.getGlobalPrefs().putBoolean("CollectingEventsAndAttrsMaint1", true);
            try {
                AppPreferences.getGlobalPrefs().flush();
                if (this.connection != null) {
                    this.connection.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected int getCountForMaint(int collectionId) {
        String sql;
        int count = 0;
        boolean isEmbeddedCE = AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent();
        if (isEmbeddedCE) {
            sql = "SELECT SUM(cnt) FROM (SELECT CollectingEventID, count(*) AS cnt FROM collectionobject WHERE CollectingEventID IS NOT NULL AND CollectionMemberID = " + collectionId + " GROUP BY CollectingEventID) T1 WHERE cnt > 1";
            count += BasicSQLUtils.getCountAsInt(this.connection, sql);
        }
        sql = "SELECT COUNT(*) FROM (SELECT CollectionObjectAttributeID, count(*) AS cnt FROM collectionobject c WHERE CollectionObjectAttributeID IS NOT NULL AND CollectionMemberId = " + collectionId + " GROUP BY CollectionObjectAttributeID) T1 WHERE cnt > 1";
        count += BasicSQLUtils.getCountAsInt(this.connection, sql);
        sql = "SELECT * FROM (SELECT PreparationAttributeID, count(*) AS cnt FROM preparation WHERE PreparationAttributeID IS NOT NULL AND CollectionMemberId = " + collectionId + " GROUP BY PreparationAttributeID) T1 WHERE cnt > 1";
        return count += BasicSQLUtils.getCountAsInt(this.connection, sql);
    }

    protected int getCECountForMaint() {
        String sql = "SELECT COUNT(*) FROM (SELECT CollectingEventAttributeID, count(*) AS cnt FROM collectingevent WHERE CollectingEventAttributeID IS NOT NULL GROUP BY CollectingEventAttributeID) T1 WHERE cnt > 1";
        return BasicSQLUtils.getCountAsInt(this.connection, sql);
    }

    protected Vector<Object> getCollectingEventsWithManyCollectionObjects(int collectionId) {
        String sql = "SELECT * FROM (SELECT CollectingEventID, count(*) AS cnt FROM collectionobject c WHERE CollectingEventID IS NOT NULL AND CollectionMemberID = " + collectionId + " GROUP BY CollectingEventID) T1 WHERE cnt > 1";
        return BasicSQLUtils.querySingleCol(this.connection, sql);
    }

    protected int getCollectingEventsWithManyCollectionObjectsCount(int collectionId) {
        String sql = "SELECT SUM(CNT) FROM (SELECT CollectingEventID, count(*) AS cnt FROM collectionobject c WHERE CollectingEventID IS NOT NULL AND CollectionMemberID = " + collectionId + " GROUP BY CollectingEventID) T1 WHERE cnt > 1";
        return BasicSQLUtils.getCountAsInt(this.connection, sql);
    }

    public void performMaint() {
        String convPrefName = "INST.CONVERTED";
        AppPreferences remotePrefs = AppPreferences.getRemote();
        if (remotePrefs.getBoolean(convPrefName, false).booleanValue()) {
            return;
        }
        try {
            this.connection = DBConnection.getInstance().createConnection();
            this.session = DataProviderFactory.getInstance().createSession();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Institution institution = AppContextMgr.getInstance().getClassObject(Institution.class);
        String remarks = institution.getRemarks();
        if (StringUtils.isNotEmpty((String)remarks) && remarks.equals("Sp5Converted")) {
            try {
                institution.setRemarks(null);
                this.session.beginTransaction();
                this.session.saveOrUpdate(institution);
                this.session.commit();
                AppContextMgr.getInstance().setClassObject(Institution.class, institution);
                remotePrefs.getBoolean(convPrefName, true);
                this.shutdown();
                return;
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
                this.session.rollback();
                UIRegistry.showError("Database mainteneance could not be performed.\nTry again later.\nSpecify must exit now.");
                DBConnection.shutdown();
                HibernateUtil.shutdown();
                System.exit(0);
            }
        }
        final ArrayList<Integer> collectionsIds = new ArrayList<Integer>(16);
        for (Object[] row : BasicSQLUtils.query("SELECT CollectionID FROM collection WHERE IsEmbeddedCollectingEvent = TRUE")) {
            collectionsIds.add((Integer)row[0]);
        }
        if (collectionsIds.size() == 0) {
            this.shutdown();
            return;
        }
        int totCnt = 0;
        for (Integer id : collectionsIds) {
            totCnt += this.getCountForMaint(id);
        }
        if (totCnt == 0) {
            this.shutdown();
            return;
        }
        final int totalCnt = totCnt;
        final SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("PERFORMING_MAINT", new Object[0]), 24);
        glassPane.setProgress(0);
        this.fixUpWorker = new FixUpWorker(){

            @Override
            protected Integer doInBackground() throws Exception {
                int count = 0;
                glassPane.setText("Fixing Collecting Event Attributes...");
                this.firePropertyChange(CNT, count += CollectingEventsAndAttrsMaint.this.fixDupColEveAttrs(), (int)(100.0 * (double)count / (double)totalCnt));
                for (Integer id : collectionsIds) {
                    glassPane.setText("Fixing Preparation Atttributes...");
                    this.firePropertyChange(CNT, count += CollectingEventsAndAttrsMaint.this.fixDupPrepAttrs(id), (int)(100.0 * (double)count / (double)totalCnt));
                    glassPane.setText("Fixing Collection Object Atttributes...");
                    this.firePropertyChange(CNT, count += CollectingEventsAndAttrsMaint.this.fixDupColObjAttrs(id), (int)(100.0 * (double)count / (double)totalCnt));
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                CollectingEventsAndAttrsMaint.this.shutdown();
                glassPane.setProgress(100);
                UIRegistry.clearSimpleGlassPaneMsg();
            }
        };
        this.fixUpWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (CNT.equals(evt.getPropertyName())) {
                    int value = (Integer)evt.getNewValue();
                    if (value < 100) {
                        glassPane.setProgress(value);
                    } else {
                        glassPane.setProgress(100);
                    }
                }
            }
        });
        this.fixUpWorker.execute();
    }

    protected int fixDupColObjAttrs(int collectionId) {
        int count = 0;
        int localCnt = 0;
        String sql = "SELECT * FROM (SELECT CollectionObjectAttributeID, count(*) AS cnt FROM collectionobject c WHERE  CollectionObjectAttributeID IS NOT NULL AND c.CollectionMemberId = " + collectionId + " GROUP BY CollectionObjectAttributeID) T1 WHERE cnt > 1";
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        if (rows != null) {
            for (Object[] row : rows) {
                ++localCnt;
                try {
                    int id = (Integer)row[0];
                    CollectionObjectAttribute colObjAttr = this.session.get(CollectionObjectAttribute.class, id);
                    Set<CollectionObject> cos = colObjAttr.getCollectionObjects();
                    if (colObjAttr != null) {
                        int cnt = 0;
                        for (CollectionObject co : cos) {
                            if (cnt > 0) {
                                try {
                                    CollectionObjectAttribute colObjAttribute = (CollectionObjectAttribute)colObjAttr.clone();
                                    CollectionObject colObj = this.session.get(CollectionObject.class, co.getCollectionObjectId());
                                    colObj.setCollectionObjectAttribute(colObjAttribute);
                                    colObjAttribute.getCollectionObjects().add(colObj);
                                    this.session.beginTransaction();
                                    this.session.saveOrUpdate(colObjAttribute);
                                    this.session.saveOrUpdate(co);
                                    this.session.commit();
                                    this.session.evict(colObj);
                                    ++count;
                                }
                                catch (Exception ex1) {
                                    ex1.printStackTrace();
                                    this.session.rollback();
                                }
                            }
                            ++cnt;
                        }
                        this.session.evict(colObjAttr);
                        continue;
                    }
                    log.error((Object)("CollectionObjectAttribute is: " + colObjAttr));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return count;
    }

    protected int fixDupColEveAttrs() {
        int count = 0;
        int localCnt = 0;
        String sql = "SELECT * FROM (SELECT CollectingEventAttributeID, count(*) AS cnt FROM collectingevent c WHERE CollectingEventAttributeID IS NOT NULL GROUP BY CollectingEventAttributeID) T1 WHERE cnt > 1";
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        if (rows != null) {
            for (Object[] row : rows) {
                this.fixUpWorker.doFirePropertyChange(CNT, -1, (int)((double)localCnt / (double)rows.size()));
                ++localCnt;
                try {
                    int id = (Integer)row[0];
                    CollectingEventAttribute attrOwner = this.session.get(CollectingEventAttribute.class, id);
                    Set<CollectingEvent> set = attrOwner.getCollectingEvents();
                    if (attrOwner != null) {
                        int cnt = 0;
                        for (CollectingEvent obj : set) {
                            if (cnt > 0) {
                                try {
                                    CollectingEventAttribute newAttr = (CollectingEventAttribute)attrOwner.clone();
                                    CollectingEvent owner = this.session.get(CollectingEvent.class, obj.getCollectingEventId());
                                    owner.setCollectingEventAttribute(newAttr);
                                    newAttr.getCollectingEvents().add(owner);
                                    this.session.beginTransaction();
                                    this.session.saveOrUpdate(newAttr);
                                    this.session.saveOrUpdate(obj);
                                    this.session.commit();
                                    this.session.evict(owner);
                                    ++count;
                                }
                                catch (Exception ex1) {
                                    ex1.printStackTrace();
                                    this.session.rollback();
                                }
                            }
                            ++cnt;
                        }
                        this.session.evict(attrOwner);
                        continue;
                    }
                    log.error((Object)("CollectingEventAttribute is: " + attrOwner));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return count;
    }

    protected int fixDupPrepAttrs(int collectionId) {
        int count = 0;
        int localCnt = 0;
        String sql = "SELECT * FROM (SELECT PreparationAttributeID, count(*) AS cnt FROM preparation p WHERE PreparationAttributeID IS NOT NULL AND p.CollectionMemberId = " + collectionId + " GROUP BY PreparationAttributeID) T1 WHERE cnt > 1";
        Vector<Object[]> rows = BasicSQLUtils.query(this.connection, sql);
        if (rows != null) {
            for (Object[] row : rows) {
                this.fixUpWorker.doFirePropertyChange(CNT, -1, (int)((double)localCnt / (double)rows.size()));
                ++localCnt;
                try {
                    int id = (Integer)row[0];
                    PreparationAttribute attrOwner = this.session.get(PreparationAttribute.class, id);
                    Set<Preparation> set = attrOwner.getPreparations();
                    if (attrOwner != null) {
                        int cnt = 0;
                        for (Preparation obj : set) {
                            if (cnt > 0) {
                                try {
                                    PreparationAttribute newAttr = (PreparationAttribute)attrOwner.clone();
                                    Preparation owner = this.session.get(Preparation.class, obj.getPreparationId());
                                    owner.setPreparationAttribute(newAttr);
                                    newAttr.getPreparations().add(owner);
                                    this.session.beginTransaction();
                                    this.session.saveOrUpdate(newAttr);
                                    this.session.saveOrUpdate(obj);
                                    this.session.commit();
                                    this.session.evict(owner);
                                    ++count;
                                }
                                catch (Exception ex1) {
                                    ex1.printStackTrace();
                                    this.session.rollback();
                                }
                            }
                            ++cnt;
                        }
                        this.session.evict(attrOwner);
                        continue;
                    }
                    log.error((Object)("PreparationAttribute is: " + attrOwner));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return count;
    }

    abstract class FixUpWorker
    extends SwingWorker<Integer, Integer> {
        FixUpWorker() {
        }

        public void doFirePropertyChange(String propName, Object oldVal, Object newVal) {
            this.firePropertyChange(propName, oldVal, newVal);
        }
    }
}

