/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseCollectionDlg
extends CustomDialog {
    protected JList list;
    protected List<Pair<String, Integer>> collectionList;
    protected Hashtable<String, ImageIcon> iconHash = new Hashtable();
    protected Hashtable<Integer, String> collIdToDispType = new Hashtable();

    public ChooseCollectionDlg(List<Pair<String, Integer>> collectionList) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ChooseCollectionDlg.CHS_COL_TITLE"), true, 1, null);
        this.collectionList = collectionList;
        DefaultListModel model = new DefaultListModel();
        this.list = new JList(model);
        this.list.setSelectionMode(0);
        List<Pair<String, ImageIcon>> disciplinesList = IconManager.getListByType("disciplines", IconManager.IconSize.Std16);
        Collections.sort(disciplinesList, new Comparator<Pair<String, ImageIcon>>(){

            @Override
            public int compare(Pair<String, ImageIcon> o1, Pair<String, ImageIcon> o2) {
                String s1 = UIRegistry.getResourceString((String)o1.first);
                String s2 = UIRegistry.getResourceString((String)o2.first);
                return s1.compareTo(s2);
            }
        });
        for (Pair<String, Integer> pair : collectionList) {
            String dispType = (String)BasicSQLUtils.querySingleObj("SELECT d.Type FROM collection AS c Inner Join discipline AS d ON c.DisciplineID = d.UserGroupScopeId WHERE c.UserGroupScopeId = " + pair.second);
            this.collIdToDispType.put((Integer)pair.second, dispType);
        }
        for (Pair<String, Serializable> pair : disciplinesList) {
            this.iconHash.put((String)pair.first, (ImageIcon)pair.second);
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,8px"));
        CellConstraints cc = new CellConstraints();
        for (Pair<String, Integer> collPair : this.collectionList) {
            ((DefaultListModel)this.list.getModel()).addElement(collPair);
        }
        JScrollPane sp = new JScrollPane(this.list, 20, 31);
        pb.add((Component)sp, cc.xy(1, 1));
        pb.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    ChooseCollectionDlg.this.okBtn.doClick();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ChooseCollectionDlg.this.okBtn.setEnabled(ChooseCollectionDlg.this.list.getSelectedIndex() > -1);
                }
            }
        });
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList listArg, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)ChooseCollectionDlg.this.list, value, index, isSelected, cellHasFocus);
                Pair collPair = (Pair)value;
                label.setText((String)collPair.first);
                String dispType = ChooseCollectionDlg.this.collIdToDispType.get(collPair.second);
                DisciplineType disciplineType = DisciplineType.getDiscipline(DisciplineType.STD_DISCIPLINES.valueOf(dispType));
                label.setIcon(ChooseCollectionDlg.this.iconHash.get(disciplineType.getDisciplineType().toString()));
                ImageIcon imgIcon = IconManager.getIcon(dispType, IconManager.IconSize.Std24);
                if (imgIcon == null) {
                    imgIcon = IconManager.getIcon("Blank", IconManager.IconSize.Std24);
                }
                label.setIcon(imgIcon);
                return label;
            }
        };
        this.list.setCellRenderer(renderer);
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.okBtn.setEnabled(false);
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    public Pair<String, Integer> getSelectedObject() {
        return (Pair)this.list.getSelectedValue();
    }
}

