/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.AppPrefsGlobalDBIOIImpl;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceData;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.UIRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import org.apache.log4j.Logger;

public class AppPrefsDBIOIImpl
implements AppPreferences.AppPrefsIOIFace {
    protected static final Logger log = Logger.getLogger(AppPrefsDBIOIImpl.class);
    protected static final String PREF_NAME = "preferences";
    protected AppPreferences appPrefsMgr = null;
    protected SpAppResourceDir spAppResourceDir = null;
    protected SpAppResource spAppResource = null;
    protected boolean found = false;
    protected String xmlTitle = "Remote User Prefs";

    @Override
    public void setAppPrefsMgr(AppPreferences appPrefsMgr) {
        this.appPrefsMgr = appPrefsMgr;
    }

    protected void checkForAppPrefs() {
        if (this.appPrefsMgr == null) {
            throw new RuntimeException("The AppPreferences is null for " + this.getClass().getCanonicalName());
        }
        this.load();
    }

    @Override
    public boolean isAvailable() {
        return this.found;
    }

    @Override
    public boolean exists() {
        this.load();
        return this.found;
    }

    @Override
    public Date lastSavedDate() {
        this.load();
        return this.spAppResource.getTimestampModified();
    }

    protected SpAppResourceDir createResDir(DataProviderSessionIFace session, SpecifyAppContextMgr specifyAppContext) {
        return specifyAppContext.getAppResDir(session, AppContextMgr.getInstance().getClassObject(SpecifyUser.class), null, null, "Prefs", false, "Prefs", true);
    }

    protected SpAppResource createAndInitResource() {
        SpAppResource appRes = new SpAppResource();
        appRes.initialize();
        appRes.setName(PREF_NAME);
        appRes.setLevel((short)3);
        appRes.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
        return appRes;
    }

    @Override
    public void load() {
        if (this.spAppResource == null && this.appPrefsMgr != null) {
            Properties properties = new Properties();
            this.appPrefsMgr.setProperties(properties);
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    if (session != null) {
                        SpecifyAppContextMgr specifyAppContext = (SpecifyAppContextMgr)AppContextMgr.getInstance();
                        SpAppResourceData appData = null;
                        this.spAppResourceDir = this.createResDir(session, specifyAppContext);
                        if (this.spAppResourceDir.getSpAppResourceDirId() == null) {
                            this.spAppResource = this.createAndInitResource();
                            appData = new SpAppResourceData();
                            appData.initialize();
                            appData.setSpAppResource(this.spAppResource);
                            this.spAppResource.getSpAppResourceDatas().add(appData);
                            this.spAppResourceDir.getSpPersistedAppResources().add(this.spAppResource);
                            this.spAppResource.setSpAppResourceDir(this.spAppResourceDir);
                        } else {
                            for (SpAppResource appRes : this.spAppResourceDir.getSpPersistedAppResources()) {
                                if (!appRes.getName().equals(PREF_NAME)) continue;
                                this.spAppResource = appRes;
                                appData = this.spAppResource.getSpAppResourceDatas().iterator().next();
                                break;
                            }
                            if (this.spAppResource == null) {
                                log.error((Object)"Couldn't find Prefs object");
                                UIRegistry.showLocalizedError(String.format("Couldn't find '%s'. Application will exit.", this.spAppResourceDir != null ? this.spAppResourceDir.getTitle() : "(Unknown)"));
                                session.close();
                                DBConnection.shutdown();
                                System.exit(0);
                            }
                        }
                        if (appData == null) {
                            throw new RuntimeException("AppResource pref name[preferences] has not AppResourceData object.");
                        }
                        this.found = true;
                        if (appData.getData() != null) {
                            properties.load(new ByteArrayInputStream(appData.getData()));
                        }
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(AppPrefsGlobalDBIOIImpl.class, ex);
                    ex.printStackTrace();
                    log.error((Object)ex);
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        block17: {
            if (this.spAppResource != null && this.spAppResourceDir != null && this.appPrefsMgr.isChanged()) {
                if (this.spAppResource.getSpAppResourceDatas().size() == 0) {
                    throw new RuntimeException("AppResource has no AppResourceData object!");
                }
                try {
                    Properties currentProps = (Properties)this.appPrefsMgr.getProperties().clone();
                    System.out.println(currentProps.getProperty("rodsx"));
                    this.spAppResource = null;
                    this.load();
                    Properties dbProps = this.appPrefsMgr.getProperties();
                    for (Object key : currentProps.keySet()) {
                        dbProps.put(key, currentProps.get(key));
                    }
                    for (Object key : new HashSet<Object>(dbProps.keySet())) {
                        if (currentProps.get(key) != null) continue;
                        dbProps.remove(key);
                    }
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    dbProps.store(byteOut, this.xmlTitle);
                    this.appPrefsMgr.setChanged(false);
                    SpAppResourceData apData = this.spAppResource.getSpAppResourceDatas().iterator().next();
                    if (apData != null) {
                        apData.setData(byteOut.toByteArray());
                    } else {
                        log.error((Object)"AppResourceData shouldn't be null!");
                    }
                    byteOut.close();
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            session.beginTransaction();
                            if (this.spAppResource.getSpecifyUser() == null) {
                                SpecifyUser globalPrefUser = new SpecifyUser();
                                globalPrefUser.initialize();
                                globalPrefUser.setName("__GLOBAL_PREFS_USER");
                                globalPrefUser.setPassword(Long.toString(System.currentTimeMillis()));
                                session.saveOrUpdate(globalPrefUser);
                                this.spAppResource.setSpecifyUser(globalPrefUser);
                            }
                            session.saveOrUpdate(this.spAppResourceDir);
                            session.saveOrUpdate(this.spAppResource);
                            session.commit();
                        }
                        catch (Exception ex) {
                            if (session != null) {
                                session.rollback();
                            }
                            ex.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                            break block17;
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                catch (IOException ex) {
                    throw new BackingStoreException(ex);
                }
            }
            log.error((Object)("Number of ResourceData objects: " + this.spAppResource.getSpAppResourceDatas().size()));
        }
    }
}

