/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.config;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.NavBoxLayoutManager;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.ui.DBObjSearchDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AgentSearchDialogES
extends JDialog
implements ActionListener,
ExpressSearchResultsPaneIFace {
    private static final Logger log = Logger.getLogger(DBObjSearchDialog.class);
    protected JButton cancelBtn;
    protected JButton okBtn;
    protected JTextField searchText;
    protected JPanel contentPanel;
    protected JScrollPane scrollPane;
    protected JTable table;
    protected JButton searchBtn;
    protected Color textBGColor = null;
    protected Color badSearchColor = new Color(255, 235, 235);
    protected ESResultsTablePanelIFace etrb;
    protected int tableId = -1;
    protected RecordSetIFace recordSet = null;
    protected ViewIFace formView = null;
    protected Viewable form = null;
    protected Map<String, String> dataMap = UIHelper.createMap();
    protected Map<String, String> formFieldToColumnMap = UIHelper.createMap();

    public AgentSearchDialogES(Frame parent) throws HeadlessException {
        super(parent, UIRegistry.getResourceString("AgentSearchTitle"), true);
        this.tableId = DBTableIdMgr.getInstance().getIdByShortName("agent");
        String[] mappings = new String[]{"lastName", "lastname", "firstName", "firstname"};
        int i = 0;
        while (i < mappings.length) {
            this.formFieldToColumnMap.put(mappings[i], mappings[i + 1]);
            ++i;
            ++i;
        }
        this.createUI();
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(0);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createUI() {
        this.searchText = UIHelper.createTextField(30);
        this.searchBtn = UIHelper.createButton(UIRegistry.getResourceString("SEARCH"));
        ActionListener doQuery = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgentSearchDialogES.this.form.getDataFromUI();
                StringBuilder strBuf = new StringBuilder(128);
                for (String key : AgentSearchDialogES.this.formFieldToColumnMap.keySet()) {
                    String value = AgentSearchDialogES.this.dataMap.get(key);
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    if (strBuf.length() > 0) {
                        strBuf.append(" OR ");
                    }
                    strBuf.append(String.valueOf(AgentSearchDialogES.this.formFieldToColumnMap.get(key)) + ":" + value);
                }
                AgentSearchDialogES.this.searchText.setText(strBuf.toString());
                AgentSearchDialogES.this.doQuery();
            }
        };
        this.searchBtn.addActionListener(doQuery);
        this.searchText.addActionListener(doQuery);
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AgentSearchDialogES.this.searchText.getBackground() != AgentSearchDialogES.this.textBGColor) {
                    AgentSearchDialogES.this.searchText.setBackground(AgentSearchDialogES.this.textBGColor);
                }
            }
        });
        String viewName = "test";
        String name = null;
        this.formView = AppContextMgr.getInstance().getView(name, viewName);
        if (this.formView != null) {
            this.form = ViewFactory.createFormView(null, this.formView, null, this.dataMap, 0, null);
            if (this.form == null) return;
            this.add(this.form.getUIComponent(), "Center");
        } else {
            log.info((Object)("Couldn't load form with name [" + name + "] Id [" + viewName + "]"));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,1dlu,p", "p,2dlu,p,2dlu,p"));
        CellConstraints cc = new CellConstraints();
        builder.add(this.form.getUIComponent(), cc.xy(1, 1));
        builder.add((Component)this.searchBtn, cc.xy(3, 1));
        panel.add((Component)builder.getPanel(), "North");
        this.contentPanel = new JPanel(new NavBoxLayoutManager(0, 2));
        this.scrollPane = new JScrollPane(this.contentPanel);
        panel.add((Component)this.scrollPane, "Center");
        this.scrollPane.setPreferredSize(new Dimension(300, 200));
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("OK"));
        this.okBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okBtn);
        ButtonBarBuilder btnBuilder = new ButtonBarBuilder();
        btnBuilder.addGlue();
        btnBuilder.addGriddedButtons(new JButton[]{this.cancelBtn, this.okBtn});
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AgentSearchDialogES.this.setVisible(false);
            }
        });
        panel.add((Component)btnBuilder.getPanel(), "South");
        this.setContentPane(panel);
        this.pack();
        this.updateUI();
    }

    protected void updateUI() {
        this.okBtn.setEnabled(this.recordSet != null && this.recordSet.getNumItems() == 1);
    }

    public void doQuery() {
        String searchTerm = this.searchText.getText();
        if (StringUtils.isNotEmpty((String)searchTerm)) {
            this.contentPanel.removeAll();
        }
    }

    @Override
    public void addSearchResults(QueryForIdResultsIFace results) {
    }

    @Override
    public void removeTable(ESResultsTablePanelIFace expTblRes) {
        expTblRes.cleanUp();
        this.contentPanel.remove(expTblRes.getUIComponent());
        this.contentPanel.invalidate();
        this.contentPanel.doLayout();
        this.contentPanel.repaint();
        this.scrollPane.revalidate();
        this.scrollPane.doLayout();
        this.scrollPane.repaint();
    }

    @Override
    public void addTable(ESResultsTablePanelIFace expTblRes) {
    }

    @Override
    public void revalidateScroll() {
        this.contentPanel.invalidate();
        this.scrollPane.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    @Override
    public boolean hasResults() {
        return this.etrb.hasResults();
    }

    @Override
    public boolean doQueriesSynchronously() {
        return false;
    }

    @Override
    public void done() {
    }
}

